/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.commonservices.generichandlers.OMFConverter;
import org.odpi.openmetadata.commonservices.generichandlers.RelatedEntity;
import org.odpi.openmetadata.commonservices.mermaid.GlossaryCategoryMermaidGraphBuilder;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.GlossaryCategoryElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.RelatedMetadataElementSummary;
import org.odpi.openmetadata.frameworks.openmetadata.properties.glossaries.GlossaryCategoryProperties;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class GlossaryCategoryConverter<B>
extends OMFConverter<B> {
    public GlossaryCategoryConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    @Override
    public B getNewComplexBean(Class<B> beanClass, EntityDetail primaryEntity, Relationship relationship, List<RelatedEntity> relatedEntities, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof GlossaryCategoryElement) {
                GlossaryCategoryElement bean = (GlossaryCategoryElement)returnBean;
                if (primaryEntity != null) {
                    bean.setElementHeader(this.getMetadataElementHeader(beanClass, primaryEntity, methodName));
                    GlossaryCategoryProperties glossaryCategoryProperties = new GlossaryCategoryProperties();
                    InstanceProperties instanceProperties = new InstanceProperties(primaryEntity.getProperties());
                    glossaryCategoryProperties.setQualifiedName(this.removeQualifiedName(instanceProperties));
                    glossaryCategoryProperties.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                    glossaryCategoryProperties.setDisplayName(this.removeDisplayName(instanceProperties));
                    glossaryCategoryProperties.setDescription(this.removeDescription(instanceProperties));
                    glossaryCategoryProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
                    glossaryCategoryProperties.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
                    bean.setGlossaryCategoryProperties(glossaryCategoryProperties);
                    if (relatedEntities != null) {
                        ArrayList<RelatedMetadataElementSummary> externalReferences = new ArrayList<RelatedMetadataElementSummary>();
                        ArrayList<RelatedMetadataElementSummary> terms = new ArrayList<RelatedMetadataElementSummary>();
                        ArrayList<RelatedMetadataElementSummary> childCategories = new ArrayList<RelatedMetadataElementSummary>();
                        ArrayList<RelatedMetadataElementSummary> otherRelatedElements = new ArrayList<RelatedMetadataElementSummary>();
                        for (RelatedEntity relatedEntity : relatedEntities) {
                            if (relatedEntity == null || relatedEntity.relationship() == null || relatedEntity.entityDetail() == null) continue;
                            if (this.repositoryHelper.isTypeOf(this.serviceName, relatedEntity.relationship().getType().getTypeDefName(), OpenMetadataType.CATEGORY_ANCHOR_RELATIONSHIP.typeName)) {
                                bean.setParentGlossary(super.getRelatedMetadataElementSummary(beanClass, relatedEntity, methodName));
                                continue;
                            }
                            if (this.repositoryHelper.isTypeOf(this.serviceName, relatedEntity.relationship().getType().getTypeDefName(), OpenMetadataType.TERM_CATEGORIZATION.typeName)) {
                                terms.add(super.getRelatedMetadataElementSummary(beanClass, relatedEntity, methodName));
                                continue;
                            }
                            if (this.repositoryHelper.isTypeOf(this.serviceName, relatedEntity.relationship().getType().getTypeDefName(), OpenMetadataType.EXTERNAL_REFERENCE_LINK_RELATIONSHIP.typeName)) {
                                externalReferences.add(super.getRelatedMetadataElementSummary(beanClass, relatedEntity, methodName));
                                continue;
                            }
                            if (this.repositoryHelper.isTypeOf(this.serviceName, relatedEntity.relationship().getType().getTypeDefName(), OpenMetadataType.CATEGORY_HIERARCHY_LINK_RELATIONSHIP.typeName)) {
                                if (relatedEntity.relationship().getEntityOneProxy().getGUID().equals(primaryEntity.getGUID())) {
                                    childCategories.add(super.getRelatedMetadataElementSummary(beanClass, relatedEntity, methodName));
                                    continue;
                                }
                                bean.setParentCategory(super.getRelatedMetadataElementSummary(beanClass, relatedEntity, methodName));
                                continue;
                            }
                            otherRelatedElements.add(super.getRelatedMetadataElementSummary(beanClass, relatedEntity, methodName));
                        }
                        if (!externalReferences.isEmpty()) {
                            bean.setExternalReferences(externalReferences);
                        }
                        if (!terms.isEmpty()) {
                            bean.setTerms(terms);
                        }
                        if (!childCategories.isEmpty()) {
                            bean.setChildCategories(childCategories);
                        }
                        if (!otherRelatedElements.isEmpty()) {
                            bean.setOtherRelatedElements(otherRelatedElements);
                        }
                    }
                    GlossaryCategoryMermaidGraphBuilder graphBuilder = new GlossaryCategoryMermaidGraphBuilder(bean);
                    bean.setMermaidGraph(graphBuilder.getMermaidGraph());
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    @Override
    public B getNewBean(Class<B> beanClass, EntityDetail entity, String methodName) throws PropertyServerException {
        return this.getNewComplexBean(beanClass, entity, (Relationship)null, null, methodName);
    }

    @Override
    public B getNewBean(Class<B> beanClass, EntityDetail entity, Relationship relationship, String methodName) throws PropertyServerException {
        return this.getNewComplexBean(beanClass, entity, relationship, null, methodName);
    }
}

