/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.GlossaryCategoryBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIAnchorHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.generichandlers.RelatedEntity;
import org.odpi.openmetadata.commonservices.generichandlers.ffdc.GenericHandlersErrorCode;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class GlossaryCategoryHandler<B>
extends ReferenceableHandler<B> {
    public GlossaryCategoryHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public String createGlossaryCategory(String userId, String externalSourceGUID, String externalSourceName, String glossaryGUID, String glossaryGUIDParameterName, String qualifiedName, String displayName, String description, Map<String, String> additionalProperties, boolean rootCategory, String suppliedTypeName, Map<String, Object> extendedProperties, Date effectiveFrom, Date effectiveTo, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String glossaryCategoryGUID;
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryGUID, glossaryGUIDParameterName, methodName);
        String typeName = OpenMetadataType.GLOSSARY_CATEGORY.typeName;
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, OpenMetadataType.GLOSSARY_CATEGORY.typeName, this.serviceName, methodName, this.repositoryHelper);
        GlossaryCategoryBuilder builder = new GlossaryCategoryBuilder(qualifiedName, displayName, description, additionalProperties, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setAnchors(userId, null, OpenMetadataType.GLOSSARY_CATEGORY.typeName, OpenMetadataType.GLOSSARY_CATEGORY.typeName, glossaryGUID, methodName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        if (rootCategory) {
            builder.setRootCategory(userId, methodName);
        }
        if ((glossaryCategoryGUID = this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, typeGUID, typeName, builder, effectiveTime, methodName)) != null) {
            String glossaryCategoryGUIDParameterName = "glossaryCategoryGUID";
            this.uncheckedLinkElementToElement(userId, externalSourceGUID, externalSourceName, glossaryGUID, glossaryGUIDParameterName, glossaryCategoryGUID, "glossaryCategoryGUID", OpenMetadataType.CATEGORY_ANCHOR_RELATIONSHIP.typeGUID, null, methodName);
        }
        return glossaryCategoryGUID;
    }

    public String createGlossaryCategoryFromTemplate(String userId, String externalSourceGUID, String externalSourceName, String glossaryGUID, String glossaryGUIDParameterName, String templateGUID, String qualifiedName, String displayName, String description, boolean deepCopy, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        GlossaryCategoryBuilder builder = new GlossaryCategoryBuilder(qualifiedName, displayName, description, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setAnchors(userId, null, OpenMetadataType.GLOSSARY_CATEGORY.typeName, OpenMetadataType.GLOSSARY_CATEGORY.typeName, glossaryGUID, methodName);
        String glossaryCategoryGUID = this.createBeanFromTemplate(userId, externalSourceGUID, externalSourceName, templateGUID, "templateGUID", OpenMetadataType.GLOSSARY_CATEGORY.typeGUID, OpenMetadataType.GLOSSARY_CATEGORY.typeName, qualifiedName, OpenMetadataProperty.QUALIFIED_NAME.name, builder, this.supportedZones, deepCopy, false, null, methodName);
        if (glossaryCategoryGUID != null) {
            String glossaryCategoryGUIDParameterName = "glossaryCategoryGUID";
            this.uncheckedLinkElementToElement(userId, externalSourceGUID, externalSourceName, glossaryGUID, glossaryGUIDParameterName, glossaryCategoryGUID, "glossaryCategoryGUID", OpenMetadataType.CATEGORY_ANCHOR_RELATIONSHIP.typeGUID, null, methodName);
        }
        return glossaryCategoryGUID;
    }

    public void updateGlossaryCategory(String userId, String externalSourceGUID, String externalSourceName, String glossaryCategoryGUID, String glossaryCategoryGUIDParameterName, String qualifiedName, String displayName, String description, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, Date effectiveFrom, Date effectiveTo, Date effectiveTime, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryCategoryGUID, glossaryCategoryGUIDParameterName, methodName);
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        }
        String typeName = OpenMetadataType.GLOSSARY_CATEGORY.typeName;
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, OpenMetadataType.GLOSSARY_CATEGORY.typeName, this.serviceName, methodName, this.repositoryHelper);
        GlossaryCategoryBuilder builder = new GlossaryCategoryBuilder(qualifiedName, displayName, description, additionalProperties, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, glossaryCategoryGUID, glossaryCategoryGUIDParameterName, typeGUID, typeName, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, builder.getInstanceProperties(methodName), isMergeUpdate, effectiveTime, methodName);
    }

    public void removeGlossaryCategory(String userId, String externalSourceGUID, String externalSourceName, String glossaryCategoryGUID, String glossaryCategoryGUIDParameterName, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, glossaryCategoryGUID, glossaryCategoryGUIDParameterName, OpenMetadataType.GLOSSARY_CATEGORY.typeGUID, OpenMetadataType.GLOSSARY_CATEGORY.typeName, false, null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> findGlossaryCategories(String userId, String glossaryGUID, String searchString, String searchStringParameterName, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        List categoryEntities = this.repositoryHandler.getEntitiesByValue(userId, searchString, OpenMetadataType.GLOSSARY_CATEGORY.typeGUID, null, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, startFrom, queryPageSize, effectiveTime, methodName);
        return this.getValidCategories(userId, glossaryGUID, effectiveTime, forLineage, forDuplicateProcessing, methodName, categoryEntities);
    }

    private List<B> getValidCategories(String userId, String glossaryGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing, String methodName, List<EntityDetail> categoryEntities) {
        List<EntityDetail> validatedCategories = super.validateEntitiesAndAnchorsForRead(userId, categoryEntities, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
        if (validatedCategories != null) {
            ArrayList<B> results = new ArrayList<B>();
            for (EntityDetail entity : validatedCategories) {
                if (entity == null) continue;
                try {
                    if (glossaryGUID == null) {
                        results.add(this.getGlossaryCategoryBean(userId, entity, null, forLineage, forDuplicateProcessing, effectiveTime));
                        continue;
                    }
                    OpenMetadataAPIAnchorHandler.AnchorIdentifiers anchorIdentifiers = this.getAnchorsFromAnchorsClassification((EntitySummary)entity, methodName);
                    if (!glossaryGUID.equals(anchorIdentifiers.anchorGUID)) continue;
                    results.add(this.getGlossaryCategoryBean(userId, entity, null, forLineage, forDuplicateProcessing, effectiveTime));
                }
                catch (Exception exception) {}
            }
            if (!results.isEmpty()) {
                return results;
            }
        }
        return null;
    }

    private List<B> getRelatedGlossaryCategoryBeans(String userId, List<RelatedEntity> relatedCategories, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (relatedCategories != null) {
            ArrayList<B> results = new ArrayList<B>();
            for (RelatedEntity relatedTerm : relatedCategories) {
                if (relatedTerm == null || relatedTerm.relationship() == null || relatedTerm.entityDetail() == null) continue;
                results.add(this.getGlossaryCategoryBean(userId, relatedTerm.entityDetail(), relatedTerm.relationship(), forLineage, forDuplicateProcessing, effectiveTime));
            }
            return results;
        }
        return null;
    }

    private List<B> getGlossaryCategoryBeans(String userId, List<EntityDetail> categoryEntities, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (categoryEntities != null) {
            ArrayList<B> results = new ArrayList<B>();
            for (EntityDetail entityDetail : categoryEntities) {
                if (entityDetail == null) continue;
                results.add(this.getGlossaryCategoryBean(userId, entityDetail, null, forLineage, forDuplicateProcessing, effectiveTime));
            }
            return results;
        }
        return null;
    }

    private B getGlossaryCategoryBean(String userId, EntityDetail categoryEntity, Relationship relatedByRelationship, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGlossaryCategoryBean";
        String startingGUIDParameterName = "categoryEntity.guid";
        if (categoryEntity != null) {
            List<RelatedEntity> relatedEntities = this.getAllRelatedEntities(userId, categoryEntity, "categoryEntity.guid", OpenMetadataType.GLOSSARY_CATEGORY.typeName, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, "getGlossaryCategoryBean");
            return this.converter.getNewComplexBean(this.beanClass, categoryEntity, relatedByRelationship, relatedEntities, "getGlossaryCategoryBean");
        }
        return null;
    }

    public List<B> getCategoriesForGlossary(String userId, String glossaryGUID, String glossaryGUIDParameterName, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateGUID(glossaryGUID, glossaryGUIDParameterName, methodName);
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        EntityDetail glossaryEntity = this.repositoryHandler.getEntityByGUID(userId, glossaryGUID, glossaryGUIDParameterName, OpenMetadataType.GLOSSARY.typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.securityVerifier.validateUserForElementRead(userId, glossaryEntity, this.repositoryHelper, this.serviceName, methodName);
        InstanceProperties matchProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.ANCHOR_SCOPE_GUID.name, glossaryGUID, methodName);
        List retrievedEntities = this.repositoryHandler.getEntitiesForClassificationType(userId, OpenMetadataType.GLOSSARY_CATEGORY.typeGUID, OpenMetadataType.ANCHORS_CLASSIFICATION.typeName, matchProperties, MatchCriteria.ALL, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, startFrom, queryPageSize, effectiveTime, methodName);
        return this.getGlossaryCategoryBeans(userId, retrievedEntities, forLineage, forDuplicateProcessing, effectiveTime);
    }

    public List<B> getCategoriesForTerm(String userId, String glossaryTermGUID, String glossaryTermGUIDParameterName, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        EntityDetail termEntity = this.getEntityFromRepository(userId, glossaryTermGUID, glossaryTermGUIDParameterName, OpenMetadataType.GLOSSARY_TERM.typeName, null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        List<RelatedEntity> relatedCategories = this.getRelatedEntities(userId, termEntity, glossaryTermGUIDParameterName, OpenMetadataType.GLOSSARY_TERM.typeName, OpenMetadataType.TERM_CATEGORIZATION.typeGUID, OpenMetadataType.TERM_CATEGORIZATION.typeName, null, OpenMetadataType.GLOSSARY_CATEGORY.typeName, 1, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
        return this.getRelatedGlossaryCategoryBeans(userId, relatedCategories, forLineage, forDuplicateProcessing, effectiveTime);
    }

    public List<B> getGlossaryCategoriesByName(String userId, String glossaryGUID, String name, String nameParameterName, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(name, nameParameterName, methodName);
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        InstanceProperties matchProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.QUALIFIED_NAME.name, name, methodName);
        matchProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, matchProperties, OpenMetadataProperty.DISPLAY_NAME.name, name, methodName);
        List categoryEntities = this.repositoryHandler.getEntitiesByName(userId, matchProperties, OpenMetadataType.GLOSSARY_CATEGORY.typeGUID, null, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, startFrom, queryPageSize, effectiveTime, methodName);
        return this.getValidCategories(userId, glossaryGUID, effectiveTime, forLineage, forDuplicateProcessing, methodName, categoryEntities);
    }

    public B getGlossaryCategoryParent(String userId, String glossaryCategoryGUID, String glossaryCategoryGUIDParameterName, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        EntityDetail categoryEntity = this.getEntityFromRepository(userId, glossaryCategoryGUID, glossaryCategoryGUIDParameterName, OpenMetadataType.GLOSSARY_CATEGORY.typeName, null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        List<RelatedEntity> parentCategories = this.getRelatedEntities(userId, categoryEntity, glossaryCategoryGUIDParameterName, OpenMetadataType.GLOSSARY_CATEGORY.typeName, OpenMetadataType.CATEGORY_HIERARCHY_LINK_RELATIONSHIP.typeGUID, OpenMetadataType.CATEGORY_HIERARCHY_LINK_RELATIONSHIP.typeName, null, OpenMetadataType.GLOSSARY_CATEGORY.typeName, 1, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, this.supportedZones, 0, this.invalidParameterHandler.getMaxPagingSize(), effectiveTime, methodName);
        if (parentCategories == null || parentCategories.isEmpty()) {
            return null;
        }
        if (parentCategories.size() == 1) {
            return this.getGlossaryCategoryBean(userId, parentCategories.get(0).entityDetail(), parentCategories.get(0).relationship(), forLineage, forDuplicateProcessing, effectiveTime);
        }
        throw new PropertyServerException(GenericHandlersErrorCode.MULTIPLE_BEANS_FOUND.getMessageDefinition(OpenMetadataType.GLOSSARY_CATEGORY.typeName, methodName, parentCategories.toString(), glossaryCategoryGUID, this.serviceName, this.serverName), this.getClass().getName(), methodName);
    }

    public List<B> getGlossarySubCategories(String userId, String glossaryCategoryGUID, String glossaryCategoryGUIDParameterName, int startFrom, int pageSize, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        EntityDetail categoryEntity = this.getEntityFromRepository(userId, glossaryCategoryGUID, glossaryCategoryGUIDParameterName, OpenMetadataType.GLOSSARY_CATEGORY.typeName, null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        List<RelatedEntity> childCategories = this.getRelatedEntities(userId, categoryEntity, glossaryCategoryGUIDParameterName, OpenMetadataType.GLOSSARY_CATEGORY.typeName, OpenMetadataType.CATEGORY_HIERARCHY_LINK_RELATIONSHIP.typeGUID, OpenMetadataType.CATEGORY_HIERARCHY_LINK_RELATIONSHIP.typeName, null, OpenMetadataType.GLOSSARY_CATEGORY.typeName, 2, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
        return this.getRelatedGlossaryCategoryBeans(userId, childCategories, forLineage, forDuplicateProcessing, effectiveTime);
    }

    public B getGlossaryCategoryByGUID(String userId, String guid, String guidParameterName, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        EntityDetail entity = this.getEntityFromRepository(userId, guid, guidParameterName, OpenMetadataType.GLOSSARY_CATEGORY.typeName, null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return this.getGlossaryCategoryBean(userId, entity, null, forLineage, forDuplicateProcessing, effectiveTime);
    }
}

