/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.odpi.openmetadata.commonservices.generichandlers.OMFConverter;
import org.odpi.openmetadata.commonservices.generichandlers.RelatedEntity;
import org.odpi.openmetadata.commonservices.mermaid.GlossaryMermaidGraphBuilder;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ChildCategoryElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.GlossaryElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.RelatedMetadataElementSummary;
import org.odpi.openmetadata.frameworks.openmetadata.properties.glossaries.GlossaryProperties;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class GlossaryConverter<B>
extends OMFConverter<B> {
    public GlossaryConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    @Override
    public B getNewComplexBean(Class<B> beanClass, EntityDetail primaryEntity, Relationship relationship, List<RelatedEntity> relatedEntities, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof GlossaryElement) {
                GlossaryElement bean = (GlossaryElement)returnBean;
                if (primaryEntity != null) {
                    bean.setElementHeader(this.getMetadataElementHeader(beanClass, primaryEntity, methodName));
                    GlossaryProperties glossaryProperties = new GlossaryProperties();
                    InstanceProperties instanceProperties = new InstanceProperties(primaryEntity.getProperties());
                    glossaryProperties.setQualifiedName(this.removeQualifiedName(instanceProperties));
                    glossaryProperties.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                    glossaryProperties.setDisplayName(this.removeDisplayName(instanceProperties));
                    glossaryProperties.setDescription(this.removeDescription(instanceProperties));
                    glossaryProperties.setLanguage(this.removeLanguage(instanceProperties));
                    glossaryProperties.setUsage(this.removeUsage(instanceProperties));
                    bean.setGlossaryProperties(glossaryProperties);
                    if (relatedEntities != null) {
                        ArrayList<RelatedMetadataElementSummary> externalReferences = new ArrayList<RelatedMetadataElementSummary>();
                        HashMap<String, ChildCategoryElement> categories = new HashMap<String, ChildCategoryElement>();
                        ArrayList<RelatedEntity> categoryHierarchyLinks = new ArrayList<RelatedEntity>();
                        ArrayList<String> childCategories = new ArrayList<String>();
                        ArrayList<RelatedMetadataElementSummary> otherRelatedElements = new ArrayList<RelatedMetadataElementSummary>();
                        for (RelatedEntity relatedEntity : relatedEntities) {
                            if (relatedEntity == null || relatedEntity.relationship() == null || relatedEntity.entityDetail() == null) continue;
                            if (this.repositoryHelper.isTypeOf(this.serviceName, relatedEntity.relationship().getType().getTypeDefName(), OpenMetadataType.CATEGORY_ANCHOR_RELATIONSHIP.typeName)) {
                                ChildCategoryElement childCategoryElement = new ChildCategoryElement(super.getRelatedMetadataElementSummary(beanClass, relatedEntity, methodName));
                                categories.put(childCategoryElement.getRelatedElement().getElementHeader().getGUID(), childCategoryElement);
                                continue;
                            }
                            if (this.repositoryHelper.isTypeOf(this.serviceName, relatedEntity.relationship().getType().getTypeDefName(), OpenMetadataType.CATEGORY_HIERARCHY_LINK_RELATIONSHIP.typeName)) {
                                categoryHierarchyLinks.add(relatedEntity);
                                continue;
                            }
                            if (this.repositoryHelper.isTypeOf(this.serviceName, relatedEntity.relationship().getType().getTypeDefName(), OpenMetadataType.EXTERNAL_REFERENCE_LINK_RELATIONSHIP.typeName)) {
                                externalReferences.add(super.getRelatedMetadataElementSummary(beanClass, relatedEntity, methodName));
                                continue;
                            }
                            if (this.repositoryHelper.isTypeOf(this.serviceName, relatedEntity.relationship().getType().getTypeDefName(), OpenMetadataType.TERM_ANCHOR_RELATIONSHIP.typeName)) continue;
                            otherRelatedElements.add(super.getRelatedMetadataElementSummary(beanClass, relatedEntity, methodName));
                        }
                        if (!categoryHierarchyLinks.isEmpty()) {
                            for (RelatedEntity relatedEntity : categoryHierarchyLinks) {
                                ChildCategoryElement parentCategory = (ChildCategoryElement)categories.get(relatedEntity.relationship().getEntityOneProxy().getGUID());
                                ChildCategoryElement childCategory = (ChildCategoryElement)categories.get(relatedEntity.relationship().getEntityTwoProxy().getGUID());
                                if (parentCategory == null || childCategory == null) continue;
                                ArrayList<ChildCategoryElement> currentChildCategories = parentCategory.getChildCategories();
                                if (currentChildCategories == null) {
                                    currentChildCategories = new ArrayList<ChildCategoryElement>();
                                }
                                currentChildCategories.add(childCategory);
                                parentCategory.setChildCategories(currentChildCategories);
                                childCategories.add(childCategory.getRelatedElement().getElementHeader().getGUID());
                            }
                        }
                        if (!externalReferences.isEmpty()) {
                            bean.setExternalReferences(externalReferences);
                        }
                        if (!categories.isEmpty()) {
                            ArrayList<ChildCategoryElement> parentCategories = new ArrayList<ChildCategoryElement>();
                            for (ChildCategoryElement categoryElement : categories.values()) {
                                if (childCategories.contains(categoryElement.getRelatedElement().getElementHeader().getGUID())) continue;
                                parentCategories.add(categoryElement);
                            }
                            bean.setCategories(parentCategories);
                        }
                        if (!otherRelatedElements.isEmpty()) {
                            bean.setOtherRelatedElements(otherRelatedElements);
                        }
                    }
                    GlossaryMermaidGraphBuilder graphBuilder = new GlossaryMermaidGraphBuilder(bean);
                    bean.setMermaidGraph(graphBuilder.getMermaidGraph());
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    @Override
    public B getNewBean(Class<B> beanClass, EntityDetail entity, String methodName) throws PropertyServerException {
        return this.getNewComplexBean(beanClass, entity, (Relationship)null, null, methodName);
    }

    @Override
    public B getNewBean(Class<B> beanClass, EntityDetail entity, Relationship relationship, String methodName) throws PropertyServerException {
        return this.getNewComplexBean(beanClass, entity, relationship, null, methodName);
    }
}

