/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.GlossaryBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.generichandlers.RelatedEntity;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class GlossaryHandler<B>
extends ReferenceableHandler<B> {
    public GlossaryHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public String createGlossary(String userId, String externalSourceGUID, String externalSourceName, String qualifiedName, String displayName, String description, String language, String usage, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String typeName = OpenMetadataType.GLOSSARY.typeName;
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, OpenMetadataType.GLOSSARY.typeName, this.serviceName, methodName, this.repositoryHelper);
        GlossaryBuilder builder = new GlossaryBuilder(qualifiedName, displayName, description, language, usage, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        return this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, typeGUID, typeName, builder, null, methodName);
    }

    public String createGlossaryFromTemplate(String userId, String externalSourceGUID, String externalSourceName, String templateGUID, String qualifiedName, String displayName, String description, boolean deepCopy, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        GlossaryBuilder builder = new GlossaryBuilder(qualifiedName, displayName, description, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setAnchors(userId, null, OpenMetadataType.GLOSSARY.typeName, OpenMetadataType.GLOSSARY.typeName, null, methodName);
        return this.createBeanFromTemplate(userId, externalSourceGUID, externalSourceName, templateGUID, "templateGUID", OpenMetadataType.GLOSSARY.typeGUID, OpenMetadataType.GLOSSARY.typeName, qualifiedName, OpenMetadataProperty.QUALIFIED_NAME.name, builder, this.supportedZones, deepCopy, false, null, methodName);
    }

    public void updateGlossary(String userId, String externalSourceGUID, String externalSourceName, String glossaryGUID, String glossaryGUIDParameterName, String qualifiedName, String displayName, String description, String language, String usage, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryGUID, glossaryGUIDParameterName, methodName);
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        }
        String typeName = OpenMetadataType.GLOSSARY.typeName;
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, OpenMetadataType.GLOSSARY.typeName, this.serviceName, methodName, this.repositoryHelper);
        GlossaryBuilder builder = new GlossaryBuilder(qualifiedName, displayName, description, language, usage, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, glossaryGUID, glossaryGUIDParameterName, typeGUID, typeName, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, builder.getInstanceProperties(methodName), isMergeUpdate, effectiveTime, methodName);
    }

    public void addEditingGlossaryClassificationToGlossary(String userId, String externalSourceGUID, String externalSourceName, String glossaryGUID, String glossaryGUIDParameterName, String description, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryGUID, glossaryGUIDParameterName, methodName);
        GlossaryBuilder builder = new GlossaryBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        this.setClassificationInRepository(userId, externalSourceGUID, externalSourceName, glossaryGUID, glossaryGUIDParameterName, OpenMetadataType.GLOSSARY.typeName, OpenMetadataType.EDITING_GLOSSARY_CLASSIFICATION.typeGUID, OpenMetadataType.EDITING_GLOSSARY_CLASSIFICATION.typeName, builder.getEditingGlossaryProperties(description, methodName), false, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void removeEditingGlossaryClassificationFromGlossary(String userId, String externalSourceGUID, String externalSourceName, String glossaryGUID, String glossaryGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryGUID, glossaryGUIDParameterName, methodName);
        this.removeClassificationFromRepository(userId, externalSourceGUID, externalSourceName, glossaryGUID, glossaryGUIDParameterName, OpenMetadataType.GLOSSARY.typeName, OpenMetadataType.EDITING_GLOSSARY_CLASSIFICATION.typeGUID, OpenMetadataType.EDITING_GLOSSARY_CLASSIFICATION.typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void addStagingGlossaryClassificationToGlossary(String userId, String externalSourceGUID, String externalSourceName, String glossaryGUID, String glossaryGUIDParameterName, String description, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryGUID, glossaryGUIDParameterName, methodName);
        GlossaryBuilder builder = new GlossaryBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        this.setClassificationInRepository(userId, externalSourceGUID, externalSourceName, glossaryGUID, glossaryGUIDParameterName, OpenMetadataType.GLOSSARY.typeName, OpenMetadataType.STAGING_GLOSSARY_CLASSIFICATION.typeGUID, OpenMetadataType.STAGING_GLOSSARY_CLASSIFICATION.typeName, builder.getStagingGlossaryProperties(description, methodName), false, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void removeStagingGlossaryClassificationFromGlossary(String userId, String externalSourceGUID, String externalSourceName, String glossaryGUID, String glossaryGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryGUID, glossaryGUIDParameterName, methodName);
        this.removeClassificationFromRepository(userId, externalSourceGUID, externalSourceName, glossaryGUID, glossaryGUIDParameterName, OpenMetadataType.GLOSSARY.typeName, OpenMetadataType.STAGING_GLOSSARY_CLASSIFICATION.typeGUID, OpenMetadataType.STAGING_GLOSSARY_CLASSIFICATION.typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void addTaxonomyClassificationToGlossary(String userId, String externalSourceGUID, String externalSourceName, String glossaryGUID, String glossaryGUIDParameterName, String organizingPrinciple, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryGUID, glossaryGUIDParameterName, methodName);
        GlossaryBuilder builder = new GlossaryBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        this.setClassificationInRepository(userId, externalSourceGUID, externalSourceName, glossaryGUID, glossaryGUIDParameterName, OpenMetadataType.GLOSSARY.typeName, OpenMetadataType.TAXONOMY_CLASSIFICATION.typeGUID, OpenMetadataType.TAXONOMY_CLASSIFICATION.typeName, builder.getTaxonomyProperties(organizingPrinciple, methodName), false, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void removeTaxonomyClassificationFromGlossary(String userId, String externalSourceGUID, String externalSourceName, String glossaryGUID, String glossaryGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryGUID, glossaryGUIDParameterName, methodName);
        this.removeClassificationFromRepository(userId, externalSourceGUID, externalSourceName, glossaryGUID, glossaryGUIDParameterName, OpenMetadataType.GLOSSARY.typeName, OpenMetadataType.TAXONOMY_CLASSIFICATION.typeGUID, OpenMetadataType.TAXONOMY_CLASSIFICATION.typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void addCanonicalVocabClassificationToGlossary(String userId, String externalSourceGUID, String externalSourceName, String glossaryGUID, String glossaryGUIDParameterName, String scope, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryGUID, glossaryGUIDParameterName, methodName);
        GlossaryBuilder builder = new GlossaryBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        this.setClassificationInRepository(userId, externalSourceGUID, externalSourceName, glossaryGUID, glossaryGUIDParameterName, OpenMetadataType.GLOSSARY.typeName, OpenMetadataType.CANONICAL_VOCABULARY_CLASSIFICATION.typeGUID, OpenMetadataType.CANONICAL_VOCABULARY_CLASSIFICATION.typeName, builder.getCanonicalVocabularyProperties(scope, methodName), false, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void removeCanonicalVocabClassificationFromGlossary(String userId, String externalSourceGUID, String externalSourceName, String glossaryGUID, String glossaryGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.removeClassificationFromRepository(userId, externalSourceGUID, externalSourceName, glossaryGUID, glossaryGUIDParameterName, OpenMetadataType.GLOSSARY.typeName, OpenMetadataType.CANONICAL_VOCABULARY_CLASSIFICATION.typeGUID, OpenMetadataType.CANONICAL_VOCABULARY_CLASSIFICATION.typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void removeGlossary(String userId, String externalSourceGUID, String externalSourceName, String glossaryGUID, String glossaryGUIDParameterName, boolean cascadedDelete, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        EntityDetail glossaryEntity = this.getEntityFromRepository(userId, glossaryGUID, glossaryGUIDParameterName, OpenMetadataType.GLOSSARY.typeName, null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (glossaryEntity != null) {
            this.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, glossaryGUID, glossaryGUIDParameterName, OpenMetadataType.GLOSSARY.typeGUID, OpenMetadataType.GLOSSARY.typeName, cascadedDelete, null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
    }

    public List<B> findGlossaries(String userId, String searchString, String searchStringParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        List glossaryEntities = this.repositoryHandler.getEntitiesByValue(userId, searchString, OpenMetadataType.GLOSSARY.typeGUID, null, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, startFrom, queryPageSize, effectiveTime, methodName);
        return this.getGlossaryBeans(userId, glossaryEntities, forLineage, forDuplicateProcessing, effectiveTime);
    }

    public List<B> getGlossariesByName(String userId, String name, String nameParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(name, nameParameterName, methodName);
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        InstanceProperties matchProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.QUALIFIED_NAME.name, name, methodName);
        matchProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, matchProperties, OpenMetadataProperty.DISPLAY_NAME.name, name, methodName);
        List glossaryEntities = this.repositoryHandler.getEntitiesByName(userId, matchProperties, OpenMetadataType.GLOSSARY.typeGUID, null, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, startFrom, queryPageSize, effectiveTime, methodName);
        return this.getGlossaryBeans(userId, glossaryEntities, forLineage, forDuplicateProcessing, effectiveTime);
    }

    public B getGlossaryByGUID(String userId, String guid, String guidParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        EntityDetail entity = this.getEntityFromRepository(userId, guid, guidParameterName, OpenMetadataType.GLOSSARY.typeName, null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return this.getGlossaryBean(userId, entity, null, forLineage, forDuplicateProcessing, effectiveTime);
    }

    private List<B> getGlossaryBeans(String userId, List<EntityDetail> glossaryEntities, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (glossaryEntities != null) {
            ArrayList<B> results = new ArrayList<B>();
            for (EntityDetail entityDetail : glossaryEntities) {
                if (entityDetail == null) continue;
                results.add(this.getGlossaryBean(userId, entityDetail, null, forLineage, forDuplicateProcessing, effectiveTime));
            }
            return results;
        }
        return null;
    }

    private B getGlossaryBean(String userId, EntityDetail categoryEntity, Relationship relatedByRelationship, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGlossaryBean";
        String startingGUIDParameterName = "glossaryEntity.guid";
        if (categoryEntity != null) {
            List<RelatedEntity> relatedEntities = this.getAllRelatedEntities(userId, categoryEntity, "glossaryEntity.guid", OpenMetadataType.GLOSSARY.typeName, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, "getGlossaryBean");
            if (relatedEntities != null) {
                ArrayList<RelatedEntity> categoryLinks = new ArrayList<RelatedEntity>();
                String categoryGUIDParameterName = "ownedCategory.guid";
                for (RelatedEntity relatedEntity : relatedEntities) {
                    List<RelatedEntity> relatedCategories;
                    if (relatedEntity == null || relatedEntity.relationship() == null || relatedEntity.entityDetail() == null || !this.repositoryHelper.isTypeOf(this.serviceName, relatedEntity.relationship().getType().getTypeDefName(), OpenMetadataType.CATEGORY_ANCHOR_RELATIONSHIP.typeName) || (relatedCategories = this.getRelatedEntities(userId, relatedEntity.entityDetail(), "ownedCategory.guid", OpenMetadataType.GLOSSARY_CATEGORY.typeName, OpenMetadataType.CATEGORY_HIERARCHY_LINK_RELATIONSHIP.typeGUID, OpenMetadataType.CATEGORY_HIERARCHY_LINK_RELATIONSHIP.typeName, null, OpenMetadataType.GLOSSARY_CATEGORY.typeName, 1, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, this.supportedZones, 0, this.invalidParameterHandler.getMaxPagingSize(), effectiveTime, "getGlossaryBean")) == null) continue;
                    categoryLinks.addAll(relatedCategories);
                }
                relatedEntities.addAll(categoryLinks);
            }
            return this.converter.getNewComplexBean(this.beanClass, categoryEntity, relatedByRelationship, relatedEntities, "getGlossaryBean");
        }
        return null;
    }

    public B getGlossaryForCategory(String userId, String glossaryCategoryGUID, String guidParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getAttachedElement(userId, glossaryCategoryGUID, guidParameterName, OpenMetadataType.GLOSSARY_CATEGORY.typeName, OpenMetadataType.CATEGORY_ANCHOR_RELATIONSHIP.typeGUID, OpenMetadataType.CATEGORY_ANCHOR_RELATIONSHIP.typeName, OpenMetadataType.GLOSSARY.typeName, 1, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
    }

    public B getGlossaryForTerm(String userId, String glossaryTermGUID, String guidParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getAttachedElement(userId, glossaryTermGUID, guidParameterName, OpenMetadataType.GLOSSARY_TERM.typeName, OpenMetadataType.TERM_ANCHOR_RELATIONSHIP.typeGUID, OpenMetadataType.TERM_ANCHOR_RELATIONSHIP.typeName, OpenMetadataType.GLOSSARY.typeName, 1, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
    }
}

