/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.commonservices.generichandlers.OMFConverter;
import org.odpi.openmetadata.commonservices.generichandlers.RelatedEntity;
import org.odpi.openmetadata.commonservices.mermaid.GlossaryTermMermaidGraphBuilder;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.GlossaryTermElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.RelatedBy;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.RelatedMetadataElementSummary;
import org.odpi.openmetadata.frameworks.openmetadata.properties.RelationshipProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.glossaries.GlossaryTermProperties;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class GlossaryTermConverter<B>
extends OMFConverter<B> {
    public GlossaryTermConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    @Override
    public B getNewComplexBean(Class<B> beanClass, EntityDetail primaryEntity, Relationship relationship, List<RelatedEntity> relatedEntities, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof GlossaryTermElement) {
                GlossaryTermElement bean = (GlossaryTermElement)returnBean;
                if (primaryEntity != null) {
                    bean.setElementHeader(this.getMetadataElementHeader(beanClass, primaryEntity, methodName));
                    GlossaryTermProperties glossaryTermProperties = new GlossaryTermProperties();
                    InstanceProperties instanceProperties = new InstanceProperties(primaryEntity.getProperties());
                    glossaryTermProperties.setQualifiedName(this.removeQualifiedName(instanceProperties));
                    glossaryTermProperties.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                    glossaryTermProperties.setDisplayName(this.removeDisplayName(instanceProperties));
                    glossaryTermProperties.setAliases(this.removeAliases(instanceProperties));
                    glossaryTermProperties.setDescription(this.removeDescription(instanceProperties));
                    glossaryTermProperties.setAbbreviation(this.removeAbbreviation(instanceProperties));
                    glossaryTermProperties.setUsage(this.removeUsage(instanceProperties));
                    glossaryTermProperties.setExamples(this.removeExamples(instanceProperties));
                    glossaryTermProperties.setSummary(this.removeSummary(instanceProperties));
                    glossaryTermProperties.setPublishVersionIdentifier(this.removePublishVersionIdentifier(instanceProperties));
                    glossaryTermProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
                    glossaryTermProperties.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
                    bean.setGlossaryTermProperties(glossaryTermProperties);
                    if (relationship != null) {
                        RelatedBy relatedBy = new RelatedBy();
                        relatedBy.setRelationshipHeader(super.getMetadataElementHeader(beanClass, (InstanceHeader)relationship, null, methodName));
                        if (relationship.getProperties() != null) {
                            instanceProperties = new InstanceProperties(relationship.getProperties());
                            RelationshipProperties relationshipProperties = new RelationshipProperties();
                            relationshipProperties.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
                            relationshipProperties.setEffectiveFrom(instanceProperties.getEffectiveFromTime());
                            relationshipProperties.setEffectiveTo(instanceProperties.getEffectiveToTime());
                            relatedBy.setRelationshipProperties(relationshipProperties);
                        }
                        bean.setRelatedElement(relatedBy);
                    }
                    if (relatedEntities != null) {
                        ArrayList<RelatedMetadataElementSummary> externalReferences = new ArrayList<RelatedMetadataElementSummary>();
                        ArrayList<RelatedMetadataElementSummary> categoryMembership = new ArrayList<RelatedMetadataElementSummary>();
                        ArrayList<RelatedMetadataElementSummary> relatedTerms = new ArrayList<RelatedMetadataElementSummary>();
                        ArrayList<RelatedMetadataElementSummary> relatedDefinitions = new ArrayList<RelatedMetadataElementSummary>();
                        ArrayList<RelatedMetadataElementSummary> semanticAssignments = new ArrayList<RelatedMetadataElementSummary>();
                        ArrayList<RelatedMetadataElementSummary> otherRelatedElements = new ArrayList<RelatedMetadataElementSummary>();
                        for (RelatedEntity relatedEntity : relatedEntities) {
                            if (relatedEntity == null || relatedEntity.relationship() == null || relatedEntity.entityDetail() == null) continue;
                            if (this.repositoryHelper.isTypeOf(this.serviceName, relatedEntity.relationship().getType().getTypeDefName(), OpenMetadataType.TERM_ANCHOR_RELATIONSHIP.typeName)) {
                                bean.setParentGlossary(super.getRelatedMetadataElementSummary(beanClass, relatedEntity, methodName));
                                continue;
                            }
                            if (this.repositoryHelper.isTypeOf(this.serviceName, relatedEntity.relationship().getType().getTypeDefName(), OpenMetadataType.TERM_CATEGORIZATION.typeName)) {
                                categoryMembership.add(super.getRelatedMetadataElementSummary(beanClass, relatedEntity, methodName));
                                continue;
                            }
                            if (this.repositoryHelper.isTypeOf(this.serviceName, relatedEntity.relationship().getType().getTypeDefName(), OpenMetadataType.SEMANTIC_DEFINITION_RELATIONSHIP.typeName)) {
                                relatedDefinitions.add(super.getRelatedMetadataElementSummary(beanClass, relatedEntity, methodName));
                                continue;
                            }
                            if (this.repositoryHelper.isTypeOf(this.serviceName, relatedEntity.relationship().getType().getTypeDefName(), OpenMetadataType.SEMANTIC_ASSIGNMENT_RELATIONSHIP.typeName)) {
                                semanticAssignments.add(super.getRelatedMetadataElementSummary(beanClass, relatedEntity, methodName));
                                continue;
                            }
                            if (this.repositoryHelper.isTypeOf(this.serviceName, relatedEntity.relationship().getType().getTypeDefName(), OpenMetadataType.EXTERNAL_REFERENCE_LINK_RELATIONSHIP.typeName)) {
                                externalReferences.add(super.getRelatedMetadataElementSummary(beanClass, relatedEntity, methodName));
                                continue;
                            }
                            if (this.repositoryHelper.isTypeOf(this.serviceName, relatedEntity.entityDetail().getType().getTypeDefName(), OpenMetadataType.GLOSSARY_TERM.typeName)) {
                                relatedTerms.add(super.getRelatedMetadataElementSummary(beanClass, relatedEntity, methodName));
                                continue;
                            }
                            otherRelatedElements.add(super.getRelatedMetadataElementSummary(beanClass, relatedEntity, methodName));
                        }
                        if (!externalReferences.isEmpty()) {
                            bean.setExternalReferences(externalReferences);
                        }
                        if (!categoryMembership.isEmpty()) {
                            bean.setCategoryMembership(categoryMembership);
                        }
                        if (!relatedTerms.isEmpty()) {
                            bean.setRelatedToTerms(relatedTerms);
                        }
                        if (!relatedDefinitions.isEmpty()) {
                            bean.setRelatedDefinitions(relatedDefinitions);
                        }
                        if (!semanticAssignments.isEmpty()) {
                            bean.setSemanticAssignments(semanticAssignments);
                        }
                        if (!otherRelatedElements.isEmpty()) {
                            bean.setOtherRelatedElements(otherRelatedElements);
                        }
                    }
                    GlossaryTermMermaidGraphBuilder graphBuilder = new GlossaryTermMermaidGraphBuilder(bean);
                    bean.setMermaidGraph(graphBuilder.getMermaidGraph());
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    @Override
    public B getNewBean(Class<B> beanClass, EntityDetail entity, String methodName) throws PropertyServerException {
        return this.getNewComplexBean(beanClass, entity, (Relationship)null, null, methodName);
    }

    @Override
    public B getNewBean(Class<B> beanClass, EntityDetail entity, Relationship relationship, String methodName) throws PropertyServerException {
        return this.getNewComplexBean(beanClass, entity, relationship, null, methodName);
    }
}

