/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.GlossaryTermBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIAnchorHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.generichandlers.RelatedEntity;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ClassificationOrigin;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.RelationshipDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class GlossaryTermHandler<B>
extends ReferenceableHandler<B> {
    public GlossaryTermHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public List<String> getTermRelationshipTypeNames() {
        List knownTypeDefs = this.repositoryHelper.getKnownTypeDefs();
        ArrayList<String> relationshipNames = new ArrayList<String>();
        if (knownTypeDefs != null) {
            for (TypeDef typeDef : knownTypeDefs) {
                RelationshipDef relationshipDef;
                if (typeDef == null || typeDef.getStatus() != TypeDefStatus.ACTIVE_TYPEDEF || !(typeDef instanceof RelationshipDef) || !(relationshipDef = (RelationshipDef)typeDef).getEndDef1().getEntityType().getName().equals(OpenMetadataType.GLOSSARY_TERM.typeName) || !relationshipDef.getEndDef2().getEntityType().getName().equals(OpenMetadataType.GLOSSARY_TERM.typeName)) continue;
                relationshipNames.add(relationshipDef.getName());
            }
        }
        return relationshipNames;
    }

    public String createGlossaryTerm(String userId, String externalSourceGUID, String externalSourceName, String glossaryGUID, String glossaryGUIDParameterName, String qualifiedName, String displayName, List<String> aliases, String summary, String description, String examples, String abbreviation, String usage, String publishVersionIdentifier, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, InstanceStatus initialStatus, Date effectiveFrom, Date effectiveTo, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String typeName = suppliedTypeName != null ? suppliedTypeName : (initialStatus == null || initialStatus == InstanceStatus.ACTIVE ? OpenMetadataType.GLOSSARY_TERM.typeName : OpenMetadataType.CONTROLLED_GLOSSARY_TERM.typeName);
        TypeDef glossaryTypeDef = this.invalidParameterHandler.validateTypeDefName(typeName, OpenMetadataType.GLOSSARY_TERM.typeName, this.serviceName, methodName, this.repositoryHelper);
        InstanceStatus instanceStatus = initialStatus != null ? initialStatus : glossaryTypeDef.getInitialStatus();
        GlossaryTermBuilder builder = new GlossaryTermBuilder(qualifiedName, displayName, aliases, summary, description, examples, abbreviation, usage, publishVersionIdentifier, additionalProperties, extendedProperties, instanceStatus, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setAnchors(userId, null, typeName, OpenMetadataType.GLOSSARY_TERM.typeName, glossaryGUID, methodName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        String glossaryTermGUID = this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, glossaryTypeDef.getGUID(), glossaryTypeDef.getName(), builder, effectiveTime, methodName);
        if (glossaryTermGUID != null) {
            String glossaryTermGUIDParameterName = "glossaryTermGUID";
            this.uncheckedLinkElementToElement(userId, externalSourceGUID, externalSourceName, glossaryGUID, glossaryGUIDParameterName, glossaryTermGUID, "glossaryTermGUID", OpenMetadataType.TERM_ANCHOR_RELATIONSHIP.typeGUID, null, methodName);
        }
        return glossaryTermGUID;
    }

    public String createGlossaryTermFromTemplate(String userId, String externalSourceGUID, String externalSourceName, String glossaryGUID, String glossaryGUIDParameterName, String templateGUID, String qualifiedName, String displayName, List<String> aliases, String description, String publishVersionIdentifier, InstanceStatus initialStatus, boolean deepCopy, boolean templateSubstitute, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        GlossaryTermBuilder builder = new GlossaryTermBuilder(qualifiedName, displayName, aliases, description, publishVersionIdentifier, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setAnchors(userId, null, OpenMetadataType.GLOSSARY_TERM.typeName, OpenMetadataType.GLOSSARY_TERM.typeName, glossaryGUID, methodName);
        String glossaryTermGUID = this.createBeanFromTemplate(userId, externalSourceGUID, externalSourceName, templateGUID, "templateGUID", OpenMetadataType.GLOSSARY_TERM.typeGUID, OpenMetadataType.GLOSSARY_TERM.typeName, qualifiedName, OpenMetadataProperty.QUALIFIED_NAME.name, builder, this.supportedZones, deepCopy, templateSubstitute, null, methodName);
        if (glossaryTermGUID != null) {
            String glossaryTermGUIDParameterName = "glossaryTermGUID";
            if (initialStatus != null) {
                this.updateBeanStatusInRepository(userId, externalSourceGUID, externalSourceName, glossaryTermGUID, "glossaryTermGUID", OpenMetadataType.GLOSSARY_TERM.typeGUID, OpenMetadataType.GLOSSARY_TERM.typeName, false, false, initialStatus, "initialStatus", null, methodName);
            }
            this.uncheckedLinkElementToElement(userId, externalSourceGUID, externalSourceName, glossaryGUID, glossaryGUIDParameterName, glossaryTermGUID, "glossaryTermGUID", OpenMetadataType.TERM_ANCHOR_RELATIONSHIP.typeGUID, null, methodName);
        }
        return glossaryTermGUID;
    }

    public void updateGlossaryTerm(String userId, String externalSourceGUID, String externalSourceName, String glossaryTermGUID, String glossaryTermGUIDParameterName, String qualifiedName, String displayName, List<String> aliases, String summary, String description, String examples, String abbreviation, String usage, String publishVersionIdentifier, Map<String, String> additionalProperties, String typeName, Map<String, Object> extendedProperties, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, OpenMetadataType.GLOSSARY_TERM.typeName, this.serviceName, methodName, this.repositoryHelper);
        GlossaryTermBuilder builder = new GlossaryTermBuilder(qualifiedName, displayName, aliases, summary, description, examples, abbreviation, usage, publishVersionIdentifier, additionalProperties, extendedProperties, InstanceStatus.ACTIVE, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, glossaryTermGUID, glossaryTermGUIDParameterName, typeGUID, typeName, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, builder.getInstanceProperties(methodName), isMergeUpdate, effectiveTime, methodName);
    }

    public void updateGlossaryTermStatus(String userId, String externalSourceGUID, String externalSourceName, String glossaryTermGUID, String glossaryTermGUIDParameterName, InstanceStatus glossaryTermStatus, String glossaryTermStatusParameterName, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.updateBeanStatusInRepository(userId, externalSourceGUID, externalSourceName, glossaryTermGUID, glossaryTermGUIDParameterName, OpenMetadataType.GLOSSARY_TERM.typeGUID, OpenMetadataType.GLOSSARY_TERM.typeName, forLineage, forDuplicateProcessing, this.supportedZones, glossaryTermStatus, glossaryTermStatusParameterName, effectiveTime, methodName);
    }

    public EntityDetail updateGlossaryTermFromTemplate(String userId, String externalSourceGUID, String externalSourceName, String glossaryTermGUID, String glossaryTermGUIDParameterName, String templateGUID, String templateGUIDParameterName, boolean isMergeClassifications, boolean isMergeProperties, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        EntityDetail templateEntity = this.repositoryHandler.getEntityByGUID(userId, templateGUID, templateGUIDParameterName, OpenMetadataType.GLOSSARY_TERM.typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        EntityDetail termEntity = this.repositoryHandler.getEntityByGUID(userId, glossaryTermGUID, glossaryTermGUIDParameterName, OpenMetadataType.GLOSSARY_TERM.typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (templateEntity != null) {
            InstanceProperties templateProperties = null;
            if (templateEntity.getProperties() != null) {
                templateProperties = new InstanceProperties();
                templateProperties.setEffectiveFromTime(templateEntity.getProperties().getEffectiveFromTime());
                templateProperties.setEffectiveToTime(templateEntity.getProperties().getEffectiveToTime());
                if (templateEntity.getProperties().getPropertyCount() > 0) {
                    Iterator propertyNames = templateEntity.getProperties().getPropertyNames();
                    while (propertyNames.hasNext()) {
                        String propertyName = (String)propertyNames.next();
                        if (OpenMetadataProperty.QUALIFIED_NAME.name.equals(propertyName)) continue;
                        templateProperties.setProperty(propertyName, templateEntity.getProperties().getPropertyValue(propertyName));
                    }
                }
            }
            this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, termEntity, glossaryTermGUIDParameterName, OpenMetadataType.GLOSSARY_TERM.typeGUID, OpenMetadataType.GLOSSARY_TERM.typeName, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, templateProperties, isMergeProperties, effectiveTime, methodName);
            ArrayList<String> updatedClassifications = new ArrayList<String>();
            if (templateEntity.getClassifications() != null) {
                for (Classification classification : templateEntity.getClassifications()) {
                    if (OpenMetadataType.ANCHORS_CLASSIFICATION.typeName.equals(classification.getName())) continue;
                    this.setClassificationInRepository(userId, externalSourceGUID, externalSourceName, termEntity, glossaryTermGUIDParameterName, OpenMetadataType.GLOSSARY_TERM.typeName, classification.getType().getTypeDefGUID(), classification.getType().getTypeDefName(), classification.getProperties(), isMergeProperties, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, effectiveTime, methodName);
                    updatedClassifications.add(classification.getName());
                }
            }
            if (!isMergeClassifications && termEntity.getClassifications() != null) {
                for (Classification classification : termEntity.getClassifications()) {
                    if (OpenMetadataType.ANCHORS_CLASSIFICATION.typeName.equals(classification.getName()) || updatedClassifications.contains(classification.getName())) continue;
                    this.removeClassificationFromRepository(userId, externalSourceGUID, externalSourceName, termEntity.getGUID(), glossaryTermGUIDParameterName, OpenMetadataType.GLOSSARY_TERM.typeName, classification.getType().getTypeDefGUID(), classification.getType().getTypeDefName(), forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
                }
            }
        }
        return termEntity;
    }

    public void moveGlossaryTerm(String userId, String externalSourceGUID, String externalSourceName, String glossaryTermGUID, String glossaryTermGUIDParameterName, String newGlossaryGUID, String newGlossaryGUIDParameterName, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        EntityDetail termEntity = this.repositoryHandler.getEntityByGUID(userId, glossaryTermGUID, glossaryTermGUIDParameterName, OpenMetadataType.GLOSSARY_TERM.typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        List<Relationship> termAnchors = this.getAttachmentLinks(userId, termEntity.getGUID(), glossaryTermGUIDParameterName, OpenMetadataType.GLOSSARY_TERM.typeName, OpenMetadataType.TERM_ANCHOR_RELATIONSHIP.typeGUID, OpenMetadataType.TERM_ANCHOR_RELATIONSHIP.typeName, null, OpenMetadataType.GLOSSARY.typeName, 1, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, 0, 0, effectiveTime, methodName);
        if (termAnchors != null) {
            for (Relationship termAnchor : termAnchors) {
                if (termAnchor == null) continue;
                this.repositoryHandler.removeRelationship(userId, externalSourceGUID, externalSourceName, termAnchor, methodName);
            }
        }
        this.removeClassificationFromRepository(userId, externalSourceGUID, externalSourceName, termEntity.getGUID(), glossaryTermGUIDParameterName, OpenMetadataType.GLOSSARY_TERM.typeName, OpenMetadataType.ANCHORS_CLASSIFICATION.typeGUID, OpenMetadataType.ANCHORS_CLASSIFICATION.typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, newGlossaryGUID, newGlossaryGUIDParameterName, OpenMetadataType.GLOSSARY.typeName, termEntity.getGUID(), glossaryTermGUIDParameterName, OpenMetadataType.GLOSSARY_TERM.typeName, forLineage, forDuplicateProcessing, this.supportedZones, OpenMetadataType.TERM_ANCHOR_RELATIONSHIP.typeGUID, OpenMetadataType.TERM_ANCHOR_RELATIONSHIP.typeName, null, null, null, effectiveTime, methodName);
    }

    public void setTermAsAbstractConcept(String userId, String externalSourceGUID, String externalSourceName, String glossaryTermGUID, String glossaryTermGUIDParameterName, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.setClassificationInRepository(userId, externalSourceGUID, externalSourceName, glossaryTermGUID, glossaryTermGUIDParameterName, OpenMetadataType.GLOSSARY_TERM.typeName, OpenMetadataType.ABSTRACT_CONCEPT_CLASSIFICATION.typeGUID, OpenMetadataType.ABSTRACT_CONCEPT_CLASSIFICATION.typeName, this.setUpEffectiveDates(null, effectiveFrom, effectiveTo), isMergeUpdate, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void clearTermAsAbstractConcept(String userId, String externalSourceGUID, String externalSourceName, String glossaryTermGUID, String glossaryTermGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.removeClassificationFromRepository(userId, externalSourceGUID, externalSourceName, glossaryTermGUID, glossaryTermGUIDParameterName, OpenMetadataType.GLOSSARY_TERM.typeName, OpenMetadataType.ABSTRACT_CONCEPT_CLASSIFICATION.typeGUID, OpenMetadataType.ABSTRACT_CONCEPT_CLASSIFICATION.typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void setTermAsDataValue(String userId, String externalSourceGUID, String externalSourceName, String glossaryTermGUID, String glossaryTermGUIDParameterName, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.setClassificationInRepository(userId, externalSourceGUID, externalSourceName, glossaryTermGUID, glossaryTermGUIDParameterName, OpenMetadataType.GLOSSARY_TERM.typeName, OpenMetadataType.DATA_VALUE_CLASSIFICATION.typeGUID, OpenMetadataType.DATA_VALUE_CLASSIFICATION.typeName, this.setUpEffectiveDates(null, effectiveFrom, effectiveTo), isMergeUpdate, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void clearTermAsDataValue(String userId, String externalSourceGUID, String externalSourceName, String glossaryTermGUID, String glossaryTermGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.removeClassificationFromRepository(userId, externalSourceGUID, externalSourceName, glossaryTermGUID, glossaryTermGUIDParameterName, OpenMetadataType.GLOSSARY_TERM.typeName, OpenMetadataType.DATA_VALUE_CLASSIFICATION.typeGUID, OpenMetadataType.DATA_VALUE_CLASSIFICATION.typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void setTermAsActivity(String userId, String externalSourceGUID, String externalSourceName, String glossaryTermGUID, String glossaryTermGUIDParameterName, int activityType, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        GlossaryTermBuilder builder = new GlossaryTermBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        this.setClassificationInRepository(userId, externalSourceGUID, externalSourceName, glossaryTermGUID, glossaryTermGUIDParameterName, OpenMetadataType.GLOSSARY_TERM.typeName, OpenMetadataType.ACTIVITY_DESCRIPTION_CLASSIFICATION.typeGUID, OpenMetadataType.ACTIVITY_DESCRIPTION_CLASSIFICATION.typeName, builder.getActivityTypeProperties(activityType, methodName), isMergeUpdate, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void clearTermAsActivity(String userId, String externalSourceGUID, String externalSourceName, String glossaryTermGUID, String glossaryTermGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.removeClassificationFromRepository(userId, externalSourceGUID, externalSourceName, glossaryTermGUID, glossaryTermGUIDParameterName, OpenMetadataType.GLOSSARY_TERM.typeName, OpenMetadataType.ACTIVITY_DESCRIPTION_CLASSIFICATION.typeGUID, OpenMetadataType.ACTIVITY_DESCRIPTION_CLASSIFICATION.typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void setTermAsContext(String userId, String externalSourceGUID, String externalSourceName, String glossaryTermGUID, String glossaryTermGUIDParameterName, String description, String scope, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        GlossaryTermBuilder builder = new GlossaryTermBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        this.setClassificationInRepository(userId, externalSourceGUID, externalSourceName, glossaryTermGUID, glossaryTermGUIDParameterName, OpenMetadataType.GLOSSARY_TERM.typeName, OpenMetadataType.CONTEXT_DEFINITION_CLASSIFICATION.typeGUID, OpenMetadataType.CONTEXT_DEFINITION_CLASSIFICATION.typeName, builder.getContextDescriptionProperties(description, scope, methodName), isMergeUpdate, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void clearTermAsContext(String userId, String externalSourceGUID, String externalSourceName, String glossaryTermGUID, String glossaryTermGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.removeClassificationFromRepository(userId, externalSourceGUID, externalSourceName, glossaryTermGUID, glossaryTermGUIDParameterName, OpenMetadataType.GLOSSARY_TERM.typeName, OpenMetadataType.CONTEXT_DEFINITION_CLASSIFICATION.typeGUID, OpenMetadataType.CONTEXT_DEFINITION_CLASSIFICATION.typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void setTermAsSpineObject(String userId, String externalSourceGUID, String externalSourceName, String glossaryTermGUID, String glossaryTermGUIDParameterName, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.setClassificationInRepository(userId, externalSourceGUID, externalSourceName, glossaryTermGUID, glossaryTermGUIDParameterName, OpenMetadataType.GLOSSARY_TERM.typeName, OpenMetadataType.SPINE_OBJECT_CLASSIFICATION.typeGUID, OpenMetadataType.SPINE_OBJECT_CLASSIFICATION.typeName, this.setUpEffectiveDates(null, effectiveFrom, effectiveTo), isMergeUpdate, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void clearTermAsSpineObject(String userId, String externalSourceGUID, String externalSourceName, String glossaryTermGUID, String glossaryTermGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.removeClassificationFromRepository(userId, externalSourceGUID, externalSourceName, glossaryTermGUID, glossaryTermGUIDParameterName, OpenMetadataType.GLOSSARY_TERM.typeName, OpenMetadataType.SPINE_OBJECT_CLASSIFICATION.typeGUID, OpenMetadataType.SPINE_OBJECT_CLASSIFICATION.typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void setTermAsSpineAttribute(String userId, String externalSourceGUID, String externalSourceName, String glossaryTermGUID, String glossaryTermGUIDParameterName, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.setClassificationInRepository(userId, externalSourceGUID, externalSourceName, glossaryTermGUID, glossaryTermGUIDParameterName, OpenMetadataType.GLOSSARY_TERM.typeName, OpenMetadataType.SPINE_ATTRIBUTE_CLASSIFICATION.typeGUID, OpenMetadataType.SPINE_ATTRIBUTE_CLASSIFICATION.typeName, this.setUpEffectiveDates(null, effectiveFrom, effectiveTo), isMergeUpdate, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void clearTermAsSpineAttribute(String userId, String externalSourceGUID, String externalSourceName, String glossaryTermGUID, String glossaryTermGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.removeClassificationFromRepository(userId, externalSourceGUID, externalSourceName, glossaryTermGUID, glossaryTermGUIDParameterName, OpenMetadataType.GLOSSARY_TERM.typeName, OpenMetadataType.SPINE_ATTRIBUTE_CLASSIFICATION.typeGUID, OpenMetadataType.SPINE_ATTRIBUTE_CLASSIFICATION.typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void setTermAsObjectIdentifier(String userId, String externalSourceGUID, String externalSourceName, String glossaryTermGUID, String glossaryTermGUIDParameterName, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.setClassificationInRepository(userId, externalSourceGUID, externalSourceName, glossaryTermGUID, glossaryTermGUIDParameterName, OpenMetadataType.GLOSSARY_TERM.typeName, OpenMetadataType.OBJECT_IDENTIFIER_CLASSIFICATION.typeGUID, OpenMetadataType.OBJECT_IDENTIFIER_CLASSIFICATION.typeName, this.setUpEffectiveDates(null, effectiveFrom, effectiveTo), isMergeUpdate, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void clearTermAsObjectIdentifier(String userId, String externalSourceGUID, String externalSourceName, String glossaryTermGUID, String glossaryTermGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(glossaryTermGUID, glossaryTermGUIDParameterName, methodName);
        this.removeClassificationFromRepository(userId, externalSourceGUID, externalSourceName, glossaryTermGUID, glossaryTermGUIDParameterName, OpenMetadataType.GLOSSARY_TERM.typeName, OpenMetadataType.OBJECT_IDENTIFIER_CLASSIFICATION.typeGUID, OpenMetadataType.OBJECT_IDENTIFIER_CLASSIFICATION.typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void archiveGlossaryTerm(String userId, String assetManagerGUID, String assetManagerName, String glossaryTermGUID, String glossaryTermGUIDParameterName, Date archiveDate, String archiveProcess, Map<String, String> archiveProperties, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        EntityDetail entity = this.getEntityFromRepository(userId, glossaryTermGUID, glossaryTermGUIDParameterName, OpenMetadataType.GLOSSARY_TERM.typeName, null, null, true, forDuplicateProcessing, effectiveTime, methodName);
        ReferenceableBuilder builder = new ReferenceableBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        this.repositoryHandler.classifyEntity(userId, assetManagerGUID, assetManagerName, entity.getGUID(), entity, glossaryTermGUIDParameterName, OpenMetadataType.GLOSSARY_TERM.typeName, OpenMetadataType.MEMENTO_CLASSIFICATION.typeGUID, OpenMetadataType.MEMENTO_CLASSIFICATION.typeName, ClassificationOrigin.ASSIGNED, entity.getGUID(), builder.getMementoProperties(archiveDate, userId, archiveProcess, archiveProperties, methodName), true, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void removeGlossaryTerm(String userId, String externalSourceGUID, String externalSourceName, String glossaryTermGUID, String glossaryTermGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, glossaryTermGUID, glossaryTermGUIDParameterName, OpenMetadataType.GLOSSARY_TERM.typeGUID, OpenMetadataType.GLOSSARY_TERM.typeName, false, null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> getTermsByName(String userId, String glossaryGUID, String name, List<InstanceStatus> limitResultsByStatus, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        InstanceProperties matchProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.QUALIFIED_NAME.name, name, methodName);
        matchProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, matchProperties, OpenMetadataProperty.DISPLAY_NAME.name, name, methodName);
        matchProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, matchProperties, OpenMetadataProperty.ALIASES.name, name, methodName);
        List termEntities = this.repositoryHandler.getEntitiesByName(userId, matchProperties, OpenMetadataType.GLOSSARY_TERM.typeGUID, limitResultsByStatus, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, startFrom, queryPageSize, effectiveTime, methodName);
        return this.getValidTerms(userId, glossaryGUID, effectiveTime, forLineage, forDuplicateProcessing, methodName, termEntities);
    }

    private List<B> getValidTerms(String userId, String glossaryGUID, Date effectiveTime, boolean forLineage, boolean forDuplicateProcessing, String methodName, List<EntityDetail> termEntities) {
        if (termEntities != null) {
            List<EntityDetail> validatedTerms = super.validateEntitiesAndAnchorsForRead(userId, termEntities, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
            ArrayList<B> results = new ArrayList<B>();
            for (EntityDetail entity : validatedTerms) {
                if (entity == null) continue;
                try {
                    if (glossaryGUID == null) {
                        results.add(this.getGlossaryTermBean(userId, entity, null, forLineage, forDuplicateProcessing, effectiveTime));
                        continue;
                    }
                    OpenMetadataAPIAnchorHandler.AnchorIdentifiers anchorIdentifiers = this.getAnchorsFromAnchorsClassification((EntitySummary)entity, methodName);
                    if (!glossaryGUID.equals(anchorIdentifiers.anchorScopeGUID)) continue;
                    results.add(this.getGlossaryTermBean(userId, entity, null, forLineage, forDuplicateProcessing, effectiveTime));
                }
                catch (Exception exception) {}
            }
            if (!results.isEmpty()) {
                return results;
            }
        }
        return null;
    }

    public List<B> findTerms(String userId, String glossaryGUID, String searchString, List<InstanceStatus> limitResultsByStatus, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        List termEntities = this.repositoryHandler.getEntitiesByValue(userId, searchString, OpenMetadataType.GLOSSARY_TERM.typeGUID, limitResultsByStatus, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, startFrom, queryPageSize, effectiveTime, methodName);
        return this.getValidTerms(userId, glossaryGUID, effectiveTime, forLineage, forDuplicateProcessing, methodName, termEntities);
    }

    public B getTerm(String userId, String guid, String guidParameter, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        EntityDetail entity = this.getEntityFromRepository(userId, guid, guidParameter, OpenMetadataType.GLOSSARY_TERM.typeName, null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return this.getGlossaryTermBean(userId, entity, null, forLineage, forDuplicateProcessing, effectiveTime);
    }

    public List<B> getTermsForGlossary(String userId, String glossaryGUID, String glossaryGUIDParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateGUID(glossaryGUID, glossaryGUIDParameterName, methodName);
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        EntityDetail glossaryEntity = this.repositoryHandler.getEntityByGUID(userId, glossaryGUID, glossaryGUIDParameterName, OpenMetadataType.GLOSSARY.typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.securityVerifier.validateUserForElementRead(userId, glossaryEntity, this.repositoryHelper, this.serviceName, methodName);
        InstanceProperties matchProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.ANCHOR_SCOPE_GUID.name, glossaryGUID, methodName);
        List termEntities = this.repositoryHandler.getEntitiesForClassificationType(userId, OpenMetadataType.GLOSSARY_TERM.typeGUID, OpenMetadataType.ANCHORS_CLASSIFICATION.typeName, matchProperties, MatchCriteria.ALL, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, startFrom, queryPageSize, effectiveTime, methodName);
        return this.getGlossaryTermBeans(userId, termEntities, forLineage, forDuplicateProcessing, effectiveTime);
    }

    private List<B> getGlossaryTermBeans(String userId, List<EntityDetail> termEntities, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (termEntities != null) {
            ArrayList<B> results = new ArrayList<B>();
            for (EntityDetail termEntity : termEntities) {
                results.add(this.getGlossaryTermBean(userId, termEntity, null, forLineage, forDuplicateProcessing, effectiveTime));
            }
            return results;
        }
        return null;
    }

    private List<B> getGlossaryTermBeans(String userId, List<RelatedEntity> relatedTerms, List<Integer> limitResultsByStatus, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGlossaryTermBeans";
        if (relatedTerms != null) {
            ArrayList<B> results = new ArrayList<B>();
            for (RelatedEntity relatedTerm : relatedTerms) {
                if (relatedTerm == null || relatedTerm.relationship() == null || relatedTerm.entityDetail() == null) continue;
                if (limitResultsByStatus != null && !limitResultsByStatus.isEmpty()) {
                    Integer relationshipOrdinal = this.repositoryHelper.getEnumPropertyOrdinal(this.serviceName, OpenMetadataProperty.TERM_RELATIONSHIP_STATUS.name, relatedTerm.relationship().getProperties(), "getGlossaryTermBeans");
                    if (!limitResultsByStatus.contains(relationshipOrdinal)) continue;
                    results.add(this.getGlossaryTermBean(userId, relatedTerm.entityDetail(), relatedTerm.relationship(), forLineage, forDuplicateProcessing, effectiveTime));
                    continue;
                }
                results.add(this.getGlossaryTermBean(userId, relatedTerm.entityDetail(), relatedTerm.relationship(), forLineage, forDuplicateProcessing, effectiveTime));
            }
            return results;
        }
        return null;
    }

    private B getGlossaryTermBean(String userId, EntityDetail termEntity, Relationship relatedByRelationship, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "getGlossaryTermBeans";
        String startingGUIDParameterName = "termEntity.guid";
        if (termEntity != null) {
            List<RelatedEntity> relatedEntities = this.getAllRelatedEntities(userId, termEntity, "termEntity.guid", OpenMetadataType.GLOSSARY_TERM.typeName, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, "getGlossaryTermBeans");
            return this.converter.getNewComplexBean(this.beanClass, termEntity, relatedByRelationship, relatedEntities, "getGlossaryTermBeans");
        }
        return null;
    }

    public List<B> getTermsForGlossaryCategory(String userId, String glossaryCategoryGUID, String glossaryCategoryGUIDParameterName, List<Integer> limitResultsByStatus, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        EntityDetail categoryEntity = this.getEntityFromRepository(userId, glossaryCategoryGUID, glossaryCategoryGUIDParameterName, OpenMetadataType.GLOSSARY_CATEGORY.typeName, null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        List<RelatedEntity> relatedTerms = this.getRelatedEntities(userId, categoryEntity, glossaryCategoryGUIDParameterName, OpenMetadataType.GLOSSARY_CATEGORY.typeName, OpenMetadataType.TERM_CATEGORIZATION.typeGUID, OpenMetadataType.TERM_CATEGORIZATION.typeName, null, OpenMetadataType.GLOSSARY_TERM.typeName, 2, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
        return this.getGlossaryTermBeans(userId, relatedTerms, limitResultsByStatus, forLineage, forDuplicateProcessing, effectiveTime);
    }

    public List<B> getRelatedTerms(String userId, String glossaryTermGUID, String glossaryTermGUIDParameterName, String relationshipTypeName, List<Integer> limitResultsByStatus, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String relationshipTypeGUID = null;
        if (relationshipTypeName != null) {
            relationshipTypeGUID = this.invalidParameterHandler.validateTypeName(relationshipTypeName, relationshipTypeName, this.serviceName, methodName, this.repositoryHelper);
        }
        EntityDetail startingTermEntity = this.getEntityFromRepository(userId, glossaryTermGUID, glossaryTermGUIDParameterName, OpenMetadataType.GLOSSARY_TERM.typeName, null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        List<RelatedEntity> relatedTerms = this.getRelatedEntities(userId, startingTermEntity, glossaryTermGUIDParameterName, OpenMetadataType.GLOSSARY_TERM.typeName, relationshipTypeGUID, relationshipTypeName, null, OpenMetadataType.GLOSSARY_TERM.typeName, 0, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
        return this.getGlossaryTermBeans(userId, relatedTerms, limitResultsByStatus, forLineage, forDuplicateProcessing, effectiveTime);
    }

    public List<B> getAttachedMeanings(String userId, String elementGUID, String elementGUIDParameterName, String elementTypeName, List<String> serviceSupportedZones, int startingFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        EntityDetail startingEntity = this.getEntityFromRepository(userId, elementGUID, elementGUIDParameterName, elementTypeName, null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        List<RelatedEntity> relatedTerms = this.getRelatedEntities(userId, startingEntity, elementGUIDParameterName, OpenMetadataType.GLOSSARY_TERM.typeName, OpenMetadataType.SEMANTIC_ASSIGNMENT_RELATIONSHIP.typeGUID, OpenMetadataType.SEMANTIC_ASSIGNMENT_RELATIONSHIP.typeName, null, OpenMetadataType.GLOSSARY_TERM.typeName, 0, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, serviceSupportedZones, startingFrom, pageSize, effectiveTime, methodName);
        return this.getGlossaryTermBeans(userId, relatedTerms, null, forLineage, forDuplicateProcessing, effectiveTime);
    }
}

