/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.Map;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableBuilder;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class GovernanceActionProcessStepBuilder
extends ReferenceableBuilder {
    private final int domainIdentifier;
    private final String displayName;
    private final String description;
    private final boolean ignoreMultipleTriggers;
    private final int waitTime;

    GovernanceActionProcessStepBuilder(String qualifiedName, int domainIdentifier, String displayName, String description, boolean ignoreMultipleTriggers, int waitTime, Map<String, String> additionalProperties, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, additionalProperties, OpenMetadataType.GOVERNANCE_ACTION_PROCESS_STEP.typeGUID, OpenMetadataType.GOVERNANCE_ACTION_PROCESS_STEP.typeName, null, repositoryHelper, serviceName, serverName);
        this.domainIdentifier = domainIdentifier;
        this.displayName = displayName;
        this.description = description;
        this.ignoreMultipleTriggers = ignoreMultipleTriggers;
        this.waitTime = waitTime;
    }

    @Override
    public InstanceProperties getInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = super.getInstanceProperties(methodName);
        properties = this.repositoryHelper.addIntPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.DOMAIN_IDENTIFIER.name, this.domainIdentifier, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.DISPLAY_NAME.name, this.displayName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.DESCRIPTION.name, this.description, methodName);
        properties = this.repositoryHelper.addBooleanPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.IGNORE_MULTIPLE_TRIGGERS.name, this.ignoreMultipleTriggers, methodName);
        properties = this.repositoryHelper.addIntPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.WAIT_TIME.name, this.waitTime, methodName);
        return properties;
    }
}

