/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableBuilder;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class GovernanceDefinitionBuilder
extends ReferenceableBuilder {
    private String title = null;
    private String summary = null;
    private String description = null;
    private String scope = null;
    private int domainIdentifier = 0;
    private String priority = null;
    private List<String> implications = null;
    private List<String> outcomes = null;
    private List<String> results = null;
    private List<String> businessImperatives = null;
    private String jurisdiction = null;
    private String implementationDescription = null;
    private List<String> namePatterns = null;
    private String details = null;
    private String distinguishedName = null;

    GovernanceDefinitionBuilder(String qualifiedName, String title, String summary, String description, String scope, int domainIdentifier, String priority, List<String> implications, List<String> outcomes, List<String> results, List<String> businessImperatives, String jurisdiction, String implementationDescription, List<String> namePatterns, String details, String distinguishedName, Map<String, String> additionalProperties, String typeGUID, String typeName, Map<String, Object> extendedProperties, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, additionalProperties, typeGUID, typeName, extendedProperties, repositoryHelper, serviceName, serverName);
        this.title = title;
        this.summary = summary;
        this.description = description;
        this.scope = scope;
        this.domainIdentifier = domainIdentifier;
        this.priority = priority;
        this.implications = implications;
        this.outcomes = outcomes;
        this.results = results;
        this.businessImperatives = businessImperatives;
        this.jurisdiction = jurisdiction;
        this.implementationDescription = implementationDescription;
        this.namePatterns = namePatterns;
        this.details = details;
        this.distinguishedName = distinguishedName;
    }

    GovernanceDefinitionBuilder(String qualifiedName, String title, String description, String typeGUID, String typeName, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, null, typeGUID, typeName, null, repositoryHelper, serviceName, serverName);
        this.title = title;
        this.description = description;
    }

    GovernanceDefinitionBuilder(String typeGUID, String typeName, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(typeGUID, typeName, repositoryHelper, serviceName, serverName);
    }

    @Override
    public InstanceProperties getInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = super.getInstanceProperties(methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.TITLE.name, this.title, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.SUMMARY.name, this.summary, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.DESCRIPTION.name, this.description, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.SCOPE.name, this.scope, methodName);
        properties = this.repositoryHelper.addIntPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.DOMAIN_IDENTIFIER.name, this.domainIdentifier, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.IMPORTANCE.name, this.priority, methodName);
        properties = this.repositoryHelper.addStringArrayPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.IMPLICATIONS.name, this.implications, methodName);
        properties = this.repositoryHelper.addStringArrayPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.OUTCOMES.name, this.outcomes, methodName);
        properties = this.repositoryHelper.addStringArrayPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.RESULTS.name, this.results, methodName);
        properties = this.repositoryHelper.addStringArrayPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.BUSINESS_IMPERATIVES.name, this.businessImperatives, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.JURISDICTION.name, this.jurisdiction, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.IMPLEMENTATION_DESCRIPTION.name, this.implementationDescription, methodName);
        properties = this.repositoryHelper.addStringArrayPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.NAME_PATTERNS.name, this.namePatterns, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.DETAILS.name, this.details, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.DISTINGUISHED_NAME.name, this.distinguishedName, methodName);
        return properties;
    }
}

