/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.commonservices.generichandlers.OMFConverter;
import org.odpi.openmetadata.commonservices.mermaid.GovernanceDefinitionMermaidGraphBuilder;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.GovernanceDefinitionGraph;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.RelatedElementStub;
import org.odpi.openmetadata.frameworks.openmetadata.properties.governance.CertificationTypeProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.governance.GovernanceDefinitionProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.governance.LicenseTypeProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.security.SecurityGroupProperties;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class GovernanceDefinitionGraphConverter<B>
extends OMFConverter<B> {
    public GovernanceDefinitionGraphConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    @Override
    public B getNewComplexBean(Class<B> beanClass, EntityDetail primaryEntity, List<Relationship> relationships, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof GovernanceDefinitionGraph) {
                GovernanceDefinitionGraph bean = (GovernanceDefinitionGraph)returnBean;
                if (primaryEntity != null) {
                    CertificationTypeProperties governanceDefinitionProperties;
                    bean.setElementHeader(this.getMetadataElementHeader(beanClass, (InstanceHeader)primaryEntity, primaryEntity.getClassifications(), methodName));
                    InstanceProperties instanceProperties = new InstanceProperties(primaryEntity.getProperties());
                    String typeName = primaryEntity.getType().getTypeDefName();
                    if (this.repositoryHelper.isTypeOf(this.serviceName, typeName, OpenMetadataType.CERTIFICATION_TYPE.typeName)) {
                        governanceDefinitionProperties = new CertificationTypeProperties();
                        governanceDefinitionProperties.setDetails(this.removeDetails(instanceProperties));
                    } else if (this.repositoryHelper.isTypeOf(this.serviceName, typeName, OpenMetadataType.LICENSE_TYPE.typeName)) {
                        governanceDefinitionProperties = new LicenseTypeProperties();
                        ((LicenseTypeProperties)governanceDefinitionProperties).setDetails(this.removeDetails(instanceProperties));
                    } else if (this.repositoryHelper.isTypeOf(this.serviceName, typeName, OpenMetadataType.SECURITY_GROUP.typeName)) {
                        governanceDefinitionProperties = new SecurityGroupProperties();
                        ((SecurityGroupProperties)governanceDefinitionProperties).setDistinguishedName(this.removeDistinguishedName(instanceProperties));
                    } else {
                        governanceDefinitionProperties = new GovernanceDefinitionProperties();
                    }
                    governanceDefinitionProperties.setDocumentIdentifier(this.removeQualifiedName(instanceProperties));
                    governanceDefinitionProperties.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                    governanceDefinitionProperties.setTitle(this.removeTitle(instanceProperties));
                    governanceDefinitionProperties.setSummary(this.removeSummary(instanceProperties));
                    governanceDefinitionProperties.setDescription(this.removeDescription(instanceProperties));
                    governanceDefinitionProperties.setScope(this.removeScope(instanceProperties));
                    governanceDefinitionProperties.setDomainIdentifier(this.removeDomainIdentifier(instanceProperties));
                    governanceDefinitionProperties.setImportance(this.removeImportance(instanceProperties));
                    governanceDefinitionProperties.setImplications(this.removeImplications(instanceProperties));
                    governanceDefinitionProperties.setOutcomes(this.removeOutcomes(instanceProperties));
                    governanceDefinitionProperties.setResults(this.removeResults(instanceProperties));
                    governanceDefinitionProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
                    governanceDefinitionProperties.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
                    bean.setProperties((GovernanceDefinitionProperties)governanceDefinitionProperties);
                    if (relationships != null) {
                        ArrayList<RelatedElementStub> parents = new ArrayList<RelatedElementStub>();
                        ArrayList<RelatedElementStub> peers = new ArrayList<RelatedElementStub>();
                        ArrayList<RelatedElementStub> children = new ArrayList<RelatedElementStub>();
                        ArrayList<RelatedElementStub> metrics = new ArrayList<RelatedElementStub>();
                        ArrayList<RelatedElementStub> externalReferences = new ArrayList<RelatedElementStub>();
                        ArrayList<RelatedElementStub> others = new ArrayList<RelatedElementStub>();
                        for (Relationship relationship : relationships) {
                            if (relationship == null) continue;
                            EntityProxy otherEnd = this.repositoryHelper.getOtherEnd(this.serviceName, primaryEntity.getGUID(), relationship);
                            RelatedElementStub element = super.getRelatedElement(beanClass, relationship, otherEnd, methodName);
                            if (this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), OpenMetadataType.EXTERNAL_REFERENCE_LINK_RELATIONSHIP.typeName)) {
                                externalReferences.add(element);
                                continue;
                            }
                            if (this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), OpenMetadataType.GOVERNANCE_DEFINITION_METRIC_RELATIONSHIP.typeName)) {
                                metrics.add(element);
                                continue;
                            }
                            if (this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), OpenMetadataType.GOVERNANCE_DRIVER_LINK_RELATIONSHIP.typeName) || this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), OpenMetadataType.GOVERNANCE_POLICY_LINK_RELATIONSHIP.typeName) || this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), OpenMetadataType.GOVERNANCE_CONTROL_LINK_RELATIONSHIP.typeName)) {
                                peers.add(element);
                                continue;
                            }
                            if (this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), OpenMetadataType.GOVERNANCE_RESPONSE_RELATIONSHIP.typeName) || this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), OpenMetadataType.GOVERNANCE_IMPLEMENTATION_RELATIONSHIP.typeName)) {
                                if (primaryEntity.getGUID().equals(relationship.getEntityTwoProxy().getGUID())) {
                                    parents.add(element);
                                    continue;
                                }
                                children.add(element);
                                continue;
                            }
                            others.add(element);
                        }
                        if (!parents.isEmpty()) {
                            bean.setParents(parents);
                        }
                        if (!peers.isEmpty()) {
                            bean.setPeers(peers);
                        }
                        if (!children.isEmpty()) {
                            bean.setChildren(children);
                        }
                        if (!metrics.isEmpty()) {
                            bean.setMetrics(metrics);
                        }
                        if (!externalReferences.isEmpty()) {
                            bean.setExternalReferences(externalReferences);
                        }
                        if (!others.isEmpty()) {
                            bean.setOthers(others);
                        }
                        GovernanceDefinitionMermaidGraphBuilder graphBuilder = new GovernanceDefinitionMermaidGraphBuilder(bean);
                        bean.setMermaidGraph(graphBuilder.getMermaidGraph());
                    }
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }
}

