/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.Map;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableBuilder;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class GovernanceMetricBuilder
extends ReferenceableBuilder {
    private String displayName = null;
    private String description = null;
    private String measurement = null;
    private String target = null;
    private int domainIdentifier = 0;

    GovernanceMetricBuilder(String qualifiedName, String displayName, String description, String measurement, String target, int domainIdentifier, Map<String, String> additionalProperties, String typeGUID, String typeName, Map<String, Object> extendedProperties, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, additionalProperties, typeGUID, typeName, extendedProperties, repositoryHelper, serviceName, serverName);
        this.displayName = displayName;
        this.description = description;
        this.measurement = measurement;
        this.target = target;
        this.domainIdentifier = domainIdentifier;
    }

    GovernanceMetricBuilder(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(OpenMetadataType.GOVERNANCE_METRIC.typeGUID, OpenMetadataType.GOVERNANCE_METRIC.typeName, repositoryHelper, serviceName, serverName);
    }

    @Override
    public InstanceProperties getInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = super.getInstanceProperties(methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.DISPLAY_NAME.name, this.displayName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.DESCRIPTION.name, this.description, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.MEASUREMENT.name, this.measurement, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.TARGET.name, this.target, methodName);
        properties = this.repositoryHelper.addIntPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.DOMAIN_IDENTIFIER.name, this.domainIdentifier, methodName);
        return properties;
    }
}

