/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.GovernanceMetricBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class GovernanceMetricHandler<B>
extends ReferenceableHandler<B> {
    private static final String qualifiedNameParameterName = "qualifiedName";

    public GovernanceMetricHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public String createGovernanceMetric(String userId, String externalSourceGUID, String externalSourceName, String qualifiedName, String displayName, String description, String measurement, String target, int domainIdentifier, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, Date effectiveFrom, Date effectiveTo, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, qualifiedNameParameterName, methodName);
        String typeName = OpenMetadataType.GOVERNANCE_METRIC.typeName;
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, OpenMetadataType.GOVERNANCE_METRIC.typeName, this.serviceName, methodName, this.repositoryHelper);
        GovernanceMetricBuilder builder = new GovernanceMetricBuilder(qualifiedName, displayName, description, measurement, target, domainIdentifier, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        return this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, typeGUID, typeName, builder, effectiveTime, methodName);
    }

    public void updateGovernanceMetric(String userId, String externalSourceGUID, String externalSourceName, String governanceMetricGUID, String governanceMetricGUIDParameterName, String qualifiedName, String displayName, String description, String measurement, String target, int domainIdentifier, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(governanceMetricGUID, governanceMetricGUIDParameterName, methodName);
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(qualifiedName, qualifiedNameParameterName, methodName);
        }
        String typeName = OpenMetadataType.GOVERNANCE_METRIC.typeName;
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, OpenMetadataType.GOVERNANCE_METRIC.typeName, this.serviceName, methodName, this.repositoryHelper);
        GovernanceMetricBuilder builder = new GovernanceMetricBuilder(qualifiedName, displayName, description, measurement, target, domainIdentifier, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, governanceMetricGUID, governanceMetricGUIDParameterName, typeGUID, typeName, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, builder.getInstanceProperties(methodName), isMergeUpdate, effectiveTime, methodName);
    }

    public void addGovernanceDefinitionMetric(String userId, String externalSourceGUID, String externalSourceName, String governanceMetricGUID, String governanceMetricGUIDParameterName, String governanceDefinitionGUID, String governanceDefinitionGUIDParameterName, String rationale, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.RATIONALE.name, rationale, methodName);
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, governanceDefinitionGUID, governanceDefinitionGUIDParameterName, OpenMetadataType.REFERENCEABLE.typeName, governanceMetricGUID, governanceMetricGUIDParameterName, OpenMetadataType.GOVERNANCE_METRIC.typeName, forLineage, forDuplicateProcessing, this.supportedZones, OpenMetadataType.GOVERNANCE_DEFINITION_METRIC_RELATIONSHIP.typeGUID, OpenMetadataType.GOVERNANCE_DEFINITION_METRIC_RELATIONSHIP.typeName, properties, effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void removeGovernanceDefinitionMetric(String userId, String externalSourceGUID, String externalSourceName, String governanceMetricGUID, String governanceMetricGUIDParameterName, String governanceDefinitionGUID, String governanceDefinitionGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, governanceDefinitionGUID, governanceDefinitionGUIDParameterName, OpenMetadataType.GOVERNANCE_DEFINITION.typeName, governanceMetricGUID, governanceMetricGUIDParameterName, OpenMetadataType.GOVERNANCE_METRIC.typeGUID, OpenMetadataType.GOVERNANCE_METRIC.typeName, forLineage, forDuplicateProcessing, OpenMetadataType.GOVERNANCE_DEFINITION_METRIC_RELATIONSHIP.typeGUID, OpenMetadataType.GOVERNANCE_DEFINITION_METRIC_RELATIONSHIP.typeName, effectiveTime, methodName);
    }

    public void addGovernanceResults(String userId, String externalSourceGUID, String externalSourceName, String governanceMetricGUID, String governanceMetricGUIDParameterName, String dataSetGUID, String dataSetGUIDParameterName, String query, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.QUERY.name, query, methodName);
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, governanceMetricGUID, governanceMetricGUIDParameterName, OpenMetadataType.GOVERNANCE_METRIC.typeName, dataSetGUID, dataSetGUIDParameterName, OpenMetadataType.DATA_SET.typeName, forLineage, forDuplicateProcessing, this.supportedZones, OpenMetadataType.GOVERNANCE_RESULTS_RELATIONSHIP.typeGUID, OpenMetadataType.GOVERNANCE_RESULTS_RELATIONSHIP.typeName, properties, effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void removeGovernanceResults(String userId, String externalSourceGUID, String externalSourceName, String governanceMetricGUID, String governanceMetricGUIDParameterName, String dataSetGUID, String dataSetGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, governanceMetricGUID, governanceMetricGUIDParameterName, OpenMetadataType.GOVERNANCE_METRIC.typeName, dataSetGUID, dataSetGUIDParameterName, OpenMetadataType.DATA_SET.typeGUID, OpenMetadataType.DATA_SET.typeName, forLineage, forDuplicateProcessing, OpenMetadataType.GOVERNANCE_RESULTS_RELATIONSHIP.typeGUID, OpenMetadataType.GOVERNANCE_RESULTS_RELATIONSHIP.typeName, effectiveTime, methodName);
    }

    public void removeGovernanceMetric(String userId, String externalSourceGUID, String externalSourceName, String governanceMetricGUID, String governanceMetricGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, governanceMetricGUID, governanceMetricGUIDParameterName, OpenMetadataType.GOVERNANCE_METRIC.typeGUID, OpenMetadataType.GOVERNANCE_METRIC.typeName, false, null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> findGovernanceMetrics(String userId, String searchString, String searchStringParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.findBeans(userId, searchString, searchStringParameterName, OpenMetadataType.GOVERNANCE_METRIC.typeGUID, OpenMetadataType.GOVERNANCE_METRIC.typeName, startFrom, pageSize, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> getAttachedGovernanceMetricImplementations(String userId, String guid, String guidParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List<EntityDetail> entities = this.getAttachedEntities(userId, guid, guidParameterName, OpenMetadataType.GOVERNANCE_DEFINITION.typeName, OpenMetadataType.GOVERNANCE_DEFINITION_METRIC_RELATIONSHIP.typeGUID, OpenMetadataType.GOVERNANCE_DEFINITION_METRIC_RELATIONSHIP.typeName, OpenMetadataType.GOVERNANCE_METRIC.typeName, null, null, 2, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
        if (entities != null) {
            ArrayList results = new ArrayList();
            for (EntityDetail entity : entities) {
                if (entity == null) continue;
                List<Relationship> relationships = this.getAllAttachmentLinks(userId, guid, guidParameterName, OpenMetadataType.GOVERNANCE_METRIC.typeName, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                results.add(this.converter.getNewComplexBean(this.beanClass, entity, relationships, methodName));
            }
            if (!results.isEmpty()) {
                return results;
            }
        }
        return null;
    }

    public B getGovernanceMetricByGUID(String userId, String guid, String guidParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getBeanFromRepository(userId, guid, guidParameterName, OpenMetadataType.GOVERNANCE_METRIC.typeName, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
    }
}

