/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.GovernanceZoneBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class GovernanceZoneHandler<B>
extends OpenMetadataAPIGenericHandler<B> {
    public GovernanceZoneHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public String createGovernanceZone(String userId, String externalSourceGUID, String externalSourceName, String qualifiedName, String zoneName, String displayName, String description, String criteria, String scope, int domainIdentifier, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String typeName = OpenMetadataType.GOVERNANCE_ZONE.typeName;
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, OpenMetadataType.GOVERNANCE_ZONE.typeName, this.serviceName, methodName, this.repositoryHelper);
        GovernanceZoneBuilder builder = new GovernanceZoneBuilder(qualifiedName, zoneName, displayName, description, criteria, scope, domainIdentifier, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        return this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, typeGUID, typeName, builder, effectiveTime, methodName);
    }

    public void updateGovernanceZone(String userId, String externalSourceGUID, String externalSourceName, String zoneGUID, String zoneGUIDParameterName, String qualifiedName, String zoneName, String displayName, String description, String criteria, String scope, int domainIdentifier, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, boolean isMergeUpdate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String typeName = OpenMetadataType.GOVERNANCE_ZONE.typeName;
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, OpenMetadataType.GOVERNANCE_ZONE.typeName, this.serviceName, methodName, this.repositoryHelper);
        GovernanceZoneBuilder builder = new GovernanceZoneBuilder(qualifiedName, zoneName, displayName, description, criteria, scope, domainIdentifier, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, zoneGUID, zoneGUIDParameterName, OpenMetadataType.GOVERNANCE_ZONE.typeGUID, OpenMetadataType.GOVERNANCE_ZONE.typeName, false, false, (List<String>)this.supportedZones, builder.getInstanceProperties(methodName), isMergeUpdate, new Date(), methodName);
    }

    public B getGovernanceZone(String userId, String name, String nameParameter, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add(OpenMetadataProperty.QUALIFIED_NAME.name);
        specificMatchPropertyNames.add(OpenMetadataProperty.ZONE_NAME.name);
        return this.getBeanByValue(userId, name, nameParameter, OpenMetadataType.GOVERNANCE_ZONE.typeGUID, OpenMetadataType.GOVERNANCE_ZONE.typeName, specificMatchPropertyNames, null, null, SequencingOrder.CREATION_DATE_RECENT, null, false, false, this.supportedZones, new Date(), methodName);
    }

    public Relationship getGovernanceZoneParentGUID(String userId, String zoneGUID, String zoneGUIDParameter, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getUniqueAttachmentLink(userId, zoneGUID, zoneGUIDParameter, OpenMetadataType.GOVERNANCE_ZONE.typeName, OpenMetadataType.ZONE_HIERARCHY_RELATIONSHIP.typeGUID, OpenMetadataType.ZONE_HIERARCHY_RELATIONSHIP.typeName, null, OpenMetadataType.GOVERNANCE_ZONE.typeName, 1, null, null, SequencingOrder.CREATION_DATE_RECENT, null, false, false, new Date(), methodName);
    }

    public List<Relationship> getGovernanceZoneChildrenGUIDs(String userId, String zoneGUID, String zoneGUIDParameter, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getAttachmentLinks(userId, zoneGUID, zoneGUIDParameter, OpenMetadataType.GOVERNANCE_ZONE.typeName, OpenMetadataType.ZONE_HIERARCHY_RELATIONSHIP.typeGUID, OpenMetadataType.ZONE_HIERARCHY_RELATIONSHIP.typeName, null, OpenMetadataType.GOVERNANCE_ZONE.typeName, 2, null, null, SequencingOrder.CREATION_DATE_RECENT, null, false, false, (List<String>)this.supportedZones, 0, 0, new Date(), methodName);
    }

    public List<B> getGovernanceZones(String userId, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getBeansByType(userId, OpenMetadataType.GOVERNANCE_ZONE.typeGUID, OpenMetadataType.GOVERNANCE_ZONE.typeName, null, null, SequencingOrder.CREATION_DATE_RECENT, null, false, false, this.supportedZones, startFrom, pageSize, new Date(), methodName);
    }

    public List<B> getGovernanceZonesByDomain(String userId, int domainIdentifier, int startFrom, int pageSize, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (domainIdentifier == 0) {
            return this.getGovernanceZones(userId, startFrom, pageSize, methodName);
        }
        List<EntityDetail> entities = this.getEntitiesByType(userId, OpenMetadataType.GOVERNANCE_ZONE.typeGUID, OpenMetadataType.GOVERNANCE_ZONE.typeName, null, null, SequencingOrder.CREATION_DATE_RECENT, null, false, false, this.supportedZones, startFrom, pageSize, new Date(), methodName);
        ArrayList results = new ArrayList();
        if (entities != null) {
            for (EntityDetail entity : entities) {
                if (entity == null || entity.getProperties() == null || this.repositoryHelper.getIntProperty(this.serviceName, OpenMetadataProperty.DOMAIN_IDENTIFIER.name, entity.getProperties(), methodName) != domainIdentifier) continue;
                Object bean = this.converter.getNewBean(this.beanClass, entity, methodName);
                results.add(bean);
            }
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }
}

