/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.Date;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericBuilder;
import org.odpi.openmetadata.frameworks.openmetadata.enums.OperationalStatus;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ServerAssetUseType;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.OMFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;

public class ITInfrastructureBuilder
extends OpenMetadataAPIGenericBuilder {
    ITInfrastructureBuilder(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(OpenMetadataType.IT_INFRASTRUCTURE.typeGUID, OpenMetadataType.IT_INFRASTRUCTURE.typeName, repositoryHelper, serviceName, serverName);
    }

    @Override
    public InstanceProperties getInstanceProperties(String methodName) throws InvalidParameterException {
        return super.getInstanceProperties(methodName);
    }

    InstanceProperties getSoftwareServerSupportedCapabilitiesProperties(Date deploymentTime, String deployer, int serverCapabilityStatus, String methodName) throws InvalidParameterException {
        InstanceProperties properties = this.repositoryHelper.addDatePropertyToInstance(this.serviceName, null, OpenMetadataProperty.DEPLOYMENT_TIME.name, deploymentTime, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.DEPLOYER.name, deployer, methodName);
        try {
            properties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.OPERATIONAL_STATUS.name, OperationalStatus.getOpenTypeGUID(), OperationalStatus.getOpenTypeName(), serverCapabilityStatus, methodName);
        }
        catch (TypeErrorException error) {
            throw new InvalidParameterException((OMFCheckedExceptionBase)((Object)error), OpenMetadataProperty.OPERATIONAL_STATUS.name);
        }
        this.setEffectivityDates(properties);
        return properties;
    }

    InstanceProperties getSoftwareServerCapabilitiesAssetUseProperties(String description, int useType, String methodName) throws InvalidParameterException {
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.DESCRIPTION.name, description, methodName);
        try {
            properties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.USE_TYPE.name, ServerAssetUseType.getOpenTypeGUID(), ServerAssetUseType.getOpenTypeName(), useType, methodName);
        }
        catch (TypeErrorException error) {
            throw new InvalidParameterException((OMFCheckedExceptionBase)((Object)error), OpenMetadataProperty.USE_TYPE.name);
        }
        this.setEffectivityDates(properties);
        return properties;
    }

    InstanceProperties getCloudProviderProperties(String providerName, String methodName) {
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.PROVIDER_NAME.name, providerName, methodName);
        this.setEffectivityDates(properties);
        return properties;
    }

    InstanceProperties getCloudPlatformProperties(String implementationType, String methodName) {
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, implementationType, methodName);
        this.setEffectivityDates(properties);
        return properties;
    }

    InstanceProperties getCloudTenantProperties(String tenantName, String tenantType, String methodName) {
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.TENANT_NAME.name, tenantName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.TENANT_TYPE.name, tenantType, methodName);
        this.setEffectivityDates(properties);
        return properties;
    }

    InstanceProperties getCloudServiceProperties(String offeringName, String serviceType, String methodName) {
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.OFFERING_NAME.name, offeringName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.SERVICE_TYPE.name, serviceType, methodName);
        this.setEffectivityDates(properties);
        return properties;
    }
}

