/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericBuilder;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class InformalTagBuilder
extends OpenMetadataAPIGenericBuilder {
    private final String tagName;
    private final String tagDescription;
    private final boolean isPublic;

    InformalTagBuilder(String tagName, String tagDescription, boolean isPublic, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(OpenMetadataType.INFORMAL_TAG.typeGUID, OpenMetadataType.INFORMAL_TAG.typeName, repositoryHelper, serviceName, serverName);
        this.tagName = tagName;
        this.tagDescription = tagDescription;
        this.isPublic = isPublic;
    }

    @Override
    public InstanceProperties getInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = super.getInstanceProperties(methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.TAG_NAME.name, this.tagName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.TAG_DESCRIPTION.name, this.tagDescription, methodName);
        properties = this.repositoryHelper.addBooleanPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.IS_PUBLIC.name, this.isPublic, methodName);
        return properties;
    }
}

