/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.InformalTagBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class InformalTagHandler<B>
extends OpenMetadataAPIGenericHandler<B> {
    public InformalTagHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public List<B> getAttachedTags(String userId, String elementGUID, String elementGUIDParameterName, String elementTypeName, List<String> serviceSupportedZones, int startingFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedElements(userId, null, null, elementGUID, elementGUIDParameterName, elementTypeName, OpenMetadataType.ATTACHED_TAG_RELATIONSHIP.typeGUID, OpenMetadataType.ATTACHED_TAG_RELATIONSHIP.typeName, OpenMetadataType.INFORMAL_TAG.typeName, (String)null, null, 0, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, serviceSupportedZones, startingFrom, pageSize, effectiveTime, methodName);
    }

    public String createTag(String userId, String externalSourceGUID, String externalSourceName, String tagName, String tagDescription, boolean isPublic, Date effectiveFrom, Date effectiveTo, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String nameParameter = "tagName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(tagName, "tagName", methodName);
        InformalTagBuilder builder = new InformalTagBuilder(tagName, tagDescription, isPublic, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        return this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, OpenMetadataType.INFORMAL_TAG.typeGUID, OpenMetadataType.INFORMAL_TAG.typeName, builder, effectiveTime, methodName);
    }

    public void updateTagDescription(String userId, String externalSourceGUID, String externalSourceName, String tagGUID, String tagGUIDParameterName, String tagDescription, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.TAG_DESCRIPTION.name, tagDescription, methodName);
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, tagGUID, tagGUIDParameterName, OpenMetadataType.INFORMAL_TAG.typeGUID, OpenMetadataType.INFORMAL_TAG.typeName, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, this.setUpEffectiveDates(properties, effectiveFrom, effectiveTo), true, effectiveTime, methodName);
    }

    public void deleteTag(String userId, String externalSourceGUID, String externalSourceName, String tagGUID, String tagGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, tagGUID, tagGUIDParameterName, OpenMetadataType.INFORMAL_TAG.typeGUID, OpenMetadataType.INFORMAL_TAG.typeName, false, null, null, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
    }

    public B getTag(String userId, String guid, String guidParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getBeanFromRepository(userId, guid, guidParameterName, OpenMetadataType.INFORMAL_TAG.typeName, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
    }

    public List<B> getTagsByName(String userId, String name, String nameParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ArrayList<String> propertyNames = new ArrayList<String>();
        propertyNames.add(OpenMetadataProperty.TAG_NAME.name);
        return this.getBeansByValue(userId, name, nameParameterName, OpenMetadataType.INFORMAL_TAG.typeGUID, OpenMetadataType.INFORMAL_TAG.typeName, propertyNames, true, null, null, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getMyTagsByName(String userId, String name, String nameParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(name, nameParameterName, methodName);
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        InstanceProperties matchProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.CREATED_BY.name, userId, methodName);
        matchProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, matchProperties, OpenMetadataProperty.TAG_NAME.name, userId, methodName);
        List retrievedEntities = this.repositoryHandler.getEntitiesByName(userId, matchProperties, OpenMetadataType.INFORMAL_TAG.typeGUID, null, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, startFrom, queryPageSize, effectiveTime, methodName);
        return this.getValidatedBeans(userId, effectiveTime, forLineage, forDuplicateProcessing, this.supportedZones, methodName, retrievedEntities);
    }

    public List<B> findTags(String userId, String searchString, String searchStringParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getBeansByValue(userId, searchString, searchStringParameterName, OpenMetadataType.INFORMAL_TAG.typeGUID, OpenMetadataType.INFORMAL_TAG.typeName, null, false, null, null, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> findMyTags(String userId, String searchString, String searchStringParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(searchString, searchStringParameterName, methodName);
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        List retrievedEntities = this.repositoryHandler.getEntitiesByValue(userId, searchString, OpenMetadataType.INFORMAL_TAG.typeGUID, null, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, startFrom, queryPageSize, effectiveTime, methodName);
        if (retrievedEntities != null) {
            ArrayList<EntityDetail> myEntities = new ArrayList<EntityDetail>();
            for (EntityDetail entity : retrievedEntities) {
                if (entity == null || !entity.getCreatedBy().equals(userId)) continue;
                myEntities.add(entity);
            }
            return this.getValidatedBeans(userId, effectiveTime, forLineage, forDuplicateProcessing, this.supportedZones, methodName, myEntities);
        }
        return null;
    }

    public void addTagToElement(String userId, String externalSourceGUID, String externalSourceName, String elementGUID, String elementGUIDParameterName, String elementType, String tagGUID, String tagGUIDParameterName, boolean isPublic, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.addTagToElement(userId, externalSourceGUID, externalSourceName, elementGUID, elementGUIDParameterName, elementType, tagGUID, tagGUIDParameterName, this.supportedZones, isPublic, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void addTagToElement(String userId, String externalSourceGUID, String externalSourceName, String elementGUID, String elementGUIDParameterName, String elementType, String tagGUID, String tagGUIDParameterName, List<String> suppliedSupportedZones, boolean isPublic, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        InstanceProperties properties = this.repositoryHelper.addBooleanPropertyToInstance(this.serviceName, null, OpenMetadataProperty.IS_PUBLIC.name, isPublic, methodName);
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, elementGUID, elementGUIDParameterName, elementType, tagGUID, tagGUIDParameterName, OpenMetadataType.INFORMAL_TAG.typeName, forLineage, forDuplicateProcessing, suppliedSupportedZones, OpenMetadataType.ATTACHED_TAG_RELATIONSHIP.typeGUID, OpenMetadataType.ATTACHED_TAG_RELATIONSHIP.typeName, this.setUpEffectiveDates(properties, effectiveFrom, effectiveTo), effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void removeTagFromElement(String userId, String externalSourceGUID, String externalSourceName, String elementGUID, String elementGUIDParameterName, String elementType, String tagGUID, String tagGUIDParameterName, List<String> suppliedSupportedZones, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, elementGUID, elementGUIDParameterName, elementType, tagGUID, tagGUIDParameterName, OpenMetadataType.INFORMAL_TAG.typeGUID, OpenMetadataType.INFORMAL_TAG.typeName, forLineage, forDuplicateProcessing, suppliedSupportedZones, OpenMetadataType.ATTACHED_TAG_RELATIONSHIP.typeGUID, OpenMetadataType.ATTACHED_TAG_RELATIONSHIP.typeName, effectiveTime, methodName);
    }
}

