/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.GovernanceDefinitionHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class LicenseHandler<B>
extends GovernanceDefinitionHandler<B> {
    public LicenseHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public List<B> getLicenses(String userId, String elementGUID, String elementGUIDParameterName, String elementTypeName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getLicenses(userId, elementGUID, elementGUIDParameterName, elementTypeName, this.supportedZones, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> getLicenses(String userId, String elementGUID, String elementGUIDParameterName, String elementTypeName, List<String> serviceSupportedZones, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List<Relationship> relationships = this.getAttachmentLinks(userId, elementGUID, elementGUIDParameterName, elementTypeName, OpenMetadataType.LICENSE_RELATIONSHIP.typeGUID, OpenMetadataType.LICENSE_RELATIONSHIP.typeName, null, OpenMetadataType.LICENSE_TYPE.typeName, 0, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, serviceSupportedZones, startFrom, pageSize, effectiveTime, methodName);
        if (relationships != null) {
            ArrayList results = new ArrayList();
            for (Relationship relationship : relationships) {
                EntityProxy entityProxy;
                if (relationship == null || (entityProxy = relationship.getEntityTwoProxy()) == null) continue;
                String entityParameterName = "entityProxyTwo.getGUID";
                EntityDetail entity = this.getEntityFromRepository(userId, entityProxy.getGUID(), "entityProxyTwo.getGUID", OpenMetadataType.LICENSE_TYPE.typeName, null, null, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
                results.add(this.converter.getNewBean(this.beanClass, entity, relationship, methodName));
            }
            if (results.isEmpty()) {
                return null;
            }
            return results;
        }
        return null;
    }

    public String licenseElement(String userId, String externalSourceGUID, String externalSourceName, String elementGUID, String elementGUIDParameterName, String elementTypeName, String licenseTypeGUID, String licenseTypeGUIDParameterName, String licenseTypeGUIDTypeName, String licenseGUID, Date start, Date end, String conditions, String licensedBy, String licensedByTypeName, String licensedByPropertyName, String custodian, String custodianTypeName, String custodianPropertyName, String licensee, String licenseeTypeName, String licenseePropertyName, String notes, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.multiLinkElementToElement(userId, externalSourceGUID, externalSourceName, elementGUID, elementGUIDParameterName, elementTypeName, licenseTypeGUID, licenseTypeGUIDParameterName, licenseTypeGUIDTypeName, forLineage, forDuplicateProcessing, this.supportedZones, OpenMetadataType.LICENSE_RELATIONSHIP.typeGUID, OpenMetadataType.LICENSE_RELATIONSHIP.typeName, this.getLicenseProperties(licenseGUID, start, end, conditions, licensedBy, licensedByTypeName, licensedByPropertyName, custodian, custodianTypeName, custodianPropertyName, licensee, licenseeTypeName, licenseePropertyName, notes, effectiveFrom, effectiveTo, methodName), effectiveTime, methodName);
    }

    public void updateLicense(String userId, String externalSourceGUID, String externalSourceName, String licenseGUID, String licenseGUIDParameterName, String licenseId, Date start, Date end, String conditions, String licensedBy, String licensedByTypeName, String licensedByPropertyName, String custodian, String custodianTypeName, String custodianPropertyName, String licensee, String licenseeTypeName, String licenseePropertyName, String notes, boolean isMergeUpdate, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.updateRelationshipProperties(userId, externalSourceGUID, externalSourceName, licenseGUID, licenseGUIDParameterName, OpenMetadataType.LICENSE_RELATIONSHIP.typeName, isMergeUpdate, this.getLicenseProperties(licenseId, start, end, conditions, licensedBy, licensedByTypeName, licensedByPropertyName, custodian, custodianTypeName, custodianPropertyName, licensee, licenseeTypeName, licenseePropertyName, notes, effectiveFrom, effectiveTo, methodName), forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
    }

    private InstanceProperties getLicenseProperties(String licenseId, Date start, Date end, String conditions, String licensedBy, String licensedByTypeName, String licensedByPropertyName, String custodian, String custodianTypeName, String custodianPropertyName, String licensee, String licenseeTypeName, String licenseePropertyName, String notes, Date effectiveFrom, Date effectiveTo, String methodName) {
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.LICENSE_GUID.name, licenseId, methodName);
        properties = this.repositoryHelper.addDatePropertyToInstance(this.serviceName, properties, OpenMetadataProperty.START.name, start, methodName);
        properties = this.repositoryHelper.addDatePropertyToInstance(this.serviceName, properties, OpenMetadataProperty.END.name, end, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.CONDITIONS.name, conditions, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.LICENSED_BY.name, licensedBy, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.LICENSED_BY_TYPE_NAME.name, licensedByTypeName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.LICENSED_BY_PROPERTY_NAME.name, licensedByPropertyName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.CUSTODIAN.name, custodian, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.CUSTODIAN_TYPE_NAME.name, custodianTypeName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.CUSTODIAN_PROPERTY_NAME.name, custodianPropertyName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.LICENSEE.name, licensee, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.LICENSEE_TYPE_NAME.name, licenseeTypeName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.LICENSEE_PROPERTY_NAME.name, licenseePropertyName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.NOTES.name, notes, methodName);
        return this.setUpEffectiveDates(properties, effectiveFrom, effectiveTo);
    }

    public void unlicenseElement(String userId, String externalSourceGUID, String externalSourceName, String licenseGUID, String licenseGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.deleteRelationship(userId, externalSourceGUID, externalSourceName, licenseGUID, licenseGUIDParameterName, OpenMetadataType.LICENSE_RELATIONSHIP.typeName, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
    }
}

