/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.LocationBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class LocationHandler<B>
extends ReferenceableHandler<B> {
    public LocationHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public String createLocation(String userId, String externalSourceGUID, String externalSourceName, String qualifiedName, String identifier, String displayName, String description, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, Date effectiveFrom, Date effectiveTo, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String typeName = OpenMetadataType.LOCATION.typeName;
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, OpenMetadataType.LOCATION.typeName, this.serviceName, methodName, this.repositoryHelper);
        LocationBuilder locationBuilder = new LocationBuilder(qualifiedName, identifier, displayName, description, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        locationBuilder.setEffectivityDates(effectiveFrom, effectiveTo);
        return this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, typeGUID, typeName, locationBuilder, effectiveTime, methodName);
    }

    public String createLocationFromTemplate(String userId, String externalSourceGUID, String externalSourceName, String templateGUID, String qualifiedName, String identifier, String displayName, String description, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        LocationBuilder locationBuilder = new LocationBuilder(qualifiedName, identifier, displayName, description, this.repositoryHelper, this.serviceName, this.serverName);
        locationBuilder.setAnchors(userId, null, OpenMetadataType.LOCATION.typeName, OpenMetadataType.LOCATION.typeName, null, methodName);
        return this.createBeanFromTemplate(userId, externalSourceGUID, externalSourceName, templateGUID, "templateGUID", OpenMetadataType.LOCATION.typeGUID, OpenMetadataType.LOCATION.typeName, qualifiedName, OpenMetadataProperty.QUALIFIED_NAME.name, locationBuilder, this.supportedZones, true, false, null, methodName);
    }

    public void updateLocation(String userId, String externalSourceGUID, String externalSourceName, String locationGUID, String locationGUIDParameterName, String qualifiedName, String identifier, String displayName, String description, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, boolean isMergeUpdate, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(locationGUID, locationGUIDParameterName, methodName);
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        }
        String typeName = OpenMetadataType.LOCATION.typeName;
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, OpenMetadataType.LOCATION.typeName, this.serviceName, methodName, this.repositoryHelper);
        LocationBuilder locationBuilder = new LocationBuilder(qualifiedName, identifier, displayName, description, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        locationBuilder.setEffectivityDates(effectiveFrom, effectiveTo);
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, locationGUID, locationGUIDParameterName, typeGUID, typeName, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, locationBuilder.getInstanceProperties(methodName), isMergeUpdate, effectiveTime, methodName);
    }

    public void addFixedLocationClassification(String userId, String externalSourceGUID, String externalSourceName, String locationGUID, String locationGUIDParameterName, String coordinates, String mapProjection, String postalAddress, String timeZone, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(locationGUID, locationGUIDParameterName, methodName);
        LocationBuilder builder = new LocationBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        this.setClassificationInRepository(userId, externalSourceGUID, externalSourceName, locationGUID, locationGUIDParameterName, OpenMetadataType.LOCATION.typeName, OpenMetadataType.FIXED_LOCATION_CLASSIFICATION.typeGUID, OpenMetadataType.FIXED_LOCATION_CLASSIFICATION.typeName, builder.getFixedLocationProperties(coordinates, mapProjection, postalAddress, timeZone, methodName), false, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void removeFixedLocationClassification(String userId, String externalSourceGUID, String externalSourceName, String locationGUID, String locationGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(locationGUID, locationGUIDParameterName, methodName);
        this.removeClassificationFromRepository(userId, externalSourceGUID, externalSourceName, locationGUID, locationGUIDParameterName, OpenMetadataType.LOCATION.typeName, OpenMetadataType.FIXED_LOCATION_CLASSIFICATION.typeGUID, OpenMetadataType.FIXED_LOCATION_CLASSIFICATION.typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void addSecureLocationClassification(String userId, String externalSourceGUID, String externalSourceName, String locationGUID, String locationGUIDParameterName, String description, String level, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(locationGUID, locationGUIDParameterName, methodName);
        LocationBuilder builder = new LocationBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        this.setClassificationInRepository(userId, externalSourceGUID, externalSourceName, locationGUID, locationGUIDParameterName, OpenMetadataType.LOCATION.typeName, OpenMetadataType.SECURE_LOCATION_CLASSIFICATION.typeGUID, OpenMetadataType.SECURE_LOCATION_CLASSIFICATION.typeName, builder.getSecureLocationProperties(description, level, methodName), false, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void removeSecureLocationClassification(String userId, String externalSourceGUID, String externalSourceName, String locationGUID, String locationGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.removeClassificationFromRepository(userId, externalSourceGUID, externalSourceName, locationGUID, locationGUIDParameterName, OpenMetadataType.LOCATION.typeName, OpenMetadataType.SECURE_LOCATION_CLASSIFICATION.typeGUID, OpenMetadataType.SECURE_LOCATION_CLASSIFICATION.typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void addCyberLocationClassification(String userId, String externalSourceGUID, String externalSourceName, String locationGUID, String locationGUIDParameterName, String networkAddress, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(locationGUID, locationGUIDParameterName, methodName);
        LocationBuilder builder = new LocationBuilder(this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        this.setClassificationInRepository(userId, externalSourceGUID, externalSourceName, locationGUID, locationGUIDParameterName, OpenMetadataType.LOCATION.typeName, OpenMetadataType.CYBER_LOCATION_CLASSIFICATION.typeGUID, OpenMetadataType.CYBER_LOCATION_CLASSIFICATION.typeName, builder.getCyberLocationProperties(networkAddress, methodName), false, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void removeCyberLocationClassification(String userId, String externalSourceGUID, String externalSourceName, String locationGUID, String locationGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.removeClassificationFromRepository(userId, externalSourceGUID, externalSourceName, locationGUID, locationGUIDParameterName, OpenMetadataType.LOCATION.typeName, OpenMetadataType.CYBER_LOCATION_CLASSIFICATION.typeGUID, OpenMetadataType.CYBER_LOCATION_CLASSIFICATION.typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void setupNestedLocation(String userId, String externalSourceGUID, String externalSourceName, String locationParentGUID, String locationParentGUIDParameterName, String locationChildGUID, String locationChildGUIDParameterName, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, locationParentGUID, locationParentGUIDParameterName, OpenMetadataType.LOCATION.typeName, locationChildGUID, locationChildGUIDParameterName, OpenMetadataType.LOCATION.typeName, forLineage, forDuplicateProcessing, this.supportedZones, OpenMetadataType.NESTED_LOCATION_RELATIONSHIP.typeGUID, OpenMetadataType.NESTED_LOCATION_RELATIONSHIP.typeName, this.setUpEffectiveDates(null, effectiveFrom, effectiveTo), effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void clearNestedLocation(String userId, String externalSourceGUID, String externalSourceName, String locationParentGUID, String locationParentGUIDParameterName, String locationChildGUID, String locationChildGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, locationParentGUID, locationParentGUIDParameterName, OpenMetadataType.LOCATION.typeName, locationChildGUID, locationChildGUIDParameterName, OpenMetadataType.LOCATION.typeGUID, OpenMetadataType.LOCATION.typeName, forLineage, forDuplicateProcessing, OpenMetadataType.NESTED_LOCATION_RELATIONSHIP.typeGUID, OpenMetadataType.NESTED_LOCATION_RELATIONSHIP.typeName, effectiveTime, methodName);
    }

    public void setupPeerLocations(String userId, String externalSourceGUID, String externalSourceName, String locationOneGUID, String locationOneGUIDParameterName, String locationTwoGUID, String locationTwoGUIDParameterName, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, locationOneGUID, locationOneGUIDParameterName, OpenMetadataType.LOCATION.typeName, locationTwoGUID, locationTwoGUIDParameterName, OpenMetadataType.LOCATION.typeName, forLineage, forDuplicateProcessing, this.supportedZones, OpenMetadataType.ADJACENT_LOCATION_RELATIONSHIP.typeGUID, OpenMetadataType.ADJACENT_LOCATION_RELATIONSHIP.typeName, this.setUpEffectiveDates(null, effectiveFrom, effectiveTo), effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void clearPeerLocations(String userId, String externalSourceGUID, String externalSourceName, String locationOneGUID, String locationOneGUIDParameterName, String locationTwoGUID, String locationTwoGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, locationOneGUID, locationOneGUIDParameterName, OpenMetadataType.LOCATION.typeName, locationTwoGUID, locationTwoGUIDParameterName, OpenMetadataType.LOCATION.typeGUID, OpenMetadataType.LOCATION.typeName, forLineage, forDuplicateProcessing, OpenMetadataType.ADJACENT_LOCATION_RELATIONSHIP.typeGUID, OpenMetadataType.ADJACENT_LOCATION_RELATIONSHIP.typeName, effectiveTime, methodName);
    }

    public void setupProfileLocation(String userId, String externalSourceGUID, String externalSourceName, String actorProfileGUID, String actorProfileGUIDParameterName, String locationGUID, String locationGUIDParameterName, String associationType, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.ASSOCIATION_TYPE.name, associationType, methodName);
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, actorProfileGUID, actorProfileGUIDParameterName, OpenMetadataType.ACTOR_PROFILE.typeName, locationGUID, locationGUIDParameterName, OpenMetadataType.LOCATION.typeName, forLineage, forDuplicateProcessing, this.supportedZones, OpenMetadataType.PROFILE_LOCATION_RELATIONSHIP.typeGUID, OpenMetadataType.PROFILE_LOCATION_RELATIONSHIP.typeName, this.setUpEffectiveDates(properties, effectiveFrom, effectiveTo), effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void clearProfileLocation(String userId, String externalSourceGUID, String externalSourceName, String actorProfileGUID, String actorProfileGUIDParameterName, String locationGUID, String locationGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, actorProfileGUID, actorProfileGUIDParameterName, OpenMetadataType.ACTOR_PROFILE.typeName, locationGUID, locationGUIDParameterName, OpenMetadataType.LOCATION.typeGUID, OpenMetadataType.LOCATION.typeName, forLineage, forDuplicateProcessing, OpenMetadataType.PROFILE_LOCATION_RELATIONSHIP.typeGUID, OpenMetadataType.PROFILE_LOCATION_RELATIONSHIP.typeName, effectiveTime, methodName);
    }

    public void setupAssetLocation(String userId, String externalSourceGUID, String externalSourceName, String locationGUID, String locationGUIDParameterName, String assetGUID, String assetGUIDParameterName, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, assetGUID, assetGUIDParameterName, OpenMetadataType.ASSET.typeName, locationGUID, locationGUIDParameterName, OpenMetadataType.LOCATION.typeName, forLineage, forDuplicateProcessing, this.supportedZones, OpenMetadataType.ASSET_LOCATION_RELATIONSHIP.typeGUID, OpenMetadataType.ASSET_LOCATION_RELATIONSHIP.typeName, this.setUpEffectiveDates(null, effectiveFrom, effectiveTo), effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void clearAssetLocation(String userId, String externalSourceGUID, String externalSourceName, String locationGUID, String locationGUIDParameterName, String assetGUID, String assetGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, assetGUID, assetGUIDParameterName, OpenMetadataType.ASSET.typeName, locationGUID, locationGUIDParameterName, OpenMetadataType.LOCATION.typeGUID, OpenMetadataType.LOCATION.typeName, forLineage, forDuplicateProcessing, OpenMetadataType.ASSET_LOCATION_RELATIONSHIP.typeGUID, OpenMetadataType.ASSET_LOCATION_RELATIONSHIP.typeName, effectiveTime, methodName);
    }

    public void removeLocation(String userId, String externalSourceGUID, String externalSourceName, String locationGUID, String locationGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, locationGUID, locationGUIDParameterName, OpenMetadataType.LOCATION.typeGUID, OpenMetadataType.LOCATION.typeName, false, null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> getAdjacentLocations(String userId, String elementGUID, String elementGUIDParameterName, String elementTypeName, int startingFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedElements(userId, null, null, elementGUID, elementGUIDParameterName, elementTypeName, OpenMetadataType.ADJACENT_LOCATION_RELATIONSHIP.typeGUID, OpenMetadataType.ADJACENT_LOCATION_RELATIONSHIP.typeName, OpenMetadataType.LOCATION.typeName, (String)null, null, 0, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, startingFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getNestedLocations(String userId, String elementGUID, String elementGUIDParameterName, String elementTypeName, int startingFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedElements(userId, null, null, elementGUID, elementGUIDParameterName, elementTypeName, OpenMetadataType.NESTED_LOCATION_RELATIONSHIP.typeGUID, OpenMetadataType.NESTED_LOCATION_RELATIONSHIP.typeName, OpenMetadataType.LOCATION.typeName, (String)null, null, 2, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, startingFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getGroupingLocations(String userId, String elementGUID, String elementGUIDParameterName, String elementTypeName, int startingFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedElements(userId, null, null, elementGUID, elementGUIDParameterName, elementTypeName, OpenMetadataType.NESTED_LOCATION_RELATIONSHIP.typeGUID, OpenMetadataType.NESTED_LOCATION_RELATIONSHIP.typeName, OpenMetadataType.LOCATION.typeName, (String)null, null, 1, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, startingFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getAssetLocations(String userId, String elementGUID, String elementGUIDParameterName, String elementTypeName, int startingFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAssetLocations(userId, elementGUID, elementGUIDParameterName, elementTypeName, this.supportedZones, startingFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> getAssetLocations(String userId, String elementGUID, String elementGUIDParameterName, String elementTypeName, List<String> serviceSupportedZones, int startingFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedElements(userId, null, null, elementGUID, elementGUIDParameterName, elementTypeName, OpenMetadataType.ASSET_LOCATION_RELATIONSHIP.typeGUID, OpenMetadataType.ASSET_LOCATION_RELATIONSHIP.typeName, OpenMetadataType.LOCATION.typeName, (String)null, null, 2, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, serviceSupportedZones, startingFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getProfileLocations(String userId, String elementGUID, String elementGUIDParameterName, String elementTypeName, int startingFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getProfileLocations(userId, elementGUID, elementGUIDParameterName, elementTypeName, this.supportedZones, startingFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> getProfileLocations(String userId, String elementGUID, String elementGUIDParameterName, String elementTypeName, List<String> serviceSupportedZones, int startingFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedElements(userId, null, null, elementGUID, elementGUIDParameterName, elementTypeName, OpenMetadataType.PROFILE_LOCATION_RELATIONSHIP.typeGUID, OpenMetadataType.PROFILE_LOCATION_RELATIONSHIP.typeName, OpenMetadataType.LOCATION.typeName, (String)null, null, 2, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, serviceSupportedZones, startingFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> findLocations(String userId, String searchString, String searchStringParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.findBeans(userId, searchString, searchStringParameterName, OpenMetadataType.LOCATION.typeGUID, OpenMetadataType.LOCATION.typeName, startFrom, pageSize, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> getLocationsByName(String userId, String name, String nameParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add(OpenMetadataProperty.QUALIFIED_NAME.name);
        specificMatchPropertyNames.add(OpenMetadataProperty.IDENTIFIER.name);
        specificMatchPropertyNames.add(OpenMetadataProperty.NAME.name);
        return this.getBeansByValue(userId, name, nameParameterName, OpenMetadataType.LOCATION.typeGUID, OpenMetadataType.LOCATION.typeName, specificMatchPropertyNames, true, null, null, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getLocations(String userId, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getBeansByType(userId, OpenMetadataType.LOCATION.typeGUID, OpenMetadataType.LOCATION.typeName, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
    }
}

