/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import org.odpi.openmetadata.commonservices.generichandlers.OMFConverter;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementHeader;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.MetadataElementSummary;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class MetadataElementConverter<B>
extends OMFConverter<B> {
    public MetadataElementConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    @Override
    public B getNewBean(Class<B> beanClass, EntityDetail entity, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof MetadataElementSummary) {
                MetadataElementSummary bean = (MetadataElementSummary)returnBean;
                ElementHeader elementHeader = new ElementHeader();
                this.setUpElementHeader(elementHeader, entity, OpenMetadataType.OPEN_METADATA_ROOT.typeName, methodName);
                bean.setElementHeader(elementHeader);
                if (entity.getProperties() != null) {
                    Iterator propertyNames = entity.getProperties().getPropertyNames();
                    HashMap<String, String> propertyValues = new HashMap<String, String>();
                    while (propertyNames.hasNext()) {
                        String propertyName = (String)propertyNames.next();
                        InstancePropertyValue instancePropertyValue = entity.getProperties().getPropertyValue(propertyName);
                        propertyValues.put(propertyName, instancePropertyValue.valueAsString());
                    }
                    bean.setProperties(propertyValues);
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    @Override
    public B getNewBean(Class<B> beanClass, EntityDetail entity, Relationship relationship, String methodName) throws PropertyServerException {
        return this.getNewBean(beanClass, entity, methodName);
    }
}

