/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.RelatedEntity;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Connection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ConnectorType;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.EmbeddedConnection;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.Endpoint;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.VirtualConnection;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ContactMethodType;
import org.odpi.openmetadata.frameworks.openmetadata.enums.PermittedSynchronization;
import org.odpi.openmetadata.frameworks.openmetadata.enums.PortType;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementClassification;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementHeader;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementOrigin;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.MetadataElementSummary;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.RelatedMetadataElementSummary;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceAuditHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public abstract class OMFConverter<B>
extends OpenMetadataAPIGenericConverter<B> {
    protected long karmaPointPlateau = 0L;

    protected OMFConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    public OMFConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName, int karmaPointPlateau) {
        this(repositoryHelper, serviceName, serverName);
        this.karmaPointPlateau = karmaPointPlateau;
    }

    protected void setUpElementHeader(ElementHeader elementHeader, EntityDetail entity, String expectedTypeName, String methodName) throws PropertyServerException {
        if (entity != null) {
            super.validateInstanceType(expectedTypeName, elementHeader.getClass().getName(), (InstanceAuditHeader)entity, methodName);
            elementHeader.setGUID(entity.getGUID());
            elementHeader.setType(this.getElementType((InstanceAuditHeader)entity));
            elementHeader.setClassifications(this.getEntityClassifications(entity));
            ElementOrigin elementOrigin = new ElementOrigin();
            elementOrigin.setSourceServer(this.serverName);
            elementOrigin.setOriginCategory(this.getElementOriginCategory(entity.getInstanceProvenanceType()));
            elementOrigin.setHomeMetadataCollectionId(entity.getMetadataCollectionId());
            elementOrigin.setHomeMetadataCollectionName(entity.getMetadataCollectionName());
            elementOrigin.setLicense(entity.getInstanceLicense());
            elementHeader.setOrigin(elementOrigin);
            elementHeader.setVersions(this.getElementVersions((InstanceAuditHeader)entity));
        } else {
            super.handleMissingMetadataInstance(elementHeader.getClass().getName(), TypeDefCategory.ENTITY_DEF, methodName);
        }
    }

    protected void setUpElementHeader(ElementHeader elementHeader, InstanceHeader instanceHeader, List<Classification> classifications, String methodName) throws PropertyServerException {
        if (instanceHeader != null) {
            elementHeader.setGUID(instanceHeader.getGUID());
            elementHeader.setType(this.getElementType((InstanceAuditHeader)instanceHeader));
            elementHeader.setClassifications(this.getElementClassifications(classifications));
            ElementOrigin elementOrigin = new ElementOrigin();
            elementOrigin.setSourceServer(this.serverName);
            elementOrigin.setOriginCategory(this.getElementOriginCategory(instanceHeader.getInstanceProvenanceType()));
            elementOrigin.setHomeMetadataCollectionId(instanceHeader.getMetadataCollectionId());
            elementOrigin.setHomeMetadataCollectionName(instanceHeader.getMetadataCollectionName());
            elementOrigin.setLicense(instanceHeader.getInstanceLicense());
            elementHeader.setOrigin(elementOrigin);
            elementHeader.setVersions(this.getElementVersions((InstanceAuditHeader)instanceHeader));
        } else {
            super.handleMissingMetadataInstance(elementHeader.getClass().getName(), TypeDefCategory.ENTITY_DEF, methodName);
        }
    }

    protected ElementClassification getClassification(String classificationName, List<ElementClassification> beanClassifications) {
        if (classificationName != null && beanClassifications != null) {
            for (ElementClassification classification : beanClassifications) {
                if (classification == null || !classification.getClassificationName().equals(classificationName)) continue;
                return classification;
            }
        }
        return null;
    }

    protected List<ElementClassification> removeClassification(String classificationName, List<ElementClassification> beanClassifications) {
        if (classificationName != null && beanClassifications != null) {
            ArrayList<ElementClassification> results = new ArrayList<ElementClassification>();
            for (ElementClassification classification : beanClassifications) {
                if (classification == null || classification.getClassificationName().equals(classificationName)) continue;
                results.add(classification);
            }
            if (!results.isEmpty()) {
                return results;
            }
        }
        return null;
    }

    public RelatedMetadataElementSummary getRelatedMetadataElementSummary(Class<B> beanClass, RelatedEntity relatedEntity, String methodName) throws PropertyServerException {
        if (relatedEntity != null && relatedEntity.entityDetail() != null && relatedEntity.relationship() != null) {
            RelatedMetadataElementSummary relatedElementSummary = new RelatedMetadataElementSummary();
            MetadataElementSummary elementSummary = new MetadataElementSummary();
            ElementHeader elementHeader = this.getMetadataElementHeader(beanClass, (InstanceHeader)relatedEntity.relationship(), null, methodName);
            elementHeader.setGUID(relatedEntity.relationship().getGUID());
            relatedElementSummary.setRelationshipHeader(elementHeader);
            if (relatedEntity.relationship().getProperties() != null) {
                relatedElementSummary.setRelationshipProperties(super.getPropertiesAsStrings(relatedEntity.relationship().getProperties()));
            }
            elementHeader = this.getMetadataElementHeader(beanClass, (InstanceHeader)relatedEntity.entityDetail(), relatedEntity.entityDetail().getClassifications(), methodName);
            elementSummary.setElementHeader(elementHeader);
            if (relatedEntity.entityDetail().getProperties() != null) {
                elementSummary.setProperties(super.getPropertiesAsStrings(relatedEntity.entityDetail().getProperties()));
            }
            relatedElementSummary.setRelatedElement(elementSummary);
            return relatedElementSummary;
        }
        this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
        return null;
    }

    protected Connection getEmbeddedConnection(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        if (primaryEntity != null && primaryEntity.getType() != null) {
            String actualTypeName = primaryEntity.getType().getTypeDefName();
            if (this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, OpenMetadataType.VIRTUAL_CONNECTION.typeName)) {
                return this.getNewVirtualConnection(beanClass, primaryEntity, supplementaryEntities, relationships, methodName);
            }
            if (this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, OpenMetadataType.CONNECTION.typeName)) {
                return this.getNewConnection(beanClass, primaryEntity, supplementaryEntities, relationships, methodName);
            }
            super.validateInstanceType(OpenMetadataType.CONNECTION.typeName, beanClass.getName(), (InstanceAuditHeader)primaryEntity, methodName);
        } else {
            this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
        }
        return null;
    }

    private Connection getNewVirtualConnection(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        try {
            VirtualConnection connection = new VirtualConnection();
            this.fillInConnectionProperties((Connection)connection, primaryEntity, relationships, supplementaryEntities, methodName);
            if (relationships == null || relationships.isEmpty()) {
                return null;
            }
            List<String> connectedEntities = this.getConnectedEntities(primaryEntity, relationships);
            HashMap<String, EntityDetail> entityDetailMap = new HashMap<String, EntityDetail>();
            if (supplementaryEntities != null) {
                for (EntityDetail entity : supplementaryEntities) {
                    if (entity == null || entity.getGUID() == null || !connectedEntities.contains(entity.getGUID())) continue;
                    entityDetailMap.put(entity.getGUID(), entity);
                }
            }
            if (!entityDetailMap.isEmpty()) {
                ArrayList<EmbeddedConnection> embeddedConnections = new ArrayList<EmbeddedConnection>();
                for (Relationship relationship : relationships) {
                    EntityDetail embeddedConnectionEntity;
                    EntityProxy embeddedConnectionProxy;
                    EntityProxy parentConnectionProxy;
                    if (relationship == null || relationship.getType() == null || !this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), OpenMetadataType.EMBEDDED_CONNECTION_RELATIONSHIP.typeName) || (parentConnectionProxy = relationship.getEntityOneProxy()) == null || !primaryEntity.getGUID().equals(parentConnectionProxy.getGUID()) || (embeddedConnectionProxy = relationship.getEntityTwoProxy()) == null || embeddedConnectionProxy.getGUID() == null || (embeddedConnectionEntity = (EntityDetail)entityDetailMap.get(embeddedConnectionProxy.getGUID())) == null) continue;
                    InstanceProperties properties = relationship.getProperties();
                    EmbeddedConnection embeddedConnection = new EmbeddedConnection();
                    embeddedConnection.setPosition(this.getPosition(properties));
                    embeddedConnection.setDisplayName(this.getDisplayName(properties));
                    embeddedConnection.setArguments(this.getArguments(properties));
                    embeddedConnection.setEmbeddedConnection(this.getEmbeddedConnection(beanClass, embeddedConnectionEntity, supplementaryEntities, relationships, methodName));
                    embeddedConnections.add(embeddedConnection);
                }
                if (!embeddedConnections.isEmpty()) {
                    connection.setEmbeddedConnections(embeddedConnections);
                }
            }
            return connection;
        }
        catch (ClassCastException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    private Connection getNewConnection(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        try {
            Connection connection = new Connection();
            this.fillInConnectionProperties(connection, primaryEntity, relationships, supplementaryEntities, methodName);
            return connection;
        }
        catch (ClassCastException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    private void fillInConnectionProperties(Connection connection, EntityDetail primaryEntity, List<Relationship> relationships, List<EntityDetail> supplementaryEntities, String methodName) throws PropertyServerException {
        this.setUpElementHeader((ElementHeader)connection, primaryEntity, OpenMetadataType.CONNECTION.typeName, methodName);
        InstanceProperties instanceProperties = new InstanceProperties(primaryEntity.getProperties());
        connection.setQualifiedName(this.removeQualifiedName(instanceProperties));
        connection.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
        connection.setDisplayName(this.removeDisplayName(instanceProperties));
        connection.setDescription(this.removeDescription(instanceProperties));
        connection.setSecuredProperties(this.removeSecuredProperties(instanceProperties));
        connection.setConfigurationProperties(this.removeConfigurationProperties(instanceProperties));
        connection.setUserId(this.removeUserId(instanceProperties));
        connection.setClearPassword(this.removeClearPassword(instanceProperties));
        connection.setEncryptedPassword(this.removeEncryptedPassword(instanceProperties));
        connection.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
        List<String> connectedEntities = this.getConnectedEntities(primaryEntity, relationships);
        if (supplementaryEntities != null) {
            for (EntityDetail entity : supplementaryEntities) {
                if (entity == null || entity.getType() == null || !connectedEntities.contains(entity.getGUID())) continue;
                String actualTypeName = entity.getType().getTypeDefName();
                if (this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, OpenMetadataType.ENDPOINT.typeName)) {
                    Endpoint endpoint = this.getEndpoint(entity, methodName);
                    connection.setEndpoint(endpoint);
                    continue;
                }
                if (!this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, OpenMetadataType.CONNECTOR_TYPE.typeName)) continue;
                ConnectorType connectorType = this.getConnectorType(entity, methodName);
                connection.setConnectorType(connectorType);
            }
        }
    }

    private List<String> getConnectedEntities(EntityDetail primaryEntity, List<Relationship> relationships) {
        ArrayList<String> connectedEntities = new ArrayList<String>();
        if (relationships != null) {
            for (Relationship relationship : relationships) {
                if (relationship.getEntityOneProxy().getGUID().equals(primaryEntity.getGUID())) {
                    connectedEntities.add(relationship.getEntityTwoProxy().getGUID());
                    continue;
                }
                if (!relationship.getEntityTwoProxy().getGUID().equals(primaryEntity.getGUID())) continue;
                connectedEntities.add(relationship.getEntityOneProxy().getGUID());
            }
        }
        return connectedEntities;
    }

    private Endpoint getEndpoint(EntityDetail entity, String methodName) throws PropertyServerException {
        Endpoint endpoint = new Endpoint();
        this.setUpElementHeader((ElementHeader)endpoint, entity, OpenMetadataType.ENDPOINT.typeName, methodName);
        InstanceProperties instanceProperties = new InstanceProperties(entity.getProperties());
        endpoint.setQualifiedName(this.removeQualifiedName(instanceProperties));
        endpoint.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
        endpoint.setDisplayName(this.removeName(instanceProperties));
        endpoint.setDescription(this.removeDescription(instanceProperties));
        endpoint.setAddress(this.removeNetworkAddress(instanceProperties));
        endpoint.setProtocol(this.removeProtocol(instanceProperties));
        endpoint.setEncryptionMethod(this.removeEncryptionMethod(instanceProperties));
        endpoint.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
        return endpoint;
    }

    private ConnectorType getConnectorType(EntityDetail entity, String methodName) throws PropertyServerException {
        ConnectorType connectorType = new ConnectorType();
        this.setUpElementHeader((ElementHeader)connectorType, entity, OpenMetadataType.CONNECTOR_TYPE.typeName, methodName);
        InstanceProperties instanceProperties = new InstanceProperties(entity.getProperties());
        connectorType.setQualifiedName(this.removeQualifiedName(instanceProperties));
        connectorType.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
        connectorType.setDisplayName(this.removeDisplayName(instanceProperties));
        connectorType.setDescription(this.removeDescription(instanceProperties));
        connectorType.setSupportedAssetTypeName(this.removeSupportedAssetTypeName(instanceProperties));
        connectorType.setSupportedDeployedImplementationType(this.removeSupportedDeployedImplementationType(instanceProperties));
        connectorType.setExpectedDataFormat(this.removeExpectedDataFormat(instanceProperties));
        connectorType.setConnectorProviderClassName(this.removeConnectorProviderClassName(instanceProperties));
        connectorType.setConnectorFrameworkName(this.removeConnectorFrameworkName(instanceProperties));
        connectorType.setConnectorInterfaceLanguage(this.removeConnectorInterfaceLanguage(instanceProperties));
        connectorType.setConnectorInterfaces(this.removeConnectorInterfaces(instanceProperties));
        connectorType.setTargetTechnologySource(this.removeTargetTechnologySource(instanceProperties));
        connectorType.setTargetTechnologyName(this.removeTargetTechnologyName(instanceProperties));
        connectorType.setTargetTechnologyInterfaces(this.removeTargetTechnologyInterfaces(instanceProperties));
        connectorType.setTargetTechnologyVersions(this.removeTargetTechnologyVersions(instanceProperties));
        connectorType.setRecognizedAdditionalProperties(this.removeRecognizedAdditionalProperties(instanceProperties));
        connectorType.setRecognizedSecuredProperties(this.removeRecognizedSecuredProperties(instanceProperties));
        connectorType.setRecognizedConfigurationProperties(this.removeRecognizedConfigurationProperties(instanceProperties));
        connectorType.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
        return connectorType;
    }

    protected PermittedSynchronization removePermittedSynchronization(InstanceProperties instanceProperties) {
        String methodName = "removePermittedSynchronization";
        if (instanceProperties != null) {
            int ordinal = this.repositoryHelper.removeEnumPropertyOrdinal(this.serviceName, OpenMetadataProperty.PERMITTED_SYNCHRONIZATION.name, instanceProperties, "removePermittedSynchronization");
            for (PermittedSynchronization permittedSynchronization : PermittedSynchronization.values()) {
                if (permittedSynchronization.getOrdinal() != ordinal) continue;
                return permittedSynchronization;
            }
        }
        return PermittedSynchronization.BOTH_DIRECTIONS;
    }

    protected PortType removePortType(InstanceProperties instanceProperties) {
        String methodName = "removePortType";
        if (instanceProperties != null) {
            int ordinal = this.repositoryHelper.removeEnumPropertyOrdinal(this.serviceName, OpenMetadataProperty.PORT_TYPE.name, instanceProperties, "removePortType");
            for (PortType portType : PortType.values()) {
                if (portType.getOrdinal() != ordinal) continue;
                return portType;
            }
        }
        return PortType.OTHER;
    }

    protected ContactMethodType getContactMethodTypeFromProperties(InstanceProperties properties) {
        String methodName = "getContactMethodTypeFromProperties";
        ContactMethodType contactMethodType = ContactMethodType.OTHER;
        if (properties != null) {
            int ordinal = this.repositoryHelper.removeEnumPropertyOrdinal(this.serviceName, OpenMetadataProperty.CONTACT_METHOD_TYPE.name, properties, "getContactMethodTypeFromProperties");
            switch (ordinal) {
                case 0: {
                    contactMethodType = ContactMethodType.EMAIL;
                    break;
                }
                case 1: {
                    contactMethodType = ContactMethodType.PHONE;
                    break;
                }
                case 2: {
                    contactMethodType = ContactMethodType.CHAT;
                    break;
                }
                case 3: {
                    contactMethodType = ContactMethodType.PROFILE;
                    break;
                }
                case 4: {
                    contactMethodType = ContactMethodType.ACCOUNT;
                    break;
                }
            }
        }
        return contactMethodType;
    }
}

