/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.Date;
import java.util.List;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIRootHandler;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.ffdc.GenericHandlersAuditCode;
import org.odpi.openmetadata.commonservices.generichandlers.ffdc.GenericHandlersErrorCode;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ClassificationOrigin;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceAuditHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefLink;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;

public class OpenMetadataAPIAnchorHandler<B>
extends OpenMetadataAPIRootHandler<B> {
    public OpenMetadataAPIAnchorHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public AnchorIdentifiers getAnchorsFromAnchorsClassification(EntitySummary connectToEntity, String methodName) {
        AnchorIdentifiers anchorIdentifiers = null;
        try {
            Classification anchorsClassification = this.repositoryHelper.getClassificationFromEntity(this.serviceName, connectToEntity, OpenMetadataType.ANCHORS_CLASSIFICATION.typeName, methodName);
            if (anchorsClassification != null && anchorsClassification.getProperties() != null) {
                anchorIdentifiers = new AnchorIdentifiers();
                anchorIdentifiers.anchorGUID = this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.ANCHOR_GUID.name, anchorsClassification.getProperties(), methodName);
                anchorIdentifiers.anchorTypeName = this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.ANCHOR_TYPE_NAME.name, anchorsClassification.getProperties(), methodName);
                anchorIdentifiers.anchorDomainName = this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.ANCHOR_DOMAIN_NAME.name, anchorsClassification.getProperties(), methodName);
                anchorIdentifiers.anchorScopeGUID = this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.ANCHOR_SCOPE_GUID.name, anchorsClassification.getProperties(), methodName);
                if (anchorIdentifiers.anchorGUID == null) {
                    anchorIdentifiers.anchorGUID = connectToEntity.getGUID();
                }
                if ("<unknown>".equals(anchorIdentifiers.anchorGUID)) {
                    String localMethodName = "getAnchorGUIDFromAnchorsClassification";
                    throw new PropertyServerException(GenericHandlersErrorCode.UNKNOWN_ANCHOR_GUID.getMessageDefinition("getAnchorGUIDFromAnchorsClassification", this.serviceName, methodName), this.getClass().getName(), "getAnchorGUIDFromAnchorsClassification");
                }
            }
        }
        catch (ClassificationErrorException localMethodName) {
        }
        catch (PropertyServerException error) {
            try {
                this.errorHandler.handleUnsupportedAnchorsType((Exception)((Object)error), methodName, OpenMetadataType.ANCHORS_CLASSIFICATION.typeName);
            }
            catch (PropertyServerException propertyServerException) {
                // empty catch block
            }
        }
        return anchorIdentifiers;
    }

    public void setUpAnchorsClassificationFromParent(String userId, String parentGUID, String parentGUIDParameterName, OpenMetadataAPIGenericBuilder builder, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        EntityDetail parentEntity;
        if (parentGUID != null && (parentEntity = this.repositoryHandler.getEntityByGUID(userId, parentGUID, parentGUIDParameterName, OpenMetadataType.OPEN_METADATA_ROOT.typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName)) != null) {
            AnchorIdentifiers anchors = this.getAnchorsFromAnchorsClassification((EntitySummary)parentEntity, methodName);
            if (anchors != null) {
                builder.setAnchors(userId, anchors, methodName);
            } else {
                builder.setAnchors(userId, parentEntity.getGUID(), parentEntity.getType().getTypeDefName(), this.getDomainName((EntitySummary)parentEntity), null, methodName);
            }
        }
    }

    public EntityDetail setUpAnchorsClassificationFromAnchor(String userId, String anchorGUID, String anchorGUIDParameterName, String anchorScopeGUID, OpenMetadataAPIGenericBuilder builder, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        EntityDetail anchorEntity;
        if (anchorGUID != null && (anchorEntity = this.repositoryHandler.getEntityByGUID(userId, anchorGUID, anchorGUIDParameterName, OpenMetadataType.OPEN_METADATA_ROOT.typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName)) != null) {
            AnchorIdentifiers anchors = this.getAnchorsFromAnchorsClassification((EntitySummary)anchorEntity, methodName);
            if (anchors == null || anchorScopeGUID != null) {
                builder.setAnchors(userId, anchorGUID, anchorEntity.getType().getTypeDefName(), this.getDomainName((EntitySummary)anchorEntity), anchorScopeGUID, methodName);
            } else {
                builder.setAnchors(userId, anchorGUID, anchorEntity.getType().getTypeDefName(), this.getDomainName((EntitySummary)anchorEntity), anchors.anchorScopeGUID, methodName);
            }
        }
        return null;
    }

    public String getAnchorScopeGUIDFromAnchorsClassification(EntitySummary anchorEntity, String methodName) {
        AnchorIdentifiers anchors;
        if (anchorEntity != null && (anchors = this.getAnchorsFromAnchorsClassification(anchorEntity, methodName)) != null) {
            return anchors.anchorScopeGUID;
        }
        return null;
    }

    private void maintainAnchorGUIDInClassification(String targetGUID, String targetGUIDParameterName, String targetTypeName, EntitySummary targetEntity, AnchorIdentifiers anchorIdentifiers, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws PropertyServerException {
        Classification anchorsClassification;
        InstanceProperties anchorsProperties = null;
        String currentAnchorGUID = null;
        String newAnchorGUID = null;
        if (anchorIdentifiers != null) {
            newAnchorGUID = anchorIdentifiers.anchorGUID;
        }
        if ("<unknown>".equals(newAnchorGUID)) {
            String localMethodName = "maintainAnchorGUIDInClassification";
            throw new PropertyServerException(GenericHandlersErrorCode.UNKNOWN_ANCHOR_GUID.getMessageDefinition("maintainAnchorGUIDInClassification", this.serviceName, methodName), this.getClass().getName(), "maintainAnchorGUIDInClassification");
        }
        try {
            anchorsClassification = this.repositoryHelper.getClassificationFromEntity(this.serviceName, targetEntity, OpenMetadataType.ANCHORS_CLASSIFICATION.typeName, methodName);
            if (anchorsClassification != null && (anchorsProperties = anchorsClassification.getProperties()) != null) {
                currentAnchorGUID = this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.ANCHOR_GUID.name, anchorsClassification.getProperties(), methodName);
            }
        }
        catch (ClassificationErrorException noAnchorsClassification) {
            anchorsClassification = null;
        }
        if ("<unknown>".equals(currentAnchorGUID)) {
            String localMethodName = "maintainAnchorGUIDInClassification";
            throw new PropertyServerException(GenericHandlersErrorCode.UNKNOWN_ANCHOR_GUID.getMessageDefinition("maintainAnchorGUIDInClassification", this.serviceName, methodName), this.getClass().getName(), "maintainAnchorGUIDInClassification");
        }
        if (currentAnchorGUID == null && newAnchorGUID != null || currentAnchorGUID != null && !currentAnchorGUID.equals(newAnchorGUID)) {
            try {
                if (anchorIdentifiers != null) {
                    anchorsProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, anchorsProperties, OpenMetadataProperty.ANCHOR_GUID.name, anchorIdentifiers.anchorGUID, methodName);
                    anchorsProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, anchorsProperties, OpenMetadataProperty.ANCHOR_TYPE_NAME.name, anchorIdentifiers.anchorTypeName, methodName);
                    anchorsProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, anchorsProperties, OpenMetadataProperty.ANCHOR_DOMAIN_NAME.name, anchorIdentifiers.anchorDomainName, methodName);
                    anchorsProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, anchorsProperties, OpenMetadataProperty.ANCHOR_SCOPE_GUID.name, anchorIdentifiers.anchorScopeGUID, methodName);
                }
                if (anchorsClassification == null) {
                    this.repositoryHandler.classifyEntity(this.localServerUserId, null, null, targetGUID, null, targetGUIDParameterName, targetEntity.getType().getTypeDefName(), OpenMetadataType.ANCHORS_CLASSIFICATION.typeGUID, OpenMetadataType.ANCHORS_CLASSIFICATION.typeName, ClassificationOrigin.ASSIGNED, null, anchorsProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                } else if (newAnchorGUID != null) {
                    this.repositoryHandler.reclassifyEntity(this.localServerUserId, null, null, targetGUID, targetGUIDParameterName, targetTypeName, OpenMetadataType.ANCHORS_CLASSIFICATION.typeGUID, OpenMetadataType.ANCHORS_CLASSIFICATION.typeName, (InstanceAuditHeader)anchorsClassification, anchorsProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                } else if (targetEntity instanceof EntityDetail) {
                    this.repositoryHandler.declassifyEntity(this.localServerUserId, null, null, targetGUID, (EntityDetail)targetEntity, targetGUIDParameterName, targetEntity.getType().getTypeDefName(), OpenMetadataType.ANCHORS_CLASSIFICATION.typeGUID, OpenMetadataType.ANCHORS_CLASSIFICATION.typeName, (InstanceAuditHeader)anchorsClassification, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                } else {
                    this.repositoryHandler.declassifyEntity(this.localServerUserId, null, null, targetGUID, null, targetGUIDParameterName, targetEntity.getType().getTypeDefName(), OpenMetadataType.ANCHORS_CLASSIFICATION.typeGUID, OpenMetadataType.ANCHORS_CLASSIFICATION.typeName, (InstanceAuditHeader)anchorsClassification, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                }
            }
            catch (Exception error) {
                String typeName = "<null>";
                String typeGUID = "<null>";
                if (targetEntity.getType() != null) {
                    typeName = targetEntity.getType().getTypeDefName();
                    typeGUID = targetEntity.getType().getTypeDefGUID();
                }
                this.auditLog.logException(methodName, GenericHandlersAuditCode.UNABLE_TO_SET_ANCHORS.getMessageDefinition(this.serviceName, targetGUID, typeName, typeGUID, methodName, error.getClass().getName(), error.getMessage()), (Throwable)error);
            }
        }
    }

    private AnchorIdentifiers getAnchorGUIDForSchemaType(String userId, String schemaTypeGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Relationship relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, schemaTypeGUID, OpenMetadataType.SCHEMA_TYPE.typeName, false, OpenMetadataType.ASSET_SCHEMA_TYPE_RELATIONSHIP.typeGUID, OpenMetadataType.ASSET_SCHEMA_TYPE_RELATIONSHIP.typeName, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (relationship != null) {
            EntityProxy proxy = relationship.getEntityOneProxy();
            AnchorIdentifiers anchorIdentifiers = new AnchorIdentifiers();
            anchorIdentifiers.anchorGUID = proxy.getGUID();
            anchorIdentifiers.anchorTypeName = proxy.getType().getTypeDefName();
            anchorIdentifiers.anchorDomainName = OpenMetadataType.ASSET.typeName;
            return anchorIdentifiers;
        }
        relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, schemaTypeGUID, OpenMetadataType.SCHEMA_TYPE.typeName, false, OpenMetadataType.SCHEMA_ATTRIBUTE_TYPE_RELATIONSHIP.typeGUID, OpenMetadataType.SCHEMA_ATTRIBUTE_TYPE_RELATIONSHIP.typeName, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (relationship != null) {
            EntityProxy proxy = relationship.getEntityOneProxy();
            return this.getAnchorGUIDForSchemaAttribute(userId, proxy.getGUID(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, schemaTypeGUID, OpenMetadataType.SCHEMA_TYPE.typeName, false, OpenMetadataType.SCHEMA_TYPE_OPTION_RELATIONSHIP.typeGUID, OpenMetadataType.SCHEMA_TYPE_OPTION_RELATIONSHIP.typeName, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (relationship != null) {
            EntityProxy proxy = relationship.getEntityOneProxy();
            return this.getAnchorGUIDForSchemaType(userId, proxy.getGUID(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, schemaTypeGUID, OpenMetadataType.SCHEMA_TYPE.typeName, false, OpenMetadataType.MAP_FROM_ELEMENT_TYPE_RELATIONSHIP.typeGUID, OpenMetadataType.MAP_FROM_ELEMENT_TYPE_RELATIONSHIP.typeName, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (relationship != null) {
            EntityProxy proxy = relationship.getEntityOneProxy();
            return this.getAnchorGUIDForSchemaType(userId, proxy.getGUID(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, schemaTypeGUID, OpenMetadataType.SCHEMA_TYPE.typeName, false, OpenMetadataType.MAP_TO_ELEMENT_TYPE_RELATIONSHIP.typeGUID, OpenMetadataType.MAP_TO_ELEMENT_TYPE_RELATIONSHIP.typeName, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (relationship != null) {
            EntityProxy proxy = relationship.getEntityOneProxy();
            return this.getAnchorGUIDForSchemaType(userId, proxy.getGUID(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, schemaTypeGUID, OpenMetadataType.SCHEMA_TYPE.typeName, false, OpenMetadataType.API_OPERATIONS_RELATIONSHIP.typeGUID, OpenMetadataType.API_OPERATIONS_RELATIONSHIP.typeName, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (relationship != null) {
            EntityProxy proxy = relationship.getEntityOneProxy();
            return this.getAnchorGUIDForSchemaType(userId, proxy.getGUID(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, schemaTypeGUID, OpenMetadataType.SCHEMA_TYPE.typeName, false, OpenMetadataType.API_HEADER_RELATIONSHIP.typeGUID, OpenMetadataType.API_HEADER_RELATIONSHIP.typeName, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (relationship != null) {
            EntityProxy proxy = relationship.getEntityOneProxy();
            return this.getAnchorGUIDForSchemaType(userId, proxy.getGUID(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, schemaTypeGUID, OpenMetadataType.SCHEMA_TYPE.typeName, false, OpenMetadataType.API_REQUEST_RELATIONSHIP.typeGUID, OpenMetadataType.API_REQUEST_RELATIONSHIP.typeName, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (relationship != null) {
            EntityProxy proxy = relationship.getEntityOneProxy();
            return this.getAnchorGUIDForSchemaType(userId, proxy.getGUID(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, schemaTypeGUID, OpenMetadataType.SCHEMA_TYPE.typeName, false, OpenMetadataType.API_RESPONSE_RELATIONSHIP.typeGUID, OpenMetadataType.API_RESPONSE_RELATIONSHIP.typeName, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (relationship != null) {
            EntityProxy proxy = relationship.getEntityOneProxy();
            return this.getAnchorGUIDForSchemaType(userId, proxy.getGUID(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, schemaTypeGUID, OpenMetadataType.SCHEMA_TYPE.typeName, false, OpenMetadataType.PORT_SCHEMA_RELATIONSHIP.typeGUID, OpenMetadataType.PORT_SCHEMA_RELATIONSHIP.typeName, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (relationship != null) {
            EntityProxy proxy = relationship.getEntityOneProxy();
            AnchorIdentifiers anchorIdentifiers = new AnchorIdentifiers();
            anchorIdentifiers.anchorGUID = proxy.getGUID();
            anchorIdentifiers.anchorTypeName = proxy.getType().getTypeDefName();
            return anchorIdentifiers;
        }
        return null;
    }

    private AnchorIdentifiers getAnchorGUIDForSchemaAttribute(String userId, String attributeGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Relationship relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, attributeGUID, OpenMetadataType.SCHEMA_ATTRIBUTE.typeName, false, OpenMetadataType.ATTRIBUTE_FOR_SCHEMA_RELATIONSHIP.typeGUID, OpenMetadataType.ATTRIBUTE_FOR_SCHEMA_RELATIONSHIP.typeName, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (relationship != null) {
            EntityProxy proxy = relationship.getEntityOneProxy();
            return this.getAnchorGUIDForSchemaType(userId, proxy.getGUID(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        relationship = this.repositoryHandler.getUniqueParentRelationshipByType(userId, attributeGUID, OpenMetadataType.SCHEMA_ATTRIBUTE.typeName, OpenMetadataType.NESTED_SCHEMA_ATTRIBUTE_RELATIONSHIP.typeGUID, OpenMetadataType.NESTED_SCHEMA_ATTRIBUTE_RELATIONSHIP.typeName, true, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (relationship != null) {
            EntityProxy proxy = relationship.getEntityOneProxy();
            return this.getAnchorGUIDForSchemaAttribute(userId, proxy.getGUID(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        return null;
    }

    private AnchorIdentifiers getAnchorGUIDForConnection(String userId, String connectionGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Relationship relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, connectionGUID, OpenMetadataType.CONNECTION.typeName, false, OpenMetadataType.ASSET_CONNECTION_RELATIONSHIP.typeGUID, OpenMetadataType.ASSET_CONNECTION_RELATIONSHIP.typeName, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (relationship != null) {
            EntityProxy proxy = relationship.getEntityOneProxy();
            if (proxy != null && proxy.getGUID() != null) {
                AnchorIdentifiers anchorIdentifiers = new AnchorIdentifiers();
                anchorIdentifiers.anchorGUID = proxy.getGUID();
                anchorIdentifiers.anchorTypeName = proxy.getType().getTypeDefName();
                return anchorIdentifiers;
            }
        } else {
            EntityProxy proxy;
            relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, connectionGUID, OpenMetadataType.CONNECTION.typeName, true, OpenMetadataType.CONNECTION_TO_ASSET_RELATIONSHIP.typeGUID, OpenMetadataType.CONNECTION_TO_ASSET_RELATIONSHIP.typeName, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            if (relationship != null && (proxy = relationship.getEntityOneProxy()) != null && proxy.getGUID() != null) {
                AnchorIdentifiers anchorIdentifiers = new AnchorIdentifiers();
                anchorIdentifiers.anchorGUID = proxy.getGUID();
                anchorIdentifiers.anchorTypeName = proxy.getType().getTypeDefName();
                return anchorIdentifiers;
            }
        }
        return null;
    }

    private AnchorIdentifiers getAnchorGUIDForEndpoint(String userId, String endpointGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        block8: {
            List relationships;
            block7: {
                relationships = this.repositoryHandler.getRelationshipsByType(userId, endpointGUID, OpenMetadataType.ENDPOINT.typeName, OpenMetadataType.SERVER_ENDPOINT_RELATIONSHIP.typeGUID, OpenMetadataType.SERVER_ENDPOINT_RELATIONSHIP.typeName, 1, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, 0, 0, effectiveTime, methodName);
                if (relationships != null) {
                    if (relationships.size() == 1) {
                        EntityProxy proxy = ((Relationship)relationships.get(0)).getEntityOneProxy();
                        if (proxy != null && proxy.getGUID() != null && proxy.getType() != null) {
                            AnchorIdentifiers anchorIdentifiers = new AnchorIdentifiers();
                            anchorIdentifiers.anchorGUID = proxy.getGUID();
                            anchorIdentifiers.anchorTypeName = proxy.getType().getTypeDefName();
                            return anchorIdentifiers;
                        }
                    } else {
                        return null;
                    }
                }
                if ((relationships = this.repositoryHandler.getRelationshipsByType(userId, endpointGUID, OpenMetadataType.ENDPOINT.typeName, OpenMetadataType.CONNECT_TO_ENDPOINT_RELATIONSHIP.typeGUID, OpenMetadataType.CONNECT_TO_ENDPOINT_RELATIONSHIP.typeName, 1, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, 0, 0, effectiveTime, methodName)) != null) break block7;
                relationships = this.repositoryHandler.getRelationshipsByType(userId, endpointGUID, OpenMetadataType.ENDPOINT.typeName, OpenMetadataType.CONNECTION_ENDPOINT_RELATIONSHIP.typeGUID, OpenMetadataType.CONNECTION_ENDPOINT_RELATIONSHIP.typeName, 2, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, 0, 0, effectiveTime, methodName);
                if (relationships == null || relationships.size() != 1) break block8;
                for (Relationship relationship : relationships) {
                    EntityProxy proxy;
                    if (relationship == null || (proxy = relationship.getEntityTwoProxy()) == null || proxy.getGUID() == null || proxy.getType() == null) continue;
                    AnchorIdentifiers anchorIdentifiers = new AnchorIdentifiers();
                    anchorIdentifiers.anchorGUID = proxy.getGUID();
                    anchorIdentifiers.anchorTypeName = proxy.getType().getTypeDefName();
                    return anchorIdentifiers;
                }
                break block8;
            }
            if (relationships.size() == 1) {
                for (Relationship relationship : relationships) {
                    EntityProxy proxy;
                    if (relationship == null || (proxy = relationship.getEntityOneProxy()) == null || proxy.getGUID() == null || proxy.getType() == null) continue;
                    AnchorIdentifiers anchorIdentifiers = new AnchorIdentifiers();
                    anchorIdentifiers.anchorGUID = proxy.getGUID();
                    anchorIdentifiers.anchorTypeName = proxy.getType().getTypeDefName();
                    return anchorIdentifiers;
                }
            }
        }
        return null;
    }

    private AnchorIdentifiers getAnchorGUIDForLike(String userId, String likeGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        EntityProxy proxy;
        Relationship relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, likeGUID, OpenMetadataType.LIKE.typeName, false, OpenMetadataType.ATTACHED_LIKE_RELATIONSHIP.typeGUID, OpenMetadataType.ATTACHED_LIKE_RELATIONSHIP.typeName, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (relationship != null && (proxy = relationship.getEntityOneProxy()) != null && proxy.getGUID() != null) {
            AnchorIdentifiers anchorIdentifiers = new AnchorIdentifiers();
            anchorIdentifiers.anchorGUID = proxy.getGUID();
            anchorIdentifiers.anchorTypeName = proxy.getType().getTypeDefName();
            return anchorIdentifiers;
        }
        return null;
    }

    private AnchorIdentifiers getAnchorGUIDForRating(String userId, String ratingGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        EntityProxy proxy;
        Relationship relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, ratingGUID, OpenMetadataType.RATING.typeName, false, OpenMetadataType.ATTACHED_RATING_RELATIONSHIP.typeGUID, OpenMetadataType.ATTACHED_RATING_RELATIONSHIP.typeName, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (relationship != null && (proxy = relationship.getEntityOneProxy()) != null && proxy.getGUID() != null) {
            AnchorIdentifiers anchorIdentifiers = new AnchorIdentifiers();
            anchorIdentifiers.anchorGUID = proxy.getGUID();
            anchorIdentifiers.anchorTypeName = proxy.getType().getTypeDefName();
            return anchorIdentifiers;
        }
        return null;
    }

    private AnchorIdentifiers getAnchorGUIDForSurveyReport(String userId, String reportGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        EntityProxy proxy;
        Relationship relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, reportGUID, OpenMetadataType.SURVEY_REPORT.typeName, false, OpenMetadataType.ASSET_SURVEY_REPORT_RELATIONSHIP.typeGUID, OpenMetadataType.ASSET_SURVEY_REPORT_RELATIONSHIP.typeName, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (relationship != null && (proxy = relationship.getEntityOneProxy()) != null && proxy.getGUID() != null) {
            AnchorIdentifiers anchorIdentifiers = new AnchorIdentifiers();
            anchorIdentifiers.anchorGUID = proxy.getGUID();
            anchorIdentifiers.anchorTypeName = proxy.getType().getTypeDefName();
            return anchorIdentifiers;
        }
        return null;
    }

    private AnchorIdentifiers getAnchorGUIDForAnnotation(String userId, String annotationGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List relationships = this.repositoryHandler.getRelationshipsByType(userId, annotationGUID, OpenMetadataType.ANNOTATION.typeName, OpenMetadataType.REPORTED_ANNOTATION_RELATIONSHIP.typeGUID, OpenMetadataType.REPORTED_ANNOTATION_RELATIONSHIP.typeName, 1, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, 0, 0, effectiveTime, methodName);
        if (relationships != null) {
            for (Relationship relationship : relationships) {
                EntityProxy proxy;
                if (relationship == null || (proxy = relationship.getEntityOneProxy()) == null || proxy.getGUID() == null || proxy.getType() == null || annotationGUID.equals(proxy.getGUID()) || !this.repositoryHelper.isTypeOf(this.serviceName, proxy.getType().getTypeDefName(), OpenMetadataType.SURVEY_REPORT.typeName)) continue;
                return this.getAnchorGUIDForSurveyReport(userId, proxy.getGUID(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
        }
        return null;
    }

    private AnchorIdentifiers getAnchorGUIDForAnnotationReview(String userId, String annotationReviewGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        EntityProxy proxy;
        Relationship relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, annotationReviewGUID, OpenMetadataType.ANNOTATION_REVIEW.typeName, false, OpenMetadataType.ANNOTATION_REVIEW_LINK_RELATIONSHIP.typeGUID, OpenMetadataType.ANNOTATION_REVIEW_LINK_RELATIONSHIP.typeName, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (relationship != null && (proxy = relationship.getEntityOneProxy()) != null && proxy.getGUID() != null) {
            return this.getAnchorGUIDForAnnotation(userId, proxy.getGUID(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        return null;
    }

    private AnchorIdentifiers getAnchorGUIDForDataField(String userId, String dataFieldGUID, String typeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        EntityProxy proxy;
        Relationship relationship = this.repositoryHandler.getUniqueRelationshipByType(userId, dataFieldGUID, OpenMetadataType.DATA_FIELD.typeName, false, OpenMetadataType.NESTED_DATA_FIELD_RELATIONSHIP.typeGUID, OpenMetadataType.NESTED_DATA_FIELD_RELATIONSHIP.typeName, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (relationship != null && (proxy = relationship.getEntityOneProxy()) != null && proxy.getGUID() != null) {
            return this.getAnchorGUIDForDataField(userId, proxy.getGUID(), proxy.getType().getTypeDefName(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        AnchorIdentifiers anchorIdentifiers = new AnchorIdentifiers();
        anchorIdentifiers.anchorGUID = dataFieldGUID;
        anchorIdentifiers.anchorTypeName = typeName;
        anchorIdentifiers.anchorDomainName = OpenMetadataType.DATA_FIELD.typeName;
        return anchorIdentifiers;
    }

    private AnchorIdentifiers getAnchorGUIDForComment(String userId, String commentGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List relationships = this.repositoryHandler.getRelationshipsByType(userId, commentGUID, OpenMetadataType.COMMENT.typeName, OpenMetadataType.ATTACHED_COMMENT_RELATIONSHIP.typeGUID, OpenMetadataType.ATTACHED_COMMENT_RELATIONSHIP.typeName, 1, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, 0, 0, effectiveTime, methodName);
        if (relationships != null) {
            for (Relationship relationship : relationships) {
                AnchorIdentifiers parentAnchorIdentifiers;
                EntityProxy proxy;
                if (relationship == null || (proxy = relationship.getEntityOneProxy()) == null || proxy.getGUID() == null || proxy.getType() == null) continue;
                if (!commentGUID.equals(proxy.getGUID()) && this.repositoryHelper.isTypeOf(this.serviceName, proxy.getType().getTypeDefName(), OpenMetadataType.COMMENT.typeName) && (parentAnchorIdentifiers = this.getAnchorGUIDForComment(userId, proxy.getGUID(), forLineage, forDuplicateProcessing, effectiveTime, methodName)) != null) {
                    return parentAnchorIdentifiers;
                }
                AnchorIdentifiers anchorIdentifiers = new AnchorIdentifiers();
                anchorIdentifiers.anchorGUID = proxy.getGUID();
                anchorIdentifiers.anchorTypeName = proxy.getType().getTypeDefName();
                return anchorIdentifiers;
            }
        }
        return null;
    }

    private AnchorIdentifiers getAnchorGUIDForGlossaryTerm(String userId, String glossaryTermGUID, String typeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List relationships = this.repositoryHandler.getRelationshipsByType(userId, glossaryTermGUID, OpenMetadataType.GLOSSARY_TERM.typeName, OpenMetadataType.SUPPLEMENTARY_PROPERTIES_RELATIONSHIP.typeGUID, OpenMetadataType.SUPPLEMENTARY_PROPERTIES_RELATIONSHIP.typeName, 1, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, 0, 0, effectiveTime, methodName);
        if (relationships != null) {
            for (Relationship relationship : relationships) {
                EntityProxy proxy;
                if (relationship == null || (proxy = relationship.getEntityOneProxy()) == null || proxy.getGUID() == null || proxy.getType() == null) continue;
                AnchorIdentifiers anchorIdentifiers = new AnchorIdentifiers();
                anchorIdentifiers.anchorGUID = proxy.getGUID();
                anchorIdentifiers.anchorTypeName = proxy.getType().getTypeDefName();
                return anchorIdentifiers;
            }
        }
        AnchorIdentifiers anchorIdentifiers = new AnchorIdentifiers();
        anchorIdentifiers.anchorGUID = glossaryTermGUID;
        anchorIdentifiers.anchorTypeName = typeName;
        anchorIdentifiers.anchorDomainName = OpenMetadataType.GLOSSARY_TERM.typeName;
        return anchorIdentifiers;
    }

    private AnchorIdentifiers getAnchorGUIDForISCSegment(String userId, String glossaryTermGUID, String typeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List relationships = this.repositoryHandler.getRelationshipsByType(userId, glossaryTermGUID, OpenMetadataType.GLOSSARY_TERM.typeName, OpenMetadataType.SUPPLEMENTARY_PROPERTIES_RELATIONSHIP.typeGUID, OpenMetadataType.SUPPLEMENTARY_PROPERTIES_RELATIONSHIP.typeName, 1, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, 0, 0, effectiveTime, methodName);
        if (relationships != null) {
            for (Relationship relationship : relationships) {
                EntityProxy proxy;
                if (relationship == null || (proxy = relationship.getEntityOneProxy()) == null || proxy.getGUID() == null || proxy.getType() == null) continue;
                AnchorIdentifiers anchorIdentifiers = new AnchorIdentifiers();
                anchorIdentifiers.anchorGUID = proxy.getGUID();
                anchorIdentifiers.anchorTypeName = proxy.getType().getTypeDefName();
                return anchorIdentifiers;
            }
        }
        AnchorIdentifiers anchorIdentifiers = new AnchorIdentifiers();
        anchorIdentifiers.anchorGUID = glossaryTermGUID;
        anchorIdentifiers.anchorTypeName = typeName;
        anchorIdentifiers.anchorDomainName = OpenMetadataType.GLOSSARY_TERM.typeName;
        return anchorIdentifiers;
    }

    AnchorIdentifiers deriveAnchorGUID(String targetGUID, String targetTypeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        AnchorIdentifiers anchorIdentifiers = null;
        if (this.repositoryHelper.isTypeOf(this.serviceName, targetTypeName, OpenMetadataType.SCHEMA_TYPE.typeName)) {
            anchorIdentifiers = this.getAnchorGUIDForSchemaType(this.localServerUserId, targetGUID, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, targetTypeName, OpenMetadataType.SCHEMA_ATTRIBUTE.typeName)) {
            anchorIdentifiers = this.getAnchorGUIDForSchemaAttribute(this.localServerUserId, targetGUID, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, targetTypeName, OpenMetadataType.CONNECTION.typeName)) {
            anchorIdentifiers = this.getAnchorGUIDForConnection(this.localServerUserId, targetGUID, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, targetTypeName, OpenMetadataType.ENDPOINT.typeName)) {
            anchorIdentifiers = this.getAnchorGUIDForEndpoint(this.localServerUserId, targetGUID, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, targetTypeName, OpenMetadataType.COMMENT.typeName)) {
            anchorIdentifiers = this.getAnchorGUIDForComment(this.localServerUserId, targetGUID, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, targetTypeName, OpenMetadataType.RATING.typeName)) {
            anchorIdentifiers = this.getAnchorGUIDForRating(this.localServerUserId, targetGUID, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, targetTypeName, OpenMetadataType.LIKE.typeName)) {
            anchorIdentifiers = this.getAnchorGUIDForLike(this.localServerUserId, targetGUID, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, targetTypeName, OpenMetadataType.SURVEY_REPORT.typeName)) {
            anchorIdentifiers = this.getAnchorGUIDForSurveyReport(this.localServerUserId, targetGUID, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, targetTypeName, OpenMetadataType.ANNOTATION.typeName)) {
            anchorIdentifiers = this.getAnchorGUIDForAnnotation(this.localServerUserId, targetGUID, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, targetTypeName, OpenMetadataType.ANNOTATION_REVIEW.typeName)) {
            anchorIdentifiers = this.getAnchorGUIDForAnnotationReview(this.localServerUserId, targetGUID, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, targetTypeName, OpenMetadataType.DATA_FIELD.typeName)) {
            anchorIdentifiers = this.getAnchorGUIDForDataField(this.localServerUserId, targetGUID, targetTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, targetTypeName, OpenMetadataType.GLOSSARY_TERM.typeName)) {
            anchorIdentifiers = this.getAnchorGUIDForGlossaryTerm(this.localServerUserId, targetGUID, targetTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, targetTypeName, OpenMetadataType.INFORMATION_SUPPLY_CHAIN_SEGMENT.typeName)) {
            anchorIdentifiers = this.getAnchorGUIDForISCSegment(this.localServerUserId, targetGUID, targetTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, targetTypeName, OpenMetadataType.GLOSSARY_CATEGORY.typeName) || this.repositoryHelper.isTypeOf(this.serviceName, targetTypeName, OpenMetadataType.INFORMATION_SUPPLY_CHAIN.typeName) || this.repositoryHelper.isTypeOf(this.serviceName, targetTypeName, OpenMetadataType.SOLUTION_COMPONENT.typeName) || this.repositoryHelper.isTypeOf(this.serviceName, targetTypeName, OpenMetadataType.SOLUTION_BLUEPRINT.typeName) || this.repositoryHelper.isTypeOf(this.serviceName, targetTypeName, OpenMetadataType.DATA_STRUCTURE.typeName) || this.repositoryHelper.isTypeOf(this.serviceName, targetTypeName, OpenMetadataType.ASSET.typeName) || this.repositoryHelper.isTypeOf(this.serviceName, targetTypeName, OpenMetadataType.PERSON.typeName)) {
            anchorIdentifiers = new AnchorIdentifiers();
            anchorIdentifiers.anchorGUID = targetGUID;
            anchorIdentifiers.anchorTypeName = targetTypeName;
        }
        if (anchorIdentifiers != null && anchorIdentifiers.anchorGUID != null && anchorIdentifiers.anchorTypeName != null && anchorIdentifiers.anchorDomainName == null) {
            anchorIdentifiers.anchorDomainName = this.getDomainName(anchorIdentifiers.anchorTypeName);
        }
        return anchorIdentifiers;
    }

    String reEvaluateAnchorGUID(String targetGUID, String targetGUIDParameterName, String targetTypeName, String originalAnchorGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        EntityDetail targetElement;
        AnchorIdentifiers newAnchorIdentifiers = this.deriveAnchorGUID(targetGUID, targetTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if ((newAnchorIdentifiers == null && originalAnchorGUID != null || newAnchorIdentifiers != null && !newAnchorIdentifiers.anchorGUID.equals(originalAnchorGUID)) && (targetElement = this.repositoryHandler.getEntityByGUID(this.localServerUserId, targetGUID, targetGUIDParameterName, targetTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName)) != null) {
            this.maintainAnchorGUIDInClassification(targetElement.getGUID(), targetGUIDParameterName, targetTypeName, (EntitySummary)targetElement, newAnchorIdentifiers, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        if (newAnchorIdentifiers != null) {
            return newAnchorIdentifiers.anchorGUID;
        }
        return null;
    }

    public String getDomainName(EntitySummary instance) {
        return this.getDomainName(instance.getType().getTypeDefName());
    }

    public String getDomainName(String typeName) {
        List superTypes;
        String anchorDomainName = typeName;
        if (typeName != null && (superTypes = this.repositoryHelper.getSuperTypes(this.serviceName, typeName)) != null) {
            for (TypeDefLink typeDefLink : superTypes) {
                if (OpenMetadataType.OPEN_METADATA_ROOT.typeName.equals(typeDefLink.getName()) || OpenMetadataType.REFERENCEABLE.typeName.equals(typeDefLink.getName())) continue;
                anchorDomainName = typeDefLink.getName();
            }
        }
        return anchorDomainName;
    }

    String reEvaluateAnchorGUID(String targetGUID, String targetGUIDParameterName, String targetTypeName, EntityDetail targetElement, String originalAnchorGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        AnchorIdentifiers newAnchorIdentifiers = this.deriveAnchorGUID(targetGUID, targetTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if ((newAnchorIdentifiers == null && originalAnchorGUID != null || newAnchorIdentifiers != null && !newAnchorIdentifiers.anchorGUID.equals(originalAnchorGUID)) && targetElement != null) {
            this.maintainAnchorGUIDInClassification(targetElement.getGUID(), targetGUIDParameterName, targetTypeName, (EntitySummary)targetElement, newAnchorIdentifiers, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        if (newAnchorIdentifiers != null) {
            return newAnchorIdentifiers.anchorGUID;
        }
        return null;
    }

    public AnchorIdentifiers getAnchorGUIDForEntity(EntityDetail connectToEntity, String connectToGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws PropertyServerException, InvalidParameterException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateObject((Object)connectToEntity, connectToGUIDParameterName, methodName);
        AnchorIdentifiers anchorIdentifiers = this.getAnchorsFromAnchorsClassification((EntitySummary)connectToEntity, methodName);
        if (anchorIdentifiers == null && (anchorIdentifiers = this.deriveAnchorGUID(connectToEntity.getGUID(), connectToEntity.getType().getTypeDefName(), forLineage, forDuplicateProcessing, effectiveTime, methodName)) != null) {
            this.maintainAnchorGUIDInClassification(connectToEntity.getGUID(), connectToGUIDParameterName, connectToEntity.getType().getTypeDefName(), (EntitySummary)connectToEntity, anchorIdentifiers, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        return anchorIdentifiers;
    }

    public void addAnchorsClassification(String userId, EntityDetail anchoredElement, String anchoredElementGUIDParameterName, String anchorGUID, String anchorTypeName, String anchorDomainName, String anchorScopeGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws UserNotAuthorizedException, PropertyServerException, InvalidParameterException {
        AnchorIdentifiers anchorIdentifiers = this.getAnchorsFromAnchorsClassification((EntitySummary)anchoredElement, methodName);
        ReferenceableBuilder builder = new ReferenceableBuilder(OpenMetadataType.REFERENCEABLE.typeGUID, OpenMetadataType.REFERENCEABLE.typeName, this.repositoryHelper, this.serviceName, this.serverName);
        if (anchorIdentifiers == null) {
            this.repositoryHandler.classifyEntity(userId, null, null, anchoredElement.getGUID(), anchoredElement, anchoredElementGUIDParameterName, anchoredElement.getType().getTypeDefName(), OpenMetadataType.ANCHORS_CLASSIFICATION.typeGUID, OpenMetadataType.ANCHORS_CLASSIFICATION.typeName, ClassificationOrigin.ASSIGNED, null, builder.getAnchorsProperties(anchorGUID, anchorTypeName, anchorDomainName, anchorScopeGUID, methodName), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else {
            this.repositoryHandler.reclassifyEntity(userId, null, null, anchoredElement.getGUID(), anchoredElementGUIDParameterName, anchoredElement.getType().getTypeDefName(), OpenMetadataType.ANCHORS_CLASSIFICATION.typeGUID, OpenMetadataType.ANCHORS_CLASSIFICATION.typeName, null, builder.getAnchorsProperties(anchorGUID, anchorTypeName, anchorDomainName, anchorScopeGUID, methodName), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
    }

    public static class AnchorIdentifiers {
        public String anchorGUID = null;
        String anchorTypeName = null;
        String anchorDomainName = null;
        String anchorScopeGUID = null;
    }
}

