/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.generichandlers.RelatedEntity;
import org.odpi.openmetadata.commonservices.generichandlers.ffdc.GenericHandlersErrorCode;
import org.odpi.openmetadata.frameworks.openmetadata.enums.DataItemSortOrder;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ElementOriginCategory;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ElementStatus;
import org.odpi.openmetadata.frameworks.openmetadata.enums.KeyPattern;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementClassification;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementHeader;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementOrigin;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementStub;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementType;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementVersions;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.RelatedBy;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.RelatedElementStub;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.SchemaTypeElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.RelationshipProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.schema.EnumSchemaTypeProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.schema.ExternalSchemaTypeProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.schema.LiteralSchemaTypeProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.schema.PrimitiveSchemaTypeProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.schema.SchemaAttributeProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.schema.SchemaTypeProperties;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceAuditHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDef;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefLink;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public abstract class OpenMetadataAPIGenericConverter<B> {
    protected OMRSRepositoryHelper repositoryHelper;
    protected String serviceName;
    protected String serverName;

    public OpenMetadataAPIGenericConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        this.repositoryHelper = repositoryHelper;
        this.serviceName = serviceName;
        this.serverName = serverName;
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, String methodName) throws PropertyServerException {
        String thisMethodName = "getNewBean(entity)";
        this.handleUnimplementedConverterMethod(beanClass.getName(), "getNewBean(entity)", this.getClass().getName(), methodName);
        return null;
    }

    public B getNewBean(Class<B> beanClass, EntityDetail entity, Relationship relationship, String methodName) throws PropertyServerException {
        String thisMethodName = "getNewBean(entity, relationship)";
        this.handleUnimplementedConverterMethod(beanClass.getName(), "getNewBean(entity, relationship)", this.getClass().getName(), methodName);
        return null;
    }

    public B getNewComplexBean(Class<B> beanClass, EntityDetail primaryEntity, List<Relationship> relationships, String methodName) throws PropertyServerException {
        String thisMethodName = "getNewComplexBean";
        this.handleUnimplementedConverterMethod(beanClass.getName(), "getNewComplexBean", this.getClass().getName(), methodName);
        return null;
    }

    public B getNewComplexBean(Class<B> beanClass, EntityDetail primaryEntity, Relationship relationship, List<RelatedEntity> relatedEntities, String methodName) throws PropertyServerException {
        String thisMethodName = "getNewComplexBean";
        this.handleUnimplementedConverterMethod(beanClass.getName(), "getNewComplexBean", this.getClass().getName(), methodName);
        return null;
    }

    public B getNewComplexBean(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        String thisMethodName = "getNewComplexBean(with supplementary entities)";
        this.handleUnimplementedConverterMethod(beanClass.getName(), "getNewComplexBean(with supplementary entities)", this.getClass().getName(), methodName);
        return null;
    }

    public B getNewRelationshipBean(Class<B> beanClass, Relationship relationship, String methodName) throws PropertyServerException {
        String thisMethodName = "getNewRelationshipBean";
        this.handleUnimplementedConverterMethod(beanClass.getName(), "getNewRelationshipBean", this.getClass().getName(), methodName);
        return null;
    }

    public B getNewSchemaTypeBean(Class<B> beanClass, InstanceHeader schemaRootHeader, String schemaTypeTypeName, InstanceProperties instanceProperties, List<Classification> schemaRootClassifications, int attributeCount, String validValueSetGUID, B externalSchemaType, B mapFromSchemaType, B mapToSchemaType, List<B> schemaTypeOptions, String methodName) throws PropertyServerException {
        String thisMethodName = "getNewSchemaTypeBean";
        this.handleUnimplementedConverterMethod(beanClass.getName(), "getNewSchemaTypeBean", this.getClass().getName(), methodName);
        return null;
    }

    public B getNewSchemaTypeBean(Class<B> beanClass, InstanceHeader schemaRootHeader, String schemaTypeTypeName, InstanceProperties instanceProperties, List<Classification> schemaRootClassifications, int attributeCount, String validValueSetGUID, String externalSchemaTypeGUID, B externalSchemaType, String mapFromSchemaTypeGUID, B mapFromSchemaType, String mapToSchemaTypeGUID, B mapToSchemaType, List<String> schemaTypeOptionGUIDs, List<B> schemaTypeOptions, List<Relationship> queryTargets, String methodName) throws PropertyServerException {
        return this.getNewSchemaTypeBean(beanClass, schemaRootHeader, schemaTypeTypeName, instanceProperties, schemaRootClassifications, attributeCount, validValueSetGUID, externalSchemaType, mapFromSchemaType, mapToSchemaType, schemaTypeOptions, methodName);
    }

    public <T> B getNewSchemaAttributeBean(Class<B> beanClass, EntityDetail schemaAttributeEntity, Class<T> typeClass, T schemaType, List<Relationship> schemaAttributeRelationships, String methodName) throws PropertyServerException {
        String thisMethodName = "getNewSchemaAttributeBean)";
        this.handleUnimplementedConverterMethod(beanClass.getName(), "getNewSchemaAttributeBean)", this.getClass().getName(), methodName);
        return null;
    }

    private void handleUnimplementedConverterMethod(String beanClassName, String missingMethodName, String converterClassName, String methodName) throws PropertyServerException {
        throw new PropertyServerException(GenericHandlersErrorCode.MISSING_CONVERTER_METHOD.getMessageDefinition(this.serviceName, missingMethodName, converterClassName, beanClassName, methodName), this.getClass().getName(), methodName);
    }

    protected void handleInvalidBeanClass(String beanClassName, Exception error, String methodName) throws PropertyServerException {
        throw new PropertyServerException(GenericHandlersErrorCode.INVALID_BEAN_CLASS.getMessageDefinition(beanClassName, methodName, this.serviceName, this.serverName, error.getMessage()), this.getClass().getName(), methodName, error);
    }

    protected void handleUnexpectedBeanClass(String beanClassName, String expectedBeanClass, String methodName) throws PropertyServerException {
        throw new PropertyServerException(GenericHandlersErrorCode.UNEXPECTED_BEAN_CLASS.getMessageDefinition(beanClassName, methodName, this.serviceName, this.serverName, expectedBeanClass), this.getClass().getName(), methodName);
    }

    protected void handleMissingMetadataInstance(String beanClassName, TypeDefCategory typeDefCategory, String methodName) throws PropertyServerException {
        throw new PropertyServerException(GenericHandlersErrorCode.MISSING_METADATA_INSTANCE.getMessageDefinition(this.serviceName, beanClassName, typeDefCategory.getName(), methodName), this.getClass().getName(), methodName);
    }

    void validateInstanceType(String expectedTypeName, String beanClassName, InstanceAuditHeader instanceAuditHeader, String methodName) throws PropertyServerException {
        String actualTypeName = "<null>";
        if (instanceAuditHeader.getType() != null && instanceAuditHeader.getType().getTypeDefName() != null) {
            actualTypeName = instanceAuditHeader.getType().getTypeDefName();
        }
        this.validateInstanceType(expectedTypeName, beanClassName, actualTypeName, methodName);
    }

    protected void validateInstanceType(String expectedTypeName, String beanClassName, String actualTypeName, String methodName) throws PropertyServerException {
        if (this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, expectedTypeName)) {
            return;
        }
        throw new PropertyServerException(GenericHandlersErrorCode.BAD_INSTANCE_TYPE.getMessageDefinition(this.serviceName, beanClassName, actualTypeName, methodName, expectedTypeName), this.getClass().getName(), methodName);
    }

    protected void handleBadEntity(String beanClassName, EntityDetail entity, String methodName) throws PropertyServerException {
        if (entity != null) {
            throw new PropertyServerException(GenericHandlersErrorCode.BAD_ENTITY.getMessageDefinition(methodName, this.serviceName, entity.toString()), this.getClass().getName(), methodName);
        }
        this.handleMissingMetadataInstance(beanClassName, TypeDefCategory.ENTITY_DEF, methodName);
    }

    protected void handleBadRelationship(String beanClassName, Relationship relationship, String methodName) throws PropertyServerException {
        if (relationship != null) {
            throw new PropertyServerException(GenericHandlersErrorCode.BAD_RELATIONSHIP.getMessageDefinition(methodName, this.serviceName, relationship.toString()), this.getClass().getName(), methodName);
        }
        this.handleMissingMetadataInstance(beanClassName, TypeDefCategory.RELATIONSHIP_DEF, methodName);
    }

    protected InstanceProperties getClassificationProperties(String classificationName, EntityDetail entity) {
        List entityClassifications;
        if (entity != null && (entityClassifications = entity.getClassifications()) != null) {
            return this.getClassificationProperties(classificationName, entityClassifications);
        }
        return null;
    }

    protected InstanceProperties getClassificationProperties(String classificationName, List<Classification> entityClassifications) {
        if (entityClassifications != null) {
            for (Classification entityClassification : entityClassifications) {
                if (entityClassification == null || !classificationName.equals(entityClassification.getName())) continue;
                return entityClassification.getProperties();
            }
        }
        return null;
    }

    protected ElementHeader getMetadataElementHeader(Class<B> beanClass, EntityDetail entity, String methodName) throws PropertyServerException {
        if (entity != null) {
            return this.getMetadataElementHeader(beanClass, (InstanceHeader)entity, entity.getClassifications(), methodName);
        }
        this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
        return null;
    }

    public ElementHeader getMetadataElementHeader(Class<B> beanClass, InstanceHeader header, List<Classification> entityClassifications, String methodName) throws PropertyServerException {
        if (header != null) {
            ElementHeader elementHeader = new ElementHeader();
            elementHeader.setGUID(header.getGUID());
            elementHeader.setStatus(this.getElementStatus(header.getStatus()));
            elementHeader.setClassifications(this.getElementClassifications(entityClassifications));
            elementHeader.setType(this.getElementType((InstanceAuditHeader)header));
            ElementOrigin elementOrigin = new ElementOrigin();
            elementOrigin.setSourceServer(this.serverName);
            elementOrigin.setOriginCategory(this.getElementOriginCategory(header.getInstanceProvenanceType()));
            elementOrigin.setHomeMetadataCollectionId(header.getMetadataCollectionId());
            elementOrigin.setHomeMetadataCollectionName(header.getMetadataCollectionName());
            elementOrigin.setLicense(header.getInstanceLicense());
            elementHeader.setOrigin(elementOrigin);
            elementHeader.setVersions(this.getElementVersions((InstanceAuditHeader)header));
            return elementHeader;
        }
        this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
        return null;
    }

    protected ElementStatus getElementStatus(InstanceStatus instanceStatus) {
        if (instanceStatus != null) {
            switch (instanceStatus) {
                case UNKNOWN: {
                    return ElementStatus.UNKNOWN;
                }
                case DRAFT: {
                    return ElementStatus.DRAFT;
                }
                case PREPARED: {
                    return ElementStatus.PREPARED;
                }
                case PROPOSED: {
                    return ElementStatus.PROPOSED;
                }
                case APPROVED: {
                    return ElementStatus.APPROVED;
                }
                case REJECTED: {
                    return ElementStatus.REJECTED;
                }
                case APPROVED_CONCEPT: {
                    return ElementStatus.APPROVED_CONCEPT;
                }
                case UNDER_DEVELOPMENT: {
                    return ElementStatus.UNDER_DEVELOPMENT;
                }
                case DEVELOPMENT_COMPLETE: {
                    return ElementStatus.DEVELOPMENT_COMPLETE;
                }
                case APPROVED_FOR_DEPLOYMENT: {
                    return ElementStatus.APPROVED_FOR_DEPLOYMENT;
                }
                case STANDBY: {
                    return ElementStatus.STANDBY;
                }
                case ACTIVE: {
                    return ElementStatus.ACTIVE;
                }
                case FAILED: {
                    return ElementStatus.FAILED;
                }
                case DISABLED: {
                    return ElementStatus.DISABLED;
                }
                case COMPLETE: {
                    return ElementStatus.COMPLETE;
                }
                case DEPRECATED: {
                    return ElementStatus.DEPRECATED;
                }
                case DELETED: {
                    return ElementStatus.DELETED;
                }
                case OTHER: {
                    return ElementStatus.OTHER;
                }
            }
        }
        return ElementStatus.UNKNOWN;
    }

    public ElementStub getElementStub(Class<B> beanClass, EntityProxy entityProxy, String methodName) throws PropertyServerException {
        if (entityProxy != null) {
            ElementHeader elementHeader = this.getMetadataElementHeader(beanClass, (InstanceHeader)entityProxy, entityProxy.getClassifications(), methodName);
            ElementStub elementStub = new ElementStub(elementHeader);
            elementStub.setUniqueName(this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.QUALIFIED_NAME.name, entityProxy.getUniqueProperties(), methodName));
            return elementStub;
        }
        this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
        return null;
    }

    public ElementStub getElementStub(Class<B> beanClass, EntityDetail entity, String methodName) throws PropertyServerException {
        if (entity != null) {
            ElementHeader elementHeader = this.getMetadataElementHeader(beanClass, entity, methodName);
            ElementStub elementStub = new ElementStub(elementHeader);
            elementStub.setUniqueName(this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.QUALIFIED_NAME.name, entity.getProperties(), methodName));
            return elementStub;
        }
        this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
        return null;
    }

    public ElementStub getElementStub(Class<B> beanClass, Relationship relationship, String methodName) throws PropertyServerException {
        if (relationship != null) {
            ElementHeader elementHeader = this.getMetadataElementHeader(beanClass, (InstanceHeader)relationship, null, methodName);
            return new ElementStub(elementHeader);
        }
        this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.RELATIONSHIP_DEF, methodName);
        return null;
    }

    List<ElementClassification> getEntityClassifications(EntityDetail entity) {
        if (entity != null) {
            return this.getElementClassifications(entity.getClassifications());
        }
        return null;
    }

    protected List<ElementClassification> getElementClassifications(List<Classification> entityClassifications) {
        ArrayList<ElementClassification> beanClassifications = null;
        if (entityClassifications != null) {
            beanClassifications = new ArrayList<ElementClassification>();
            for (Classification entityClassification : entityClassifications) {
                if (entityClassification == null) continue;
                ElementClassification beanClassification = new ElementClassification();
                beanClassification.setStatus(this.getElementStatus(entityClassification.getStatus()));
                beanClassification.setType(this.getElementType((InstanceAuditHeader)entityClassification));
                ElementOrigin elementOrigin = new ElementOrigin();
                elementOrigin.setSourceServer(this.serverName);
                elementOrigin.setOriginCategory(this.getElementOriginCategory(entityClassification.getInstanceProvenanceType()));
                elementOrigin.setHomeMetadataCollectionId(entityClassification.getMetadataCollectionId());
                elementOrigin.setHomeMetadataCollectionName(entityClassification.getMetadataCollectionName());
                elementOrigin.setLicense(entityClassification.getInstanceLicense());
                beanClassification.setOrigin(elementOrigin);
                beanClassification.setVersions(this.getElementVersions((InstanceAuditHeader)entityClassification));
                beanClassification.setClassificationName(entityClassification.getName());
                beanClassification.setClassificationProperties(this.repositoryHelper.getInstancePropertiesAsMap(entityClassification.getProperties()));
                beanClassifications.add(beanClassification);
            }
        }
        return beanClassifications;
    }

    public ElementType getElementType(InstanceAuditHeader instanceHeader) {
        ElementType elementType = new ElementType();
        InstanceType instanceType = instanceHeader.getType();
        if (instanceType != null) {
            String typeDefName = instanceType.getTypeDefName();
            TypeDef typeDef = this.repositoryHelper.getTypeDefByName(this.serviceName, typeDefName);
            elementType.setTypeId(instanceType.getTypeDefGUID());
            elementType.setTypeName(typeDefName);
            elementType.setTypeVersion(instanceType.getTypeDefVersion());
            elementType.setTypeDescription(typeDef.getDescription());
            List typeDefSuperTypes = this.repositoryHelper.getSuperTypes(this.serviceName, typeDefName);
            if (typeDefSuperTypes != null && !typeDefSuperTypes.isEmpty()) {
                ArrayList<String> superTypes = new ArrayList<String>();
                for (TypeDefLink typeDefLink : typeDefSuperTypes) {
                    if (typeDefLink == null) continue;
                    superTypes.add(typeDefLink.getName());
                }
                if (!superTypes.isEmpty()) {
                    elementType.setSuperTypeNames(superTypes);
                }
            }
        }
        return elementType;
    }

    protected ElementVersions getElementVersions(InstanceAuditHeader header) {
        ElementVersions elementVersions = new ElementVersions();
        elementVersions.setCreatedBy(header.getCreatedBy());
        elementVersions.setCreateTime(header.getCreateTime());
        elementVersions.setUpdatedBy(header.getUpdatedBy());
        elementVersions.setUpdateTime(header.getUpdateTime());
        elementVersions.setMaintainedBy(header.getMaintainedBy());
        elementVersions.setVersion(header.getVersion());
        return elementVersions;
    }

    protected ElementOriginCategory getElementOriginCategory(InstanceProvenanceType instanceProvenanceType) {
        if (instanceProvenanceType != null) {
            return switch (instanceProvenanceType) {
                default -> throw new IncompatibleClassChangeError();
                case InstanceProvenanceType.DEREGISTERED_REPOSITORY -> ElementOriginCategory.DEREGISTERED_REPOSITORY;
                case InstanceProvenanceType.EXTERNAL_SOURCE -> ElementOriginCategory.EXTERNAL_SOURCE;
                case InstanceProvenanceType.EXPORT_ARCHIVE -> ElementOriginCategory.EXPORT_ARCHIVE;
                case InstanceProvenanceType.LOCAL_COHORT -> ElementOriginCategory.LOCAL_COHORT;
                case InstanceProvenanceType.CONTENT_PACK -> ElementOriginCategory.CONTENT_PACK;
                case InstanceProvenanceType.CONFIGURATION -> ElementOriginCategory.CONFIGURATION;
                case InstanceProvenanceType.UNKNOWN -> ElementOriginCategory.UNKNOWN;
            };
        }
        return ElementOriginCategory.UNKNOWN;
    }

    public DataItemSortOrder removeSortOrder(InstanceProperties instanceProperties) {
        String methodName = "removeSortOrder";
        if (instanceProperties != null) {
            int ordinal = this.repositoryHelper.removeEnumPropertyOrdinal(this.serviceName, OpenMetadataProperty.SORT_ORDER.name, instanceProperties, "removeSortOrder");
            for (DataItemSortOrder dataItemSortOrder : DataItemSortOrder.values()) {
                if (dataItemSortOrder.getOrdinal() != ordinal) continue;
                return dataItemSortOrder;
            }
        }
        return null;
    }

    public KeyPattern removeKeyPattern(InstanceProperties instanceProperties) {
        String methodName = "removeKeyPattern";
        if (instanceProperties != null) {
            int ordinal = this.repositoryHelper.removeEnumPropertyOrdinal(this.serviceName, OpenMetadataProperty.KEY_PATTERN.name, instanceProperties, "removeKeyPattern");
            for (KeyPattern keyPattern : KeyPattern.values()) {
                if (keyPattern.getOrdinal() != ordinal) continue;
                return keyPattern;
            }
        }
        return null;
    }

    public void setUpSchemaAttribute(EntityDetail schemaAttributeEntity, SchemaTypeElement schemaTypeElement, SchemaAttributeProperties properties) {
        InstanceProperties instanceProperties = new InstanceProperties(schemaAttributeEntity.getProperties());
        properties.setQualifiedName(this.removeQualifiedName(instanceProperties));
        properties.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
        properties.setDisplayName(this.removeDisplayName(instanceProperties));
        properties.setDescription(this.removeDescription(instanceProperties));
        properties.setElementPosition(this.removePosition(instanceProperties));
        properties.setMinCardinality(this.removeMinCardinality(instanceProperties));
        properties.setMaxCardinality(this.removeMaxCardinality(instanceProperties));
        properties.setAllowsDuplicateValues(this.removeAllowsDuplicateValues(instanceProperties));
        properties.setOrderedValues(this.removeOrderedValues(instanceProperties));
        properties.setDefaultValueOverride(this.removeDefaultValueOverride(instanceProperties));
        properties.setSortOrder(this.removeSortOrder(instanceProperties));
        properties.setMinimumLength(this.removeMinimumLength(instanceProperties));
        properties.setLength(this.removeLength(instanceProperties));
        properties.setPrecision(this.removePrecision(instanceProperties));
        properties.setIsNullable(this.removeIsNullable(instanceProperties));
        properties.setNativeJavaClass(this.removeNativeClass(instanceProperties));
        properties.setAliases(this.removeAliases(instanceProperties));
        properties.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
        if (schemaTypeElement != null) {
            this.addSchemaTypeToAttribute(schemaTypeElement, properties);
        }
    }

    public void addSchemaTypeToAttribute(SchemaTypeElement schemaTypeElement, SchemaAttributeProperties attributeProperties) {
        SchemaTypeProperties schemaTypeProperties = schemaTypeElement.getSchemaTypeProperties();
        if (schemaTypeProperties instanceof PrimitiveSchemaTypeProperties) {
            attributeProperties.setDataType(((PrimitiveSchemaTypeProperties)schemaTypeProperties).getDataType());
            attributeProperties.setDefaultValue(((PrimitiveSchemaTypeProperties)schemaTypeProperties).getDefaultValue());
        } else if (schemaTypeProperties instanceof LiteralSchemaTypeProperties) {
            attributeProperties.setDataType(((LiteralSchemaTypeProperties)schemaTypeProperties).getDataType());
            attributeProperties.setFixedValue(((LiteralSchemaTypeProperties)schemaTypeProperties).getFixedValue());
        } else if (schemaTypeProperties instanceof EnumSchemaTypeProperties) {
            attributeProperties.setDataType(((EnumSchemaTypeProperties)schemaTypeProperties).getDataType());
            attributeProperties.setDefaultValue(((EnumSchemaTypeProperties)schemaTypeProperties).getDefaultValue());
            attributeProperties.setValidValuesSetGUID(((EnumSchemaTypeProperties)schemaTypeProperties).getValidValueSetGUID());
        } else if (schemaTypeProperties instanceof ExternalSchemaTypeProperties) {
            SchemaTypeElement externalSchemaType = schemaTypeElement.getExternalSchemaType();
            attributeProperties.setExternalTypeGUID(externalSchemaType.getElementHeader().getGUID());
        } else if (schemaTypeProperties.getExtendedProperties() != null) {
            Map extendedProperties = schemaTypeProperties.getExtendedProperties();
            Object propertyObject = extendedProperties.get(OpenMetadataProperty.DATA_TYPE.name);
            if (propertyObject != null) {
                attributeProperties.setDataType(propertyObject.toString());
            }
            if ((propertyObject = extendedProperties.get(OpenMetadataProperty.FIXED_VALUE.name)) != null) {
                attributeProperties.setFixedValue(propertyObject.toString());
            }
            if ((propertyObject = extendedProperties.get(OpenMetadataProperty.DEFAULT_VALUE.name)) != null) {
                attributeProperties.setDefaultValue(propertyObject.toString());
            }
        }
        attributeProperties.setSchemaType(schemaTypeProperties);
    }

    public RelatedElementStub getRelatedElement(Class<B> beanClass, EntityDetail entity, Relationship relationship, String methodName) throws PropertyServerException {
        RelatedElementStub relatedElement = new RelatedElementStub();
        relatedElement.setRelationshipHeader(this.getMetadataElementHeader(beanClass, (InstanceHeader)relationship, null, methodName));
        if (relationship != null) {
            InstanceProperties instanceProperties = new InstanceProperties(relationship.getProperties());
            RelationshipProperties relationshipProperties = new RelationshipProperties();
            relationshipProperties.setEffectiveFrom(instanceProperties.getEffectiveFromTime());
            relationshipProperties.setEffectiveTo(instanceProperties.getEffectiveToTime());
            relationshipProperties.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
            relatedElement.setRelationshipProperties(relationshipProperties);
        } else {
            this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.RELATIONSHIP_DEF, methodName);
        }
        if (entity != null) {
            ElementStub elementStub = this.getElementStub(beanClass, entity, methodName);
            relatedElement.setRelatedElement(elementStub);
        } else {
            this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
        }
        return relatedElement;
    }

    public RelatedElementStub getRelatedElement(Class<B> beanClass, Relationship relationship, EntityProxy entityProxy, String methodName) throws PropertyServerException {
        RelatedElementStub relatedElementStub = new RelatedElementStub();
        relatedElementStub.setRelationshipHeader(this.getMetadataElementHeader(beanClass, (InstanceHeader)relationship, null, methodName));
        if (relationship != null) {
            InstanceProperties instanceProperties = new InstanceProperties(relationship.getProperties());
            RelationshipProperties relationshipProperties = new RelationshipProperties();
            relationshipProperties.setEffectiveFrom(instanceProperties.getEffectiveFromTime());
            relationshipProperties.setEffectiveTo(instanceProperties.getEffectiveToTime());
            relationshipProperties.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
            relatedElementStub.setRelationshipProperties(relationshipProperties);
        } else {
            this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.RELATIONSHIP_DEF, methodName);
        }
        if (entityProxy != null) {
            ElementStub elementStub = this.getElementStub(beanClass, entityProxy, methodName);
            relatedElementStub.setRelatedElement(elementStub);
        } else {
            this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
        }
        return relatedElementStub;
    }

    public RelatedBy getRelatedBy(Class<B> beanClass, Relationship relationship, String methodName) throws PropertyServerException {
        RelatedBy relatedBy = new RelatedBy();
        relatedBy.setRelationshipHeader(this.getMetadataElementHeader(beanClass, (InstanceHeader)relationship, null, methodName));
        if (relationship != null) {
            InstanceProperties instanceProperties = new InstanceProperties(relationship.getProperties());
            RelationshipProperties relationshipProperties = new RelationshipProperties();
            relationshipProperties.setEffectiveFrom(instanceProperties.getEffectiveFromTime());
            relationshipProperties.setEffectiveTo(instanceProperties.getEffectiveToTime());
            relationshipProperties.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
            relatedBy.setRelationshipProperties(relationshipProperties);
        } else {
            this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.RELATIONSHIP_DEF, methodName);
        }
        return relatedBy;
    }

    protected String getQualifiedName(InstanceProperties instanceProperties) {
        String methodName = "getQualifiedName";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.QUALIFIED_NAME.name, instanceProperties, "getQualifiedName");
        }
        return null;
    }

    protected String removeQualifiedName(InstanceProperties instanceProperties) {
        String methodName = "removeQualifiedName";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.QUALIFIED_NAME.name, instanceProperties, "removeQualifiedName");
        }
        return null;
    }

    protected Map<String, String> removeAdditionalProperties(InstanceProperties instanceProperties) {
        String methodName = "removeAdditionalProperties";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringMapFromProperty(this.serviceName, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, instanceProperties, "removeAdditionalProperties");
        }
        return null;
    }

    protected Map<String, Object> getRemainingExtendedProperties(InstanceProperties instanceProperties) {
        Map extendedProperties;
        if (instanceProperties != null && (extendedProperties = this.repositoryHelper.getInstancePropertiesAsMap(instanceProperties)) != null && !extendedProperties.isEmpty()) {
            return extendedProperties;
        }
        return null;
    }

    protected Map<String, String> getPropertiesAsStrings(InstanceProperties instanceProperties) {
        Map propertyMap;
        if (instanceProperties != null && (propertyMap = instanceProperties.getInstanceProperties()) != null && !propertyMap.isEmpty()) {
            HashMap<String, String> stringPropertyMap = new HashMap<String, String>();
            for (String propertyName : propertyMap.keySet()) {
                InstancePropertyValue instancePropertyValue = (InstancePropertyValue)propertyMap.get(propertyName);
                if (instancePropertyValue != null) {
                    stringPropertyMap.put(propertyName, instancePropertyValue.valueAsString());
                    continue;
                }
                stringPropertyMap.put(propertyName, null);
            }
            return stringPropertyMap;
        }
        return null;
    }

    protected String removeDisplayName(InstanceProperties instanceProperties) {
        String methodName = "removeDisplayName";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.DISPLAY_NAME.name, instanceProperties, "removeDisplayName");
        }
        return null;
    }

    protected String getDisplayName(InstanceProperties instanceProperties) {
        String methodName = "getDisplayName";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.DISPLAY_NAME.name, instanceProperties, "getDisplayName");
        }
        return null;
    }

    protected String removeName(InstanceProperties instanceProperties) {
        String methodName = "removeName";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.NAME.name, instanceProperties, "removeName");
        }
        return null;
    }

    protected String removeResourceName(InstanceProperties instanceProperties) {
        String methodName = "removeName";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.RESOURCE_NAME.name, instanceProperties, "removeName");
        }
        return null;
    }

    protected String removeVersionIdentifier(InstanceProperties instanceProperties) {
        String methodName = "removeVersionIdentifier";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.VERSION_IDENTIFIER.name, instanceProperties, "removeVersionIdentifier");
        }
        return null;
    }

    protected String getDescription(InstanceProperties instanceProperties) {
        String methodName = "getDescription";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.DESCRIPTION.name, instanceProperties, "getDescription");
        }
        return null;
    }

    protected String removeDescription(InstanceProperties instanceProperties) {
        String methodName = "removeDescription";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.DESCRIPTION.name, instanceProperties, "removeDescription");
        }
        return null;
    }

    protected String removeCollectionType(InstanceProperties instanceProperties) {
        String methodName = "removeCollectionType";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.COLLECTION_TYPE.name, instanceProperties, "removeCollectionType");
        }
        return null;
    }

    protected String removeKeyword(InstanceProperties instanceProperties) {
        String methodName = "removeKeyword";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.KEYWORD.name, instanceProperties, "removeKeyword");
        }
        return null;
    }

    protected String removeTopicType(InstanceProperties instanceProperties) {
        String methodName = "removeTopicType";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.TOPIC_TYPE.name, instanceProperties, "removeTopicType");
        }
        return null;
    }

    protected String removeTopicName(InstanceProperties instanceProperties) {
        String methodName = "removeTopicName";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.TOPIC_NAME.name, instanceProperties, "removeTopicName");
        }
        return null;
    }

    protected String removeContactType(InstanceProperties instanceProperties) {
        String methodName = "removeContactType";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.CONTACT_TYPE.name, instanceProperties, "removeContactType");
        }
        return null;
    }

    protected String removeContactMethodService(InstanceProperties instanceProperties) {
        String methodName = "removeContactMethodService";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.CONTACT_METHOD_SERVICE.name, instanceProperties, "removeContactMethodService");
        }
        return null;
    }

    protected String removeContactMethodValue(InstanceProperties instanceProperties) {
        String methodName = "removeContactMethodValue";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.CONTACT_METHOD_VALUE.name, instanceProperties, "removeContactMethodValue");
        }
        return null;
    }

    protected String removeMission(InstanceProperties instanceProperties) {
        String methodName = "removeMission";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.MISSION.name, instanceProperties, "removeMission");
        }
        return null;
    }

    protected String removeAssociationType(InstanceProperties instanceProperties) {
        String methodName = "removeAssociationType";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.ASSOCIATION_TYPE.name, instanceProperties, "removeAssociationType");
        }
        return null;
    }

    protected String removeIdentifier(InstanceProperties instanceProperties) {
        String methodName = "removeIdentifier";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.IDENTIFIER.name, instanceProperties, "removeIdentifier");
        }
        return null;
    }

    protected String removeIdentifierTypeName(InstanceProperties instanceProperties) {
        String methodName = "removeIdentifierTypeName";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.EXT_INSTANCE_TYPE_NAME.name, instanceProperties, "removeIdentifierTypeName");
        }
        return null;
    }

    protected String removeExternalInstanceCreatedBy(InstanceProperties instanceProperties) {
        String methodName = "removeExternalInstanceCreatedBy";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.EXT_INSTANCE_CREATED_BY.name, instanceProperties, "removeExternalInstanceCreatedBy");
        }
        return null;
    }

    protected Date removeExternalInstanceCreationTime(InstanceProperties instanceProperties) {
        String methodName = "removeExternalInstanceCreationTime";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeDateProperty(this.serviceName, OpenMetadataProperty.EXT_INSTANCE_CREATION_TIME.name, instanceProperties, "removeExternalInstanceCreationTime");
        }
        return null;
    }

    protected String removeExternalInstanceLastUpdatedBy(InstanceProperties instanceProperties) {
        String methodName = "removeExternalInstanceLastUpdatedBy";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.EXT_INSTANCE_LAST_UPDATED_BY.name, instanceProperties, "removeExternalInstanceLastUpdatedBy");
        }
        return null;
    }

    protected Date removeExternalInstanceLastUpdateTime(InstanceProperties instanceProperties) {
        String methodName = "removeExternalInstanceCreationTime";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeDateProperty(this.serviceName, OpenMetadataProperty.EXT_INSTANCE_LAST_UPDATE_TIME.name, instanceProperties, "removeExternalInstanceCreationTime");
        }
        return null;
    }

    protected long removeExternalInstanceVersion(InstanceProperties instanceProperties) {
        String methodName = "removeExternalInstanceVersion";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeLongProperty(this.serviceName, OpenMetadataProperty.EXT_INSTANCE_VERSION.name, instanceProperties, "removeExternalInstanceVersion");
        }
        return 0L;
    }

    protected String removeURL(InstanceProperties instanceProperties) {
        String methodName = "removeURL";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.URL.name, instanceProperties, "removeURL");
        }
        return null;
    }

    protected String removeOwningOrganization(InstanceProperties instanceProperties) {
        String methodName = "removeOwningOrganization";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.ORGANIZATION.name, instanceProperties, "removeOwningOrganization");
        }
        return null;
    }

    protected String removeReferenceVersion(InstanceProperties instanceProperties) {
        String methodName = "removeReferenceVersion";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.REFERENCE_VERSION.name, instanceProperties, "removeReferenceVersion");
        }
        return null;
    }

    protected String removeReferenceId(InstanceProperties instanceProperties) {
        String methodName = "removeReferenceId";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.REFERENCE_ID.name, instanceProperties, "removeReferenceId");
        }
        return null;
    }

    protected String getReferenceId(InstanceProperties instanceProperties) {
        String methodName = "getReferenceId";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.REFERENCE_ID.name, instanceProperties, "getReferenceId");
        }
        return null;
    }

    protected Map<String, String> removeMappingProperties(InstanceProperties instanceProperties) {
        String methodName = "removeMappingProperties";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringMapFromProperty(this.serviceName, OpenMetadataProperty.MAPPING_PROPERTIES.name, instanceProperties, "removeMappingProperties");
        }
        return null;
    }

    protected Date removeLastSynchronized(InstanceProperties instanceProperties) {
        String methodName = "removeLastSynchronized";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeDateProperty(this.serviceName, OpenMetadataProperty.LAST_SYNCHRONIZED.name, instanceProperties, "removeLastSynchronized");
        }
        return null;
    }

    protected String removeNetworkAddress(InstanceProperties instanceProperties) {
        String methodName = "removeNetworkAddress";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.NETWORK_ADDRESS.name, instanceProperties, "removeNetworkAddress");
        }
        return null;
    }

    protected String removeProtocol(InstanceProperties instanceProperties) {
        String methodName = "removeProtocol";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.PROTOCOL.name, instanceProperties, "removeProtocol");
        }
        return null;
    }

    protected String removeEncryptionMethod(InstanceProperties instanceProperties) {
        String methodName = "removeEncryptionMethod";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.ENCRYPTION_METHOD.name, instanceProperties, "removeEncryptionMethod");
        }
        return null;
    }

    protected String removeConnectorProviderClassName(InstanceProperties instanceProperties) {
        String methodName = "removeConnectorProviderClassName";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.CONNECTOR_PROVIDER_CLASS_NAME.name, instanceProperties, "removeConnectorProviderClassName");
        }
        return null;
    }

    protected String removeSupportedAssetTypeName(InstanceProperties instanceProperties) {
        String methodName = "removeSupportedAssetTypeName";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.SUPPORTED_ASSET_TYPE_NAME.name, instanceProperties, "removeSupportedAssetTypeName");
        }
        return null;
    }

    protected String removeExpectedDataFormat(InstanceProperties instanceProperties) {
        String methodName = "removeExpectedDataFormat";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.EXPECTED_DATA_FORMAT.name, instanceProperties, "removeExpectedDataFormat");
        }
        return null;
    }

    protected String removeConnectorFrameworkName(InstanceProperties instanceProperties) {
        String connectorFrameworkName;
        String methodName = "removeConnectorFrameworkName";
        if (instanceProperties != null && (connectorFrameworkName = this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.CONNECTOR_FRAMEWORK_NAME.name, instanceProperties, "removeConnectorFrameworkName")) != null) {
            return connectorFrameworkName;
        }
        return "Open Connector Framework (OCF)";
    }

    protected String removeConnectorInterfaceLanguage(InstanceProperties instanceProperties) {
        String connectorInterfaceLanguage;
        String methodName = "removeConnectorInterfaceLanguage";
        if (instanceProperties != null && (connectorInterfaceLanguage = this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.CONNECTOR_INTERFACE_LANGUAGE.name, instanceProperties, "removeConnectorInterfaceLanguage")) != null) {
            return connectorInterfaceLanguage;
        }
        return "Java";
    }

    protected List<String> removeConnectorInterfaces(InstanceProperties instanceProperties) {
        String methodName = "removeConnectorInterfaces";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringArrayProperty(this.serviceName, OpenMetadataProperty.CONNECTOR_INTERFACES.name, instanceProperties, "removeConnectorInterfaces");
        }
        return null;
    }

    protected String removeTargetTechnologySource(InstanceProperties instanceProperties) {
        String methodName = "removeTargetTechnologySource";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.TARGET_TECHNOLOGY_SOURCE.name, instanceProperties, "removeTargetTechnologySource");
        }
        return null;
    }

    protected String removeTargetTechnologyName(InstanceProperties instanceProperties) {
        String methodName = "removeTargetTechnologyName";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.TARGET_TECHNOLOGY_NAME.name, instanceProperties, "removeTargetTechnologyName");
        }
        return null;
    }

    protected List<String> removeTargetTechnologyInterfaces(InstanceProperties instanceProperties) {
        String methodName = "removeTargetTechnologyInterfaces";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringArrayProperty(this.serviceName, OpenMetadataProperty.TARGET_TECHNOLOGY_INTERFACES.name, instanceProperties, "removeTargetTechnologyInterfaces");
        }
        return null;
    }

    protected List<String> removeTargetTechnologyVersions(InstanceProperties instanceProperties) {
        String methodName = "removeTargetTechnologyVersions";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringArrayProperty(this.serviceName, OpenMetadataProperty.TARGET_TECHNOLOGY_VERSIONS.name, instanceProperties, "removeTargetTechnologyVersions");
        }
        return null;
    }

    protected List<String> removeRecognizedAdditionalProperties(InstanceProperties instanceProperties) {
        String methodName = "removeRecognizedAdditionalProperties";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringArrayProperty(this.serviceName, OpenMetadataProperty.RECOGNIZED_ADDITIONAL_PROPERTIES.name, instanceProperties, "removeRecognizedAdditionalProperties");
        }
        return null;
    }

    protected List<String> removeRecognizedSecuredProperties(InstanceProperties instanceProperties) {
        String methodName = "removeRecognizedSecuredProperties";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringArrayProperty(this.serviceName, OpenMetadataProperty.RECOGNIZED_SECURED_PROPERTIES.name, instanceProperties, "removeRecognizedSecuredProperties");
        }
        return null;
    }

    protected List<String> removeRecognizedConfigurationProperties(InstanceProperties instanceProperties) {
        String methodName = "removeRecognizedConfigurationProperties";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringArrayProperty(this.serviceName, OpenMetadataProperty.RECOGNIZED_CONFIGURATION_PROPERTIES.name, instanceProperties, "removeRecognizedConfigurationProperties");
        }
        return null;
    }

    protected Map<String, String> removeSecuredProperties(InstanceProperties instanceProperties) {
        String methodName = "removeSecuredProperties";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringMapFromProperty(this.serviceName, OpenMetadataProperty.SECURED_PROPERTIES.name, instanceProperties, "removeSecuredProperties");
        }
        return null;
    }

    protected Map<String, Object> removeConfigurationProperties(InstanceProperties instanceProperties) {
        String methodName = "removeConfigurationProperties";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeMapFromProperty(this.serviceName, OpenMetadataProperty.CONFIGURATION_PROPERTIES.name, instanceProperties, "removeConfigurationProperties");
        }
        return null;
    }

    protected String removeUserId(InstanceProperties instanceProperties) {
        String methodName = "removeUserId";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.USER_ID.name, instanceProperties, "removeUserId");
        }
        return null;
    }

    protected String removeClearPassword(InstanceProperties instanceProperties) {
        String methodName = "removeClearPassword";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.CLEAR_PASSWORD.name, instanceProperties, "removeClearPassword");
        }
        return null;
    }

    protected String removeEncryptedPassword(InstanceProperties instanceProperties) {
        String methodName = "removeEncryptedPassword";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.ENCRYPTED_PASSWORD.name, instanceProperties, "removeEncryptedPassword");
        }
        return null;
    }

    protected String getAssetSummary(InstanceProperties instanceProperties) {
        String methodName = "removeEncryptedPassword";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.ASSET_SUMMARY.name, instanceProperties, "removeEncryptedPassword");
        }
        return null;
    }

    protected Map<String, Object> getArguments(InstanceProperties instanceProperties) {
        String methodName = "getArguments";
        if (instanceProperties != null) {
            return this.repositoryHelper.getMapFromProperty(this.serviceName, OpenMetadataProperty.ARGUMENTS.name, instanceProperties, "getArguments");
        }
        return null;
    }

    protected String removeZoneName(InstanceProperties instanceProperties) {
        String methodName = "removeZoneName";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.ZONE_NAME.name, instanceProperties, "removeZoneName");
        }
        return null;
    }

    protected String removeSubjectAreaName(InstanceProperties instanceProperties) {
        String methodName = "removeSubjectAreaName";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.SUBJECT_AREA_NAME.name, instanceProperties, "removeSubjectAreaName");
        }
        return null;
    }

    protected String removeDistinguishedName(InstanceProperties instanceProperties) {
        String methodName = "removeDistinguishedName";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.DISTINGUISHED_NAME.name, instanceProperties, "removeDistinguishedName");
        }
        return null;
    }

    protected long removeKarmaPoints(InstanceProperties instanceProperties) {
        String methodName = "removeKarmaPoints";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeLongProperty(this.serviceName, OpenMetadataProperty.KARMA_POINTS.name, instanceProperties, "removeKarmaPoints");
        }
        return 0L;
    }

    protected Date removeResourceCreateTime(InstanceProperties instanceProperties) {
        String methodName = "removeResourceCreateTime";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeDateProperty(this.serviceName, OpenMetadataProperty.RESOURCE_CREATE_TIME.name, instanceProperties, "removeResourceCreateTime");
        }
        return null;
    }

    protected Date removeResourceUpdateTime(InstanceProperties instanceProperties) {
        String methodName = "removeResourceUpdateTime";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeDateProperty(this.serviceName, OpenMetadataProperty.RESOURCE_UPDATE_TIME.name, instanceProperties, "removeResourceUpdateTime");
        }
        return null;
    }

    protected Date removeResourceLastAccessedTime(InstanceProperties instanceProperties) {
        String methodName = "removeResourceLastAccessedTime";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeDateProperty(this.serviceName, OpenMetadataProperty.RESOURCE_LAST_ACCESSED_TIME.name, instanceProperties, "removeResourceLastAccessedTime");
        }
        return null;
    }

    protected String removePathName(InstanceProperties instanceProperties) {
        String methodName = "removePathName";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.PATH_NAME.name, instanceProperties, "removePathName");
        }
        return null;
    }

    protected Date removeStoreCreateTime(InstanceProperties instanceProperties) {
        String methodName = "removeStoreCreateTime";
        if (instanceProperties != null) {
            Date createTime1 = this.repositoryHelper.removeDateProperty(this.serviceName, OpenMetadataProperty.STORE_CREATE_TIME.name, instanceProperties, "removeStoreCreateTime");
            Date createTime2 = this.repositoryHelper.removeDateProperty(this.serviceName, OpenMetadataProperty.CREATE_TIME.name, instanceProperties, "removeStoreCreateTime");
            return createTime1 == null ? createTime2 : createTime1;
        }
        return null;
    }

    protected Date removeStoreUpdateTime(InstanceProperties instanceProperties) {
        String methodName = "removeStoreUpdateTime";
        if (instanceProperties != null) {
            Date modifiedTime1 = this.repositoryHelper.removeDateProperty(this.serviceName, OpenMetadataProperty.STORE_UPDATE_TIME.name, instanceProperties, "removeStoreUpdateTime");
            Date modifiedTime2 = this.repositoryHelper.removeDateProperty(this.serviceName, OpenMetadataProperty.UPDATE_TIME.name, instanceProperties, "removeStoreUpdateTime");
            return modifiedTime1 == null ? modifiedTime2 : modifiedTime1;
        }
        return null;
    }

    protected String getDataStoreEncodingType(InstanceProperties instanceProperties) {
        String methodName = "getDataStoreEncodingType";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.ENCODING.name, instanceProperties, "getDataStoreEncodingType");
        }
        return null;
    }

    protected String getDataStoreEncodingLanguage(InstanceProperties instanceProperties) {
        String methodName = "getDataStoreEncodingLanguage";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.ENCODING_LANGUAGE.name, instanceProperties, "getDataStoreEncodingLanguage");
        }
        return null;
    }

    protected String getDataStoreEncodingDescription(InstanceProperties instanceProperties) {
        String methodName = "getDataStoreEncodingDescription";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.ENCODING_DESCRIPTION.name, instanceProperties, "getDataStoreEncodingDescription");
        }
        return null;
    }

    protected Map<String, String> getEncodingProperties(InstanceProperties instanceProperties) {
        String methodName = "getEncodingProperties";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringMapFromProperty(this.serviceName, OpenMetadataProperty.ENCODING_PROPERTIES.name, instanceProperties, "getEncodingProperties");
        }
        return null;
    }

    protected String removeDatabaseVersion(InstanceProperties instanceProperties) {
        String methodName = "removeDatabaseVersion";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.DATABASE_VERSION.name, instanceProperties, "removeDatabaseVersion");
        }
        return null;
    }

    protected String removeDatabaseInstance(InstanceProperties instanceProperties) {
        String methodName = "removeDatabaseInstance";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.INSTANCE.name, instanceProperties, "removeDatabaseInstance");
        }
        return null;
    }

    protected String removeDatabaseImportedFrom(InstanceProperties instanceProperties) {
        String methodName = "removeDatabaseImportedFrom";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.IMPORTED_FROM.name, instanceProperties, "removeDatabaseImportedFrom");
        }
        return null;
    }

    protected String removeFileName(InstanceProperties instanceProperties) {
        String methodName = "removeFileName";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.FILE_NAME.name, instanceProperties, "removeFileName");
        }
        return null;
    }

    protected String removeFileType(InstanceProperties instanceProperties) {
        String methodName = "removeFileType";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.FILE_TYPE.name, instanceProperties, "removeFileType");
        }
        return null;
    }

    protected String removeFileExtension(InstanceProperties instanceProperties) {
        String methodName = "removeFileExtension";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.FILE_EXTENSION.name, instanceProperties, "removeFileExtension");
        }
        return null;
    }

    protected String getFormat(InstanceProperties instanceProperties) {
        String methodName = "getFormat";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.FORMAT.name, instanceProperties, "getFormat");
        }
        return null;
    }

    protected String getEncryption(InstanceProperties instanceProperties) {
        String methodName = "getEncryption";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.ENCRYPTION.name, instanceProperties, "getEncryption");
        }
        return null;
    }

    protected String removeDeployedImplementationType(InstanceProperties instanceProperties) {
        String methodName = "removeDeployedImplementationType";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, instanceProperties, "removeDeployedImplementationType");
        }
        return null;
    }

    protected String removeSupportedDeployedImplementationType(InstanceProperties instanceProperties) {
        String methodName = "removeDeployedImplementationType";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.SUPPORTED_DEPLOYED_IMPLEMENTATION_TYPE.name, instanceProperties, "removeDeployedImplementationType");
        }
        return null;
    }

    protected String removeCapabilityType(InstanceProperties instanceProperties) {
        String methodName = "removeCapabilityType";
        if (instanceProperties != null) {
            String type = this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, instanceProperties, "removeCapabilityType");
            if (type == null) {
                type = this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.CAPABILITY_TYPE.name, instanceProperties, "removeCapabilityType");
            }
            return type;
        }
        return null;
    }

    protected String removeCapabilityVersion(InstanceProperties instanceProperties) {
        String methodName = "removeCapabilityVersion";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.CAPABILITY_VERSION.name, instanceProperties, "removeCapabilityVersion");
        }
        return null;
    }

    protected String removePatchLevel(InstanceProperties instanceProperties) {
        String methodName = "removePatchLevel";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.PATCH_LEVEL.name, instanceProperties, "removePatchLevel");
        }
        return null;
    }

    protected boolean removeIsDeprecated(InstanceProperties instanceProperties) {
        String methodName = "removeIsDeprecated";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeBooleanProperty(this.serviceName, OpenMetadataProperty.IS_DEPRECATED.name, instanceProperties, "removeIsDeprecated");
        }
        return false;
    }

    protected boolean removeIsDefaultValue(InstanceProperties instanceProperties) {
        String methodName = "removeIsDefaultValue";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeBooleanProperty(this.serviceName, OpenMetadataProperty.IS_DEFAULT_VALUE.name, instanceProperties, "removeIsDefaultValue");
        }
        return false;
    }

    protected String removeDataType(InstanceProperties instanceProperties) {
        String methodName = "removeDataType";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.DATA_TYPE.name, instanceProperties, "removeDataType");
        }
        return null;
    }

    protected String removeDefaultValue(InstanceProperties instanceProperties) {
        String methodName = "removeDefaultValue";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.DEFAULT_VALUE.name, instanceProperties, "removeDefaultValue");
        }
        return null;
    }

    protected String removeFixedValue(InstanceProperties instanceProperties) {
        String methodName = "removeFixedValue";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.FIXED_VALUE.name, instanceProperties, "removeFixedValue");
        }
        return null;
    }

    protected String getQuery(InstanceProperties instanceProperties) {
        String methodName = "setQuery";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.QUERY.name, instanceProperties, "setQuery");
        }
        return null;
    }

    protected String getQueryId(InstanceProperties instanceProperties) {
        String methodName = "setQueryId";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.QUERY_ID.name, instanceProperties, "setQueryId");
        }
        return null;
    }

    protected String removeVersionNumber(InstanceProperties instanceProperties) {
        String methodName = "removeVersionNumber";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.VERSION_NUMBER.name, instanceProperties, "removeVersionNumber");
        }
        return null;
    }

    protected String removeId(InstanceProperties instanceProperties) {
        String methodName = "removeId";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.ID.name, instanceProperties, "removeId");
        }
        return null;
    }

    protected Date removeCreatedTime(InstanceProperties instanceProperties) {
        String methodName = "removeCreatedTime";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeDateProperty(this.serviceName, OpenMetadataProperty.CREATED_TIME.name, instanceProperties, "removeCreatedTime");
        }
        return null;
    }

    protected Date removeLastModifiedTime(InstanceProperties instanceProperties) {
        String methodName = "removeLastModifiedTime";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeDateProperty(this.serviceName, OpenMetadataProperty.LAST_MODIFIED_TIME.name, instanceProperties, "removeLastModifiedTime");
        }
        return null;
    }

    protected String removeLastModifier(InstanceProperties instanceProperties) {
        String methodName = "removeId";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.LAST_MODIFIER.name, instanceProperties, "removeId");
        }
        return null;
    }

    protected String removeAuthor(InstanceProperties instanceProperties) {
        String methodName = "removeAuthor";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.AUTHOR.name, instanceProperties, "removeAuthor");
        }
        return null;
    }

    protected String removeEncodingStandard(InstanceProperties instanceProperties) {
        String methodName = "removeEncodingStandard";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.ENCODING_STANDARD.name, instanceProperties, "removeEncodingStandard");
        }
        return null;
    }

    protected String removeNamespace(InstanceProperties instanceProperties) {
        String methodName = "removeNamespace";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.NAMESPACE.name, instanceProperties, "removeNamespace");
        }
        return null;
    }

    protected int removePosition(InstanceProperties instanceProperties) {
        String methodName = "removePosition";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeIntProperty(this.serviceName, OpenMetadataProperty.POSITION.name, instanceProperties, "removePosition");
        }
        return 0;
    }

    protected int getPosition(InstanceProperties instanceProperties) {
        String methodName = "getPosition";
        if (instanceProperties != null) {
            return this.repositoryHelper.getIntProperty(this.serviceName, OpenMetadataProperty.POSITION.name, instanceProperties, "getPosition");
        }
        return 0;
    }

    protected int removeMinCardinality(InstanceProperties instanceProperties) {
        String methodName = "removeMinCardinality";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeIntProperty(this.serviceName, OpenMetadataProperty.MIN_CARDINALITY.name, instanceProperties, "removeMinCardinality");
        }
        return 0;
    }

    protected int getMinCardinality(InstanceProperties instanceProperties) {
        String methodName = "getMinCardinality";
        if (instanceProperties != null) {
            return this.repositoryHelper.getIntProperty(this.serviceName, OpenMetadataProperty.MIN_CARDINALITY.name, instanceProperties, "getMinCardinality");
        }
        return 0;
    }

    protected int removeMaxCardinality(InstanceProperties instanceProperties) {
        String methodName = "removeMaxCardinality";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeIntProperty(this.serviceName, OpenMetadataProperty.MAX_CARDINALITY.name, instanceProperties, "removeMaxCardinality");
        }
        return -1;
    }

    protected int getMaxCardinality(InstanceProperties instanceProperties) {
        String methodName = "getMaxCardinality";
        if (instanceProperties != null) {
            return this.repositoryHelper.getIntProperty(this.serviceName, OpenMetadataProperty.MAX_CARDINALITY.name, instanceProperties, "getMaxCardinality");
        }
        return -1;
    }

    protected boolean removeAllowsDuplicateValues(InstanceProperties instanceProperties) {
        String methodName = "removeAllowsDuplicateValues";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeBooleanProperty(this.serviceName, OpenMetadataProperty.ALLOWS_DUPLICATE_VALUES.name, instanceProperties, "removeAllowsDuplicateValues");
        }
        return true;
    }

    protected boolean removeOrderedValues(InstanceProperties instanceProperties) {
        String methodName = "removeOrderedValues";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeBooleanProperty(this.serviceName, OpenMetadataProperty.ORDERED_VALUES.name, instanceProperties, "removeOrderedValues");
        }
        return false;
    }

    protected String removeDefaultValueOverride(InstanceProperties instanceProperties) {
        String methodName = "removeDefaultValueOverride";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.DEFAULT_VALUE_OVERRIDE.name, instanceProperties, "removeDefaultValueOverride");
        }
        return null;
    }

    protected int removeMinimumLength(InstanceProperties instanceProperties) {
        String methodName = "removeMinimumLength";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeIntProperty(this.serviceName, OpenMetadataProperty.MINIMUM_LENGTH.name, instanceProperties, "removeMinimumLength");
        }
        return 0;
    }

    protected int removeLength(InstanceProperties instanceProperties) {
        String methodName = "removeLength";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeIntProperty(this.serviceName, OpenMetadataProperty.LENGTH.name, instanceProperties, "removeLength");
        }
        return 0;
    }

    protected int removePrecision(InstanceProperties instanceProperties) {
        String methodName = "removePrecision";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeIntProperty(this.serviceName, OpenMetadataProperty.PRECISION.name, instanceProperties, "removePrecision");
        }
        return 0;
    }

    protected boolean removeIsNullable(InstanceProperties instanceProperties) {
        String methodName = "removeIsNullable";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeBooleanProperty(this.serviceName, OpenMetadataProperty.IS_NULLABLE.name, instanceProperties, "removeIsNullable");
        }
        return false;
    }

    protected boolean removeRequired(InstanceProperties instanceProperties) {
        String methodName = "removeRequired";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeBooleanProperty(this.serviceName, OpenMetadataProperty.REQUIRED.name, instanceProperties, "removeRequired");
        }
        return false;
    }

    protected String removeNativeClass(InstanceProperties instanceProperties) {
        String methodName = "removeNativeClass";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.NATIVE_CLASS.name, instanceProperties, "removeNativeClass");
        }
        return null;
    }

    protected List<String> removeAliases(InstanceProperties instanceProperties) {
        String methodName = "removeAliases";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringArrayProperty(this.serviceName, OpenMetadataProperty.ALIASES.name, instanceProperties, "removeAliases");
        }
        return null;
    }

    protected String getGuard(InstanceProperties instanceProperties) {
        String methodName = "getGuard";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.GUARD.name, instanceProperties, "getGuard");
        }
        return null;
    }

    protected String getISCQualifiedName(InstanceProperties instanceProperties) {
        String methodName = "getISCQualifiedName";
        if (instanceProperties != null) {
            String iscQualifiedName = this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.ISC_QUALIFIED_NAME.name, instanceProperties, "getISCQualifiedName");
            if (iscQualifiedName != null) {
                return iscQualifiedName;
            }
            return this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.QUALIFIED_NAME.name, instanceProperties, "getISCQualifiedName");
        }
        return null;
    }

    protected String getLabel(InstanceProperties instanceProperties) {
        String methodName = "getLabel";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.LABEL.name, instanceProperties, "getLabel");
        }
        return null;
    }

    protected String getFormula(InstanceProperties instanceProperties) {
        String methodName = "getFormula";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.FORMULA.name, instanceProperties, "getFormula");
        }
        return null;
    }

    protected String getFormulaType(InstanceProperties instanceProperties) {
        String methodName = "getFormulaType";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.FORMULA_TYPE.name, instanceProperties, "getFormulaType");
        }
        return null;
    }

    protected String removeFormula(InstanceProperties instanceProperties) {
        String methodName = "removeFormula";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.FORMULA.name, instanceProperties, "removeFormula");
        }
        return null;
    }

    protected String removeFormulaType(InstanceProperties instanceProperties) {
        String methodName = "removeFormulaType";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.FORMULA_TYPE.name, instanceProperties, "removeFormulaType");
        }
        return null;
    }

    protected String removeImplementationLanguage(InstanceProperties instanceProperties) {
        String methodName = "removeImplementationLanguage";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.IMPLEMENTATION_LANGUAGE.name, instanceProperties, "removeImplementationLanguage");
        }
        return null;
    }

    protected Date removeProcessStartTime(InstanceProperties instanceProperties) {
        String methodName = "removeProcessStartTime";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeDateProperty(this.serviceName, OpenMetadataProperty.PROCESS_START_TIME.name, instanceProperties, "removeProcessStartTime");
        }
        return null;
    }

    protected Date removeProcessEndTime(InstanceProperties instanceProperties) {
        String methodName = "removeProcessEndTime";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeDateProperty(this.serviceName, OpenMetadataProperty.PROCESS_END_TIME.name, instanceProperties, "removeProcessEndTime");
        }
        return null;
    }

    protected boolean removeUsesBlockingCalls(InstanceProperties instanceProperties) {
        String methodName = "removeUsesBlockingCalls";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeBooleanProperty(this.serviceName, OpenMetadataProperty.USES_BLOCKING_CALLS.name, instanceProperties, "removeUsesBlockingCalls");
        }
        return false;
    }

    protected String removeSource(InstanceProperties instanceProperties) {
        String methodName = "removeSource";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.SOURCE.name, instanceProperties, "removeSource");
        }
        return null;
    }

    protected String getUsage(InstanceProperties instanceProperties) {
        String methodName = "getUsage";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.USAGE.name, instanceProperties, "getUsage");
        }
        return null;
    }

    protected String removeUsage(InstanceProperties instanceProperties) {
        String methodName = "removeUsage";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.USAGE.name, instanceProperties, "removeUsage");
        }
        return null;
    }

    protected String removeLanguage(InstanceProperties instanceProperties) {
        String methodName = "removeLanguage";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.LANGUAGE.name, instanceProperties, "removeLanguage");
        }
        return null;
    }

    protected String getSummary(InstanceProperties instanceProperties) {
        String methodName = "getSummary";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.SUMMARY.name, instanceProperties, "getSummary");
        }
        return null;
    }

    protected String removeSummary(InstanceProperties instanceProperties) {
        String methodName = "removeSummary";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.SUMMARY.name, instanceProperties, "removeSummary");
        }
        return null;
    }

    protected String removePublishVersionIdentifier(InstanceProperties instanceProperties) {
        String methodName = "removePublishVersionIdentifier";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.PUBLISH_VERSION_ID.name, instanceProperties, "removePublishVersionIdentifier");
        }
        return null;
    }

    protected String getAbbreviation(InstanceProperties instanceProperties) {
        String methodName = "getAbbreviation";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.ABBREVIATION.name, instanceProperties, "getAbbreviation");
        }
        return null;
    }

    protected String removeAbbreviation(InstanceProperties instanceProperties) {
        String methodName = "removeAbbreviation";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.ABBREVIATION.name, instanceProperties, "removeAbbreviation");
        }
        return null;
    }

    protected String removeExamples(InstanceProperties instanceProperties) {
        String methodName = "removeExamples";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.EXAMPLES.name, instanceProperties, "removeExamples");
        }
        return null;
    }

    protected String removeTitle(InstanceProperties instanceProperties) {
        String methodName = "removeTitle";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.TITLE.name, instanceProperties, "removeTitle");
        }
        return null;
    }

    protected String removeText(InstanceProperties instanceProperties) {
        String methodName = "removeText";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.TEXT.name, instanceProperties, "removeText");
        }
        return null;
    }

    protected String removeImportance(InstanceProperties instanceProperties) {
        String methodName = "removeImportance";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.IMPORTANCE.name, instanceProperties, "removeImportance");
        }
        return null;
    }

    protected int removeIntPriority(InstanceProperties instanceProperties) {
        String methodName = "removeIntPriority";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeIntProperty(this.serviceName, OpenMetadataProperty.PRIORITY.name, instanceProperties, "removeIntPriority");
        }
        return 0;
    }

    protected int removeHeadCount(InstanceProperties instanceProperties) {
        String methodName = "removeHeadCount";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeIntProperty(this.serviceName, OpenMetadataProperty.HEAD_COUNT.name, instanceProperties, "removeHeadCount");
        }
        return 0;
    }

    protected String removeScope(InstanceProperties instanceProperties) {
        String methodName = "removeScope";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.SCOPE.name, instanceProperties, "removeScope");
        }
        return null;
    }

    protected String removeCategory(InstanceProperties instanceProperties) {
        String methodName = "removeCategory";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.CATEGORY.name, instanceProperties, "removeCategory");
        }
        return null;
    }

    protected List<String> removeOutcomes(InstanceProperties instanceProperties) {
        String methodName = "removeOutcomes";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringArrayProperty(this.serviceName, OpenMetadataProperty.OUTCOMES.name, instanceProperties, "removeOutcomes");
        }
        return null;
    }

    protected List<String> removeImplications(InstanceProperties instanceProperties) {
        String methodName = "removeImplications";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringArrayProperty(this.serviceName, OpenMetadataProperty.IMPLICATIONS.name, instanceProperties, "removeImplications");
        }
        return null;
    }

    protected List<String> removeResults(InstanceProperties instanceProperties) {
        String methodName = "removeResults";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringArrayProperty(this.serviceName, OpenMetadataProperty.RESULTS.name, instanceProperties, "removeResults");
        }
        return null;
    }

    protected String removeDetails(InstanceProperties instanceProperties) {
        String methodName = "removeDetails";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.DETAILS.name, instanceProperties, "removeDetails");
        }
        return null;
    }

    protected String removeCriteria(InstanceProperties instanceProperties) {
        String methodName = "removeCriteria";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.CRITERIA.name, instanceProperties, "removeCriteria");
        }
        return null;
    }

    protected int removeDomainIdentifier(InstanceProperties instanceProperties) {
        String methodName = "removeDomainIdentifier";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeIntProperty(this.serviceName, OpenMetadataProperty.DOMAIN_IDENTIFIER.name, instanceProperties, "removeDomainIdentifier");
        }
        return 0;
    }

    protected String removeMeasurement(InstanceProperties instanceProperties) {
        String methodName = "removeMeasurement";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.MEASUREMENT.name, instanceProperties, "removeMeasurement");
        }
        return null;
    }

    protected String removeTarget(InstanceProperties instanceProperties) {
        String methodName = "removeTarget";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.TARGET.name, instanceProperties, "removeTarget");
        }
        return null;
    }

    protected String removeProcessingEngineUserId(InstanceProperties instanceProperties) {
        String methodName = "removeProcessingEngineUserId";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.PROCESSING_ENGINE_USER_ID.name, instanceProperties, "removeProcessingEngineUserId");
        }
        return null;
    }

    protected String removeRequesterUserId(InstanceProperties instanceProperties) {
        String methodName = "removeRequesterUserId";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.REQUESTER_USER_ID.name, instanceProperties, "removeRequesterUserId");
        }
        return null;
    }

    protected String removeRequestType(InstanceProperties instanceProperties) {
        String methodName = "removeRequestType";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.REQUEST_TYPE.name, instanceProperties, "removeRequestType");
        }
        return null;
    }

    protected Map<String, String> removeRequestParameters(InstanceProperties instanceProperties) {
        String methodName = "removeRequestParameters";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringMapFromProperty(this.serviceName, OpenMetadataProperty.REQUEST_PARAMETERS.name, instanceProperties, "removeRequestParameters");
        }
        return null;
    }

    protected String removeExecutorEngineGUID(InstanceProperties instanceProperties) {
        String methodName = "removeExecutorEngineGUID";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.EXECUTOR_ENGINE_GUID.name, instanceProperties, "removeExecutorEngineGUID");
        }
        return null;
    }

    protected String removeExecutorEngineName(InstanceProperties instanceProperties) {
        String methodName = "removeExecutorEngineName";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.EXECUTOR_ENGINE_NAME.name, instanceProperties, "removeExecutorEngineName");
        }
        return null;
    }

    protected String removeProcessName(InstanceProperties instanceProperties) {
        String methodName = "removeProcessName";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.PROCESS_NAME.name, instanceProperties, "removeProcessName");
        }
        return null;
    }

    protected String removeProcessStepGUID(InstanceProperties instanceProperties) {
        String methodName = "removeProcessStepGUID";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.PROCESS_STEP_GUID.name, instanceProperties, "removeProcessStepGUID");
        }
        return null;
    }

    protected String removeProcessStepName(InstanceProperties instanceProperties) {
        String methodName = "removeProcessStepName";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.PROCESS_STEP_NAME.name, instanceProperties, "removeProcessStepName");
        }
        return null;
    }

    protected String removeGovernanceActionTypeGUID(InstanceProperties instanceProperties) {
        String methodName = "removeGovernanceActionTypeGUID";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.GOVERNANCE_ACTION_TYPE_GUID.name, instanceProperties, "removeGovernanceActionTypeGUID");
        }
        return null;
    }

    protected String removeGovernanceActionTypeName(InstanceProperties instanceProperties) {
        String methodName = "removeGovernanceActionTypeName";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.GOVERNANCE_ACTION_TYPE_NAME.name, instanceProperties, "removeGovernanceActionTypeName");
        }
        return null;
    }

    protected String removeGuard(InstanceProperties instanceProperties) {
        String methodName = "removeGuard";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.GUARD.name, instanceProperties, "removeGuard");
        }
        return null;
    }

    protected List<String> removeMandatoryGuards(InstanceProperties instanceProperties) {
        String methodName = "removeMandatoryGuards";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringArrayProperty(this.serviceName, OpenMetadataProperty.MANDATORY_GUARDS.name, instanceProperties, "removeMandatoryGuards");
        }
        return null;
    }

    protected boolean removeMandatoryGuard(InstanceProperties instanceProperties) {
        String methodName = "removeMandatoryGuard";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeBooleanProperty(this.serviceName, OpenMetadataProperty.MANDATORY_GUARD.name, instanceProperties, "removeMandatoryGuard");
        }
        return false;
    }

    protected boolean removeIgnoreMultipleTriggers(InstanceProperties instanceProperties) {
        String methodName = "removeIgnoreMultipleTriggers";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeBooleanProperty(this.serviceName, OpenMetadataProperty.IGNORE_MULTIPLE_TRIGGERS.name, instanceProperties, "removeIgnoreMultipleTriggers");
        }
        return false;
    }

    protected int removeWaitTime(InstanceProperties instanceProperties) {
        String methodName = "removeWaitTime";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeIntProperty(this.serviceName, OpenMetadataProperty.WAIT_TIME.name, instanceProperties, "removeWaitTime");
        }
        return 0;
    }

    protected List<String> removeReceivedGuards(InstanceProperties instanceProperties) {
        String methodName = "removeReceivedGuards";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringArrayProperty(this.serviceName, OpenMetadataProperty.RECEIVED_GUARDS.name, instanceProperties, "removeReceivedGuards");
        }
        return null;
    }

    protected List<String> removeCompletionGuards(InstanceProperties instanceProperties) {
        String methodName = "removeCompletionGuards";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringArrayProperty(this.serviceName, OpenMetadataProperty.COMPLETION_GUARDS.name, instanceProperties, "removeCompletionGuards");
        }
        return null;
    }

    protected String removeCompletionMessage(InstanceProperties instanceProperties) {
        String methodName = "removeCompletionMessage";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.COMPLETION_MESSAGE.name, instanceProperties, "removeCompletionMessage");
        }
        return null;
    }

    protected Date removeStartDate(InstanceProperties instanceProperties) {
        String methodName = "removeStartDate";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeDateProperty(this.serviceName, OpenMetadataProperty.START_DATE.name, instanceProperties, "removeStartDate");
        }
        return null;
    }

    protected Date removeRequestedStartDate(InstanceProperties instanceProperties) {
        String methodName = "removeRequestedStartDate";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeDateProperty(this.serviceName, OpenMetadataProperty.REQUESTED_START_DATE.name, instanceProperties, "removeRequestedStartDate");
        }
        return null;
    }

    protected Date removePlannedEndDate(InstanceProperties instanceProperties) {
        String methodName = "removePlannedEndDate";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeDateProperty(this.serviceName, OpenMetadataProperty.PLANNED_END_DATE.name, instanceProperties, "removePlannedEndDate");
        }
        return null;
    }

    protected Date removeCompletionDate(InstanceProperties instanceProperties) {
        String methodName = "removeCompletionDate";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeDateProperty(this.serviceName, OpenMetadataProperty.COMPLETION_DATE.name, instanceProperties, "removeCompletionDate");
        }
        return null;
    }

    protected String removeProjectStatus(InstanceProperties instanceProperties) {
        String methodName = "removeProjectStatus";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.PROJECT_STATUS.name, instanceProperties, "removeProjectStatus");
        }
        return null;
    }

    protected String removeProjectPhase(InstanceProperties instanceProperties) {
        String methodName = "removeProjectPhase";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.PROJECT_PHASE.name, instanceProperties, "removeProjectPhase");
        }
        return null;
    }

    protected String removeProjectHealth(InstanceProperties instanceProperties) {
        String methodName = "removeProjectHealth";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.PROJECT_HEALTH.name, instanceProperties, "removeProjectHealth");
        }
        return null;
    }

    protected String removeRequestSourceName(InstanceProperties instanceProperties) {
        String methodName = "removeRequestSourceName";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.REQUEST_SOURCE_NAME.name, instanceProperties, "removeRequestSourceName");
        }
        return null;
    }

    protected String removeActionTargetName(InstanceProperties instanceProperties) {
        String methodName = "removeActionTargetName";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.ACTION_TARGET_NAME.name, instanceProperties, "removeActionTargetName");
        }
        return null;
    }

    protected String removeOriginGovernanceService(InstanceProperties instanceProperties) {
        String methodName = "removeOriginGovernanceService";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.ORIGIN_GOVERNANCE_SERVICE.name, instanceProperties, "removeOriginGovernanceService");
        }
        return null;
    }

    protected String removeOriginGovernanceEngine(InstanceProperties instanceProperties) {
        String methodName = "removeOriginGovernanceEngine";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.ORIGIN_GOVERNANCE_ENGINE.name, instanceProperties, "removeOriginGovernanceEngine");
        }
        return null;
    }

    protected String getCertificationGUID(InstanceProperties instanceProperties) {
        String methodName = "getCertificationGUID";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.CERTIFICATE_GUID.name, instanceProperties, "getCertificationGUID");
        }
        return null;
    }

    protected Date getStart(InstanceProperties instanceProperties) {
        String methodName = "getStart";
        if (instanceProperties != null) {
            return this.repositoryHelper.getDateProperty(this.serviceName, OpenMetadataProperty.START.name, instanceProperties, "getStart");
        }
        return null;
    }

    protected Date getEnd(InstanceProperties instanceProperties) {
        String methodName = "getEnd";
        if (instanceProperties != null) {
            return this.repositoryHelper.getDateProperty(this.serviceName, OpenMetadataProperty.END.name, instanceProperties, "getEnd");
        }
        return null;
    }

    protected String getConditions(InstanceProperties instanceProperties) {
        String methodName = "getConditions";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.CONDITIONS.name, instanceProperties, "getConditions");
        }
        return null;
    }

    protected String getCustodian(InstanceProperties instanceProperties) {
        String methodName = "getCustodian";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.CUSTODIAN.name, instanceProperties, "getCustodian");
        }
        return null;
    }

    protected String getCertifiedBy(InstanceProperties instanceProperties) {
        String methodName = "getCertifiedBy";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.CERTIFIED_BY.name, instanceProperties, "getCertifiedBy");
        }
        return null;
    }

    protected String getRecipient(InstanceProperties instanceProperties) {
        String methodName = "getRecipient";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.RECIPIENT.name, instanceProperties, "getRecipient");
        }
        return null;
    }

    protected String getLicensedBy(InstanceProperties instanceProperties) {
        String methodName = "getLicensedBy";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.LICENSED_BY.name, instanceProperties, "getLicensedBy");
        }
        return null;
    }

    protected String getLicensee(InstanceProperties instanceProperties) {
        String methodName = "getLicensee";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.LICENSEE.name, instanceProperties, "getLicensee");
        }
        return null;
    }

    protected String removePreferredValue(InstanceProperties instanceProperties) {
        String methodName = "removePreferredValue";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.PREFERRED_VALUE.name, instanceProperties, "removePreferredValue");
        }
        return null;
    }

    protected boolean removeIsCaseSensitive(InstanceProperties instanceProperties) {
        String methodName = "removeIsCaseSensitive";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeBooleanProperty(this.serviceName, OpenMetadataProperty.IS_CASE_SENSITIVE.name, instanceProperties, "removeIsCaseSensitive");
        }
        return false;
    }

    protected boolean getStrictRequirement(InstanceProperties instanceProperties) {
        String methodName = "getStrictRequirement";
        if (instanceProperties != null) {
            return this.repositoryHelper.getBooleanProperty(this.serviceName, OpenMetadataProperty.STRICT_REQUIREMENT.name, instanceProperties, "getStrictRequirement");
        }
        return false;
    }

    protected int getConfidence(InstanceProperties instanceProperties) {
        String methodName = "getConfidence";
        if (instanceProperties != null) {
            return this.repositoryHelper.getIntProperty(this.serviceName, OpenMetadataProperty.CONFIDENCE.name, instanceProperties, "getConfidence");
        }
        return 0;
    }

    protected String getSteward(InstanceProperties instanceProperties) {
        String methodName = "getSteward";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.STEWARD.name, instanceProperties, "getSteward");
        }
        return null;
    }

    protected String getStewardTypeName(InstanceProperties instanceProperties) {
        String methodName = "getStewardTypeName";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.STEWARD_TYPE_NAME.name, instanceProperties, "getStewardTypeName");
        }
        return null;
    }

    protected String getStewardPropertyName(InstanceProperties instanceProperties) {
        String methodName = "getStewardPropertyName";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.STEWARD_PROPERTY_NAME.name, instanceProperties, "getStewardPropertyName");
        }
        return null;
    }

    protected String getNotes(InstanceProperties instanceProperties) {
        String methodName = "getNotes";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.NOTES.name, instanceProperties, "getNotes");
        }
        return null;
    }

    protected String getAttributeName(InstanceProperties instanceProperties) {
        String methodName = "getAttributeName";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.ATTRIBUTE_NAME.name, instanceProperties, "getAttributeName");
        }
        return null;
    }

    protected String getAssociationDescription(InstanceProperties instanceProperties) {
        String methodName = "getAssociationDescription";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.ASSOCIATION_DESCRIPTION.name, instanceProperties, "getAssociationDescription");
        }
        return null;
    }

    protected String getSymbolicName(InstanceProperties instanceProperties) {
        String methodName = "getSymbolicName";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.SYMBOLIC_NAME.name, instanceProperties, "getSymbolicName");
        }
        return null;
    }

    protected String getImplementationValue(InstanceProperties instanceProperties) {
        String methodName = "getImplementationValue";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.IMPLEMENTATION_VALUE.name, instanceProperties, "getImplementationValue");
        }
        return null;
    }

    protected Map<String, String> getAdditionalValues(InstanceProperties instanceProperties) {
        String methodName = "getAdditionalValues";
        if (instanceProperties != null) {
            return this.repositoryHelper.getStringMapFromProperty(this.serviceName, OpenMetadataProperty.ADDITIONAL_VALUES.name, instanceProperties, "getAdditionalValues");
        }
        return null;
    }

    protected String removeCommentText(InstanceProperties instanceProperties) {
        String methodName = "removeCommentText";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.TEXT.name, instanceProperties, "removeCommentText");
        }
        return null;
    }

    protected boolean getIsPublic(InstanceProperties instanceProperties) {
        String methodName = "getIsPublic";
        if (instanceProperties != null) {
            return this.repositoryHelper.getBooleanProperty(this.serviceName, OpenMetadataProperty.IS_PUBLIC.name, instanceProperties, "getIsPublic");
        }
        return false;
    }

    protected boolean removeIsPublic(InstanceProperties instanceProperties) {
        String methodName = "removeIsPublic";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeBooleanProperty(this.serviceName, OpenMetadataProperty.IS_PUBLIC.name, instanceProperties, "removeIsPublic");
        }
        return false;
    }

    protected String removeReview(InstanceProperties instanceProperties) {
        String methodName = "removeReview";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.REVIEW.name, instanceProperties, "removeReview");
        }
        return null;
    }

    protected String removeTagName(InstanceProperties instanceProperties) {
        String methodName = "removeTagName";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.TAG_NAME.name, instanceProperties, "removeTagName");
        }
        return null;
    }

    protected String removeTagDescription(InstanceProperties instanceProperties) {
        String methodName = "removeTagDescription";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.TAG_DESCRIPTION.name, instanceProperties, "removeTagDescription");
        }
        return null;
    }

    protected Map<String, String> removeAnalysisParameters(InstanceProperties instanceProperties) {
        String methodName = "removeAnalysisParameters";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringMapFromProperty(this.serviceName, OpenMetadataProperty.ANALYSIS_PARAMETERS.name, instanceProperties, "removeAnalysisParameters");
        }
        return null;
    }

    protected String removeAnalysisStep(InstanceProperties instanceProperties) {
        String methodName = "removeAnalysisStep";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.ANALYSIS_STEP.name, instanceProperties, "removeAnalysisStep");
        }
        return null;
    }

    protected String removeAnnotationType(InstanceProperties instanceProperties) {
        String methodName = "removeAnnotationType";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.ANNOTATION_TYPE.name, instanceProperties, "removeAnnotationType");
        }
        return null;
    }

    protected int removeConfidenceLevel(InstanceProperties instanceProperties) {
        String methodName = "removeConfidenceLevel";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeIntProperty(this.serviceName, OpenMetadataProperty.CONFIDENCE_LEVEL.name, instanceProperties, "removeConfidenceLevel");
        }
        return 0;
    }

    protected int removeConfidence(InstanceProperties instanceProperties) {
        String methodName = "removeConfidence";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeIntProperty(this.serviceName, OpenMetadataProperty.CONFIDENCE.name, instanceProperties, "removeConfidence");
        }
        return 0;
    }

    protected String removeExpression(InstanceProperties instanceProperties) {
        String methodName = "removeExpression";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.EXPRESSION.name, instanceProperties, "removeExpression");
        }
        return null;
    }

    protected String removeExplanation(InstanceProperties instanceProperties) {
        String methodName = "removeExplanation";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.EXPLANATION.name, instanceProperties, "removeExplanation");
        }
        return null;
    }

    protected String removeJsonProperties(InstanceProperties instanceProperties) {
        String methodName = "removeJsonProperties";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.JSON_PROPERTIES.name, instanceProperties, "removeJsonProperties");
        }
        return null;
    }

    protected Date removeReviewDate(InstanceProperties instanceProperties) {
        String methodName = "removeReviewDate";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeDateProperty(this.serviceName, OpenMetadataProperty.REVIEW_DATE.name, instanceProperties, "removeReviewDate");
        }
        return null;
    }

    protected String removeSteward(InstanceProperties instanceProperties) {
        String methodName = "removeSteward";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.STEWARD.name, instanceProperties, "removeSteward");
        }
        return null;
    }

    protected String removeComment(InstanceProperties instanceProperties) {
        String methodName = "removeComment";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.COMMENT.name, instanceProperties, "removeComment");
        }
        return null;
    }

    protected String removeSchemaName(InstanceProperties instanceProperties) {
        String methodName = "removeSchemaName";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.SCHEMA_NAME.name, instanceProperties, "removeSchemaName");
        }
        return null;
    }

    protected String removeSchemaType(InstanceProperties instanceProperties) {
        String methodName = "removeSchemaType";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.SCHEMA_TYPE.name, instanceProperties, "removeSchemaType");
        }
        return null;
    }

    protected Map<String, String> removeCandidateClassifications(InstanceProperties instanceProperties) {
        String methodName = "removeCandidateClassifications";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringMapFromProperty(this.serviceName, OpenMetadataProperty.CANDIDATE_CLASSIFICATIONS.name, instanceProperties, "removeCandidateClassifications");
        }
        return null;
    }

    protected List<String> removeCandidateDataClassGUIDs(InstanceProperties instanceProperties) {
        String methodName = "removeCandidateDataClassGUIDs";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringArrayProperty(this.serviceName, OpenMetadataProperty.CANDIDATE_DATA_CLASS_GUIDS.name, instanceProperties, "removeCandidateDataClassGUIDs");
        }
        return null;
    }

    protected String removeInferredDataType(InstanceProperties instanceProperties) {
        String methodName = "removeInferredDataType";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.INFERRED_DATA_TYPE.name, instanceProperties, "removeInferredDataType");
        }
        return null;
    }

    protected String removeInferredFormat(InstanceProperties instanceProperties) {
        String methodName = "removeInferredFormat";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.INFERRED_FORMAT.name, instanceProperties, "removeInferredFormat");
        }
        return null;
    }

    protected int removeInferredLength(InstanceProperties instanceProperties) {
        String methodName = "removeInferredLength";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeIntProperty(this.serviceName, OpenMetadataProperty.INFERRED_LENGTH.name, instanceProperties, "removeInferredLength");
        }
        return 0;
    }

    protected int removeInferredPrecision(InstanceProperties instanceProperties) {
        String methodName = "removeInferredPrecision";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeIntProperty(this.serviceName, OpenMetadataProperty.INFERRED_PRECISION.name, instanceProperties, "removeInferredPrecision");
        }
        return 0;
    }

    protected int removeInferredScale(InstanceProperties instanceProperties) {
        String methodName = "removeInferredScale";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeIntProperty(this.serviceName, OpenMetadataProperty.INFERRED_SCALE.name, instanceProperties, "removeInferredScale");
        }
        return 0;
    }

    protected Date removeProfileStartDate(InstanceProperties instanceProperties) {
        String methodName = "removeProfileStartDate";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeDateProperty(this.serviceName, OpenMetadataProperty.PROFILE_START_DATE.name, instanceProperties, "removeProfileStartDate");
        }
        return null;
    }

    protected Date removeProfileEndDate(InstanceProperties instanceProperties) {
        String methodName = "removeProfileEndDate";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeDateProperty(this.serviceName, OpenMetadataProperty.PROFILE_END_DATE.name, instanceProperties, "removeProfileEndDate");
        }
        return null;
    }

    protected Map<String, String> removeProfileProperties(InstanceProperties instanceProperties) {
        String methodName = "removeProfileProperties";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringMapFromProperty(this.serviceName, OpenMetadataProperty.PROFILE_PROPERTIES.name, instanceProperties, "removeProfileProperties");
        }
        return null;
    }

    protected List<String> removeProfilePropertyNames(InstanceProperties instanceProperties) {
        String methodName = "removeProfilePropertyNames";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringArrayProperty(this.serviceName, OpenMetadataProperty.PROFILE_PROPERTY_NAMES.name, instanceProperties, "removeProfilePropertyNames");
        }
        return null;
    }

    protected Map<String, Boolean> removeProfileFlags(InstanceProperties instanceProperties) {
        String methodName = "removeProfileFlags";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeBooleanMapFromProperty(this.serviceName, OpenMetadataProperty.PROFILE_FLAGS.name, instanceProperties, "removeProfileFlags");
        }
        return null;
    }

    protected Map<String, Date> removeProfileDates(InstanceProperties instanceProperties) {
        String methodName = "removeProfileDates";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeDateMapFromProperty(this.serviceName, OpenMetadataProperty.PROFILE_DATES.name, instanceProperties, "removeProfileDates");
        }
        return null;
    }

    protected Map<String, Long> removeProfileCounts(InstanceProperties instanceProperties) {
        String methodName = "removeProfileCounts";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeLongMapFromProperty(this.serviceName, OpenMetadataProperty.PROFILE_COUNTS.name, instanceProperties, "removeProfileCounts");
        }
        return null;
    }

    protected Map<String, Double> removeProfileDoubles(InstanceProperties instanceProperties) {
        String methodName = "removeProfileDoubles";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeDoubleMapFromProperty(this.serviceName, OpenMetadataProperty.PROFILE_DOUBLES.name, instanceProperties, "removeProfileDoubles");
        }
        return null;
    }

    protected List<String> removeValueList(InstanceProperties instanceProperties) {
        String methodName = "removeValueList";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringArrayProperty(this.serviceName, OpenMetadataProperty.VALUE_LIST.name, instanceProperties, "removeValueList");
        }
        return null;
    }

    protected Map<String, Integer> removeValueCount(InstanceProperties instanceProperties) {
        String methodName = "removeValueCount";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeIntegerMapFromProperty(this.serviceName, OpenMetadataProperty.VALUE_COUNT.name, instanceProperties, "removeValueCount");
        }
        return null;
    }

    protected String removeValueRangeFrom(InstanceProperties instanceProperties) {
        String methodName = "removeValueRangeFrom";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.VALUE_RANGE_FROM.name, instanceProperties, "removeValueRangeFrom");
        }
        return null;
    }

    protected String removeValueRangeTo(InstanceProperties instanceProperties) {
        String methodName = "removeValueRangeTo";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.VALUE_RANGE_TO.name, instanceProperties, "removeValueRangeTo");
        }
        return null;
    }

    protected String removeAverageValue(InstanceProperties instanceProperties) {
        String methodName = "removeAverageValue";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.AVERAGE_VALUE.name, instanceProperties, "removeAverageValue");
        }
        return null;
    }

    protected Map<String, String> removeResourceProperties(InstanceProperties instanceProperties) {
        String methodName = "removeDataSourceProperties";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringMapFromProperty(this.serviceName, OpenMetadataProperty.RESOURCE_PROPERTIES.name, instanceProperties, "removeDataSourceProperties");
        }
        return null;
    }

    protected int removeSize(InstanceProperties instanceProperties) {
        String methodName = "removeSize";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeIntProperty(this.serviceName, OpenMetadataProperty.SIZE.name, instanceProperties, "removeSize");
        }
        return 0;
    }

    protected String removeEncoding(InstanceProperties instanceProperties) {
        String methodName = "removeEncoding";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.ENCODING.name, instanceProperties, "removeEncoding");
        }
        return null;
    }

    protected String removeParameterType(InstanceProperties instanceProperties) {
        String methodName = "removeParameterType";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.PARAMETER_TYPE.name, instanceProperties, "removeParameterType");
        }
        return null;
    }

    protected String removeQualityDimension(InstanceProperties instanceProperties) {
        String methodName = "removeQualityDimension";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.QUALITY_DIMENSION.name, instanceProperties, "removeQualityDimension");
        }
        return null;
    }

    protected int removeQualityScore(InstanceProperties instanceProperties) {
        String methodName = "removeQualityScore";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeIntProperty(this.serviceName, OpenMetadataProperty.QUALITY_SCORE.name, instanceProperties, "removeQualityScore");
        }
        return 0;
    }

    protected String removeRelatedEntityGUID(InstanceProperties instanceProperties) {
        String methodName = "removeRelatedEntityGUID";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.RELATED_ENTITY_GUID.name, instanceProperties, "removeRelatedEntityGUID");
        }
        return null;
    }

    protected String removeRelationshipTypeName(InstanceProperties instanceProperties) {
        String methodName = "removeRelationshipTypeName";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.RELATIONSHIP_TYPE_NAME.name, instanceProperties, "removeRelationshipTypeName");
        }
        return null;
    }

    protected Map<String, String> removeRelationshipProperties(InstanceProperties instanceProperties) {
        String methodName = "removeRelationshipProperties";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringMapFromProperty(this.serviceName, OpenMetadataProperty.RELATIONSHIP_PROPERTIES.name, instanceProperties, "removeRelationshipProperties");
        }
        return null;
    }

    protected String removeSurveyActivity(InstanceProperties instanceProperties) {
        String methodName = "removeSurveyActivity";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.ACTION_SOURCE_NAME.name, instanceProperties, "removeSurveyActivity");
        }
        return null;
    }

    protected String removeActionRequested(InstanceProperties instanceProperties) {
        String methodName = "removeActionRequested";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.ACTION_REQUESTED.name, instanceProperties, "removeActionRequested");
        }
        return null;
    }

    protected Map<String, String> removeActionProperties(InstanceProperties instanceProperties) {
        String methodName = "removeActionProperties";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringMapFromProperty(this.serviceName, OpenMetadataProperty.ACTION_PROPERTIES.name, instanceProperties, "removeActionProperties");
        }
        return null;
    }

    protected String removeInformalTerm(InstanceProperties instanceProperties) {
        String methodName = "removeInformalTerm";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.INFORMAL_TERM.name, instanceProperties, "removeInformalTerm");
        }
        return null;
    }

    protected List<String> removeCandidateGlossaryTermGUIDs(InstanceProperties instanceProperties) {
        String methodName = "removeCandidateGlossaryTermGUIDs";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringArrayProperty(this.serviceName, OpenMetadataProperty.CANDIDATE_GLOSSARY_TERM_GUIDS.name, instanceProperties, "removeCandidateGlossaryTermGUIDs");
        }
        return null;
    }

    protected String removeInformalTopic(InstanceProperties instanceProperties) {
        String methodName = "removeInformalTopic";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.INFORMAL_CATEGORY.name, instanceProperties, "removeInformalTopic");
        }
        return null;
    }

    protected List<String> removeCandidateGlossaryCategoryGUIDs(InstanceProperties instanceProperties) {
        String methodName = "removeCandidateGlossaryCategoryGUIDs";
        if (instanceProperties != null) {
            return this.repositoryHelper.removeStringArrayProperty(this.serviceName, OpenMetadataProperty.CANDIDATE_GLOSSARY_CATEGORY_GUIDS.name, instanceProperties, "removeCandidateGlossaryCategoryGUIDs");
        }
        return null;
    }
}

