/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.lang.reflect.InvocationTargetException;
import org.odpi.openmetadata.commonservices.generichandlers.OMFConverter;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ActorRoleElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.actors.PersonRoleProperties;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class PersonRoleConverter<B>
extends OMFConverter<B> {
    public PersonRoleConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    @Override
    public B getNewBean(Class<B> beanClass, EntityDetail entity, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof ActorRoleElement) {
                ActorRoleElement bean = (ActorRoleElement)returnBean;
                PersonRoleProperties roleProperties = new PersonRoleProperties();
                if (entity != null) {
                    bean.setElementHeader(this.getMetadataElementHeader(beanClass, entity, methodName));
                    InstanceProperties instanceProperties = new InstanceProperties(entity.getProperties());
                    roleProperties.setQualifiedName(this.removeQualifiedName(instanceProperties));
                    roleProperties.setRoleId(this.removeIdentifier(instanceProperties));
                    roleProperties.setTitle(this.removeName(instanceProperties));
                    roleProperties.setDescription(this.removeDescription(instanceProperties));
                    roleProperties.setScope(this.removeScope(instanceProperties));
                    roleProperties.setDomainIdentifier(this.removeDomainIdentifier(instanceProperties));
                    roleProperties.setHeadCountLimitSet(instanceProperties.getPropertyValue(OpenMetadataProperty.HEAD_COUNT.name) != null);
                    roleProperties.setHeadCount(this.removeHeadCount(instanceProperties));
                    roleProperties.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                    roleProperties.setEffectiveFrom(instanceProperties.getEffectiveFromTime());
                    roleProperties.setEffectiveTo(instanceProperties.getEffectiveToTime());
                    roleProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
                    roleProperties.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
                    bean.setProperties(roleProperties);
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    @Override
    public B getNewBean(Class<B> beanClass, EntityDetail entity, Relationship relationship, String methodName) throws PropertyServerException {
        B returnBean = this.getNewBean(beanClass, entity, methodName);
        if (returnBean instanceof ActorRoleElement) {
            ActorRoleElement bean = (ActorRoleElement)returnBean;
            bean.setRelatedBy(super.getRelatedBy(beanClass, relationship, methodName));
        }
        return returnBean;
    }
}

