/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.Map;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableBuilder;
import org.odpi.openmetadata.frameworks.openmetadata.enums.PortType;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;

public class PortBuilder
extends ReferenceableBuilder {
    private final String displayName;
    private final int portType;

    public PortBuilder(String qualifiedName, String displayName, int portType, Map<String, String> additionalProperties, String typeGUID, String typeName, Map<String, Object> extendedProperties, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, additionalProperties, typeGUID, typeName, extendedProperties, repositoryHelper, serviceName, serverName);
        this.displayName = displayName;
        this.portType = portType;
    }

    @Override
    public InstanceProperties getInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = super.getInstanceProperties(methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.DISPLAY_NAME.name, this.displayName, methodName);
        try {
            properties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.PORT_TYPE.name, PortType.getOpenTypeGUID(), PortType.getOpenTypeName(), this.portType, methodName);
        }
        catch (TypeErrorException error) {
            this.errorHandler.handleUnsupportedType((Exception)((Object)error), methodName, PortType.getOpenTypeName());
        }
        return properties;
    }
}

