/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericHandler;
import org.odpi.openmetadata.commonservices.generichandlers.PortBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.ffdc.GenericHandlersErrorCode;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class PortHandler<B>
extends OpenMetadataAPIGenericHandler<B> {
    public PortHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public String createPort(String userId, String externalSourceGUID, String externalSourceName, String processGUID, String processGUIDParameterName, String qualifiedName, String displayName, int portType, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(processGUID, processGUIDParameterName, methodName);
        String typeName = OpenMetadataType.PORT.typeName;
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, OpenMetadataType.PORT.typeName, this.serviceName, methodName, this.repositoryHelper);
        PortBuilder builder = new PortBuilder(qualifiedName, displayName, portType, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        this.addAnchorGUIDToBuilder(userId, processGUID, processGUIDParameterName, false, false, effectiveTime, this.supportedZones, builder, methodName);
        String portGUID = this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, typeGUID, typeName, builder, effectiveTime, methodName);
        if (portGUID != null) {
            String portGUIDParameterName = "portGUID";
            this.uncheckedLinkElementToElement(userId, externalSourceGUID, externalSourceName, processGUID, processGUIDParameterName, portGUID, "portGUID", OpenMetadataType.PROCESS_PORT_RELATIONSHIP.typeGUID, null, methodName);
        }
        return portGUID;
    }

    public void updatePort(String userId, String externalSourceGUID, String externalSourceName, String portGUID, String portGUIDParameterName, String qualifiedName, String displayName, int portType, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(portGUID, portGUIDParameterName, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String typeName = OpenMetadataType.PORT.typeName;
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, OpenMetadataType.PORT.typeName, this.serviceName, methodName, this.repositoryHelper);
        PortBuilder builder = new PortBuilder(qualifiedName, displayName, portType, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, portGUID, portGUIDParameterName, typeGUID, typeName, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, builder.getInstanceProperties(methodName), false, effectiveTime, methodName);
    }

    public void setupProcessPort(String userId, String externalSourceGUID, String externalSourceName, String processGUID, String processGUIDParameterName, String portGUID, String portGUIDParameterName, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, processGUID, processGUIDParameterName, OpenMetadataType.PROCESS.typeName, portGUID, portGUIDParameterName, OpenMetadataType.PORT.typeName, forLineage, forDuplicateProcessing, this.supportedZones, OpenMetadataType.PROCESS_PORT_RELATIONSHIP.typeGUID, OpenMetadataType.PROCESS_PORT_RELATIONSHIP.typeName, null, effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void clearProcessPort(String userId, String externalSourceGUID, String externalSourceName, String processGUID, String processGUIDParameterName, String portGUID, String portGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, processGUID, processGUIDParameterName, OpenMetadataType.PROCESS.typeName, portGUID, portGUIDParameterName, OpenMetadataType.PORT.typeGUID, OpenMetadataType.PORT.typeName, forLineage, forDuplicateProcessing, OpenMetadataType.PROCESS_PORT_RELATIONSHIP.typeGUID, OpenMetadataType.PROCESS_PORT_RELATIONSHIP.typeName, effectiveTime, methodName);
    }

    public void setupPortDelegation(String userId, String externalSourceGUID, String externalSourceName, String portOneGUID, String portOneGUIDParameterName, String portTwoGUID, String portTwoGUIDParameterName, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, portOneGUID, portOneGUIDParameterName, OpenMetadataType.PORT.typeName, portTwoGUID, portTwoGUIDParameterName, OpenMetadataType.PORT.typeName, forLineage, forDuplicateProcessing, this.supportedZones, OpenMetadataType.PORT_DELEGATION_RELATIONSHIP.typeGUID, OpenMetadataType.PORT_DELEGATION_RELATIONSHIP.typeName, null, effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void clearPortDelegation(String userId, String externalSourceGUID, String externalSourceName, String portOneGUID, String portOneGUIDParameterName, String portTwoGUID, String portTwoGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, portOneGUID, portOneGUIDParameterName, OpenMetadataType.PORT.typeName, portTwoGUID, portTwoGUIDParameterName, OpenMetadataType.PORT.typeGUID, OpenMetadataType.PORT.typeName, forLineage, forDuplicateProcessing, OpenMetadataType.PORT_DELEGATION_RELATIONSHIP.typeGUID, OpenMetadataType.PORT_DELEGATION_RELATIONSHIP.typeName, effectiveTime, methodName);
    }

    public void setupPortSchemaType(String userId, String externalSourceGUID, String externalSourceName, String portGUID, String portGUIDParameterName, String schemaTypeGUID, String schemaTypeGUIDParameterName, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, portGUID, portGUIDParameterName, OpenMetadataType.PORT.typeName, schemaTypeGUID, schemaTypeGUIDParameterName, OpenMetadataType.SCHEMA_TYPE.typeName, forLineage, forDuplicateProcessing, this.supportedZones, OpenMetadataType.PORT_SCHEMA_RELATIONSHIP.typeGUID, OpenMetadataType.PORT_SCHEMA_RELATIONSHIP.typeName, null, effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void clearPortSchemaType(String userId, String externalSourceGUID, String externalSourceName, String portGUID, String portGUIDParameterName, String schemaTypeGUID, String schemaTypeGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, portGUID, portGUIDParameterName, OpenMetadataType.PORT.typeName, schemaTypeGUID, schemaTypeGUIDParameterName, OpenMetadataType.SCHEMA_TYPE.typeGUID, OpenMetadataType.SCHEMA_TYPE.typeName, forLineage, forDuplicateProcessing, OpenMetadataType.PORT_SCHEMA_RELATIONSHIP.typeGUID, OpenMetadataType.PORT_SCHEMA_RELATIONSHIP.typeName, effectiveTime, methodName);
    }

    public void removePort(String userId, String externalSourceGUID, String externalSourceName, String portGUID, String portGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, portGUID, portGUIDParameterName, OpenMetadataType.PORT.typeGUID, OpenMetadataType.PORT.typeName, false, null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> findPorts(String userId, String searchString, String searchStringParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.findBeans(userId, searchString, searchStringParameterName, OpenMetadataType.PORT.typeGUID, OpenMetadataType.PORT.typeName, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getPortsForProcess(String userId, String processGUID, String processGUIDParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getAttachedElements(userId, processGUID, processGUIDParameterName, OpenMetadataType.PROCESS.typeName, OpenMetadataType.PROCESS_PORT_RELATIONSHIP.typeGUID, OpenMetadataType.PROCESS_PORT_RELATIONSHIP.typeName, OpenMetadataType.PORT.typeName, null, null, 2, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getPortUse(String userId, String portGUID, String portGUIDParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getAttachedElements(userId, portGUID, portGUIDParameterName, OpenMetadataType.PORT.typeName, OpenMetadataType.PORT_DELEGATION_RELATIONSHIP.typeGUID, OpenMetadataType.PORT_DELEGATION_RELATIONSHIP.typeName, OpenMetadataType.PORT.typeName, null, null, 1, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, startFrom, pageSize, effectiveTime, methodName);
    }

    public B getPortDelegation(String userId, String portGUID, String portGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List results = this.getAttachedElements(userId, portGUID, portGUIDParameterName, OpenMetadataType.PORT.typeName, OpenMetadataType.PORT_DELEGATION_RELATIONSHIP.typeGUID, OpenMetadataType.PORT_DELEGATION_RELATIONSHIP.typeName, OpenMetadataType.PORT.typeName, null, null, 2, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, 0, this.invalidParameterHandler.getMaxPagingSize(), effectiveTime, methodName);
        if (results == null || results.isEmpty()) {
            return null;
        }
        if (results.size() == 1) {
            return results.get(0);
        }
        throw new PropertyServerException(GenericHandlersErrorCode.MULTIPLE_BEANS_FOUND.getMessageDefinition(OpenMetadataType.PORT.typeName, methodName, results.toString(), portGUID, this.serviceName, this.serverName), this.getClass().getName(), methodName);
    }

    public List<B> getPortsByName(String userId, String name, String nameParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add(OpenMetadataProperty.QUALIFIED_NAME.name);
        specificMatchPropertyNames.add(OpenMetadataProperty.DISPLAY_NAME.name);
        return this.getBeansByValue(userId, name, nameParameterName, OpenMetadataType.PORT.typeGUID, OpenMetadataType.PORT.typeName, specificMatchPropertyNames, true, null, null, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public B getPortByGUID(String userId, String portGUID, String portGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getBeanFromRepository(userId, portGUID, portGUIDParameterName, OpenMetadataType.PORT.typeName, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
    }
}

