/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.Date;
import org.odpi.openmetadata.commonservices.generichandlers.AssetBuilder;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ProcessContainmentType;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.OMFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;

public class ProcessBuilder
extends AssetBuilder {
    private String formula = null;
    private String formulaType = null;
    private String implementationLanguage = null;
    private Date processStartTime = null;
    private Date processEndTime = null;

    ProcessBuilder(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(OpenMetadataType.DEPLOYED_SOFTWARE_COMPONENT.typeGUID, OpenMetadataType.DEPLOYED_SOFTWARE_COMPONENT.typeName, repositoryHelper, serviceName, serverName);
    }

    ProcessBuilder(String typeGUID, String typeName, String qualifiedName, String name, String description, String formula, String formulaType, String implementationLanguage, String deployedImplementationType, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, name, null, null, description, deployedImplementationType, null, typeGUID, typeName, null, InstanceStatus.ACTIVE, repositoryHelper, serviceName, serverName);
        this.formula = formula;
        this.formulaType = formulaType;
        this.implementationLanguage = implementationLanguage;
    }

    ProcessBuilder(String typeGUID, String typeName, String qualifiedName, String name, String description, String formula, String formulaType, Date processStartTime, Date processEndTime, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, name, null, null, description, null, null, typeGUID, typeName, null, InstanceStatus.ACTIVE, repositoryHelper, serviceName, serverName);
        this.formula = formula;
        this.formulaType = formulaType;
        this.processStartTime = processStartTime;
        this.processEndTime = processEndTime;
    }

    ProcessBuilder(String typeGUID, String typeName, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(typeGUID, typeName, repositoryHelper, serviceName, serverName);
    }

    public InstanceProperties getProcessHierarchyProperties(int processContainmentOrdinal) throws InvalidParameterException {
        String methodName = "getProcessHierarchyProperties";
        try {
            return this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, null, OpenMetadataProperty.CONTAINMENT_TYPE.name, ProcessContainmentType.getOpenTypeGUID(), ProcessContainmentType.getOpenTypeName(), processContainmentOrdinal, "getProcessHierarchyProperties");
        }
        catch (TypeErrorException classificationNotSupported) {
            throw new InvalidParameterException((OMFCheckedExceptionBase)classificationNotSupported, OpenMetadataProperty.KEY_PATTERN.name);
        }
    }

    @Override
    public InstanceProperties getInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = super.getInstanceProperties(methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.FORMULA.name, this.formula, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.FORMULA_TYPE.name, this.formulaType, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.IMPLEMENTATION_LANGUAGE.name, this.implementationLanguage, methodName);
        properties = this.repositoryHelper.addDatePropertyToInstance(this.serviceName, properties, OpenMetadataProperty.PROCESS_START_TIME.name, this.processStartTime, methodName);
        properties = this.repositoryHelper.addDatePropertyToInstance(this.serviceName, properties, OpenMetadataProperty.PROCESS_END_TIME.name, this.processEndTime, methodName);
        return properties;
    }
}

