/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.lang.reflect.InvocationTargetException;
import org.odpi.openmetadata.commonservices.generichandlers.OMFConverter;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ProjectElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.projects.ProjectProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ProjectConverter<B>
extends OMFConverter<B> {
    public ProjectConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    @Override
    public B getNewBean(Class<B> beanClass, EntityDetail entity, String methodName) throws PropertyServerException {
        return this.getNewBean(beanClass, entity, null, methodName);
    }

    @Override
    public B getNewBean(Class<B> beanClass, EntityDetail entity, Relationship relationship, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof ProjectElement) {
                ProjectElement bean = (ProjectElement)returnBean;
                ProjectProperties projectProperties = new ProjectProperties();
                if (entity != null) {
                    bean.setElementHeader(super.getMetadataElementHeader(beanClass, entity, methodName));
                    InstanceProperties instanceProperties = new InstanceProperties(entity.getProperties());
                    projectProperties.setQualifiedName(this.removeQualifiedName(instanceProperties));
                    projectProperties.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                    projectProperties.setIdentifier(this.removeIdentifier(instanceProperties));
                    projectProperties.setName(this.removeName(instanceProperties));
                    projectProperties.setDescription(this.removeDescription(instanceProperties));
                    projectProperties.setStartDate(this.removeStartDate(instanceProperties));
                    projectProperties.setPlannedEndDate(this.removePlannedEndDate(instanceProperties));
                    projectProperties.setProjectStatus(this.removeProjectStatus(instanceProperties));
                    projectProperties.setProjectHealth(this.removeProjectHealth(instanceProperties));
                    projectProperties.setProjectPhase(this.removeProjectPhase(instanceProperties));
                    projectProperties.setPriority(this.removeIntPriority(instanceProperties));
                    projectProperties.setEffectiveFrom(instanceProperties.getEffectiveFromTime());
                    projectProperties.setEffectiveTo(instanceProperties.getEffectiveToTime());
                    projectProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
                    projectProperties.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
                }
                if (relationship != null) {
                    bean.setRelatedBy(super.getRelatedBy(beanClass, relationship, methodName));
                }
                bean.setProperties(projectProperties);
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }
}

