/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.ProjectBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ProjectHandler<B>
extends ReferenceableHandler<B> {
    private static final String qualifiedNameParameterName = "qualifiedName";

    public ProjectHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public String createProject(String userId, String externalSourceGUID, String externalSourceName, String qualifiedName, String identifier, String name, String description, Date startDate, Date plannedEndDate, String projectPhase, String projectHealth, String projectStatus, int priority, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, boolean setCampaignClassification, boolean setTaskClassification, String projectTypeClassification, Date effectiveFrom, Date effectiveTo, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, qualifiedNameParameterName, methodName);
        String typeName = OpenMetadataType.PROJECT.typeName;
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, OpenMetadataType.PROJECT.typeName, this.serviceName, methodName, this.repositoryHelper);
        ProjectBuilder builder = new ProjectBuilder(qualifiedName, identifier, name, description, startDate, plannedEndDate, projectPhase, projectHealth, projectStatus, priority, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        if (setCampaignClassification) {
            builder.setCampaignClassification(userId, methodName);
        } else if (setTaskClassification) {
            builder.setTaskClassification(userId, methodName);
        }
        if (projectTypeClassification != null) {
            builder.setProjectTypeClassification(userId, projectTypeClassification, methodName);
        }
        return this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, typeGUID, typeName, builder, effectiveTime, methodName);
    }

    public void updateProject(String userId, String externalSourceGUID, String externalSourceName, String projectGUID, String projectGUIDParameterName, String qualifiedName, String identifier, String name, String description, Date startDate, Date plannedEndDate, String projectPhase, String projectHealth, String projectStatus, int priority, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(projectGUID, projectGUIDParameterName, methodName);
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(qualifiedName, qualifiedNameParameterName, methodName);
        }
        String typeName = OpenMetadataType.PROJECT.typeName;
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, OpenMetadataType.PROJECT.typeName, this.serviceName, methodName, this.repositoryHelper);
        ProjectBuilder builder = new ProjectBuilder(qualifiedName, identifier, name, description, startDate, plannedEndDate, projectPhase, projectHealth, projectStatus, priority, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, projectGUID, projectGUIDParameterName, typeGUID, typeName, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, builder.getInstanceProperties(methodName), isMergeUpdate, effectiveTime, methodName);
    }

    public void addActorToProject(String userId, String externalSourceGUID, String externalSourceName, String projectGUID, String projectGUIDParameterName, String actorProfileGUID, String actorProfileGUIDParameterName, String teamRole, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.TEAM_ROLE.name, teamRole, methodName);
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, projectGUID, projectGUIDParameterName, OpenMetadataType.PROJECT.typeName, actorProfileGUID, actorProfileGUIDParameterName, OpenMetadataType.ACTOR.typeName, forLineage, forDuplicateProcessing, this.supportedZones, OpenMetadataType.PROJECT_TEAM_RELATIONSHIP.typeGUID, OpenMetadataType.PROJECT_TEAM_RELATIONSHIP.typeName, properties, effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void removeActorFromProject(String userId, String externalSourceGUID, String externalSourceName, String projectGUID, String projectGUIDParameterName, String actorProfileGUID, String actorProfileGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, projectGUID, projectGUIDParameterName, OpenMetadataType.PROJECT.typeName, actorProfileGUID, actorProfileGUIDParameterName, OpenMetadataType.ACTOR.typeGUID, OpenMetadataType.ACTOR.typeName, forLineage, forDuplicateProcessing, OpenMetadataType.PROJECT_TEAM_RELATIONSHIP.typeGUID, OpenMetadataType.PROJECT_TEAM_RELATIONSHIP.typeName, effectiveTime, methodName);
    }

    public void addProjectManager(String userId, String externalSourceGUID, String externalSourceName, String projectGUID, String projectGUIDParameterName, String personRoleGUID, String personRoleGUIDParameterName, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, projectGUID, projectGUIDParameterName, OpenMetadataType.PROJECT.typeName, personRoleGUID, personRoleGUIDParameterName, OpenMetadataType.PERSON_ROLE.typeName, forLineage, forDuplicateProcessing, this.supportedZones, OpenMetadataType.PROJECT_MANAGEMENT_RELATIONSHIP.typeGUID, OpenMetadataType.PROJECT_MANAGEMENT_RELATIONSHIP.typeName, null, effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void removeProjectManager(String userId, String externalSourceGUID, String externalSourceName, String projectGUID, String projectGUIDParameterName, String personRoleGUID, String personRoleGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, projectGUID, projectGUIDParameterName, OpenMetadataType.PROJECT.typeName, personRoleGUID, personRoleGUIDParameterName, OpenMetadataType.PERSON_ROLE.typeGUID, OpenMetadataType.PERSON_ROLE.typeName, forLineage, forDuplicateProcessing, OpenMetadataType.PROJECT_MANAGEMENT_RELATIONSHIP.typeGUID, OpenMetadataType.PROJECT_MANAGEMENT_RELATIONSHIP.typeName, effectiveTime, methodName);
    }

    public void removeProject(String userId, String externalSourceGUID, String externalSourceName, String projectGUID, String projectGUIDParameterName, boolean cascadedDelete, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, projectGUID, projectGUIDParameterName, OpenMetadataType.PROJECT.typeGUID, OpenMetadataType.PROJECT.typeName, cascadedDelete, null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }
}

