/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.Map;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableBuilder;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class PropertyFacetBuilder
extends ReferenceableBuilder {
    private final String schemaVersion;
    private final String description;
    private final Map<String, String> properties;

    PropertyFacetBuilder(String qualifiedName, String schemaVersion, String description, Map<String, String> properties, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, OpenMetadataType.PROPERTY_FACET.typeGUID, OpenMetadataType.PROPERTY_FACET.typeName, repositoryHelper, serviceName, serverName);
        this.schemaVersion = schemaVersion;
        this.description = description;
        this.properties = properties;
    }

    @Override
    public InstanceProperties getInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties instanceProperties = super.getInstanceProperties(methodName);
        instanceProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, instanceProperties, OpenMetadataProperty.SCHEMA_VERSION.name, this.schemaVersion, methodName);
        instanceProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, instanceProperties, OpenMetadataProperty.DESCRIPTION.name, this.description, methodName);
        instanceProperties = this.repositoryHelper.addStringMapPropertyToInstance(this.serviceName, instanceProperties, OpenMetadataProperty.PROPERTIES.name, this.properties, methodName);
        return instanceProperties;
    }
}

