/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.lang.reflect.InvocationTargetException;
import org.odpi.openmetadata.commonservices.generichandlers.OMFConverter;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ReferenceValueAssignmentItemElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ReferenceableElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.ReferenceableProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.validvalues.ReferenceValueAssignmentProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ReferenceValueAssignmentItemConverter<B>
extends OMFConverter<B> {
    public ReferenceValueAssignmentItemConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    @Override
    public B getNewBean(Class<B> beanClass, EntityDetail entity, Relationship relationship, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof ReferenceValueAssignmentItemElement) {
                ReferenceValueAssignmentItemElement bean = (ReferenceValueAssignmentItemElement)returnBean;
                ReferenceableElement assignedItem = new ReferenceableElement();
                ReferenceableProperties referenceableProperties = new ReferenceableProperties();
                if (entity != null) {
                    assignedItem.setElementHeader(this.getMetadataElementHeader(beanClass, entity, methodName));
                    InstanceProperties instanceProperties = new InstanceProperties(entity.getProperties());
                    referenceableProperties.setQualifiedName(this.removeQualifiedName(instanceProperties));
                    referenceableProperties.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                    referenceableProperties.setTypeName(assignedItem.getElementHeader().getType().getTypeName());
                    referenceableProperties.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
                    assignedItem.setReferenceableProperties(referenceableProperties);
                    bean.setAssignedItem(assignedItem);
                    if (relationship != null) {
                        instanceProperties = relationship.getProperties();
                        ReferenceValueAssignmentProperties referenceValueAssignmentProperties = new ReferenceValueAssignmentProperties();
                        referenceValueAssignmentProperties.setAttributeName(this.getAttributeName(instanceProperties));
                        referenceValueAssignmentProperties.setConfidence(this.getConfidence(instanceProperties));
                        referenceValueAssignmentProperties.setSteward(this.getSteward(instanceProperties));
                        referenceValueAssignmentProperties.setStewardTypeName(this.getStewardTypeName(instanceProperties));
                        referenceValueAssignmentProperties.setStewardPropertyName(this.getStewardPropertyName(instanceProperties));
                        referenceValueAssignmentProperties.setNotes(this.getNotes(instanceProperties));
                        bean.setRelationshipProperties(referenceValueAssignmentProperties);
                    } else {
                        this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.RELATIONSHIP_DEF, methodName);
                    }
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }
}

