/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPITemplateHandler;
import org.odpi.openmetadata.commonservices.generichandlers.PropertyFacetBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableBuilder;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.enums.GlossaryTermAssignmentStatus;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.MatchCriteria;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;

public class ReferenceableHandler<B>
extends OpenMetadataAPITemplateHandler<B> {
    public ReferenceableHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public String getBeanGUIDByQualifiedName(String userId, String typeGUID, String typeName, String name, String nameParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getBeanGUIDByQualifiedName(userId, typeGUID, typeName, name, nameParameterName, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
    }

    public String getBeanGUIDByQualifiedName(String userId, String typeGUID, String typeName, String name, String nameParameterName, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String resultTypeGUID = OpenMetadataType.REFERENCEABLE.typeGUID;
        String resultTypeName = OpenMetadataType.REFERENCEABLE.typeName;
        if (typeGUID != null) {
            resultTypeGUID = typeGUID;
        }
        if (typeName != null) {
            resultTypeName = typeName;
        }
        return this.getBeanGUIDByUniqueName(userId, name, nameParameterName, OpenMetadataProperty.QUALIFIED_NAME.name, resultTypeGUID, resultTypeName, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
    }

    public B getBeanByQualifiedName(String userId, String typeGUID, String typeName, String name, String nameParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getBeanByQualifiedName(userId, typeGUID, typeName, name, nameParameterName, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
    }

    public B getBeanByQualifiedName(String userId, String typeGUID, String typeName, String name, String nameParameterName, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String resultTypeGUID = OpenMetadataType.REFERENCEABLE.typeGUID;
        String resultTypeName = OpenMetadataType.REFERENCEABLE.typeName;
        if (typeGUID != null) {
            resultTypeGUID = typeGUID;
        }
        if (typeName != null) {
            resultTypeName = typeName;
        }
        return this.getBeanByUniqueName(userId, name, nameParameterName, OpenMetadataProperty.QUALIFIED_NAME.name, resultTypeGUID, resultTypeName, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
    }

    public EntityDetail getEntityByUniqueQualifiedName(String userId, String typeGUID, String typeName, String name, String nameParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String resultTypeGUID = OpenMetadataType.REFERENCEABLE.typeGUID;
        String resultTypeName = OpenMetadataType.REFERENCEABLE.typeName;
        if (typeGUID != null) {
            resultTypeGUID = typeGUID;
        }
        if (typeName != null) {
            resultTypeName = typeName;
        }
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add(OpenMetadataProperty.QUALIFIED_NAME.name);
        List<EntityDetail> matchingEntities = this.getEntitiesByValue(userId, name, nameParameterName, resultTypeGUID, resultTypeName, specificMatchPropertyNames, true, false, null, null, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, this.supportedZones, 0, 0, effectiveTime, methodName);
        if (matchingEntities == null) {
            return null;
        }
        if (matchingEntities.size() == 1) {
            return matchingEntities.get(0);
        }
        this.errorHandler.handleAmbiguousEntityName(name, nameParameterName, resultTypeName, matchingEntities, methodName);
        return null;
    }

    public void addOwner(String userId, String beanGUID, String beanGUIDParameterName, String beanGUIDTypeName, String owner, String ownerTypeName, String ownerPropertyName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ReferenceableBuilder builder = new ReferenceableBuilder(OpenMetadataType.REFERENCEABLE.typeGUID, OpenMetadataType.REFERENCEABLE.typeName, this.repositoryHelper, this.serviceName, this.serverName);
        this.setClassificationInRepository(userId, null, null, beanGUID, beanGUIDParameterName, beanGUIDTypeName, OpenMetadataType.OWNERSHIP_CLASSIFICATION.typeGUID, OpenMetadataType.OWNERSHIP_CLASSIFICATION.typeName, builder.getOwnershipProperties(owner, ownerTypeName, ownerPropertyName, methodName), true, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void removeOwner(String userId, String beanGUID, String beanGUIDParameterName, String beanGUIDTypeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.removeClassificationFromRepository(userId, null, null, beanGUID, beanGUIDParameterName, beanGUIDTypeName, OpenMetadataType.OWNERSHIP_CLASSIFICATION.typeGUID, OpenMetadataType.OWNERSHIP_CLASSIFICATION.typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> getOwnersElements(String userId, String ownerName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String nameParameterName = "ownerName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(ownerName, "ownerName", methodName);
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        InstanceProperties classificationMatchProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.OWNER.name, ownerName, methodName);
        List entities = this.repositoryHandler.getEntitiesForClassificationType(userId, OpenMetadataType.REFERENCEABLE.typeGUID, OpenMetadataType.OWNERSHIP_CLASSIFICATION.typeName, classificationMatchProperties, MatchCriteria.ANY, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, startFrom, queryPageSize, effectiveTime, methodName);
        return super.getValidatedBeans(userId, effectiveTime, forLineage, forDuplicateProcessing, this.supportedZones, methodName, entities);
    }

    public void addSecurityTags(String userId, String beanGUID, String beanGUIDParameterName, String beanGUIDTypeName, List<String> securityLabels, Map<String, Object> securityProperties, Map<String, List<String>> accessGroups, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ReferenceableBuilder builder = new ReferenceableBuilder(OpenMetadataType.REFERENCEABLE.typeGUID, OpenMetadataType.REFERENCEABLE.typeName, this.repositoryHelper, this.serviceName, this.serverName);
        this.setClassificationInRepository(userId, null, null, beanGUID, beanGUIDParameterName, beanGUIDTypeName, OpenMetadataType.SECURITY_TAGS_CLASSIFICATION.typeGUID, OpenMetadataType.SECURITY_TAGS_CLASSIFICATION.typeName, builder.getSecurityTagProperties(securityLabels, securityProperties, accessGroups, methodName), true, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void removeSecurityTags(String userId, String beanGUID, String beanGUIDParameterName, String beanGUIDTypeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.removeClassificationFromRepository(userId, null, null, beanGUID, beanGUIDParameterName, beanGUIDTypeName, OpenMetadataType.SECURITY_TAGS_CLASSIFICATION.typeGUID, OpenMetadataType.SECURITY_TAGS_CLASSIFICATION.typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> getSecurityTagsClassifiedElements(String userId, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        List entities = this.repositoryHandler.getEntitiesForClassificationType(userId, OpenMetadataType.REFERENCEABLE.typeName, OpenMetadataType.SECURITY_TAGS_CLASSIFICATION.typeName, null, null, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, startFrom, queryPageSize, effectiveTime, methodName);
        return super.getValidatedBeans(userId, effectiveTime, forLineage, forDuplicateProcessing, this.supportedZones, methodName, entities);
    }

    public void addGovernanceActionClassification(String userId, String externalSourceGUID, String externalSourceName, String beanGUID, String beanGUIDParameterName, String beanGUIDTypeName, String classificationTypeGUID, String classificationTypeName, int statusIdentifier, int confidence, String steward, String stewardTypeName, String stewardPropertyName, String source, String notes, int levelIdentifier, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        InstanceProperties properties = this.repositoryHelper.addIntPropertyToInstance(this.serviceName, null, OpenMetadataProperty.STATUS_IDENTIFIER.name, statusIdentifier, methodName);
        properties = this.repositoryHelper.addIntPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.CONFIDENCE.name, confidence, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.STEWARD.name, steward, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.STEWARD_TYPE_NAME.name, stewardTypeName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.STEWARD_PROPERTY_NAME.name, stewardPropertyName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.SOURCE.name, source, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.NOTES.name, notes, methodName);
        properties = this.repositoryHelper.addIntPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.LEVEL_IDENTIFIER.name, levelIdentifier, methodName);
        this.setClassificationInRepository(userId, externalSourceGUID, externalSourceName, beanGUID, beanGUIDParameterName, beanGUIDTypeName, classificationTypeGUID, classificationTypeName, this.setUpEffectiveDates(properties, effectiveFrom, effectiveTo), true, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void removeGovernanceActionClassification(String userId, String externalSourceGUID, String externalSourceName, String beanGUID, String beanGUIDParameterName, String beanGUIDTypeName, String classificationTypeGUID, String classificationTypeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.removeClassificationFromRepository(userId, externalSourceGUID, externalSourceName, beanGUID, beanGUIDParameterName, beanGUIDTypeName, classificationTypeGUID, classificationTypeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> getGovernanceActionClassifiedElements(String userId, String classificationName, boolean returnSpecificLevel, int levelIdentifier, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        InstanceProperties classificationMatchProperties = null;
        if (returnSpecificLevel) {
            classificationMatchProperties = this.repositoryHelper.addIntPropertyToInstance(this.serviceName, null, OpenMetadataProperty.LEVEL_IDENTIFIER.name, levelIdentifier, methodName);
        }
        List entities = this.repositoryHandler.getEntitiesForClassificationType(userId, OpenMetadataType.REFERENCEABLE.typeGUID, classificationName, classificationMatchProperties, MatchCriteria.ANY, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, startFrom, queryPageSize, effectiveTime, methodName);
        return super.getValidatedBeans(userId, effectiveTime, forLineage, forDuplicateProcessing, this.supportedZones, methodName, entities);
    }

    public void addRetentionClassification(String userId, String externalSourceGUID, String externalSourceName, String beanGUID, String beanGUIDParameterName, String beanGUIDTypeName, int statusIdentifier, int confidence, String steward, String stewardTypeName, String stewardPropertyName, String source, String notes, int basisIdentifier, String associatedGUID, Date archiveAfter, Date deleteAfter, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        InstanceProperties properties = this.repositoryHelper.addIntPropertyToInstance(this.serviceName, null, OpenMetadataProperty.STATUS_IDENTIFIER.name, statusIdentifier, methodName);
        properties = this.repositoryHelper.addIntPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.CONFIDENCE.name, confidence, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.STEWARD.name, steward, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.STEWARD_TYPE_NAME.name, stewardTypeName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.STEWARD_PROPERTY_NAME.name, stewardPropertyName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.SOURCE.name, source, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.NOTES.name, notes, methodName);
        properties = this.repositoryHelper.addIntPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.RETENTION_BASIS_IDENTIFIER.name, basisIdentifier, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.ASSOCIATED_GUID.name, associatedGUID, methodName);
        properties = this.repositoryHelper.addDatePropertyToInstance(this.serviceName, properties, OpenMetadataProperty.ARCHIVE_AFTER.name, archiveAfter, methodName);
        properties = this.repositoryHelper.addDatePropertyToInstance(this.serviceName, properties, OpenMetadataProperty.DELETE_AFTER.name, deleteAfter, methodName);
        this.setClassificationInRepository(userId, externalSourceGUID, externalSourceName, beanGUID, beanGUIDParameterName, beanGUIDTypeName, OpenMetadataType.RETENTION_CLASSIFICATION.typeGUID, OpenMetadataType.RETENTION_CLASSIFICATION.typeName, this.setUpEffectiveDates(properties, effectiveFrom, effectiveTo), true, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void removeRetentionClassification(String userId, String externalSourceGUID, String externalSourceName, String beanGUID, String beanGUIDParameterName, String beanGUIDTypeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.removeClassificationFromRepository(userId, externalSourceGUID, externalSourceName, beanGUID, beanGUIDParameterName, beanGUIDTypeName, OpenMetadataType.RETENTION_CLASSIFICATION.typeGUID, OpenMetadataType.RETENTION_CLASSIFICATION.typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> getRetentionClassifiedElements(String userId, boolean returnSpecificBasisLevel, int levelIdentifier, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        InstanceProperties classificationMatchProperties = null;
        if (returnSpecificBasisLevel) {
            classificationMatchProperties = this.repositoryHelper.addIntPropertyToInstance(this.serviceName, null, OpenMetadataProperty.RETENTION_BASIS_IDENTIFIER.name, levelIdentifier, methodName);
        }
        List entities = this.repositoryHandler.getEntitiesForClassificationType(userId, OpenMetadataType.REFERENCEABLE.typeGUID, OpenMetadataType.RETENTION_CLASSIFICATION.typeName, classificationMatchProperties, MatchCriteria.ANY, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, startFrom, queryPageSize, effectiveTime, methodName);
        return super.getValidatedBeans(userId, effectiveTime, forLineage, forDuplicateProcessing, this.supportedZones, methodName, entities);
    }

    public void addGovernanceExpectationsClassification(String userId, String externalSourceGUID, String externalSourceName, String beanGUID, String beanGUIDParameterName, String beanGUIDTypeName, Map<String, Integer> counts, Map<String, String> values, Map<String, Boolean> flags, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        InstanceProperties properties = this.repositoryHelper.addIntMapPropertyToInstance(this.serviceName, null, OpenMetadataProperty.COUNTS.name, counts, methodName);
        properties = this.repositoryHelper.addStringMapPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.VALUES.name, values, methodName);
        properties = this.repositoryHelper.addBooleanMapPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.FLAGS.name, flags, methodName);
        this.setClassificationInRepository(userId, externalSourceGUID, externalSourceName, beanGUID, beanGUIDParameterName, beanGUIDTypeName, OpenMetadataType.GOVERNANCE_EXPECTATIONS_CLASSIFICATION.typeGUID, OpenMetadataType.GOVERNANCE_EXPECTATIONS_CLASSIFICATION.typeName, this.setUpEffectiveDates(properties, effectiveFrom, effectiveTo), true, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void removeGovernanceExpectationsClassification(String userId, String externalSourceGUID, String externalSourceName, String beanGUID, String beanGUIDParameterName, String beanGUIDTypeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.removeClassificationFromRepository(userId, externalSourceGUID, externalSourceName, beanGUID, beanGUIDParameterName, beanGUIDTypeName, OpenMetadataType.GOVERNANCE_EXPECTATIONS_CLASSIFICATION.typeGUID, OpenMetadataType.GOVERNANCE_EXPECTATIONS_CLASSIFICATION.typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void addGovernanceMeasurementsClassification(String userId, String externalSourceGUID, String externalSourceName, String beanGUID, String beanGUIDParameterName, String beanGUIDTypeName, Map<String, Integer> counts, Map<String, String> values, Map<String, Boolean> flags, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        InstanceProperties properties = this.repositoryHelper.addIntMapPropertyToInstance(this.serviceName, null, OpenMetadataProperty.MEASUREMENT_COUNTS.name, counts, methodName);
        properties = this.repositoryHelper.addStringMapPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.MEASUREMENT_VALUES.name, values, methodName);
        properties = this.repositoryHelper.addBooleanMapPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.MEASUREMENT_FLAGS.name, flags, methodName);
        this.setClassificationInRepository(userId, externalSourceGUID, externalSourceName, beanGUID, beanGUIDParameterName, beanGUIDTypeName, OpenMetadataType.GOVERNANCE_MEASUREMENTS_CLASSIFICATION.typeGUID, OpenMetadataType.GOVERNANCE_MEASUREMENTS_CLASSIFICATION.typeName, this.setUpEffectiveDates(properties, effectiveFrom, effectiveTo), true, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void removeGovernanceMeasurementsClassification(String userId, String externalSourceGUID, String externalSourceName, String beanGUID, String beanGUIDParameterName, String beanGUIDTypeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.removeClassificationFromRepository(userId, externalSourceGUID, externalSourceName, beanGUID, beanGUIDParameterName, beanGUIDTypeName, OpenMetadataType.GOVERNANCE_MEASUREMENTS_CLASSIFICATION.typeGUID, OpenMetadataType.GOVERNANCE_MEASUREMENTS_CLASSIFICATION.typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void addSubjectAreaClassification(String userId, String externalSourceGUID, String externalSourceName, String beanGUID, String beanGUIDParameterName, String beanGUIDTypeName, String subjectAreaName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.NAME.name, subjectAreaName, methodName);
        this.setClassificationInRepository(userId, externalSourceGUID, externalSourceName, beanGUID, beanGUIDParameterName, beanGUIDTypeName, OpenMetadataType.SUBJECT_AREA_CLASSIFICATION.typeGUID, OpenMetadataType.SUBJECT_AREA_CLASSIFICATION.typeName, this.setUpEffectiveDates(properties, effectiveFrom, effectiveTo), true, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void removeSubjectAreaClassification(String userId, String externalSourceGUID, String externalSourceName, String beanGUID, String beanGUIDParameterName, String beanGUIDTypeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.removeClassificationFromRepository(userId, externalSourceGUID, externalSourceName, beanGUID, beanGUIDParameterName, beanGUIDTypeName, OpenMetadataType.SUBJECT_AREA_CLASSIFICATION.typeGUID, OpenMetadataType.SUBJECT_AREA_CLASSIFICATION.typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> getSubjectAreaMembers(String userId, String subjectAreaName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getSubjectAreaMembers(userId, subjectAreaName, this.supportedZones, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> getSubjectAreaMembers(String userId, String subjectAreaName, List<String> serviceSupportedZones, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String nameParameterName = "subjectAreaName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(subjectAreaName, "subjectAreaName", methodName);
        int queryPageSize = this.invalidParameterHandler.validatePaging(startFrom, pageSize, methodName);
        InstanceProperties classificationMatchProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.NAME.name, subjectAreaName, methodName);
        List entities = this.repositoryHandler.getEntitiesForClassificationType(userId, OpenMetadataType.REFERENCEABLE.typeGUID, OpenMetadataType.SUBJECT_AREA_CLASSIFICATION.typeName, classificationMatchProperties, MatchCriteria.ANY, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, startFrom, queryPageSize, effectiveTime, methodName);
        return super.getValidatedBeans(userId, effectiveTime, forLineage, forDuplicateProcessing, serviceSupportedZones, methodName, entities);
    }

    public void setBusinessSignificant(String userId, String beanGUID, String beanGUIDParameterName, String beanGUIDTypeName, String description, String scope, String businessCapabilityGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ReferenceableBuilder builder = new ReferenceableBuilder(OpenMetadataType.REFERENCEABLE.typeGUID, OpenMetadataType.REFERENCEABLE.typeName, this.repositoryHelper, this.serviceName, this.serverName);
        this.setClassificationInRepository(userId, null, null, beanGUID, beanGUIDParameterName, beanGUIDTypeName, OpenMetadataType.BUSINESS_SIGNIFICANT_CLASSIFICATION.typeGUID, OpenMetadataType.BUSINESS_SIGNIFICANT_CLASSIFICATION.typeName, builder.getBusinessSignificanceProperties(description, scope, businessCapabilityGUID, methodName), true, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void clearBusinessSignificant(String userId, String beanGUID, String beanGUIDParameterName, String beanGUIDTypeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.removeClassificationFromRepository(userId, null, null, beanGUID, beanGUIDParameterName, beanGUIDTypeName, OpenMetadataType.BUSINESS_SIGNIFICANT_CLASSIFICATION.typeGUID, OpenMetadataType.BUSINESS_SIGNIFICANT_CLASSIFICATION.typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void addTemplateClassification(String userId, String beanGUID, String beanGUIDParameterName, String beanGUIDTypeName, String name, String versionIdentifier, String description, Map<String, String> additionalProperties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ReferenceableBuilder builder = new ReferenceableBuilder(OpenMetadataType.REFERENCEABLE.typeGUID, OpenMetadataType.REFERENCEABLE.typeName, this.repositoryHelper, this.serviceName, this.serverName);
        this.setClassificationInRepository(userId, null, null, beanGUID, beanGUIDParameterName, beanGUIDTypeName, OpenMetadataType.TEMPLATE_CLASSIFICATION.typeGUID, OpenMetadataType.TEMPLATE_CLASSIFICATION.typeName, builder.getTemplateProperties(name, versionIdentifier, description, additionalProperties, methodName), true, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void removeTemplateClassification(String userId, String beanGUID, String beanGUIDParameterName, String beanGUIDTypeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.removeClassificationFromRepository(userId, null, null, beanGUID, beanGUIDParameterName, beanGUIDTypeName, OpenMetadataType.TEMPLATE_CLASSIFICATION.typeGUID, OpenMetadataType.TEMPLATE_CLASSIFICATION.typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> getValidValueConsumers(String userId, String validValueGUID, String validValueGUIDParameter, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getAttachedElements(userId, validValueGUID, validValueGUIDParameter, OpenMetadataType.REFERENCEABLE.typeName, OpenMetadataType.VALID_VALUES_ASSIGNMENT_RELATIONSHIP.typeGUID, OpenMetadataType.VALID_VALUES_ASSIGNMENT_RELATIONSHIP.typeName, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, null, null, 1, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getReferenceValueAssignees(String userId, String validValueGUID, String validValueGUIDParameter, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getAttachedElements(userId, validValueGUID, validValueGUIDParameter, OpenMetadataType.REFERENCEABLE.typeName, OpenMetadataType.REFERENCE_VALUE_ASSIGNMENT_RELATIONSHIP.typeGUID, OpenMetadataType.REFERENCE_VALUE_ASSIGNMENT_RELATIONSHIP.typeName, OpenMetadataType.VALID_VALUE_DEFINITION.typeName, null, null, 1, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, startFrom, pageSize, effectiveTime, methodName);
    }

    public void addMoreInformation(String userId, String externalSourceGUID, String externalSourceName, String elementGUID, String elementGUIDParameterName, String moreInformationGUID, String moreInformationGUIDParameterName, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, elementGUID, elementGUIDParameterName, OpenMetadataType.REFERENCEABLE.typeName, moreInformationGUID, moreInformationGUIDParameterName, OpenMetadataType.REFERENCEABLE.typeName, forLineage, forDuplicateProcessing, this.supportedZones, OpenMetadataType.MORE_INFORMATION_RELATIONSHIP.typeGUID, OpenMetadataType.MORE_INFORMATION_RELATIONSHIP.typeName, this.setUpEffectiveDates(null, effectiveFrom, effectiveTo), effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void removeMoreInformation(String userId, String externalSourceGUID, String externalSourceName, String elementGUID, String elementGUIDParameterName, String moreInformationGUID, String moreInformationGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, elementGUID, elementGUIDParameterName, OpenMetadataType.REFERENCEABLE.typeName, moreInformationGUID, moreInformationGUIDParameterName, OpenMetadataType.REFERENCEABLE.typeGUID, OpenMetadataType.REFERENCEABLE.typeName, forLineage, forDuplicateProcessing, OpenMetadataType.MORE_INFORMATION_RELATIONSHIP.typeGUID, OpenMetadataType.MORE_INFORMATION_RELATIONSHIP.typeName, effectiveTime, methodName);
    }

    public List<B> getMoreInformation(String userId, String startingGUID, String startingGUIDParameterName, String suppliedStartingTypeName, String suppliedResultingTypeName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getMoreInformation(userId, startingGUID, startingGUIDParameterName, suppliedStartingTypeName, suppliedResultingTypeName, this.supportedZones, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> getMoreInformation(String userId, String startingGUID, String startingGUIDParameterName, String suppliedStartingTypeName, String suppliedResultingTypeName, List<String> serviceSupportedZones, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String startingTypeName = OpenMetadataType.REFERENCEABLE.typeName;
        String resultingTypeName = OpenMetadataType.REFERENCEABLE.typeName;
        if (suppliedStartingTypeName != null) {
            startingTypeName = suppliedStartingTypeName;
        }
        if (suppliedResultingTypeName != null) {
            resultingTypeName = suppliedResultingTypeName;
        }
        return this.getAttachedElements(userId, null, null, startingGUID, startingGUIDParameterName, startingTypeName, OpenMetadataType.MORE_INFORMATION_RELATIONSHIP.typeGUID, OpenMetadataType.MORE_INFORMATION_RELATIONSHIP.typeName, resultingTypeName, (String)null, null, 2, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, serviceSupportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getDescriptiveElements(String userId, String startingGUID, String startingGUIDParameterName, String suppliedStartingTypeName, String suppliedResultingTypeName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String startingTypeName = OpenMetadataType.REFERENCEABLE.typeName;
        String resultingTypeName = OpenMetadataType.REFERENCEABLE.typeName;
        if (suppliedStartingTypeName != null) {
            startingTypeName = suppliedStartingTypeName;
        }
        if (suppliedResultingTypeName != null) {
            resultingTypeName = suppliedResultingTypeName;
        }
        return this.getAttachedElements(userId, null, null, startingGUID, startingGUIDParameterName, startingTypeName, OpenMetadataType.MORE_INFORMATION_RELATIONSHIP.typeGUID, OpenMetadataType.MORE_INFORMATION_RELATIONSHIP.typeName, resultingTypeName, (String)null, null, 1, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public void saveSemanticAssignments(String userId, String externalSourceGUID, String externalSourceName, String beanGUID, String beanGUIDParameter, List<String> glossaryTermGUIDs, String glossaryTermGUIDsParameter, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (glossaryTermGUIDs != null) {
            for (String glossaryTermGUID : glossaryTermGUIDs) {
                if (glossaryTermGUID == null) continue;
                this.saveSemanticAssignment(userId, externalSourceGUID, externalSourceName, beanGUID, beanGUIDParameter, glossaryTermGUID, glossaryTermGUIDsParameter, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
        }
    }

    public void saveSemanticAssignment(String userId, String externalSourceGUID, String externalSourceName, String beanGUID, String beanGUIDParameter, String glossaryTermGUID, String glossaryTermGUIDParameter, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, beanGUID, beanGUIDParameter, OpenMetadataType.REFERENCEABLE.typeName, glossaryTermGUID, glossaryTermGUIDParameter, OpenMetadataType.GLOSSARY_TERM.typeName, forLineage, forDuplicateProcessing, this.supportedZones, OpenMetadataType.SEMANTIC_ASSIGNMENT_RELATIONSHIP.typeGUID, OpenMetadataType.SEMANTIC_ASSIGNMENT_RELATIONSHIP.typeName, this.setUpEffectiveDates(null, effectiveFrom, effectiveTo), effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void saveSemanticAssignment(String userId, String externalSourceGUID, String externalSourceName, String beanGUID, String beanGUIDParameter, String glossaryTermGUID, String glossaryTermGUIDParameter, String description, String expression, int statusOrdinal, int confidence, String createdBy, String steward, String source, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.DESCRIPTION.name, description, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.EXPRESSION.name, expression, methodName);
        try {
            properties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.TERM_ASSIGNMENT_STATUS.name, GlossaryTermAssignmentStatus.getOpenTypeGUID(), GlossaryTermAssignmentStatus.getOpenTypeName(), statusOrdinal, methodName);
        }
        catch (TypeErrorException error) {
            this.errorHandler.handleUnsupportedType((Exception)((Object)error), methodName, OpenMetadataProperty.TERM_ASSIGNMENT_STATUS.name);
        }
        properties = this.repositoryHelper.addIntPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.CONFIDENCE.name, confidence, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.STEWARD.name, steward, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.SOURCE.name, source, methodName);
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, beanGUID, beanGUIDParameter, OpenMetadataType.REFERENCEABLE.typeName, glossaryTermGUID, glossaryTermGUIDParameter, OpenMetadataType.GLOSSARY_TERM.typeName, forLineage, forDuplicateProcessing, this.supportedZones, OpenMetadataType.SEMANTIC_ASSIGNMENT_RELATIONSHIP.typeGUID, OpenMetadataType.SEMANTIC_ASSIGNMENT_RELATIONSHIP.typeName, this.setUpEffectiveDates(properties, effectiveFrom, effectiveTo), effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void removeSemanticAssignment(String userId, String externalSourceGUID, String externalSourceName, String beanGUID, String beanGUIDParameter, String glossaryTermGUID, String glossaryTermGUIDParameter, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, beanGUID, beanGUIDParameter, OpenMetadataType.REFERENCEABLE.typeName, glossaryTermGUID, glossaryTermGUIDParameter, OpenMetadataType.GLOSSARY_TERM.typeGUID, OpenMetadataType.GLOSSARY_TERM.typeName, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, OpenMetadataType.SEMANTIC_ASSIGNMENT_RELATIONSHIP.typeGUID, OpenMetadataType.SEMANTIC_ASSIGNMENT_RELATIONSHIP.typeName, effectiveTime, methodName);
    }

    public List<B> getMeanings(String userId, String startingGUID, String startingGUIDParameterName, String suppliedStartingTypeName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String startingTypeName = OpenMetadataType.REFERENCEABLE.typeName;
        String resultingTypeName = OpenMetadataType.GLOSSARY_TERM.typeName;
        if (suppliedStartingTypeName != null) {
            startingTypeName = suppliedStartingTypeName;
        }
        return this.getAttachedElements(userId, null, null, startingGUID, startingGUIDParameterName, startingTypeName, OpenMetadataType.SEMANTIC_ASSIGNMENT_RELATIONSHIP.typeGUID, OpenMetadataType.SEMANTIC_ASSIGNMENT_RELATIONSHIP.typeName, resultingTypeName, (String)null, null, 2, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getSemanticAssignments(String userId, String startingGUID, String startingGUIDParameterName, String suppliedResultingTypeName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String startingTypeName = OpenMetadataType.GLOSSARY_TERM.typeName;
        String resultingTypeName = OpenMetadataType.REFERENCEABLE.typeName;
        if (suppliedResultingTypeName != null) {
            resultingTypeName = suppliedResultingTypeName;
        }
        return this.getAttachedElements(userId, null, null, startingGUID, startingGUIDParameterName, startingTypeName, OpenMetadataType.SEMANTIC_ASSIGNMENT_RELATIONSHIP.typeGUID, OpenMetadataType.SEMANTIC_ASSIGNMENT_RELATIONSHIP.typeName, resultingTypeName, (String)null, null, 1, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public void saveResourceListMember(String userId, String externalSourceGUID, String externalSourceName, String beanGUID, String beanGUIDParameter, String memberGUID, String memberGUIDParameter, String resourceUse, String resourceUseDescription, Map<String, String> resourceUseProperties, boolean watchResource, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.RESOURCE_USE.name, resourceUse, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.RESOURCE_USE_DESCRIPTION.name, resourceUseDescription, methodName);
        properties = this.repositoryHelper.addStringMapPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.RESOURCE_USE_PROPERTIES.name, resourceUseProperties, methodName);
        properties = this.repositoryHelper.addBooleanPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.WATCH_RESOURCE.name, watchResource, methodName);
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, beanGUID, beanGUIDParameter, OpenMetadataType.REFERENCEABLE.typeName, memberGUID, memberGUIDParameter, OpenMetadataType.REFERENCEABLE.typeName, forLineage, forDuplicateProcessing, this.supportedZones, OpenMetadataType.RESOURCE_LIST_RELATIONSHIP.typeGUID, OpenMetadataType.RESOURCE_LIST_RELATIONSHIP.typeName, this.setUpEffectiveDates(properties, effectiveFrom, effectiveTo), effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void removeResourceListMember(String userId, String externalSourceGUID, String externalSourceName, String beanGUID, String beanGUIDParameter, String memberGUID, String memberGUIDParameter, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (beanGUID != null) {
            this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, beanGUID, beanGUIDParameter, OpenMetadataType.REFERENCEABLE.typeName, memberGUID, memberGUIDParameter, OpenMetadataType.REFERENCEABLE.typeGUID, OpenMetadataType.REFERENCEABLE.typeName, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, OpenMetadataType.RESOURCE_LIST_RELATIONSHIP.typeGUID, OpenMetadataType.RESOURCE_LIST_RELATIONSHIP.typeName, effectiveTime, methodName);
        }
    }

    public List<B> getResourceList(String userId, String startingGUID, String startingGUIDParameterName, String suppliedStartingTypeName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String startingTypeName = OpenMetadataType.REFERENCEABLE.typeName;
        String resultingTypeName = OpenMetadataType.REFERENCEABLE.typeName;
        if (suppliedStartingTypeName != null) {
            startingTypeName = suppliedStartingTypeName;
        }
        return this.getAttachedElements(userId, null, null, startingGUID, startingGUIDParameterName, startingTypeName, OpenMetadataType.RESOURCE_LIST_RELATIONSHIP.typeGUID, OpenMetadataType.RESOURCE_LIST_RELATIONSHIP.typeName, resultingTypeName, (String)null, null, 2, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getSupportedByResource(String userId, String startingGUID, String startingGUIDParameterName, String suppliedStartingTypeName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String startingTypeName = OpenMetadataType.REFERENCEABLE.typeName;
        String resultingTypeName = OpenMetadataType.REFERENCEABLE.typeName;
        if (suppliedStartingTypeName != null) {
            startingTypeName = suppliedStartingTypeName;
        }
        return this.getAttachedElements(userId, null, null, startingGUID, startingGUIDParameterName, startingTypeName, OpenMetadataType.RESOURCE_LIST_RELATIONSHIP.typeGUID, OpenMetadataType.RESOURCE_LIST_RELATIONSHIP.typeName, resultingTypeName, (String)null, null, 1, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public void saveCatalogTemplate(String userId, String externalSourceGUID, String externalSourceName, String beanGUID, String beanGUIDParameter, String memberGUID, String memberGUIDParameter, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, beanGUID, beanGUIDParameter, OpenMetadataType.OPEN_METADATA_ROOT.typeName, memberGUID, memberGUIDParameter, OpenMetadataType.OPEN_METADATA_ROOT.typeName, forLineage, forDuplicateProcessing, this.supportedZones, OpenMetadataType.CATALOG_TEMPLATE_RELATIONSHIP.typeGUID, OpenMetadataType.CATALOG_TEMPLATE_RELATIONSHIP.typeName, this.setUpEffectiveDates(null, effectiveFrom, effectiveTo), effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void removeCatalogTemplate(String userId, String externalSourceGUID, String externalSourceName, String beanGUID, String beanGUIDParameter, String memberGUID, String memberGUIDParameter, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (beanGUID != null) {
            this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, beanGUID, beanGUIDParameter, OpenMetadataType.OPEN_METADATA_ROOT.typeName, memberGUID, memberGUIDParameter, OpenMetadataType.OPEN_METADATA_ROOT.typeGUID, OpenMetadataType.OPEN_METADATA_ROOT.typeName, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, OpenMetadataType.CATALOG_TEMPLATE_RELATIONSHIP.typeGUID, OpenMetadataType.CATALOG_TEMPLATE_RELATIONSHIP.typeName, effectiveTime, methodName);
        }
    }

    public List<B> getCatalogTemplateList(String userId, String startingGUID, String startingGUIDParameterName, String suppliedStartingTypeName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String startingTypeName = OpenMetadataType.OPEN_METADATA_ROOT.typeName;
        String resultingTypeName = OpenMetadataType.OPEN_METADATA_ROOT.typeName;
        if (suppliedStartingTypeName != null) {
            startingTypeName = suppliedStartingTypeName;
        }
        return this.getAttachedElements(userId, null, null, startingGUID, startingGUIDParameterName, startingTypeName, OpenMetadataType.CATALOG_TEMPLATE_RELATIONSHIP.typeGUID, OpenMetadataType.CATALOG_TEMPLATE_RELATIONSHIP.typeName, resultingTypeName, (String)null, null, 2, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getSupportedByTemplate(String userId, String startingGUID, String startingGUIDParameterName, String suppliedStartingTypeName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String startingTypeName = OpenMetadataType.OPEN_METADATA_ROOT.typeName;
        String resultingTypeName = OpenMetadataType.OPEN_METADATA_ROOT.typeName;
        if (suppliedStartingTypeName != null) {
            startingTypeName = suppliedStartingTypeName;
        }
        return this.getAttachedElements(userId, null, null, startingGUID, startingGUIDParameterName, startingTypeName, OpenMetadataType.CATALOG_TEMPLATE_RELATIONSHIP.typeGUID, OpenMetadataType.CATALOG_TEMPLATE_RELATIONSHIP.typeName, resultingTypeName, (String)null, null, 1, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public void addAssignmentScope(String userId, String externalSourceGUID, String externalSourceName, String assignedActorGUID, String assignedActorGUIDParameterName, String assignedScopeGUID, String assignedScopeGUIDParameterName, String assignmentType, String description, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.ASSIGNMENT_TYPE.name, assignmentType, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.DESCRIPTION.name, description, methodName);
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, assignedActorGUID, assignedActorGUIDParameterName, OpenMetadataType.REFERENCEABLE.typeName, assignedScopeGUID, assignedScopeGUIDParameterName, OpenMetadataType.REFERENCEABLE.typeName, forLineage, forDuplicateProcessing, this.supportedZones, OpenMetadataType.ASSIGNMENT_SCOPE_RELATIONSHIP.typeGUID, OpenMetadataType.ASSIGNMENT_SCOPE_RELATIONSHIP.typeName, this.setUpEffectiveDates(properties, effectiveFrom, effectiveTo), effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void removeAssignmentScope(String userId, String externalSourceGUID, String externalSourceName, String assignedActorGUID, String assignedActorGUIDParameterName, String assignedScopeGUID, String assignedScopeGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, assignedActorGUID, assignedActorGUIDParameterName, OpenMetadataType.REFERENCEABLE.typeName, assignedScopeGUID, assignedScopeGUIDParameterName, OpenMetadataType.REFERENCEABLE.typeGUID, OpenMetadataType.REFERENCEABLE.typeName, forLineage, forDuplicateProcessing, OpenMetadataType.ASSIGNMENT_SCOPE_RELATIONSHIP.typeGUID, OpenMetadataType.ASSIGNMENT_SCOPE_RELATIONSHIP.typeName, effectiveTime, methodName);
    }

    public List<B> getAssignmentScope(String userId, String startingGUID, String startingGUIDParameterName, String suppliedStartingTypeName, String suppliedResultingTypeName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String startingTypeName = OpenMetadataType.REFERENCEABLE.typeName;
        String resultingTypeName = OpenMetadataType.REFERENCEABLE.typeName;
        if (suppliedStartingTypeName != null) {
            startingTypeName = suppliedStartingTypeName;
        }
        if (suppliedResultingTypeName != null) {
            resultingTypeName = suppliedResultingTypeName;
        }
        return this.getAttachedElements(userId, null, null, startingGUID, startingGUIDParameterName, startingTypeName, OpenMetadataType.ASSIGNMENT_SCOPE_RELATIONSHIP.typeGUID, OpenMetadataType.ASSIGNMENT_SCOPE_RELATIONSHIP.typeName, resultingTypeName, (String)null, null, 2, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getAssignedActors(String userId, String startingGUID, String startingGUIDParameterName, String suppliedStartingTypeName, String suppliedResultingTypeName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String startingTypeName = OpenMetadataType.REFERENCEABLE.typeName;
        String resultingTypeName = OpenMetadataType.REFERENCEABLE.typeName;
        if (suppliedStartingTypeName != null) {
            startingTypeName = suppliedStartingTypeName;
        }
        if (suppliedResultingTypeName != null) {
            resultingTypeName = suppliedResultingTypeName;
        }
        return this.getAttachedElements(userId, null, null, startingGUID, startingGUIDParameterName, startingTypeName, OpenMetadataType.ASSIGNMENT_SCOPE_RELATIONSHIP.typeGUID, OpenMetadataType.ASSIGNMENT_SCOPE_RELATIONSHIP.typeName, resultingTypeName, (String)null, null, 1, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public void addStakeholder(String userId, String externalSourceGUID, String externalSourceName, String commissionedGUID, String commissionedGUIDParameterName, String stakeholderGUID, String stakeholderGUIDParameterName, String stakeholderRole, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.STAKEHOLDER_ROLE.name, stakeholderRole, methodName);
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, commissionedGUID, commissionedGUIDParameterName, OpenMetadataType.REFERENCEABLE.typeName, stakeholderGUID, stakeholderGUIDParameterName, OpenMetadataType.REFERENCEABLE.typeName, forLineage, forDuplicateProcessing, this.supportedZones, OpenMetadataType.STAKEHOLDER_RELATIONSHIP.typeGUID, OpenMetadataType.STAKEHOLDER_RELATIONSHIP.typeName, this.setUpEffectiveDates(properties, effectiveFrom, effectiveTo), effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void removeStakeholder(String userId, String externalSourceGUID, String externalSourceName, String commissionedGUID, String commissionedGUIDParameterName, String stakeholderGUID, String stakeholderGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, commissionedGUID, commissionedGUIDParameterName, OpenMetadataType.REFERENCEABLE.typeName, stakeholderGUID, stakeholderGUIDParameterName, OpenMetadataType.REFERENCEABLE.typeGUID, OpenMetadataType.REFERENCEABLE.typeName, forLineage, forDuplicateProcessing, OpenMetadataType.STAKEHOLDER_RELATIONSHIP.typeGUID, OpenMetadataType.STAKEHOLDER_RELATIONSHIP.typeName, effectiveTime, methodName);
    }

    public List<B> getStakeholders(String userId, String startingGUID, String startingGUIDParameterName, String suppliedStartingTypeName, String suppliedResultingTypeName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String startingTypeName = OpenMetadataType.REFERENCEABLE.typeName;
        String resultingTypeName = OpenMetadataType.REFERENCEABLE.typeName;
        if (suppliedStartingTypeName != null) {
            startingTypeName = suppliedStartingTypeName;
        }
        if (suppliedResultingTypeName != null) {
            resultingTypeName = suppliedResultingTypeName;
        }
        return this.getAttachedElements(userId, null, null, startingGUID, startingGUIDParameterName, startingTypeName, OpenMetadataType.STAKEHOLDER_RELATIONSHIP.typeGUID, OpenMetadataType.STAKEHOLDER_RELATIONSHIP.typeName, resultingTypeName, (String)null, null, 2, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getCommissionedByStakeholder(String userId, String startingGUID, String startingGUIDParameterName, String suppliedStartingTypeName, String suppliedResultingTypeName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String startingTypeName = OpenMetadataType.REFERENCEABLE.typeName;
        String resultingTypeName = OpenMetadataType.REFERENCEABLE.typeName;
        if (suppliedStartingTypeName != null) {
            startingTypeName = suppliedStartingTypeName;
        }
        if (suppliedResultingTypeName != null) {
            resultingTypeName = suppliedResultingTypeName;
        }
        return this.getAttachedElements(userId, null, null, startingGUID, startingGUIDParameterName, startingTypeName, OpenMetadataType.STAKEHOLDER_RELATIONSHIP.typeGUID, OpenMetadataType.STAKEHOLDER_RELATIONSHIP.typeName, resultingTypeName, (String)null, null, 1, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getSourceElements(String userId, String startingGUID, String startingGUIDParameterName, String suppliedStartingTypeName, String suppliedResultingTypeName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String startingTypeName = OpenMetadataType.REFERENCEABLE.typeName;
        String resultingTypeName = OpenMetadataType.REFERENCEABLE.typeName;
        if (suppliedStartingTypeName != null) {
            startingTypeName = suppliedStartingTypeName;
        }
        if (suppliedResultingTypeName != null) {
            resultingTypeName = suppliedResultingTypeName;
        }
        return this.getAttachedElements(userId, null, null, startingGUID, startingGUIDParameterName, startingTypeName, OpenMetadataType.SOURCED_FROM_RELATIONSHIP.typeGUID, OpenMetadataType.SOURCED_FROM_RELATIONSHIP.typeName, resultingTypeName, (String)null, null, 2, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getElementsSourceFrom(String userId, String startingGUID, String startingGUIDParameterName, String suppliedStartingTypeName, String suppliedResultingTypeName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String startingTypeName = OpenMetadataType.REFERENCEABLE.typeName;
        String resultingTypeName = OpenMetadataType.REFERENCEABLE.typeName;
        if (suppliedStartingTypeName != null) {
            startingTypeName = suppliedStartingTypeName;
        }
        if (suppliedResultingTypeName != null) {
            resultingTypeName = suppliedResultingTypeName;
        }
        return this.getAttachedElements(userId, null, null, startingGUID, startingGUIDParameterName, startingTypeName, OpenMetadataType.SOURCED_FROM_RELATIONSHIP.typeGUID, OpenMetadataType.SOURCED_FROM_RELATIONSHIP.typeName, resultingTypeName, (String)null, null, 1, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public void addGovernedBy(String userId, String externalSourceGUID, String externalSourceName, String governanceDefinitionGUID, String governanceDefinitionGUIDParameterName, String referenceableGUID, String referenceableGUIDParameterName, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, referenceableGUID, referenceableGUIDParameterName, OpenMetadataType.REFERENCEABLE.typeName, governanceDefinitionGUID, governanceDefinitionGUIDParameterName, OpenMetadataType.GOVERNANCE_DEFINITION.typeName, forLineage, forDuplicateProcessing, this.supportedZones, OpenMetadataType.GOVERNED_BY_RELATIONSHIP.typeGUID, OpenMetadataType.GOVERNED_BY_RELATIONSHIP.typeName, this.setUpEffectiveDates(null, effectiveFrom, effectiveTo), effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void removeGovernedBy(String userId, String externalSourceGUID, String externalSourceName, String governanceDefinitionGUID, String governanceDefinitionGUIDParameterName, String referenceableGUID, String referenceableGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, referenceableGUID, referenceableGUIDParameterName, OpenMetadataType.REFERENCEABLE.typeName, governanceDefinitionGUID, governanceDefinitionGUIDParameterName, OpenMetadataType.GOVERNANCE_DEFINITION.typeGUID, OpenMetadataType.GOVERNANCE_DEFINITION.typeName, forLineage, forDuplicateProcessing, OpenMetadataType.GOVERNED_BY_RELATIONSHIP.typeGUID, OpenMetadataType.GOVERNED_BY_RELATIONSHIP.typeName, effectiveTime, methodName);
    }

    public List<B> getGovernedElements(String userId, String governanceDefinitionGUID, String governanceDefinitionGUIDParameterName, String suppliedResultingTypeName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String resultingTypeName = OpenMetadataType.REFERENCEABLE.typeName;
        if (suppliedResultingTypeName != null) {
            resultingTypeName = suppliedResultingTypeName;
        }
        return this.getAttachedElements(userId, null, null, governanceDefinitionGUID, governanceDefinitionGUIDParameterName, OpenMetadataType.GOVERNANCE_DEFINITION.typeName, OpenMetadataType.GOVERNED_BY_RELATIONSHIP.typeGUID, OpenMetadataType.GOVERNED_BY_RELATIONSHIP.typeName, resultingTypeName, (String)null, null, 1, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public void addGovernanceDefinitionScope(String userId, String externalSourceGUID, String externalSourceName, String governanceDefinitionGUID, String governanceDefinitionGUIDParameterName, String referenceableGUID, String referenceableGUIDParameterName, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, governanceDefinitionGUID, governanceDefinitionGUIDParameterName, OpenMetadataType.GOVERNANCE_DEFINITION.typeName, referenceableGUID, referenceableGUIDParameterName, OpenMetadataType.REFERENCEABLE.typeName, forLineage, forDuplicateProcessing, this.supportedZones, OpenMetadataType.GOVERNANCE_DEFINITION_SCOPE.typeGUID, OpenMetadataType.GOVERNANCE_DEFINITION_SCOPE.typeName, this.setUpEffectiveDates(null, effectiveFrom, effectiveTo), effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void removeGovernanceDefinitionScope(String userId, String externalSourceGUID, String externalSourceName, String governanceDefinitionGUID, String governanceDefinitionGUIDParameterName, String referenceableGUID, String referenceableGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, governanceDefinitionGUID, governanceDefinitionGUIDParameterName, OpenMetadataType.GOVERNANCE_DEFINITION.typeName, referenceableGUID, referenceableGUIDParameterName, OpenMetadataType.REFERENCEABLE.typeGUID, OpenMetadataType.REFERENCEABLE.typeName, forLineage, forDuplicateProcessing, OpenMetadataType.GOVERNANCE_DEFINITION_SCOPE.typeGUID, OpenMetadataType.GOVERNANCE_DEFINITION_SCOPE.typeName, effectiveTime, methodName);
    }

    public List<B> getGovernanceDefinitionScope(String userId, String governanceDefinitionGUID, String governanceDefinitionGUIDParameterName, String suppliedResultingTypeName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String resultingTypeName = OpenMetadataType.REFERENCEABLE.typeName;
        if (suppliedResultingTypeName != null) {
            resultingTypeName = suppliedResultingTypeName;
        }
        return this.getAttachedElements(userId, null, null, governanceDefinitionGUID, governanceDefinitionGUIDParameterName, OpenMetadataType.GOVERNANCE_DEFINITION.typeName, OpenMetadataType.GOVERNANCE_DEFINITION_SCOPE.typeGUID, OpenMetadataType.GOVERNANCE_DEFINITION_SCOPE.typeName, resultingTypeName, (String)null, null, 2, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public void addImplementedBy(String userId, String externalSourceGUID, String externalSourceName, String designArtifactGUID, String designArtifactGUIDParameterName, String implementationGUID, String implementationGUIDParameterName, String designStep, String role, String description, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.DESIGN_STEP.name, designStep, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.ROLE.name, role, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.DESCRIPTION.name, description, methodName);
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, designArtifactGUID, designArtifactGUIDParameterName, OpenMetadataType.REFERENCEABLE.typeName, implementationGUID, implementationGUIDParameterName, OpenMetadataType.REFERENCEABLE.typeName, forLineage, forDuplicateProcessing, this.supportedZones, OpenMetadataType.IMPLEMENTED_BY_RELATIONSHIP.typeGUID, OpenMetadataType.IMPLEMENTED_BY_RELATIONSHIP.typeName, this.setUpEffectiveDates(properties, effectiveFrom, effectiveTo), effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void removeImplementedBy(String userId, String externalSourceGUID, String externalSourceName, String designArtifactGUID, String designArtifactGUIDParameterName, String implementationGUID, String implementationGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, designArtifactGUID, designArtifactGUIDParameterName, OpenMetadataType.REFERENCEABLE.typeName, implementationGUID, implementationGUIDParameterName, OpenMetadataType.REFERENCEABLE.typeGUID, OpenMetadataType.REFERENCEABLE.typeName, forLineage, forDuplicateProcessing, OpenMetadataType.IMPLEMENTED_BY_RELATIONSHIP.typeGUID, OpenMetadataType.IMPLEMENTED_BY_RELATIONSHIP.typeName, effectiveTime, methodName);
    }

    public List<B> getCollectionMembers(String userId, String collectionGUID, String collectionGUIDParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getAttachedElements(userId, collectionGUID, collectionGUIDParameterName, OpenMetadataType.COLLECTION.typeName, OpenMetadataType.COLLECTION_MEMBERSHIP_RELATIONSHIP.typeGUID, OpenMetadataType.COLLECTION_MEMBERSHIP_RELATIONSHIP.typeName, OpenMetadataType.REFERENCEABLE.typeName, null, null, 0, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, startFrom, pageSize, effectiveTime, methodName);
    }

    private void setKnowDuplicateClassification(String userId, EntityDetail entity, String guidParameterName, List<String> serviceSupportedZones, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        boolean classificationNeeded = true;
        try {
            if (this.repositoryHelper.getClassificationFromEntity(this.serviceName, (EntitySummary)entity, OpenMetadataType.KNOWN_DUPLICATE_CLASSIFICATION.typeName, methodName) != null) {
                classificationNeeded = false;
            }
        }
        catch (ClassificationErrorException classificationErrorException) {
            // empty catch block
        }
        if (classificationNeeded) {
            this.setClassificationInRepository(userId, null, null, entity, guidParameterName, OpenMetadataType.REFERENCEABLE.typeName, OpenMetadataType.KNOWN_DUPLICATE_CLASSIFICATION.typeGUID, OpenMetadataType.KNOWN_DUPLICATE_CLASSIFICATION.typeName, null, true, false, true, serviceSupportedZones, new Date(), methodName);
        }
    }

    private InstanceProperties createStewardshipProperties(int statusIdentifier, String steward, String stewardTypeName, String stewardPropertyName, String source, String notes, String methodName) {
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.STEWARD.name, steward, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.STEWARD_TYPE_NAME.name, stewardTypeName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.STEWARD_PROPERTY_NAME.name, stewardPropertyName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.SOURCE.name, source, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.NOTES.name, notes, methodName);
        properties = this.repositoryHelper.addIntPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.STATUS_IDENTIFIER.name, statusIdentifier, methodName);
        return properties;
    }

    public void linkElementsAsPeerDuplicates(String userId, String element1GUID, String element1GUIDParameter, String element2GUID, String element2GUIDParameter, boolean setKnownDuplicate, int statusIdentifier, String steward, String stewardTypeName, String stewardPropertyName, String source, String notes, List<String> serviceSupportedZones, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(element1GUID, element1GUIDParameter, methodName);
        this.invalidParameterHandler.validateGUID(element2GUID, element2GUIDParameter, methodName);
        EntityDetail entity1 = this.getEntityFromRepository(userId, element1GUID, element1GUIDParameter, OpenMetadataType.REFERENCEABLE.typeName, null, null, false, true, serviceSupportedZones, null, methodName);
        EntityDetail entity2 = this.getEntityFromRepository(userId, element2GUID, element2GUIDParameter, OpenMetadataType.REFERENCEABLE.typeName, null, null, false, true, serviceSupportedZones, null, methodName);
        if (setKnownDuplicate) {
            this.setKnowDuplicateClassification(userId, entity1, element1GUIDParameter, serviceSupportedZones, methodName);
            this.setKnowDuplicateClassification(userId, entity2, element2GUIDParameter, serviceSupportedZones, methodName);
        }
        InstanceProperties properties = this.createStewardshipProperties(statusIdentifier, steward, stewardTypeName, stewardPropertyName, source, notes, methodName);
        this.linkElementToElement(userId, null, null, element1GUID, element1GUIDParameter, OpenMetadataType.REFERENCEABLE.typeName, element2GUID, element2GUIDParameter, OpenMetadataType.REFERENCEABLE.typeName, false, true, serviceSupportedZones, OpenMetadataType.PEER_DUPLICATE_LINK.typeGUID, OpenMetadataType.PEER_DUPLICATE_LINK.typeName, properties, null, null, null, methodName);
    }

    public void unlinkElementsAsPeerDuplicates(String userId, String element1GUID, String element1GUIDParameter, String element2GUID, String element2GUIDParameter, List<String> serviceSupportedZones, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(element1GUID, element1GUIDParameter, methodName);
        this.invalidParameterHandler.validateGUID(element2GUID, element2GUIDParameter, methodName);
        this.repositoryHandler.removeRelationshipBetweenEntities(userId, null, null, OpenMetadataType.PEER_DUPLICATE_LINK.typeGUID, OpenMetadataType.PEER_DUPLICATE_LINK.typeName, element1GUID, OpenMetadataType.REFERENCEABLE.typeName, element2GUID, null, null, SequencingOrder.CREATION_DATE_RECENT, null, true, true, null, methodName);
        if (this.getAttachmentLinks(userId, element1GUID, element1GUIDParameter, OpenMetadataType.REFERENCEABLE.typeName, OpenMetadataType.PEER_DUPLICATE_LINK.typeGUID, OpenMetadataType.PEER_DUPLICATE_LINK.typeName, null, null, 0, null, null, SequencingOrder.CREATION_DATE_RECENT, null, true, true, serviceSupportedZones, 0, this.invalidParameterHandler.getMaxPagingSize(), null, methodName) == null) {
            this.removeClassificationFromRepository(userId, null, null, element1GUID, element1GUIDParameter, OpenMetadataType.REFERENCEABLE.typeName, OpenMetadataType.KNOWN_DUPLICATE_CLASSIFICATION.typeGUID, OpenMetadataType.KNOWN_DUPLICATE_CLASSIFICATION.typeName, true, true, serviceSupportedZones, null, methodName);
        }
        if (this.getAttachmentLinks(userId, element2GUID, element2GUIDParameter, OpenMetadataType.REFERENCEABLE.typeName, OpenMetadataType.PEER_DUPLICATE_LINK.typeGUID, OpenMetadataType.PEER_DUPLICATE_LINK.typeName, null, null, 0, null, null, SequencingOrder.CREATION_DATE_RECENT, null, false, true, serviceSupportedZones, 0, this.invalidParameterHandler.getMaxPagingSize(), null, methodName) == null) {
            this.removeClassificationFromRepository(userId, null, null, element2GUID, element2GUIDParameter, OpenMetadataType.REFERENCEABLE.typeName, OpenMetadataType.KNOWN_DUPLICATE_CLASSIFICATION.typeGUID, OpenMetadataType.KNOWN_DUPLICATE_CLASSIFICATION.typeName, false, true, serviceSupportedZones, null, methodName);
        }
    }

    private void setConsolidatedDuplicateClassification(String userId, EntityDetail entity, String guidParameterName, int statusIdentifier, String steward, String stewardTypeName, String stewardPropertyName, String source, String notes, List<String> serviceSupportedZones, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        InstanceProperties properties = this.createStewardshipProperties(statusIdentifier, steward, stewardTypeName, stewardPropertyName, source, notes, methodName);
        this.setClassificationInRepository(userId, null, null, entity, guidParameterName, OpenMetadataType.REFERENCEABLE.typeName, OpenMetadataType.CONSOLIDATED_DUPLICATE_CLASSIFICATION.typeGUID, OpenMetadataType.CONSOLIDATED_DUPLICATE_CLASSIFICATION.typeName, properties, false, false, true, serviceSupportedZones, null, methodName);
    }

    public void linkConsolidatedDuplicate(String userId, String consolidatedElementGUID, String consolidatedElementGUIDParameter, int statusIdentifier, String steward, String stewardTypeName, String stewardPropertyName, String source, String notes, List<String> sourceElementGUIDs, String sourceElementGUIDsParameterName, List<String> serviceSupportedZones, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(consolidatedElementGUID, consolidatedElementGUIDParameter, methodName);
        EntityDetail consolidatedEntity = this.getEntityFromRepository(userId, consolidatedElementGUID, consolidatedElementGUIDParameter, OpenMetadataType.REFERENCEABLE.typeName, null, null, false, true, serviceSupportedZones, null, methodName);
        if (consolidatedEntity != null) {
            this.setConsolidatedDuplicateClassification(userId, consolidatedEntity, consolidatedElementGUIDParameter, statusIdentifier, steward, stewardTypeName, stewardPropertyName, source, notes, serviceSupportedZones, methodName);
            if (sourceElementGUIDs != null) {
                for (String sourceElementGUID : sourceElementGUIDs) {
                    if (sourceElementGUID == null) continue;
                    this.linkElementToElement(userId, null, null, sourceElementGUID, sourceElementGUIDsParameterName, OpenMetadataType.REFERENCEABLE.typeName, consolidatedElementGUID, consolidatedElementGUIDParameter, OpenMetadataType.REFERENCEABLE.typeName, false, true, serviceSupportedZones, OpenMetadataType.CONSOLIDATED_DUPLICATE_LINK.typeGUID, OpenMetadataType.CONSOLIDATED_DUPLICATE_LINK.typeName, null, null, null, null, methodName);
                }
            }
        }
    }

    public void setVendorProperties(String userId, String referenceableGUID, Map<String, String> vendorProperties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        block5: {
            List<EntityDetail> propertyFacets;
            block4: {
                String referenceableGUIDParameter = "referenceableGUID";
                String propertyFacetGUIDParameter = "propertyFacet[x]";
                this.invalidParameterHandler.validateUserId(userId, methodName);
                this.invalidParameterHandler.validateGUID(referenceableGUID, "referenceableGUID", methodName);
                propertyFacets = this.getAttachedEntities(userId, referenceableGUID, "referenceableGUID", OpenMetadataType.REFERENCEABLE.typeName, OpenMetadataType.REFERENCEABLE_FACET.typeGUID, OpenMetadataType.REFERENCEABLE_FACET.typeName, OpenMetadataType.PROPERTY_FACET.typeName, null, null, 2, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, 0, this.invalidParameterHandler.getMaxPagingSize(), effectiveTime, methodName);
                if (vendorProperties == null) break block4;
                PropertyFacetBuilder builder = new PropertyFacetBuilder(referenceableGUID + "_vendorProperties", null, "vendorProperties", vendorProperties, this.repositoryHelper, this.serviceName, this.serverName);
                if (propertyFacets != null) {
                    for (EntityDetail propertyFacet : propertyFacets) {
                        String description;
                        if (propertyFacet == null || !"vendorProperties".equals(description = this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.DESCRIPTION.name, propertyFacet.getProperties(), methodName))) continue;
                        this.updateBeanInRepository(userId, null, null, propertyFacet.getGUID(), "propertyFacet[x]", OpenMetadataType.PROPERTY_FACET.typeGUID, OpenMetadataType.PROPERTY_FACET.typeName, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, builder.getInstanceProperties(methodName), true, effectiveTime, methodName);
                    }
                } else {
                    this.addAnchorGUIDToBuilder(userId, referenceableGUID, "referenceableGUID", forLineage, forDuplicateProcessing, effectiveTime, this.supportedZones, builder, methodName);
                    String propertyFacetGUID = this.createBeanInRepository(userId, null, null, OpenMetadataType.PROPERTY_FACET.typeGUID, OpenMetadataType.PROPERTY_FACET.typeName, builder, effectiveTime, methodName);
                    InstanceProperties relationshipProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.SOURCE.name, this.serviceName, methodName);
                    this.linkElementToElement(userId, null, null, referenceableGUID, "referenceableGUID", OpenMetadataType.REFERENCEABLE.typeName, propertyFacetGUID, "propertyFacet[x]", OpenMetadataType.PROPERTY_FACET.typeName, forLineage, forDuplicateProcessing, this.supportedZones, OpenMetadataType.REFERENCEABLE_FACET.typeGUID, OpenMetadataType.REFERENCEABLE_FACET.typeName, relationshipProperties, null, null, effectiveTime, methodName);
                }
                break block5;
            }
            if (propertyFacets == null) break block5;
            for (EntityDetail propertyFacet : propertyFacets) {
                String description;
                if (propertyFacet == null || !"vendorProperties".equals(description = this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.DESCRIPTION.name, propertyFacet.getProperties(), methodName))) continue;
                this.deleteBeanInRepository(userId, null, null, propertyFacet.getGUID(), "propertyFacet[x]", OpenMetadataType.PROPERTY_FACET.typeGUID, OpenMetadataType.PROPERTY_FACET.typeName, false, null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
        }
    }

    public Map<String, String> getVendorProperties(String userId, String referenceableGUID, String referenceableGUIDParameter, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List<EntityDetail> propertyFacets = this.getAttachedEntities(userId, referenceableGUID, referenceableGUIDParameter, OpenMetadataType.REFERENCEABLE.typeName, OpenMetadataType.REFERENCEABLE_FACET.typeGUID, OpenMetadataType.REFERENCEABLE_FACET.typeName, OpenMetadataType.PROPERTY_FACET.typeName, null, null, 0, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, 0, this.invalidParameterHandler.getMaxPagingSize(), effectiveTime, methodName);
        if (propertyFacets != null) {
            for (EntityDetail propertyFacet : propertyFacets) {
                String description;
                if (propertyFacet == null || !"vendorProperties".equals(description = this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.DESCRIPTION.name, propertyFacet.getProperties(), methodName))) continue;
                return this.repositoryHelper.getStringMapFromProperty(this.serviceName, OpenMetadataProperty.PROPERTIES.name, propertyFacet.getProperties(), methodName);
            }
        }
        return null;
    }
}

