/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.AssetHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIAnchorHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaAttributeBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaAttributeHandler;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaTypeBuilder;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryErrorHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.enums.KeyPattern;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ServerAssetUseType;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.OMFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceStatus;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.InvalidParameterException;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;

public class RelationalDataHandler<DATABASE, DATABASE_SCHEMA, DATABASE_TABLE, DATABASE_VIEW, DATABASE_COLUMN, SCHEMA_TYPE> {
    private final String serviceName;
    private final String serverName;
    private final OMRSRepositoryHelper repositoryHelper;
    private final InvalidParameterHandler invalidParameterHandler;
    private final AssetHandler<DATABASE> databaseHandler;
    private final AssetHandler<DATABASE_SCHEMA> databaseSchemaHandler;
    private final SchemaAttributeHandler<DATABASE_TABLE, SCHEMA_TYPE> databaseTableHandler;
    private final SchemaAttributeHandler<DATABASE_VIEW, SCHEMA_TYPE> databaseViewHandler;
    private final SchemaAttributeHandler<DATABASE_COLUMN, SCHEMA_TYPE> databaseColumnHandler;
    protected RepositoryErrorHandler errorHandler;

    public RelationalDataHandler(OpenMetadataAPIGenericConverter<DATABASE> databaseConverter, Class<DATABASE> databaseClass, OpenMetadataAPIGenericConverter<DATABASE_SCHEMA> databaseSchemaConverter, Class<DATABASE_SCHEMA> databaseSchemaClass, OpenMetadataAPIGenericConverter<DATABASE_TABLE> databaseTableConverter, Class<DATABASE_TABLE> databaseTableClass, OpenMetadataAPIGenericConverter<DATABASE_VIEW> databaseViewConverter, Class<DATABASE_VIEW> databaseViewClass, OpenMetadataAPIGenericConverter<DATABASE_COLUMN> databaseColumnConverter, Class<DATABASE_COLUMN> databaseColumnClass, OpenMetadataAPIGenericConverter<SCHEMA_TYPE> schemaTypeConverter, Class<SCHEMA_TYPE> schemaTypeClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        this.serviceName = serviceName;
        this.serverName = serverName;
        this.invalidParameterHandler = invalidParameterHandler;
        this.repositoryHelper = repositoryHelper;
        this.databaseHandler = new AssetHandler<DATABASE>(databaseConverter, databaseClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.databaseSchemaHandler = new AssetHandler<DATABASE_SCHEMA>(databaseSchemaConverter, databaseSchemaClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.databaseTableHandler = new SchemaAttributeHandler<DATABASE_TABLE, SCHEMA_TYPE>(databaseTableConverter, databaseTableClass, schemaTypeConverter, schemaTypeClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.databaseViewHandler = new SchemaAttributeHandler<DATABASE_VIEW, SCHEMA_TYPE>(databaseViewConverter, databaseViewClass, schemaTypeConverter, schemaTypeClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.databaseColumnHandler = new SchemaAttributeHandler<DATABASE_COLUMN, SCHEMA_TYPE>(databaseColumnConverter, databaseColumnClass, schemaTypeConverter, schemaTypeClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.errorHandler = new RepositoryErrorHandler(repositoryHelper, serviceName, serverName, auditLog);
    }

    public String createDatabase(String userId, String databaseManagerGUID, String databaseManagerName, String qualifiedName, String name, String resourceName, String versionIdentifier, String description, String pathName, Date createTime, Date modifiedTime, String encodingType, String encodingLanguage, String encodingDescription, Map<String, String> encodingProperties, String deployedImplementationType, String databaseVersion, String databaseInstance, String databaseImportedFrom, Map<String, String> additionalProperties, String typeName, Map<String, Object> extendedProperties, Map<String, String> vendorProperties, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String databaseManagerGUIDParameterName = "databaseManagerGUID";
        String databaseGUIDParameterName = "databaseGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        this.databaseHandler.verifyExternalSourceIdentity(userId, databaseManagerGUID, databaseManagerName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        String assetTypeName = OpenMetadataType.DATABASE.typeName;
        if (typeName != null) {
            assetTypeName = typeName;
        }
        HashMap<String, Object> assetExtendedProperties = new HashMap<String, Object>();
        if (extendedProperties != null) {
            assetExtendedProperties.putAll(extendedProperties);
        }
        assetExtendedProperties.put(OpenMetadataProperty.PATH_NAME.name, pathName);
        assetExtendedProperties.put(OpenMetadataProperty.STORE_CREATE_TIME.name, createTime);
        assetExtendedProperties.put(OpenMetadataProperty.STORE_UPDATE_TIME.name, modifiedTime);
        assetExtendedProperties.put(OpenMetadataProperty.DATABASE_VERSION.name, databaseVersion);
        assetExtendedProperties.put(OpenMetadataProperty.INSTANCE.name, databaseInstance);
        assetExtendedProperties.put(OpenMetadataProperty.IMPORTED_FROM.name, databaseImportedFrom);
        String databaseGUID = this.databaseHandler.createAssetInRepository(userId, databaseManagerGUID, databaseManagerName, qualifiedName, name, resourceName, versionIdentifier, description, deployedImplementationType, additionalProperties, assetTypeName, assetExtendedProperties, InstanceStatus.ACTIVE, effectiveFrom, effectiveTo, effectiveTime, methodName);
        if (databaseGUID != null) {
            if (encodingType != null || encodingLanguage != null || encodingDescription != null) {
                InstanceProperties classificationProperties = this.getEncodingProperties(encodingType, encodingLanguage, encodingDescription, encodingProperties, methodName);
                this.databaseHandler.setClassificationInRepository(userId, databaseManagerGUID, databaseManagerName, databaseGUID, "databaseGUID", OpenMetadataType.DATABASE.typeName, OpenMetadataType.DATA_ASSET_ENCODING_CLASSIFICATION.typeGUID, OpenMetadataType.DATA_ASSET_ENCODING_CLASSIFICATION.typeName, classificationProperties, true, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
            this.databaseHandler.setVendorProperties(userId, databaseGUID, vendorProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            try {
                InstanceProperties relationshipProperties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, null, OpenMetadataProperty.USE_TYPE.name, ServerAssetUseType.getOpenTypeGUID(), ServerAssetUseType.getOpenTypeName(), ServerAssetUseType.OWNS.getOrdinal(), methodName);
                this.databaseHandler.linkElementToElement(userId, databaseManagerGUID, databaseManagerName, databaseManagerGUID, "databaseManagerGUID", OpenMetadataType.SOFTWARE_CAPABILITY.typeName, databaseGUID, "databaseGUID", OpenMetadataType.DATABASE.typeName, forLineage, forDuplicateProcessing, OpenMetadataType.SERVER_ASSET_USE_RELATIONSHIP.typeGUID, OpenMetadataType.SERVER_ASSET_USE_RELATIONSHIP.typeName, relationshipProperties, effectiveFrom, effectiveTo, effectiveTime, methodName);
            }
            catch (TypeErrorException error) {
                throw new org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException((OMFCheckedExceptionBase)error, OpenMetadataProperty.USE_TYPE.name);
            }
        }
        return databaseGUID;
    }

    public String createDatabaseFromTemplate(String userId, String databaseManagerGUID, String databaseManagerName, String templateGUID, String qualifiedName, String technicalName, String versionIdentifier, String description, String pathName, String networkAddress, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        return this.databaseHandler.addAssetFromTemplate(userId, databaseManagerGUID, databaseManagerName, templateGUID, "templateGUID", OpenMetadataType.DATABASE.typeGUID, OpenMetadataType.DATABASE.typeName, qualifiedName, "qualifiedName", technicalName, versionIdentifier, description, null, pathName, networkAddress, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void updateDatabase(String userId, String databaseManagerGUID, String databaseManagerName, String databaseGUID, String qualifiedName, String name, String resourceName, String versionIdentifier, String description, String pathName, Date createTime, Date modifiedTime, String encodingType, String encodingLanguage, String encodingDescription, Map<String, String> encodingProperties, String deployedImplementationType, String databaseVersion, String databaseInstance, String databaseImportedFrom, Map<String, String> additionalProperties, String typeName, Map<String, Object> extendedProperties, Map<String, String> vendorProperties, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementGUIDParameterName = "databaseGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(databaseGUID, "databaseGUID", methodName);
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        }
        String assetTypeName = OpenMetadataType.DATABASE.typeName;
        if (typeName != null) {
            assetTypeName = typeName;
        }
        HashMap<String, Object> assetExtendedProperties = new HashMap<String, Object>();
        if (extendedProperties != null) {
            assetExtendedProperties.putAll(extendedProperties);
        }
        assetExtendedProperties.put(OpenMetadataProperty.PATH_NAME.name, pathName);
        assetExtendedProperties.put(OpenMetadataProperty.STORE_CREATE_TIME.name, createTime);
        assetExtendedProperties.put(OpenMetadataProperty.STORE_UPDATE_TIME.name, modifiedTime);
        assetExtendedProperties.put(OpenMetadataProperty.DATABASE_VERSION.name, databaseVersion);
        assetExtendedProperties.put(OpenMetadataProperty.INSTANCE.name, databaseInstance);
        assetExtendedProperties.put(OpenMetadataProperty.IMPORTED_FROM.name, databaseImportedFrom);
        this.databaseHandler.updateAsset(userId, databaseManagerGUID, databaseManagerName, databaseGUID, "databaseGUID", qualifiedName, name, resourceName, versionIdentifier, description, deployedImplementationType, additionalProperties, assetTypeName, assetExtendedProperties, effectiveFrom, effectiveTo, isMergeUpdate, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (encodingType != null || encodingLanguage != null || encodingDescription != null) {
            InstanceProperties classificationProperties = this.getEncodingProperties(encodingType, encodingLanguage, encodingDescription, encodingProperties, methodName);
            this.databaseHandler.setClassificationInRepository(userId, databaseManagerGUID, databaseManagerName, databaseGUID, "databaseGUID", OpenMetadataType.DATABASE.typeName, OpenMetadataType.DATA_ASSET_ENCODING_CLASSIFICATION.typeGUID, OpenMetadataType.DATA_ASSET_ENCODING_CLASSIFICATION.typeName, classificationProperties, isMergeUpdate, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        if (vendorProperties != null) {
            this.databaseHandler.setVendorProperties(userId, databaseGUID, vendorProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
    }

    private InstanceProperties getEncodingProperties(String encodingType, String encodingLanguage, String encodingDescription, Map<String, String> encodingProperties, String methodName) {
        InstanceProperties classificationProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.ENCODING.name, encodingType, methodName);
        classificationProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, classificationProperties, OpenMetadataProperty.ENCODING_LANGUAGE.name, encodingLanguage, methodName);
        classificationProperties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, classificationProperties, OpenMetadataProperty.ENCODING_DESCRIPTION.name, encodingDescription, methodName);
        classificationProperties = this.repositoryHelper.addStringMapPropertyToInstance(this.serviceName, classificationProperties, OpenMetadataProperty.ENCODING_DESCRIPTION.name, encodingProperties, methodName);
        return classificationProperties;
    }

    public void publishDatabase(String userId, String databaseGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementGUIDParameterName = "databaseGUID";
        this.databaseHandler.publishAsset(userId, databaseGUID, "databaseGUID", forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void withdrawDatabase(String userId, String databaseGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementGUIDParameterName = "databaseGUID";
        this.databaseHandler.withdrawAsset(userId, databaseGUID, "databaseGUID", forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void removeDatabase(String userId, String databaseManagerGUID, String databaseManagerName, String databaseGUID, String qualifiedName, boolean cascadedDelete, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementGUIDParameterName = "databaseGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(databaseGUID, "databaseGUID", methodName);
        if (qualifiedName != null) {
            this.databaseHandler.deleteBeanInRepository(userId, databaseManagerGUID, databaseManagerName, databaseGUID, "databaseGUID", OpenMetadataType.DATABASE.typeGUID, OpenMetadataType.DATABASE.typeName, cascadedDelete, OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else {
            this.databaseHandler.deleteBeanInRepository(userId, databaseManagerGUID, databaseManagerName, databaseGUID, "databaseGUID", OpenMetadataType.DATABASE.typeGUID, OpenMetadataType.DATABASE.typeName, cascadedDelete, null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
    }

    public List<DATABASE> findDatabases(String userId, String searchString, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String searchStringParameterName = "searchString";
        return this.databaseHandler.findAssets(userId, OpenMetadataType.DATABASE.typeGUID, OpenMetadataType.DATABASE.typeName, searchString, "searchString", startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<DATABASE> getDatabasesByName(String userId, String name, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String nameParameterName = "name";
        return this.databaseHandler.getAssetsByName(userId, OpenMetadataType.DATABASE.typeGUID, OpenMetadataType.DATABASE.typeName, name, "name", startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<DATABASE> getDatabasesForDatabaseManager(String userId, String databaseManagerGUID, String databaseManagerName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String databaseManagerGUIDParameterName = "databaseManagerGUID";
        return this.databaseHandler.getAttachedElements(userId, databaseManagerGUID, "databaseManagerGUID", OpenMetadataType.DATABASE_MANAGER.typeName, OpenMetadataType.SERVER_ASSET_USE_RELATIONSHIP.typeGUID, OpenMetadataType.SERVER_ASSET_USE_RELATIONSHIP.typeName, OpenMetadataType.DATABASE.typeName, null, null, 0, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, startFrom, pageSize, effectiveTime, methodName);
    }

    public DATABASE getDatabaseByGUID(String userId, String guid, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "guid";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(guid, "guid", methodName);
        return (DATABASE)this.databaseHandler.getBeanFromRepository(userId, guid, "guid", OpenMetadataType.DATABASE.typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public String createDatabaseSchema(String userId, String databaseManagerGUID, String databaseManagerName, String databaseGUID, String qualifiedName, String name, String resourceName, String versionIdentifier, String technicalDescription, String deployedImplementationType, Map<String, String> additionalProperties, String typeName, Map<String, Object> extendedProperties, Map<String, String> vendorProperties, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String parentElementGUIDParameterName = "databaseGUID";
        String createdElementGUIDParameterName = "databaseSchemaGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        this.databaseSchemaHandler.verifyExternalSourceIdentity(userId, databaseManagerGUID, databaseManagerName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        String assetTypeName = OpenMetadataType.DEPLOYED_DATABASE_SCHEMA.typeName;
        if (typeName != null) {
            assetTypeName = typeName;
        }
        this.invalidParameterHandler.validateTypeName(assetTypeName, OpenMetadataType.DEPLOYED_DATABASE_SCHEMA.typeName, this.serviceName, methodName, this.repositoryHelper);
        String databaseSchemaGUID = this.databaseSchemaHandler.createAssetInRepository(userId, databaseManagerGUID, databaseManagerName, qualifiedName, name, resourceName, versionIdentifier, technicalDescription, deployedImplementationType, additionalProperties, assetTypeName, extendedProperties, InstanceStatus.ACTIVE, effectiveFrom, effectiveTo, effectiveTime, methodName);
        if (databaseGUID != null) {
            this.databaseSchemaHandler.linkElementToElement(userId, databaseManagerGUID, databaseManagerName, databaseSchemaGUID, "databaseSchemaGUID", OpenMetadataType.DEPLOYED_DATABASE_SCHEMA.typeName, databaseGUID, "databaseGUID", OpenMetadataType.DATABASE.typeName, forLineage, forDuplicateProcessing, OpenMetadataType.DATA_SET_CONTENT_RELATIONSHIP.typeGUID, OpenMetadataType.DATA_SET_CONTENT_RELATIONSHIP.typeName, null, effectiveFrom, effectiveTo, effectiveTime, methodName);
            if (vendorProperties != null) {
                this.databaseHandler.setVendorProperties(userId, databaseSchemaGUID, vendorProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
        }
        return databaseSchemaGUID;
    }

    public String createDatabaseSchemaFromTemplate(String userId, String databaseManagerGUID, String databaseManagerName, String templateGUID, String databaseGUID, String qualifiedName, String technicalName, String versionIdentifier, String technicalDescription, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String parentElementGUIDParameterName = "databaseGUID";
        String createdElementGUIDParameterName = "databaseSchemaGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String databaseSchemaGUID = this.databaseSchemaHandler.addAssetFromTemplate(userId, databaseManagerGUID, databaseManagerName, templateGUID, "templateGUID", OpenMetadataType.DEPLOYED_DATABASE_SCHEMA.typeGUID, OpenMetadataType.DEPLOYED_DATABASE_SCHEMA.typeName, qualifiedName, "qualifiedName", technicalName, versionIdentifier, technicalDescription, null, null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (databaseGUID != null) {
            this.databaseSchemaHandler.linkElementToElement(userId, databaseManagerGUID, databaseManagerName, databaseSchemaGUID, "databaseSchemaGUID", OpenMetadataType.DEPLOYED_DATABASE_SCHEMA.typeName, databaseGUID, "databaseGUID", OpenMetadataType.DATABASE.typeName, forLineage, forDuplicateProcessing, OpenMetadataType.DATA_SET_CONTENT_RELATIONSHIP.typeGUID, OpenMetadataType.DATA_SET_CONTENT_RELATIONSHIP.typeName, null, effectiveFrom, effectiveTo, effectiveTime, methodName);
        }
        return databaseSchemaGUID;
    }

    public void updateDatabaseSchema(String userId, String databaseManagerGUID, String databaseManagerName, String databaseSchemaGUID, String qualifiedName, String name, String resourceName, String versionIdentifier, String description, String deployedImplementationType, Map<String, String> additionalProperties, String typeName, Map<String, Object> extendedProperties, Map<String, String> vendorProperties, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementGUIDParameterName = "databaseSchemaGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(databaseSchemaGUID, "databaseSchemaGUID", methodName);
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        }
        String assetTypeName = OpenMetadataType.DEPLOYED_DATABASE_SCHEMA.typeName;
        if (typeName != null) {
            assetTypeName = typeName;
        }
        this.databaseSchemaHandler.updateAsset(userId, databaseManagerGUID, databaseManagerName, databaseSchemaGUID, "databaseSchemaGUID", qualifiedName, name, resourceName, versionIdentifier, description, deployedImplementationType, additionalProperties, assetTypeName, extendedProperties, effectiveFrom, effectiveTo, isMergeUpdate, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (vendorProperties != null) {
            this.databaseHandler.setVendorProperties(userId, databaseSchemaGUID, vendorProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
    }

    public void publishDatabaseSchema(String userId, String databaseSchemaGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementGUIDParameterName = "databaseSchemaGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(databaseSchemaGUID, "databaseSchemaGUID", methodName);
        this.databaseSchemaHandler.publishAsset(userId, databaseSchemaGUID, "databaseSchemaGUID", forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void withdrawDatabaseSchema(String userId, String databaseSchemaGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementGUIDParameterName = "databaseSchemaGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(databaseSchemaGUID, "databaseSchemaGUID", methodName);
        this.databaseSchemaHandler.withdrawAsset(userId, databaseSchemaGUID, "databaseSchemaGUID", forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void removeDatabaseSchema(String userId, String databaseManagerGUID, String databaseManagerName, String databaseSchemaGUID, String qualifiedName, boolean cascadedDelete, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementGUIDParameterName = "databaseSchemaGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(databaseSchemaGUID, "databaseSchemaGUID", methodName);
        if (qualifiedName != null) {
            this.databaseSchemaHandler.deleteBeanInRepository(userId, databaseManagerGUID, databaseManagerName, databaseSchemaGUID, "databaseSchemaGUID", OpenMetadataType.DEPLOYED_DATABASE_SCHEMA.typeGUID, OpenMetadataType.DEPLOYED_DATABASE_SCHEMA.typeName, cascadedDelete, OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else {
            this.databaseSchemaHandler.deleteBeanInRepository(userId, databaseManagerGUID, databaseManagerName, databaseSchemaGUID, "databaseSchemaGUID", OpenMetadataType.DEPLOYED_DATABASE_SCHEMA.typeGUID, OpenMetadataType.DEPLOYED_DATABASE_SCHEMA.typeName, cascadedDelete, null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
    }

    public List<DATABASE_SCHEMA> findDatabaseSchemas(String userId, String searchString, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String searchStringParameterName = "searchString";
        return this.databaseSchemaHandler.findAssets(userId, OpenMetadataType.DEPLOYED_DATABASE_SCHEMA.typeGUID, OpenMetadataType.DEPLOYED_DATABASE_SCHEMA.typeName, searchString, "searchString", startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<DATABASE_SCHEMA> getSchemasForDatabase(String userId, String databaseGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String parentElementGUIDParameterName = "databaseGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(databaseGUID, "databaseGUID", methodName);
        return this.databaseSchemaHandler.getAttachedElements(userId, databaseGUID, "databaseGUID", OpenMetadataType.DATABASE.typeName, OpenMetadataType.DATA_SET_CONTENT_RELATIONSHIP.typeGUID, OpenMetadataType.DATA_SET_CONTENT_RELATIONSHIP.typeName, OpenMetadataType.DEPLOYED_DATABASE_SCHEMA.typeName, null, null, 1, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<DATABASE_SCHEMA> getDatabaseSchemasByName(String userId, String name, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String nameParameterName = "name";
        return this.databaseSchemaHandler.getAssetsByName(userId, OpenMetadataType.DEPLOYED_DATABASE_SCHEMA.typeGUID, OpenMetadataType.DEPLOYED_DATABASE_SCHEMA.typeName, name, "name", startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public DATABASE_SCHEMA getDatabaseSchemaByGUID(String userId, String guid, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "guid";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(guid, "guid", methodName);
        return (DATABASE_SCHEMA)this.databaseSchemaHandler.getBeanFromRepository(userId, guid, "guid", OpenMetadataType.DEPLOYED_DATABASE_SCHEMA.typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public String createDatabaseSchemaType(String userId, String databaseManagerGUID, String databaseManagerName, String qualifiedName, Date effectiveFrom, Date effectiveTo, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        SchemaTypeBuilder builder = new SchemaTypeBuilder(qualifiedName, OpenMetadataType.RELATIONAL_DB_SCHEMA_TYPE.typeGUID, OpenMetadataType.RELATIONAL_DB_SCHEMA_TYPE.typeName, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        return this.databaseTableHandler.createBeanInRepository(userId, databaseManagerGUID, databaseManagerName, OpenMetadataType.RELATIONAL_DB_SCHEMA_TYPE.typeGUID, OpenMetadataType.RELATIONAL_DB_SCHEMA_TYPE.typeName, builder, effectiveTime, methodName);
    }

    public void attachSchemaTypeToDatabaseAsset(String userId, String databaseManagerGUID, String databaseManagerName, String databaseAssetGUID, String schemaTypeGUID, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String databaseAssetGUIDParameterName = "databaseAssetGUID";
        String schemaTypeGUIDParameterName = "schemaTypeGUID";
        this.databaseHandler.attachSchemaTypeToAsset(userId, databaseManagerGUID, databaseManagerName, databaseAssetGUID, "databaseAssetGUID", schemaTypeGUID, "schemaTypeGUID", effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    @Deprecated
    public String createDatabaseTable(String userId, String databaseManagerGUID, String databaseManagerName, String databaseAssetGUID, String qualifiedName, String displayName, String description, boolean isDeprecated, List<String> aliases, Map<String, String> additionalProperties, String typeName, Map<String, Object> extendedProperties, Map<String, String> vendorProperties, String methodName) throws org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.createDatabaseTable(userId, databaseManagerGUID, databaseManagerName, databaseAssetGUID, qualifiedName, displayName, description, isDeprecated, aliases, additionalProperties, typeName, extendedProperties, vendorProperties, null, null, false, false, new Date(), methodName);
    }

    public String createDatabaseTable(String userId, String databaseManagerGUID, String databaseManagerName, String databaseAssetGUID, String qualifiedName, String displayName, String description, boolean isDeprecated, List<String> aliases, Map<String, String> additionalProperties, String typeName, Map<String, Object> extendedProperties, Map<String, String> vendorProperties, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String parentElementGUIDParameterName = "databaseAssetGUID";
        String databaseSchemaTypeGUID = this.databaseTableHandler.getAssetSchemaTypeGUID(userId, databaseManagerGUID, databaseManagerName, databaseAssetGUID, "databaseAssetGUID", OpenMetadataType.ASSET.typeName, databaseAssetGUID, OpenMetadataType.RELATIONAL_DB_SCHEMA_TYPE.typeGUID, OpenMetadataType.RELATIONAL_DB_SCHEMA_TYPE.typeName, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return this.createDatabaseTableForSchemaType(userId, databaseManagerGUID, databaseManagerName, databaseSchemaTypeGUID, qualifiedName, displayName, description, isDeprecated, aliases, additionalProperties, typeName, extendedProperties, vendorProperties, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public String createDatabaseTableForSchemaType(String userId, String databaseManagerGUID, String databaseManagerName, String databaseSchemaTypeGUID, String qualifiedName, String displayName, String description, boolean isDeprecated, List<String> aliases, Map<String, String> additionalProperties, String typeName, Map<String, Object> extendedProperties, Map<String, String> vendorProperties, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String schemaTypeGUIDParameterName = "databaseSchemaTypeGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateGUID(databaseSchemaTypeGUID, "databaseSchemaTypeGUID", methodName);
        String attributeTypeName = OpenMetadataType.RELATIONAL_TABLE.typeName;
        String attributeTypeId = OpenMetadataType.RELATIONAL_TABLE.typeGUID;
        if (typeName != null) {
            attributeTypeName = typeName;
            attributeTypeId = this.invalidParameterHandler.validateTypeName(typeName, OpenMetadataType.RELATIONAL_TABLE.typeName, this.serviceName, methodName, this.repositoryHelper);
        }
        SchemaAttributeBuilder schemaAttributeBuilder = new SchemaAttributeBuilder(qualifiedName, displayName, description, 0, 1, 1, isDeprecated, null, true, false, 0, 0, 0, 0, false, null, aliases, additionalProperties, attributeTypeId, attributeTypeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        SchemaTypeBuilder schemaTypeBuilder = new SchemaTypeBuilder(qualifiedName + ":tableType", OpenMetadataType.RELATIONAL_TABLE_TYPE.typeGUID, OpenMetadataType.RELATIONAL_TABLE_TYPE.typeName, this.repositoryHelper, this.serviceName, this.serverName);
        schemaAttributeBuilder.setSchemaType(userId, schemaTypeBuilder, methodName);
        this.databaseTableHandler.setUpAnchorsClassificationFromParent(userId, databaseSchemaTypeGUID, "databaseSchemaTypeGUID", schemaAttributeBuilder, false, false, effectiveTime, methodName);
        schemaAttributeBuilder.setEffectivityDates(effectiveFrom, effectiveTo);
        String databaseTableGUID = this.databaseTableHandler.createNestedSchemaAttribute(userId, databaseManagerGUID, databaseManagerName, databaseSchemaTypeGUID, "databaseSchemaTypeGUID", OpenMetadataType.RELATIONAL_DB_SCHEMA_TYPE.typeName, OpenMetadataType.ATTRIBUTE_FOR_SCHEMA_RELATIONSHIP.typeGUID, OpenMetadataType.ATTRIBUTE_FOR_SCHEMA_RELATIONSHIP.typeName, qualifiedName, "qualifiedName", schemaAttributeBuilder, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (databaseTableGUID != null) {
            this.databaseHandler.setVendorProperties(userId, databaseTableGUID, vendorProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        return databaseTableGUID;
    }

    public String createDatabaseTableFromTemplate(String userId, String databaseManagerGUID, String databaseManagerName, String templateGUID, String databaseAssetGUID, String qualifiedName, String technicalName, String description, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "databaseAssetGUID";
        String parentElementGUIDParameterName = "databaseAssetGUID";
        String templateParameterName = "templateGUID";
        String qualifiedNameParameterName = "qualifiedName";
        String schemaTypeGUIDParameterName = "databaseSchemaTypeGUID";
        this.invalidParameterHandler.validateGUID(databaseAssetGUID, "databaseAssetGUID", methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String databaseSchemaTypeGUID = this.databaseTableHandler.getAssetSchemaTypeGUID(userId, databaseManagerGUID, databaseManagerName, databaseAssetGUID, "databaseAssetGUID", OpenMetadataType.ASSET.typeName, databaseAssetGUID, OpenMetadataType.RELATIONAL_DB_SCHEMA_TYPE.typeGUID, OpenMetadataType.RELATIONAL_DB_SCHEMA_TYPE.typeName, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (databaseSchemaTypeGUID != null) {
            SchemaAttributeBuilder builder = new SchemaAttributeBuilder(qualifiedName, technicalName, description, this.repositoryHelper, this.serviceName, this.serverName);
            this.databaseTableHandler.setUpAnchorsClassificationFromParent(userId, databaseSchemaTypeGUID, "databaseSchemaTypeGUID", builder, false, false, effectiveTime, methodName);
            String databaseTableGUID = this.databaseTableHandler.createBeanFromTemplate(userId, databaseManagerGUID, databaseManagerName, templateGUID, "templateGUID", OpenMetadataType.RELATIONAL_TABLE.typeGUID, OpenMetadataType.RELATIONAL_TABLE.typeName, qualifiedName, "qualifiedName", builder, this.databaseTableHandler.getSupportedZones(), true, false, null, methodName);
            if (databaseTableGUID != null) {
                String databaseTableGUIDParameterName = "databaseTableGUID";
                this.databaseTableHandler.linkElementToElement(userId, databaseManagerGUID, databaseManagerName, databaseSchemaTypeGUID, "databaseSchemaTypeGUID", OpenMetadataType.RELATIONAL_DB_SCHEMA_TYPE.typeName, databaseTableGUID, "databaseTableGUID", OpenMetadataType.RELATIONAL_TABLE.typeName, forLineage, forDuplicateProcessing, OpenMetadataType.ATTRIBUTE_FOR_SCHEMA_RELATIONSHIP.typeGUID, OpenMetadataType.ATTRIBUTE_FOR_SCHEMA_RELATIONSHIP.typeName, null, effectiveFrom, effectiveTo, effectiveTime, methodName);
                return databaseTableGUID;
            }
        }
        return null;
    }

    public void updateDatabaseTable(String userId, String databaseManagerGUID, String databaseManagerName, String databaseTableGUID, String qualifiedName, String displayName, String description, boolean isDeprecated, List<String> aliases, Map<String, String> additionalProperties, String typeName, Map<String, Object> extendedProperties, Map<String, String> vendorProperties, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementGUIDParameterName = "databaseTableGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(databaseTableGUID, "databaseTableGUID", methodName);
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        }
        String attributeTypeName = OpenMetadataType.RELATIONAL_TABLE.typeName;
        String attributeTypeId = OpenMetadataType.RELATIONAL_TABLE.typeGUID;
        if (typeName != null) {
            attributeTypeName = typeName;
            attributeTypeId = this.invalidParameterHandler.validateTypeName(typeName, OpenMetadataType.RELATIONAL_TABLE.typeName, this.serviceName, methodName, this.repositoryHelper);
        }
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.DISPLAY_NAME.name, displayName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.DESCRIPTION.name, description, methodName);
        properties = this.repositoryHelper.addBooleanPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.IS_DEPRECATED.name, isDeprecated, methodName);
        properties = this.repositoryHelper.addStringArrayPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.ALIASES.name, aliases, methodName);
        properties = this.repositoryHelper.addStringMapPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, additionalProperties, methodName);
        if (extendedProperties != null) {
            try {
                properties = this.repositoryHelper.addPropertyMapToInstance(this.serviceName, null, extendedProperties, methodName);
            }
            catch (InvalidParameterException error) {
                String propertyName = "extendedProperties";
                this.errorHandler.handleUnsupportedProperty((Exception)((Object)error), methodName, "extendedProperties");
            }
        }
        this.databaseTableHandler.updateBeanInRepository(userId, databaseManagerGUID, databaseManagerName, databaseTableGUID, "databaseTableGUID", attributeTypeId, attributeTypeName, forLineage, forDuplicateProcessing, this.databaseTableHandler.setUpEffectiveDates(properties, effectiveFrom, effectiveTo), isMergeUpdate, effectiveTime, methodName);
        this.databaseHandler.setVendorProperties(userId, databaseTableGUID, vendorProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void removeDatabaseTable(String userId, String databaseManagerGUID, String databaseManagerName, String databaseTableGUID, String databaseTableGUIDParameterName, String qualifiedName, boolean cascadedDelete, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (qualifiedName != null) {
            this.databaseTableHandler.deleteBeanInRepository(userId, databaseManagerGUID, databaseManagerName, databaseTableGUID, databaseTableGUIDParameterName, OpenMetadataType.RELATIONAL_TABLE.typeGUID, OpenMetadataType.RELATIONAL_TABLE.typeName, cascadedDelete, OpenMetadataProperty.QUALIFIED_NAME.name, qualifiedName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        } else {
            this.databaseTableHandler.deleteBeanInRepository(userId, databaseManagerGUID, databaseManagerName, databaseTableGUID, databaseTableGUIDParameterName, OpenMetadataType.RELATIONAL_TABLE.typeGUID, OpenMetadataType.RELATIONAL_TABLE.typeName, cascadedDelete, null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
    }

    public List<DATABASE_TABLE> findDatabaseTables(String userId, String searchString, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", methodName);
        return this.databaseTableHandler.findSchemaAttributes(userId, searchString, "searchString", OpenMetadataType.RELATIONAL_TABLE.typeGUID, OpenMetadataType.RELATIONAL_TABLE.typeName, null, OpenMetadataType.CALCULATED_VALUE_CLASSIFICATION.typeName, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<DATABASE_TABLE> getTablesForDatabaseAsset(String userId, String databaseAssetGUID, int startFrom, int pageSize, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String parentElementGUIDParameterName = "databaseAssetGUID";
        String databaseSchemaTypeGUID = this.databaseTableHandler.getAssetSchemaTypeGUID(userId, null, null, databaseAssetGUID, "databaseAssetGUID", OpenMetadataType.ASSET.typeName, databaseAssetGUID, OpenMetadataType.RELATIONAL_DB_SCHEMA_TYPE.typeGUID, OpenMetadataType.RELATIONAL_DB_SCHEMA_TYPE.typeName, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (databaseSchemaTypeGUID != null) {
            String databaseSchemaTypeGUIDParameterName = "databaseSchemaTypeGUID";
            return this.databaseTableHandler.getSchemaAttributesForComplexSchemaType(userId, databaseSchemaTypeGUID, "databaseSchemaTypeGUID", null, OpenMetadataType.CALCULATED_VALUE_CLASSIFICATION.typeName, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        return null;
    }

    public List<DATABASE_TABLE> getDatabaseTablesByName(String userId, String name, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.databaseTableHandler.getSchemaAttributesByName(userId, OpenMetadataType.RELATIONAL_TABLE.typeGUID, OpenMetadataType.RELATIONAL_TABLE.typeName, name, null, OpenMetadataType.CALCULATED_VALUE_CLASSIFICATION.typeName, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public DATABASE_TABLE getDatabaseTableByGUID(String userId, String guid, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "guid";
        return this.databaseTableHandler.getSchemaAttribute(userId, guid, "guid", OpenMetadataType.RELATIONAL_TABLE.typeName, null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public String createDatabaseView(String userId, String databaseManagerGUID, String databaseManagerName, String databaseAssetGUID, String qualifiedName, String displayName, String description, boolean isDeprecated, List<String> aliases, String expression, Map<String, String> additionalProperties, String typeName, Map<String, Object> extendedProperties, Map<String, String> vendorProperties, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String parentElementGUIDParameterName = "databaseAssetGUID";
        String databaseSchemaTypeGUID = this.databaseViewHandler.getAssetSchemaTypeGUID(userId, databaseManagerGUID, databaseManagerName, databaseAssetGUID, "databaseAssetGUID", OpenMetadataType.ASSET.typeName, databaseAssetGUID, OpenMetadataType.RELATIONAL_DB_SCHEMA_TYPE.typeGUID, OpenMetadataType.RELATIONAL_DB_SCHEMA_TYPE.typeName, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return this.createDatabaseViewForSchemaType(userId, databaseManagerGUID, databaseManagerName, databaseSchemaTypeGUID, qualifiedName, displayName, description, isDeprecated, aliases, expression, additionalProperties, typeName, extendedProperties, vendorProperties, effectiveFrom, effectiveTo, forDuplicateProcessing, forLineage, effectiveTime, methodName);
    }

    public String createDatabaseViewForSchemaType(String userId, String databaseManagerGUID, String databaseManagerName, String databaseSchemaTypeGUID, String qualifiedName, String displayName, String description, boolean isDeprecated, List<String> aliases, String expression, Map<String, String> additionalProperties, String typeName, Map<String, Object> extendedProperties, Map<String, String> vendorProperties, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String schemaTypeGUIDParameterName = "databaseSchemaTypeGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateGUID(databaseSchemaTypeGUID, "databaseSchemaTypeGUID", methodName);
        String attributeTypeName = OpenMetadataType.RELATIONAL_TABLE.typeName;
        String attributeTypeId = OpenMetadataType.RELATIONAL_TABLE.typeGUID;
        if (typeName != null) {
            attributeTypeName = typeName;
            attributeTypeId = this.invalidParameterHandler.validateTypeName(typeName, OpenMetadataType.RELATIONAL_TABLE.typeName, this.serviceName, methodName, this.repositoryHelper);
        }
        int tableCount = this.databaseViewHandler.countSchemaAttributes(userId, databaseSchemaTypeGUID, "databaseSchemaTypeGUID", effectiveTime, methodName);
        SchemaAttributeBuilder schemaAttributeBuilder = new SchemaAttributeBuilder(qualifiedName, displayName, description, tableCount, 1, 1, isDeprecated, null, true, false, 0, 0, 0, 0, false, null, aliases, additionalProperties, attributeTypeId, attributeTypeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        SchemaTypeBuilder schemaTypeBuilder = new SchemaTypeBuilder(qualifiedName + ":viewType", OpenMetadataType.RELATIONAL_TABLE_TYPE.typeGUID, OpenMetadataType.RELATIONAL_TABLE_TYPE.typeName, this.repositoryHelper, this.serviceName, this.serverName);
        schemaAttributeBuilder.setSchemaType(userId, schemaTypeBuilder, methodName);
        this.databaseTableHandler.setUpAnchorsClassificationFromParent(userId, databaseSchemaTypeGUID, "databaseSchemaTypeGUID", schemaAttributeBuilder, false, false, effectiveTime, methodName);
        schemaAttributeBuilder.setEffectivityDates(effectiveFrom, effectiveTo);
        schemaAttributeBuilder.setCalculatedValue(userId, databaseManagerGUID, databaseManagerName, expression, methodName);
        String databaseViewGUID = this.databaseViewHandler.createNestedSchemaAttribute(userId, databaseManagerGUID, databaseManagerName, databaseSchemaTypeGUID, "databaseSchemaTypeGUID", OpenMetadataType.RELATIONAL_DB_SCHEMA_TYPE.typeName, OpenMetadataType.ATTRIBUTE_FOR_SCHEMA_RELATIONSHIP.typeGUID, OpenMetadataType.ATTRIBUTE_FOR_SCHEMA_RELATIONSHIP.typeName, qualifiedName, "qualifiedName", schemaAttributeBuilder, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (databaseViewGUID != null) {
            this.databaseViewHandler.setVendorProperties(userId, databaseViewGUID, vendorProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        return databaseViewGUID;
    }

    public String createDatabaseViewFromTemplate(String userId, String databaseManagerGUID, String databaseManagerName, String templateGUID, String databaseAssetGUID, String qualifiedName, String displayName, String description, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.createDatabaseTableFromTemplate(userId, databaseManagerGUID, databaseManagerName, templateGUID, databaseAssetGUID, qualifiedName, displayName, description, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void updateDatabaseView(String userId, String databaseManagerGUID, String databaseManagerName, String databaseViewGUID, String qualifiedName, String displayName, String description, boolean isDeprecated, List<String> aliases, String expression, Map<String, String> additionalProperties, String typeName, Map<String, Object> extendedProperties, Map<String, String> vendorProperties, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementGUIDParameterName = "databaseViewGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(databaseViewGUID, "databaseViewGUID", methodName);
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        }
        String expectedTypeName = OpenMetadataType.RELATIONAL_TABLE.typeName;
        if (typeName != null) {
            expectedTypeName = typeName;
        }
        this.updateDatabaseTable(userId, databaseManagerGUID, databaseManagerName, databaseViewGUID, qualifiedName, displayName, description, isDeprecated, aliases, additionalProperties, typeName, extendedProperties, vendorProperties, effectiveFrom, effectiveTo, isMergeUpdate, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        InstanceProperties properties = null;
        if (expression != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.FORMULA.name, expression, methodName);
        }
        this.databaseViewHandler.setClassificationInRepository(userId, databaseManagerGUID, databaseManagerName, databaseViewGUID, "databaseViewGUID", expectedTypeName, OpenMetadataType.CALCULATED_VALUE_CLASSIFICATION.typeGUID, OpenMetadataType.CALCULATED_VALUE_CLASSIFICATION.typeName, properties, isMergeUpdate, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<DATABASE_VIEW> findDatabaseViews(String userId, String searchString, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", methodName);
        return this.databaseViewHandler.findSchemaAttributes(userId, searchString, "searchString", OpenMetadataType.RELATIONAL_TABLE.typeGUID, OpenMetadataType.RELATIONAL_TABLE.typeName, OpenMetadataType.CALCULATED_VALUE_CLASSIFICATION.typeName, null, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<DATABASE_VIEW> getViewsForDatabaseAsset(String userId, String databaseAssetGUID, int startFrom, int pageSize, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String parentElementGUIDParameterName = "databaseAssetGUID";
        String databaseSchemaTypeGUID = this.databaseViewHandler.getAssetSchemaTypeGUID(userId, null, null, databaseAssetGUID, "databaseAssetGUID", OpenMetadataType.ASSET.typeName, databaseAssetGUID, OpenMetadataType.RELATIONAL_DB_SCHEMA_TYPE.typeGUID, OpenMetadataType.RELATIONAL_DB_SCHEMA_TYPE.typeName, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (databaseSchemaTypeGUID != null) {
            String databaseSchemaTypeGUIDParameterName = "databaseSchemaTypeGUID";
            return this.databaseViewHandler.getSchemaAttributesForComplexSchemaType(userId, databaseSchemaTypeGUID, "databaseSchemaTypeGUID", OpenMetadataType.CALCULATED_VALUE_CLASSIFICATION.typeName, null, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        return null;
    }

    public List<DATABASE_VIEW> getDatabaseViewsByName(String userId, String name, String nameParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(name, nameParameterName, methodName);
        return this.databaseViewHandler.getSchemaAttributesByName(userId, OpenMetadataType.RELATIONAL_TABLE.typeGUID, OpenMetadataType.RELATIONAL_TABLE.typeName, name, OpenMetadataType.CALCULATED_VALUE_CLASSIFICATION.typeName, null, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public DATABASE_VIEW getDatabaseViewByGUID(String userId, String guid, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "guid";
        return this.databaseViewHandler.getSchemaAttribute(userId, guid, "guid", OpenMetadataType.RELATIONAL_TABLE.typeName, null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    @Deprecated
    public String createDatabaseColumn(String userId, String databaseManagerGUID, String databaseManagerName, String databaseTableGUID, String qualifiedName, String displayName, String description, String externalSchemaTypeGUID, String dataType, String defaultValue, String fixedValue, String validValuesSetGUID, String formula, boolean isDeprecated, int elementPosition, int minCardinality, int maxCardinality, boolean allowsDuplicateValues, boolean orderedValues, String defaultValueOverride, int sortOrder, int minimumLength, int length, int significantDigits, boolean isNullable, String nativeJavaClass, List<String> aliases, Map<String, String> additionalProperties, String typeName, Map<String, Object> extendedProperties, Map<String, String> vendorProperties, String methodName) throws org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.createDatabaseColumn(userId, databaseManagerGUID, databaseManagerName, databaseTableGUID, qualifiedName, displayName, description, externalSchemaTypeGUID, dataType, defaultValue, fixedValue, validValuesSetGUID, formula, isDeprecated, elementPosition, minCardinality, maxCardinality, allowsDuplicateValues, orderedValues, defaultValueOverride, sortOrder, minimumLength, length, significantDigits, isNullable, nativeJavaClass, aliases, additionalProperties, typeName, extendedProperties, vendorProperties, null, null, false, false, new Date(), methodName);
    }

    public String createDatabaseColumn(String userId, String databaseManagerGUID, String databaseManagerName, String databaseTableGUID, String qualifiedName, String displayName, String description, String externalSchemaTypeGUID, String dataType, String defaultValue, String fixedValue, String validValuesSetGUID, String formula, boolean isDeprecated, int elementPosition, int minCardinality, int maxCardinality, boolean allowsDuplicateValues, boolean orderedValues, String defaultValueOverride, int sortOrder, int minimumLength, int length, int significantDigits, boolean isNullable, String nativeJavaClass, List<String> aliases, Map<String, String> additionalProperties, String typeName, Map<String, Object> extendedProperties, Map<String, String> vendorProperties, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        EntityDetail databaseTableEntity;
        String databaseTableGUIDParameterName = "databaseTableGUID";
        String qualifiedNameParameterName = "qualifiedName";
        String dataTypeParameterName = "dataType";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(databaseTableGUID, "databaseTableGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        if (externalSchemaTypeGUID == null) {
            this.invalidParameterHandler.validateName(dataType, "dataType", methodName);
        }
        if ((databaseTableEntity = this.databaseColumnHandler.getEntityFromRepository(userId, databaseTableGUID, "databaseTableGUID", OpenMetadataType.RELATIONAL_TABLE.typeName, null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName)) != null) {
            String databaseColumnGUID;
            String attributeTypeName = OpenMetadataType.RELATIONAL_COLUMN.typeName;
            String attributeTypeId = OpenMetadataType.RELATIONAL_COLUMN.typeGUID;
            if (typeName != null) {
                attributeTypeName = typeName;
                attributeTypeId = this.invalidParameterHandler.validateTypeName(typeName, OpenMetadataType.RELATIONAL_COLUMN.typeName, this.serviceName, methodName, this.repositoryHelper);
            }
            SchemaAttributeBuilder schemaAttributeBuilder = new SchemaAttributeBuilder(qualifiedName, displayName, description, elementPosition, minCardinality, maxCardinality, isDeprecated, defaultValueOverride, allowsDuplicateValues, orderedValues, sortOrder, minimumLength, length, significantDigits, isNullable, nativeJavaClass, aliases, additionalProperties, attributeTypeId, attributeTypeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
            OpenMetadataAPIAnchorHandler.AnchorIdentifiers anchorIdentifiers = this.databaseColumnHandler.getAnchorsFromAnchorsClassification((EntitySummary)databaseTableEntity, methodName);
            if (anchorIdentifiers != null) {
                schemaAttributeBuilder.setAnchors(userId, anchorIdentifiers.anchorGUID, anchorIdentifiers.anchorTypeName, anchorIdentifiers.anchorDomainName, anchorIdentifiers.anchorScopeGUID, methodName);
            }
            String parentTypeName = OpenMetadataType.RELATIONAL_TABLE_TYPE.typeName;
            String parentAttachmentTypeGUID = OpenMetadataType.ATTRIBUTE_FOR_SCHEMA_RELATIONSHIP.typeGUID;
            String parentAttachmentTypeName = OpenMetadataType.ATTRIBUTE_FOR_SCHEMA_RELATIONSHIP.typeName;
            String parentGUID = this.databaseColumnHandler.getAttachedElementGUID(userId, databaseTableGUID, "databaseTableGUID", OpenMetadataType.RELATIONAL_TABLE.typeName, OpenMetadataType.SCHEMA_ATTRIBUTE_TYPE_RELATIONSHIP.typeGUID, OpenMetadataType.SCHEMA_ATTRIBUTE_TYPE_RELATIONSHIP.typeName, OpenMetadataType.SCHEMA_TYPE.typeName, 2, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            if (parentGUID == null) {
                try {
                    Classification typeClassification = this.repositoryHelper.getClassificationFromEntity(this.serviceName, (EntitySummary)databaseTableEntity, OpenMetadataType.TYPE_EMBEDDED_ATTRIBUTE_CLASSIFICATION.typeName, methodName);
                    if (typeClassification != null) {
                        parentGUID = databaseTableGUID;
                        parentTypeName = OpenMetadataType.RELATIONAL_TABLE.typeName;
                        parentAttachmentTypeGUID = OpenMetadataType.NESTED_SCHEMA_ATTRIBUTE_RELATIONSHIP.typeGUID;
                        parentAttachmentTypeName = OpenMetadataType.NESTED_SCHEMA_ATTRIBUTE_RELATIONSHIP.typeName;
                    }
                }
                catch (ClassificationErrorException typeClassification) {
                    // empty catch block
                }
            }
            if (parentGUID == null) {
                this.invalidParameterHandler.throwUnknownElement(userId, databaseTableGUID, OpenMetadataType.RELATIONAL_TABLE_TYPE.typeName, this.serviceName, this.serverName, methodName);
                return null;
            }
            SchemaTypeBuilder schemaTypeBuilder = this.databaseColumnHandler.getSchemaTypeBuilder(qualifiedName, externalSchemaTypeGUID, dataType, defaultValue, fixedValue, validValuesSetGUID);
            schemaAttributeBuilder.setSchemaType(userId, schemaTypeBuilder, methodName);
            schemaAttributeBuilder.setEffectivityDates(effectiveFrom, effectiveTo);
            if (formula != null) {
                schemaAttributeBuilder.setCalculatedValue(userId, databaseManagerGUID, databaseManagerName, formula, methodName);
            }
            if ((databaseColumnGUID = this.databaseColumnHandler.createBeanInRepository(userId, databaseManagerGUID, databaseManagerName, OpenMetadataType.RELATIONAL_COLUMN.typeGUID, OpenMetadataType.RELATIONAL_COLUMN.typeName, schemaAttributeBuilder, effectiveTime, methodName)) != null) {
                String databaseColumnGUIDParameterName = "databaseColumnGUID";
                this.databaseColumnHandler.linkElementToElement(userId, databaseManagerGUID, databaseManagerName, parentGUID, "databaseTableGUID", parentTypeName, databaseColumnGUID, "databaseColumnGUID", OpenMetadataType.RELATIONAL_COLUMN.typeName, forLineage, forDuplicateProcessing, parentAttachmentTypeGUID, parentAttachmentTypeName, schemaAttributeBuilder.getParentRelationshipProperties(methodName), effectiveFrom, effectiveTo, effectiveTime, methodName);
                this.databaseColumnHandler.setVendorProperties(userId, databaseColumnGUID, vendorProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                return databaseColumnGUID;
            }
            return null;
        }
        this.invalidParameterHandler.throwUnknownElement(userId, databaseTableGUID, OpenMetadataType.RELATIONAL_TABLE.typeName, this.serviceName, this.serverName, methodName);
        return null;
    }

    public void createDatabaseColumnQuery(String userId, String databaseManagerGUID, String databaseManagerName, String databaseColumnGUID, String queryId, String query, String queryTargetGUID, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String parentElementGUIDParameterName = "databaseColumnGUID";
        String targetElementGUIDParameterName = "queryTargetGUID";
        String queryParameterName = "query";
        this.invalidParameterHandler.validateObject((Object)query, "query", methodName);
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.QUERY.name, query, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.QUERY_ID.name, queryId, methodName);
        this.databaseColumnHandler.linkElementToElement(userId, databaseManagerGUID, databaseManagerName, databaseColumnGUID, "databaseColumnGUID", OpenMetadataType.RELATIONAL_COLUMN.typeName, queryTargetGUID, "queryTargetGUID", OpenMetadataType.SCHEMA_ELEMENT.typeName, forLineage, forDuplicateProcessing, OpenMetadataType.DERIVED_SCHEMA_TYPE_QUERY_TARGET_RELATIONSHIP.typeGUID, OpenMetadataType.DERIVED_SCHEMA_TYPE_QUERY_TARGET_RELATIONSHIP.typeName, properties, effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public String createDatabaseColumnFromTemplate(String userId, String databaseManagerGUID, String databaseManagerName, String templateGUID, String databaseTableGUID, String qualifiedName, String displayName, String description, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String databaseColumnGUID;
        String templateGUIDParameterName = "templateGUID";
        String databaseTableGUIDParameterName = "databaseTableGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateGUID(databaseTableGUID, "databaseTableGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        OpenMetadataAPIAnchorHandler.AnchorIdentifiers anchorIdentifiers = null;
        String parentTypeName = null;
        String parentAttachmentTypeGUID = null;
        String parentAttachmentTypeName = null;
        String parentGUID = null;
        EntityDetail databaseTableEntity = this.databaseColumnHandler.getEntityFromRepository(userId, databaseTableGUID, "databaseTableGUID", OpenMetadataType.RELATIONAL_TABLE.typeName, null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        if (databaseTableEntity != null) {
            anchorIdentifiers = this.databaseColumnHandler.getAnchorsFromAnchorsClassification((EntitySummary)databaseTableEntity, methodName);
            try {
                Classification typeClassification = this.repositoryHelper.getClassificationFromEntity(this.serviceName, (EntitySummary)databaseTableEntity, OpenMetadataType.TYPE_EMBEDDED_ATTRIBUTE_CLASSIFICATION.typeName, methodName);
                if (typeClassification != null) {
                    parentGUID = databaseTableGUID;
                    parentTypeName = OpenMetadataType.RELATIONAL_TABLE.typeName;
                    parentAttachmentTypeGUID = OpenMetadataType.NESTED_SCHEMA_ATTRIBUTE_RELATIONSHIP.typeGUID;
                    parentAttachmentTypeName = OpenMetadataType.NESTED_SCHEMA_ATTRIBUTE_RELATIONSHIP.typeName;
                }
            }
            catch (ClassificationErrorException typeClassification) {
                // empty catch block
            }
            if (parentGUID == null) {
                parentTypeName = OpenMetadataType.RELATIONAL_TABLE_TYPE.typeName;
                parentAttachmentTypeGUID = OpenMetadataType.ATTRIBUTE_FOR_SCHEMA_RELATIONSHIP.typeGUID;
                parentAttachmentTypeName = OpenMetadataType.ATTRIBUTE_FOR_SCHEMA_RELATIONSHIP.typeName;
                parentGUID = this.databaseColumnHandler.getAttachedElementGUID(userId, databaseTableGUID, "databaseTableGUID", OpenMetadataType.RELATIONAL_TABLE.typeName, OpenMetadataType.SCHEMA_ATTRIBUTE_TYPE_RELATIONSHIP.typeGUID, OpenMetadataType.SCHEMA_ATTRIBUTE_TYPE_RELATIONSHIP.typeName, OpenMetadataType.SCHEMA_TYPE.typeName, 2, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
        }
        if (parentGUID == null) {
            this.invalidParameterHandler.throwUnknownElement(userId, databaseTableGUID, OpenMetadataType.RELATIONAL_TABLE.typeName, this.serviceName, this.serverName, methodName);
            return null;
        }
        SchemaAttributeBuilder builder = new SchemaAttributeBuilder(qualifiedName, displayName, description, this.repositoryHelper, this.serviceName, this.serverName);
        if (anchorIdentifiers != null) {
            builder.setAnchors(userId, anchorIdentifiers.anchorGUID, anchorIdentifiers.anchorTypeName, anchorIdentifiers.anchorDomainName, anchorIdentifiers.anchorScopeGUID, methodName);
        }
        if ((databaseColumnGUID = this.databaseColumnHandler.createBeanFromTemplate(userId, databaseManagerGUID, databaseManagerName, templateGUID, "templateGUID", OpenMetadataType.RELATIONAL_COLUMN.typeGUID, OpenMetadataType.RELATIONAL_COLUMN.typeName, qualifiedName, "qualifiedName", builder, this.databaseColumnHandler.getSupportedZones(), true, false, null, methodName)) != null) {
            String databaseColumnGUIDParameterName = "databaseColumnGUID";
            this.databaseColumnHandler.linkElementToElement(userId, databaseManagerGUID, databaseManagerName, parentGUID, "databaseTableGUID", parentTypeName, databaseColumnGUID, "databaseColumnGUID", OpenMetadataType.RELATIONAL_COLUMN.typeName, forLineage, forDuplicateProcessing, parentAttachmentTypeGUID, parentAttachmentTypeName, builder.getParentRelationshipProperties(methodName), effectiveFrom, effectiveTo, effectiveTime, methodName);
        }
        return databaseColumnGUID;
    }

    public void updateDatabaseColumn(String userId, String databaseManagerGUID, String databaseManagerName, String databaseColumnGUID, String qualifiedName, String displayName, String description, String externalSchemaTypeGUID, String dataType, String defaultValue, String fixedValue, String validValuesSetGUID, String formula, boolean isDeprecated, int elementPosition, int minCardinality, int maxCardinality, boolean allowsDuplicateValues, boolean orderedValues, String defaultValueOverride, int sortOrder, int minimumLength, int length, int significantDigits, boolean isNullable, String nativeJavaClass, List<String> aliases, Map<String, String> additionalProperties, String typeName, Map<String, Object> extendedProperties, Map<String, String> vendorProperties, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementGUIDParameterName = "databaseColumnGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(databaseColumnGUID, "databaseColumnGUID", methodName);
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        }
        String attributeTypeName = OpenMetadataType.RELATIONAL_COLUMN.typeName;
        if (typeName != null) {
            attributeTypeName = typeName;
            this.invalidParameterHandler.validateTypeName(typeName, OpenMetadataType.RELATIONAL_COLUMN.typeName, this.serviceName, methodName, this.repositoryHelper);
        }
        this.databaseColumnHandler.updateSchemaAttribute(userId, databaseManagerGUID, databaseManagerName, databaseColumnGUID, "databaseColumnGUID", qualifiedName, "qualifiedName", displayName, description, externalSchemaTypeGUID, dataType, defaultValue, fixedValue, validValuesSetGUID, formula, isDeprecated, elementPosition, minCardinality, maxCardinality, allowsDuplicateValues, orderedValues, defaultValueOverride, sortOrder, minimumLength, length, significantDigits, isNullable, nativeJavaClass, aliases, additionalProperties, attributeTypeName, extendedProperties, effectiveFrom, effectiveTo, isMergeUpdate, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        this.databaseColumnHandler.setVendorProperties(userId, databaseColumnGUID, vendorProperties, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void removeDatabaseColumn(String userId, String databaseManagerGUID, String databaseManagerName, String databaseColumnGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String elementGUIDParameterName = "databaseColumnGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(databaseColumnGUID, "databaseColumnGUID", methodName);
        this.databaseColumnHandler.deleteBeanInRepository(userId, databaseManagerGUID, databaseManagerName, databaseColumnGUID, "databaseColumnGUID", OpenMetadataType.RELATIONAL_COLUMN.typeGUID, OpenMetadataType.RELATIONAL_COLUMN.typeName, false, null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<DATABASE_COLUMN> findDatabaseColumns(String userId, String searchString, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String searchStringParameterName = "searchString";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateSearchString(searchString, "searchString", methodName);
        return this.databaseColumnHandler.findSchemaAttributes(userId, searchString, "searchString", OpenMetadataType.RELATIONAL_COLUMN.typeGUID, OpenMetadataType.RELATIONAL_COLUMN.typeName, null, null, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<DATABASE_COLUMN> getColumnsForDatabaseTable(String userId, String databaseTableGUID, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String parentElementGUIDParameterName = "databaseTableGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(databaseTableGUID, "databaseTableGUID", methodName);
        return this.databaseColumnHandler.getNestedSchemaAttributes(userId, databaseTableGUID, "databaseTableGUID", startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<DATABASE_COLUMN> getDatabaseColumnsByName(String userId, String name, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String nameParameterName = "name";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateName(name, "name", methodName);
        return this.databaseColumnHandler.getSchemaAttributesByName(userId, OpenMetadataType.RELATIONAL_COLUMN.typeGUID, OpenMetadataType.RELATIONAL_COLUMN.typeName, name, null, null, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public DATABASE_COLUMN getDatabaseColumnByGUID(String userId, String guid, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String guidParameterName = "guid";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(guid, "guid", methodName);
        return this.databaseColumnHandler.getSchemaAttribute(userId, guid, "guid", OpenMetadataType.RELATIONAL_COLUMN.typeName, null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void setPrimaryKeyOnColumn(String userId, String databaseManagerGUID, String databaseManagerName, String databaseColumnGUID, String name, int keyPatternOrdinal, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String parentElementGUIDParameterName = "databaseColumnGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(databaseColumnGUID, "databaseColumnGUID", methodName);
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.NAME.name, name, methodName);
        try {
            properties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.KEY_PATTERN.name, KeyPattern.getOpenTypeGUID(), KeyPattern.getOpenTypeName(), keyPatternOrdinal, methodName);
        }
        catch (TypeErrorException classificationNotSupported) {
            throw new org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException((OMFCheckedExceptionBase)classificationNotSupported, OpenMetadataProperty.KEY_PATTERN.name);
        }
        this.databaseColumnHandler.setUpEffectiveDates(properties, effectiveFrom, effectiveTo);
        this.databaseColumnHandler.setClassificationInRepository(userId, databaseManagerGUID, databaseManagerName, databaseColumnGUID, "databaseColumnGUID", OpenMetadataType.RELATIONAL_COLUMN.typeName, OpenMetadataType.PRIMARY_KEY_CLASSIFICATION.typeGUID, OpenMetadataType.PRIMARY_KEY_CLASSIFICATION.typeName, properties, isMergeUpdate, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void removePrimaryKeyFromColumn(String userId, String databaseManagerGUID, String databaseManagerName, String databaseColumnGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String parentElementGUIDParameterName = "databaseColumnGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(databaseColumnGUID, "databaseColumnGUID", methodName);
        this.databaseColumnHandler.removeClassificationFromRepository(userId, databaseManagerGUID, databaseManagerName, databaseColumnGUID, "databaseColumnGUID", OpenMetadataType.RELATIONAL_COLUMN.typeName, OpenMetadataType.PRIMARY_KEY_CLASSIFICATION.typeGUID, OpenMetadataType.PRIMARY_KEY_CLASSIFICATION.typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void addForeignKeyRelationship(String userId, String databaseManagerGUID, String databaseManagerName, String primaryKeyColumnGUID, String foreignKeyColumnGUID, String name, String description, int confidence, String steward, String source, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String primaryElementGUIDParameterName = "primaryKeyColumnGUID";
        String foreignElementGUIDParameterName = "foreignKeyColumnGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(primaryKeyColumnGUID, "primaryKeyColumnGUID", methodName);
        this.invalidParameterHandler.validateGUID(foreignKeyColumnGUID, "foreignKeyColumnGUID", methodName);
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.NAME.name, name, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.DESCRIPTION.name, description, methodName);
        properties = this.repositoryHelper.addIntPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.CONFIDENCE.name, confidence, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.STEWARD.name, steward, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.SOURCE.name, source, methodName);
        this.databaseColumnHandler.linkElementToElement(userId, databaseManagerGUID, databaseManagerName, primaryKeyColumnGUID, "primaryKeyColumnGUID", OpenMetadataType.RELATIONAL_COLUMN.typeName, foreignKeyColumnGUID, "foreignKeyColumnGUID", OpenMetadataType.RELATIONAL_COLUMN.typeName, forLineage, forDuplicateProcessing, OpenMetadataType.FOREIGN_KEY_RELATIONSHIP.typeGUID, OpenMetadataType.FOREIGN_KEY_RELATIONSHIP.typeName, this.databaseColumnHandler.setUpEffectiveDates(properties, effectiveFrom, effectiveTo), effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void removeForeignKeyRelationship(String userId, String databaseManagerGUID, String databaseManagerName, String primaryKeyColumnGUID, String foreignKeyColumnGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String primaryElementGUIDParameterName = "primaryKeyColumnGUID";
        String foreignElementGUIDParameterName = "foreignKeyColumnGUID";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(primaryKeyColumnGUID, "primaryKeyColumnGUID", methodName);
        this.invalidParameterHandler.validateGUID(foreignKeyColumnGUID, "foreignKeyColumnGUID", methodName);
        this.databaseColumnHandler.unlinkElementFromElement(userId, false, databaseManagerGUID, databaseManagerName, primaryKeyColumnGUID, "primaryKeyColumnGUID", OpenMetadataType.RELATIONAL_COLUMN.typeName, foreignKeyColumnGUID, "foreignKeyColumnGUID", OpenMetadataType.RELATIONAL_COLUMN.typeGUID, OpenMetadataType.RELATIONAL_COLUMN.typeName, forLineage, forDuplicateProcessing, OpenMetadataType.FOREIGN_KEY_RELATIONSHIP.typeGUID, OpenMetadataType.FOREIGN_KEY_RELATIONSHIP.typeName, effectiveTime, methodName);
    }
}

