/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.lang.reflect.InvocationTargetException;
import org.odpi.openmetadata.commonservices.generichandlers.OMFConverter;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ReportElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.assets.display.ReportProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class ReportConverter<B>
extends OMFConverter<B> {
    public ReportConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    @Override
    public B getNewBean(Class<B> beanClass, EntityDetail entity, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof ReportElement) {
                ReportElement bean = (ReportElement)returnBean;
                ReportProperties reportProperties = new ReportProperties();
                if (entity != null) {
                    bean.setElementHeader(this.getMetadataElementHeader(beanClass, entity, methodName));
                    InstanceProperties instanceProperties = new InstanceProperties(entity.getProperties());
                    reportProperties.setQualifiedName(this.removeQualifiedName(instanceProperties));
                    reportProperties.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                    reportProperties.setName(this.removeName(instanceProperties));
                    reportProperties.setResourceName(this.removeResourceName(instanceProperties));
                    reportProperties.setVersionIdentifier(this.removeVersionIdentifier(instanceProperties));
                    reportProperties.setResourceDescription(this.removeDescription(instanceProperties));
                    reportProperties.setDeployedImplementationType(this.removeDeployedImplementationType(instanceProperties));
                    reportProperties.setId(this.removeId(instanceProperties));
                    reportProperties.setAuthor(this.removeAuthor(instanceProperties));
                    reportProperties.setUrl(this.removeURL(instanceProperties));
                    reportProperties.setCreateTime(this.removeCreatedTime(instanceProperties));
                    reportProperties.setLastModifiedTime(this.removeLastModifiedTime(instanceProperties));
                    reportProperties.setLastModifier(this.removeLastModifier(instanceProperties));
                    reportProperties.setTypeName(bean.getElementHeader().getType().getTypeName());
                    reportProperties.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
                    bean.setProperties(reportProperties);
                } else {
                    this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    @Override
    public B getNewBean(Class<B> beanClass, EntityDetail entity, Relationship relationship, String methodName) throws PropertyServerException {
        return this.getNewBean(beanClass, entity, methodName);
    }
}

