/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.generichandlers.OMFConverter;
import org.odpi.openmetadata.frameworks.openmetadata.enums.AnnotationStatus;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.frameworks.surveyaction.properties.Annotation;
import org.odpi.openmetadata.frameworks.surveyaction.properties.ClassificationAnnotation;
import org.odpi.openmetadata.frameworks.surveyaction.properties.DataClassAnnotation;
import org.odpi.openmetadata.frameworks.surveyaction.properties.QualityAnnotation;
import org.odpi.openmetadata.frameworks.surveyaction.properties.RelationshipAdviceAnnotation;
import org.odpi.openmetadata.frameworks.surveyaction.properties.RequestForActionAnnotation;
import org.odpi.openmetadata.frameworks.surveyaction.properties.ResourceMeasureAnnotation;
import org.odpi.openmetadata.frameworks.surveyaction.properties.ResourcePhysicalStatusAnnotation;
import org.odpi.openmetadata.frameworks.surveyaction.properties.ResourceProfileAnnotation;
import org.odpi.openmetadata.frameworks.surveyaction.properties.ResourceProfileLogAnnotation;
import org.odpi.openmetadata.frameworks.surveyaction.properties.SchemaAnalysisAnnotation;
import org.odpi.openmetadata.frameworks.surveyaction.properties.SemanticAnnotation;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EnumPropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceAuditHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstancePropertyValue;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public abstract class SAFConverter<B>
extends OMFConverter<B> {
    public SAFConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    protected Annotation getAnnotationBean(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        if (primaryEntity != null && primaryEntity.getType() != null) {
            String actualTypeName = primaryEntity.getType().getTypeDefName();
            if (this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, OpenMetadataType.CLASSIFICATION_ANNOTATION.typeName)) {
                return this.getNewClassificationAnnotation(beanClass, primaryEntity, supplementaryEntities, relationships, methodName);
            }
            if (this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, OpenMetadataType.DATA_CLASS_ANNOTATION.typeName)) {
                return this.getNewDataClassAnnotation(beanClass, primaryEntity, supplementaryEntities, relationships, methodName);
            }
            if (this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, OpenMetadataType.RESOURCE_PROFILE_ANNOTATION.typeName)) {
                return this.getNewResourceProfileAnnotation(beanClass, primaryEntity, supplementaryEntities, relationships, methodName);
            }
            if (this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, OpenMetadataType.RESOURCE_PROFILE_LOG_ANNOTATION.typeName)) {
                return this.getNewDataProfileLogAnnotation(beanClass, primaryEntity, supplementaryEntities, relationships, methodName);
            }
            if (this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, OpenMetadataType.RESOURCE_PHYSICAL_STATUS_ANNOTATION.typeName)) {
                return this.getNewDataSourcePhysicalStatusAnnotation(beanClass, primaryEntity, supplementaryEntities, relationships, methodName);
            }
            if (this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, OpenMetadataType.RESOURCE_MEASURE_ANNOTATION.typeName)) {
                return this.getNewDataSourceMeasurementAnnotation(beanClass, primaryEntity, supplementaryEntities, relationships, methodName);
            }
            if (this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, OpenMetadataType.QUALITY_ANNOTATION.typeName)) {
                return this.getNewQualityAnnotation(beanClass, primaryEntity, supplementaryEntities, relationships, methodName);
            }
            if (this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, OpenMetadataType.RELATIONSHIP_ADVICE_ANNOTATION.typeName)) {
                return this.getNewRelationshipAdviceAnnotation(beanClass, primaryEntity, supplementaryEntities, relationships, methodName);
            }
            if (this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, OpenMetadataType.REQUEST_FOR_ACTION_ANNOTATION.typeName)) {
                return this.getNewRequestForActionAnnotation(beanClass, primaryEntity, supplementaryEntities, relationships, methodName);
            }
            if (this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, OpenMetadataType.SCHEMA_ANALYSIS_ANNOTATION.typeName)) {
                return this.getNewSchemaAnalysisAnnotation(beanClass, primaryEntity, supplementaryEntities, relationships, methodName);
            }
            if (this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, OpenMetadataType.SEMANTIC_ANNOTATION.typeName)) {
                return this.getNewSemanticAnnotation(beanClass, primaryEntity, supplementaryEntities, relationships, methodName);
            }
            if (this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName, OpenMetadataType.ANNOTATION.typeName)) {
                return this.getNewAnnotation(beanClass, primaryEntity, supplementaryEntities, relationships, methodName);
            }
            super.validateInstanceType(OpenMetadataType.ANNOTATION.typeName, beanClass.getName(), (InstanceAuditHeader)primaryEntity, methodName);
        } else {
            this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
        }
        return null;
    }

    private Annotation getNewClassificationAnnotation(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        try {
            ClassificationAnnotation annotation = new ClassificationAnnotation();
            InstanceProperties remainingProperties = this.fillInCommonAnnotationProperties(beanClass, (Annotation)annotation, primaryEntity, supplementaryEntities, relationships, methodName);
            annotation.setCandidateClassifications(this.removeCandidateClassifications(remainingProperties));
            annotation.setExtendedProperties(this.getRemainingExtendedProperties(remainingProperties));
            return annotation;
        }
        catch (ClassCastException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    private Annotation getNewDataClassAnnotation(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        try {
            DataClassAnnotation annotation = new DataClassAnnotation();
            InstanceProperties remainingProperties = this.fillInCommonAnnotationProperties(beanClass, (Annotation)annotation, primaryEntity, supplementaryEntities, relationships, methodName);
            annotation.setCandidateDataClassGUIDs(this.removeCandidateDataClassGUIDs(remainingProperties));
            annotation.setExtendedProperties(this.getRemainingExtendedProperties(remainingProperties));
            return annotation;
        }
        catch (ClassCastException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    private Annotation getNewResourceProfileAnnotation(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        try {
            ResourceProfileAnnotation annotation = new ResourceProfileAnnotation();
            InstanceProperties remainingProperties = this.fillInCommonAnnotationProperties(beanClass, (Annotation)annotation, primaryEntity, supplementaryEntities, relationships, methodName);
            annotation.setProfilePropertyNames(this.removeProfilePropertyNames(remainingProperties));
            annotation.setLength(this.removeLength(remainingProperties));
            annotation.setInferredDataType(this.removeInferredDataType(remainingProperties));
            annotation.setInferredFormat(this.removeInferredFormat(remainingProperties));
            annotation.setInferredLength(this.removeInferredLength(remainingProperties));
            annotation.setInferredPrecision(this.removeInferredPrecision(remainingProperties));
            annotation.setInferredScale(this.removeInferredScale(remainingProperties));
            annotation.setProfileStartDate(this.removeProfileStartDate(remainingProperties));
            annotation.setProfileEndDate(this.removeProfileEndDate(remainingProperties));
            annotation.setProfileProperties(this.removeProfileProperties(remainingProperties));
            annotation.setProfileFlags(this.removeProfileFlags(remainingProperties));
            annotation.setProfileDates(this.removeProfileDates(remainingProperties));
            annotation.setProfileCounts(this.removeProfileCounts(remainingProperties));
            annotation.setProfileDoubles(this.removeProfileDoubles(remainingProperties));
            annotation.setValueList(this.removeValueList(remainingProperties));
            annotation.setValueCount(this.removeValueCount(remainingProperties));
            annotation.setValueRangeFrom(this.removeValueRangeFrom(remainingProperties));
            annotation.setValueRangeTo(this.removeValueRangeTo(remainingProperties));
            annotation.setAverageValue(this.removeAverageValue(remainingProperties));
            annotation.setExtendedProperties(this.getRemainingExtendedProperties(remainingProperties));
            return annotation;
        }
        catch (ClassCastException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    private Annotation getNewDataProfileLogAnnotation(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        try {
            ResourceProfileLogAnnotation annotation = new ResourceProfileLogAnnotation();
            InstanceProperties remainingProperties = this.fillInCommonAnnotationProperties(beanClass, (Annotation)annotation, primaryEntity, supplementaryEntities, relationships, methodName);
            ArrayList<String> dataProfileLogNames = new ArrayList<String>();
            if (relationships != null) {
                for (Relationship relationship : relationships) {
                    EntityProxy endTwo;
                    if (relationship == null || !this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), OpenMetadataType.RESOURCE_PROFILE_DATA_RELATIONSHIP.typeName) || (endTwo = relationship.getEntityTwoProxy()) == null) continue;
                    String name = this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.QUALIFIED_NAME.name, endTwo.getUniqueProperties(), methodName);
                    if (name == null) {
                        name = endTwo.getGUID();
                    }
                    dataProfileLogNames.add(name);
                }
            }
            annotation.setResourceProfileLogGUIDs(dataProfileLogNames);
            annotation.setExtendedProperties(this.getRemainingExtendedProperties(remainingProperties));
            return annotation;
        }
        catch (ClassCastException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    private Annotation getNewDataSourceMeasurementAnnotation(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        try {
            ResourceMeasureAnnotation annotation = new ResourceMeasureAnnotation();
            InstanceProperties remainingProperties = this.fillInCommonAnnotationProperties(beanClass, (Annotation)annotation, primaryEntity, supplementaryEntities, relationships, methodName);
            annotation.setResourceProperties(this.removeResourceProperties(remainingProperties));
            annotation.setExtendedProperties(this.getRemainingExtendedProperties(remainingProperties));
            return annotation;
        }
        catch (ClassCastException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    private Annotation getNewDataSourcePhysicalStatusAnnotation(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        try {
            ResourcePhysicalStatusAnnotation annotation = new ResourcePhysicalStatusAnnotation();
            InstanceProperties remainingProperties = this.fillInCommonAnnotationProperties(beanClass, (Annotation)annotation, primaryEntity, supplementaryEntities, relationships, methodName);
            annotation.setResourceProperties(this.removeResourceProperties(remainingProperties));
            annotation.setCreateTime(this.removeResourceCreateTime(remainingProperties));
            annotation.setModifiedTime(this.removeResourceUpdateTime(remainingProperties));
            annotation.setLastAccessedTime(this.removeResourceLastAccessedTime(remainingProperties));
            annotation.setSize((long)this.removeSize(remainingProperties));
            annotation.setEncoding(this.removeEncoding(remainingProperties));
            annotation.setExtendedProperties(this.getRemainingExtendedProperties(remainingProperties));
            return annotation;
        }
        catch (ClassCastException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    private Annotation getNewQualityAnnotation(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        try {
            QualityAnnotation annotation = new QualityAnnotation();
            InstanceProperties remainingProperties = this.fillInCommonAnnotationProperties(beanClass, (Annotation)annotation, primaryEntity, supplementaryEntities, relationships, methodName);
            annotation.setQualityDimension(this.removeQualityDimension(remainingProperties));
            annotation.setQualityScore(this.removeQualityScore(remainingProperties));
            annotation.setExtendedProperties(this.getRemainingExtendedProperties(remainingProperties));
            return annotation;
        }
        catch (ClassCastException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    private Annotation getNewRelationshipAdviceAnnotation(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        try {
            RelationshipAdviceAnnotation annotation = new RelationshipAdviceAnnotation();
            InstanceProperties remainingProperties = this.fillInCommonAnnotationProperties(beanClass, (Annotation)annotation, primaryEntity, supplementaryEntities, relationships, methodName);
            annotation.setRelatedEntityGUID(this.removeRelatedEntityGUID(remainingProperties));
            annotation.setRelationshipTypeName(this.removeRelationshipTypeName(remainingProperties));
            annotation.setRelationshipProperties(this.removeRelationshipProperties(remainingProperties));
            annotation.setExtendedProperties(this.getRemainingExtendedProperties(remainingProperties));
            return annotation;
        }
        catch (ClassCastException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    private Annotation getNewRequestForActionAnnotation(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        try {
            RequestForActionAnnotation annotation = new RequestForActionAnnotation();
            InstanceProperties remainingProperties = this.fillInCommonAnnotationProperties(beanClass, (Annotation)annotation, primaryEntity, supplementaryEntities, relationships, methodName);
            annotation.setSurveyActivity(this.removeSurveyActivity(remainingProperties));
            annotation.setActionRequested(this.removeActionRequested(remainingProperties));
            annotation.setActionProperties(this.removeActionProperties(remainingProperties));
            annotation.setExtendedProperties(this.getRemainingExtendedProperties(remainingProperties));
            return annotation;
        }
        catch (ClassCastException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    private Annotation getNewSchemaAnalysisAnnotation(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        try {
            SchemaAnalysisAnnotation annotation = new SchemaAnalysisAnnotation();
            InstanceProperties remainingProperties = this.fillInCommonAnnotationProperties(beanClass, (Annotation)annotation, primaryEntity, supplementaryEntities, relationships, methodName);
            annotation.setSchemaName(this.removeSchemaName(remainingProperties));
            annotation.setSchemaTypeName(this.removeSchemaType(remainingProperties));
            annotation.setExtendedProperties(this.getRemainingExtendedProperties(remainingProperties));
            return annotation;
        }
        catch (ClassCastException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    private Annotation getNewSemanticAnnotation(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        try {
            SemanticAnnotation annotation = new SemanticAnnotation();
            InstanceProperties remainingProperties = this.fillInCommonAnnotationProperties(beanClass, (Annotation)annotation, primaryEntity, supplementaryEntities, relationships, methodName);
            annotation.setInformalTerm(this.removeInformalTerm(remainingProperties));
            annotation.setCandidateGlossaryTermGUIDs(this.removeCandidateGlossaryTermGUIDs(remainingProperties));
            annotation.setInformalTopic(this.removeInformalTopic(remainingProperties));
            annotation.setCandidateGlossaryCategoryGUIDs(this.removeCandidateGlossaryCategoryGUIDs(remainingProperties));
            annotation.setExtendedProperties(this.getRemainingExtendedProperties(remainingProperties));
            return annotation;
        }
        catch (ClassCastException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    private Annotation getNewAnnotation(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        try {
            Annotation annotation = new Annotation();
            InstanceProperties remainingProperties = this.fillInCommonAnnotationProperties(beanClass, annotation, primaryEntity, supplementaryEntities, relationships, methodName);
            annotation.setExtendedProperties(this.getRemainingExtendedProperties(remainingProperties));
            return annotation;
        }
        catch (ClassCastException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    private InstanceProperties fillInCommonAnnotationProperties(Class<B> beanClass, Annotation annotation, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        annotation.setElementHeader(this.getMetadataElementHeader(beanClass, primaryEntity, methodName));
        InstanceProperties instanceProperties = null;
        if (primaryEntity.getProperties() != null) {
            instanceProperties = new InstanceProperties(primaryEntity.getProperties());
        }
        annotation.setAnnotationType(this.removeAnnotationType(instanceProperties));
        annotation.setSummary(this.removeSummary(instanceProperties));
        annotation.setConfidenceLevel(this.removeConfidenceLevel(instanceProperties));
        annotation.setExpression(this.removeExpression(instanceProperties));
        annotation.setExplanation(this.removeExplanation(instanceProperties));
        annotation.setAnalysisStep(this.removeAnalysisStep(instanceProperties));
        annotation.setJsonProperties(this.removeJsonProperties(instanceProperties));
        annotation.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
        if (supplementaryEntities != null) {
            for (EntityDetail entity : supplementaryEntities) {
                String actualTypeName;
                if (entity == null || entity.getType() == null || !this.repositoryHelper.isTypeOf(this.serviceName, actualTypeName = entity.getType().getTypeDefName(), OpenMetadataType.ANNOTATION_REVIEW.typeName)) continue;
                InstanceProperties properties = new InstanceProperties(entity.getProperties());
                annotation.setReviewDate(this.removeReviewDate(properties));
                annotation.setSteward(this.removeSteward(properties));
                annotation.setReviewComment(this.removeComment(properties));
            }
        }
        if (relationships != null) {
            for (Relationship relationship : relationships) {
                if (relationship == null || !this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), OpenMetadataType.ANNOTATION_REVIEW_LINK_RELATIONSHIP.typeName)) continue;
                annotation.setAnnotationStatus(this.getAnnotationStatusFromProperties(instanceProperties));
            }
        }
        return instanceProperties;
    }

    private AnnotationStatus getAnnotationStatusFromProperties(InstanceProperties properties) {
        Map instancePropertiesMap;
        InstancePropertyValue instancePropertyValue;
        AnnotationStatus requestStatus = AnnotationStatus.UNKNOWN_STATUS;
        if (properties != null && (instancePropertyValue = (InstancePropertyValue)(instancePropertiesMap = properties.getInstanceProperties()).get(OpenMetadataProperty.ANNOTATION_STATUS.name)) instanceof EnumPropertyValue) {
            EnumPropertyValue enumPropertyValue = (EnumPropertyValue)instancePropertyValue;
            switch (enumPropertyValue.getOrdinal()) {
                case 0: {
                    requestStatus = AnnotationStatus.NEW_ANNOTATION;
                    break;
                }
                case 1: {
                    requestStatus = AnnotationStatus.REVIEWED_ANNOTATION;
                    break;
                }
                case 2: {
                    requestStatus = AnnotationStatus.APPROVED_ANNOTATION;
                    break;
                }
                case 3: {
                    requestStatus = AnnotationStatus.ACTIONED_ANNOTATION;
                    break;
                }
                case 4: {
                    requestStatus = AnnotationStatus.INVALID_ANNOTATION;
                    break;
                }
                case 5: {
                    requestStatus = AnnotationStatus.IGNORE_ANNOTATION;
                    break;
                }
                case 98: {
                    requestStatus = AnnotationStatus.OTHER_STATUS;
                    break;
                }
                default: {
                    requestStatus = AnnotationStatus.UNKNOWN_STATUS;
                }
            }
        }
        return requestStatus;
    }
}

