/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaTypeBuilder;
import org.odpi.openmetadata.frameworks.openmetadata.enums.DataItemSortOrder;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.OMFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.ClassificationOrigin;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProvenanceType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.TypeErrorException;

public class SchemaAttributeBuilder
extends ReferenceableBuilder {
    private String displayName = null;
    private String description = null;
    private int elementPosition = 0;
    private int minCardinality = 0;
    private int maxCardinality = 0;
    private boolean isDeprecated = false;
    private boolean allowsDuplicateValues = false;
    private boolean orderedValues = false;
    private int sortOrder = 0;
    private int minimumLength = 0;
    private int length = 0;
    private int precision = 0;
    private boolean isNullable = true;
    private String defaultValueOverride = null;
    private String nativeJavaClass = null;
    private List<String> aliases = null;
    private SchemaTypeBuilder schemaTypeBuilder = null;

    public SchemaAttributeBuilder(String qualifiedName, String displayName, String description, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, OpenMetadataType.SCHEMA_ATTRIBUTE.typeGUID, OpenMetadataType.SCHEMA_ATTRIBUTE.typeName, repositoryHelper, serviceName, serverName);
        this.displayName = displayName;
        this.description = description;
    }

    public SchemaAttributeBuilder(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(OpenMetadataType.SCHEMA_ATTRIBUTE.typeGUID, OpenMetadataType.SCHEMA_ATTRIBUTE.typeName, repositoryHelper, serviceName, serverName);
    }

    public SchemaAttributeBuilder(String qualifiedName, String displayName, String description, int elementPosition, int minCardinality, int maxCardinality, boolean isDeprecated, String defaultValueOverride, boolean allowsDuplicateValues, boolean orderedValues, int sortOrder, int minimumLength, int length, int precision, boolean isNullable, String nativeJavaClass, List<String> aliases, Map<String, String> additionalProperties, String typeId, String typeName, Map<String, Object> extendedProperties, OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(qualifiedName, additionalProperties, typeId, typeName, extendedProperties, repositoryHelper, serviceName, serverName);
        this.displayName = displayName;
        this.description = description;
        this.elementPosition = elementPosition;
        this.minCardinality = minCardinality;
        this.maxCardinality = maxCardinality;
        this.isDeprecated = isDeprecated;
        this.defaultValueOverride = defaultValueOverride;
        this.allowsDuplicateValues = allowsDuplicateValues;
        this.orderedValues = orderedValues;
        this.sortOrder = sortOrder;
        this.minimumLength = minimumLength;
        this.length = length;
        this.precision = precision;
        this.isNullable = isNullable;
        this.nativeJavaClass = nativeJavaClass;
        this.aliases = aliases;
    }

    public void setSchemaType(String userId, SchemaTypeBuilder schemaTypeBuilder, String methodName) throws InvalidParameterException {
        this.schemaTypeBuilder = schemaTypeBuilder;
        try {
            Classification classification = this.repositoryHelper.getNewClassification(this.serviceName, null, null, InstanceProvenanceType.LOCAL_COHORT, userId, OpenMetadataType.TYPE_EMBEDDED_ATTRIBUTE_CLASSIFICATION.typeName, this.typeName, ClassificationOrigin.ASSIGNED, null, schemaTypeBuilder.getTypeEmbeddedInstanceProperties(methodName));
            this.newClassifications.put(classification.getName(), classification);
        }
        catch (TypeErrorException error) {
            this.errorHandler.handleUnsupportedType((Exception)((Object)error), methodName, OpenMetadataType.TYPE_EMBEDDED_ATTRIBUTE_CLASSIFICATION.typeName);
        }
    }

    @Override
    public void setAnchors(String userId, String anchorGUID, String anchorTypeName, String anchorDomainName, String anchorScopeGUID, String methodName) throws PropertyServerException {
        super.setAnchors(userId, anchorGUID, anchorTypeName, anchorDomainName, anchorScopeGUID, methodName);
        if (this.schemaTypeBuilder != null) {
            this.schemaTypeBuilder.setAnchors(userId, anchorGUID, anchorTypeName, anchorDomainName, anchorScopeGUID, methodName);
        }
    }

    public SchemaTypeBuilder getSchemaTypeBuilder() {
        return this.schemaTypeBuilder;
    }

    void setCalculatedValue(String userId, String externalSourceGUID, String externalSourceName, String formula, String methodName) throws InvalidParameterException {
        this.setCalculatedValue(userId, externalSourceGUID, externalSourceName, this.getCalculatedValueProperties(formula, methodName), methodName);
    }

    void setCalculatedValue(String userId, String externalSourceGUID, String externalSourceName, InstanceProperties instanceProperties, String methodName) throws InvalidParameterException {
        try {
            InstanceProvenanceType instanceProvenanceType = InstanceProvenanceType.LOCAL_COHORT;
            if (externalSourceGUID != null) {
                instanceProvenanceType = InstanceProvenanceType.EXTERNAL_SOURCE;
            }
            Classification classification = this.repositoryHelper.getNewClassification(this.serviceName, externalSourceGUID, externalSourceName, instanceProvenanceType, userId, OpenMetadataType.CALCULATED_VALUE_CLASSIFICATION.typeName, this.typeName, ClassificationOrigin.ASSIGNED, null, instanceProperties);
            this.newClassifications.put(classification.getName(), classification);
        }
        catch (TypeErrorException error) {
            this.errorHandler.handleUnsupportedType((Exception)((Object)error), methodName, OpenMetadataType.CALCULATED_VALUE_CLASSIFICATION.typeName);
        }
    }

    public InstanceProperties getCalculatedValueProperties(String formula, String methodName) {
        InstanceProperties properties = null;
        if (formula != null) {
            properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.FORMULA.name, formula, methodName);
        }
        return properties;
    }

    @Override
    public InstanceProperties getInstanceProperties(String methodName) throws InvalidParameterException {
        InstanceProperties properties = super.getInstanceProperties(methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.DISPLAY_NAME.name, this.displayName, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.DESCRIPTION.name, this.description, methodName);
        properties = this.repositoryHelper.addBooleanPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.IS_DEPRECATED.name, this.isDeprecated, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.DEFAULT_VALUE_OVERRIDE.name, this.defaultValueOverride, methodName);
        properties = this.repositoryHelper.addBooleanPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.ALLOWS_DUPLICATE_VALUES.name, this.allowsDuplicateValues, methodName);
        properties = this.repositoryHelper.addBooleanPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.ORDERED_VALUES.name, this.orderedValues, methodName);
        try {
            properties = this.repositoryHelper.addEnumPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.SORT_ORDER.name, DataItemSortOrder.getOpenTypeGUID(), DataItemSortOrder.getOpenTypeName(), this.sortOrder, methodName);
        }
        catch (TypeErrorException error) {
            throw new InvalidParameterException((OMFCheckedExceptionBase)error, OpenMetadataProperty.SORT_ORDER.name);
        }
        properties = this.repositoryHelper.addIntPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.MINIMUM_LENGTH.name, this.minimumLength, methodName);
        properties = this.repositoryHelper.addIntPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.LENGTH.name, this.length, methodName);
        properties = this.repositoryHelper.addIntPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.PRECISION.name, this.precision, methodName);
        properties = this.repositoryHelper.addBooleanPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.IS_NULLABLE.name, this.isNullable, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.NATIVE_CLASS.name, this.nativeJavaClass, methodName);
        properties = this.repositoryHelper.addStringArrayPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.ALIASES.name, this.aliases, methodName);
        return properties;
    }

    public InstanceProperties getParentRelationshipProperties(String methodName) {
        InstanceProperties properties = null;
        properties = this.repositoryHelper.addIntPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.POSITION.name, this.elementPosition, methodName);
        properties = this.repositoryHelper.addIntPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.MIN_CARDINALITY.name, this.minCardinality, methodName);
        properties = this.repositoryHelper.addIntPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.MAX_CARDINALITY.name, this.maxCardinality, methodName);
        return properties;
    }
}

