/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaAttributeBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaElementHandler;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaTypeBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaTypeHandler;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntitySummary;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;
import org.odpi.openmetadata.repositoryservices.ffdc.exception.ClassificationErrorException;

public class SchemaAttributeHandler<SCHEMA_ATTRIBUTE, SCHEMA_TYPE>
extends SchemaElementHandler<SCHEMA_ATTRIBUTE> {
    private final OpenMetadataAPIGenericConverter<SCHEMA_ATTRIBUTE> schemaAttributeConverter;
    private final Class<SCHEMA_TYPE> schemaTypeBeanClass;
    private final SchemaTypeHandler<SCHEMA_TYPE> schemaTypeHandler;

    public SchemaAttributeHandler(OpenMetadataAPIGenericConverter<SCHEMA_ATTRIBUTE> schemaAttributeConverter, Class<SCHEMA_ATTRIBUTE> schemaAttributeBeanClass, OpenMetadataAPIGenericConverter<SCHEMA_TYPE> schemaTypeConverter, Class<SCHEMA_TYPE> schemaTypeBeanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(schemaAttributeConverter, schemaAttributeBeanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.schemaAttributeConverter = schemaAttributeConverter;
        this.schemaTypeBeanClass = schemaTypeBeanClass;
        this.schemaTypeHandler = new SchemaTypeHandler<SCHEMA_TYPE>(schemaTypeConverter, schemaTypeBeanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public String createSchemaAttributeFromTemplate(String userId, String externalSourceGUID, String externalSourceName, String parentElementGUID, String parentElementGUIDParameterName, String templateGUID, String qualifiedName, String displayName, String description, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(parentElementGUID, parentElementGUIDParameterName, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        SchemaAttributeBuilder builder = new SchemaAttributeBuilder(qualifiedName, displayName, description, this.repositoryHelper, this.serviceName, this.serverName);
        String schemaAttributeGUID = this.createBeanFromTemplate(userId, externalSourceGUID, externalSourceName, templateGUID, "templateGUID", OpenMetadataType.SCHEMA_ATTRIBUTE.typeGUID, OpenMetadataType.SCHEMA_ATTRIBUTE.typeName, qualifiedName, OpenMetadataProperty.QUALIFIED_NAME.name, builder, this.supportedZones, true, false, null, methodName);
        if (schemaAttributeGUID != null) {
            String schemaAttributeGUIDParameterName = "schemaAttributeGUID";
            EntityDetail parentEntity = this.getEntityFromRepository(userId, parentElementGUID, parentElementGUIDParameterName, OpenMetadataType.SCHEMA_ELEMENT.typeName, null, null, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
            String parentElementRelationshipTypeGUID = OpenMetadataType.ATTRIBUTE_FOR_SCHEMA_RELATIONSHIP.typeGUID;
            if (parentEntity != null && parentEntity.getType() != null && this.repositoryHelper.isTypeOf(this.serviceName, parentEntity.getType().getTypeDefName(), OpenMetadataType.SCHEMA_ATTRIBUTE.typeName)) {
                parentElementRelationshipTypeGUID = OpenMetadataType.NESTED_SCHEMA_ATTRIBUTE_RELATIONSHIP.typeGUID;
            }
            this.uncheckedLinkElementToElement(userId, externalSourceGUID, externalSourceName, parentElementGUID, parentElementGUIDParameterName, schemaAttributeGUID, "schemaAttributeGUID", parentElementRelationshipTypeGUID, builder.getParentRelationshipProperties(methodName), methodName);
        }
        return schemaAttributeGUID;
    }

    public String createNestedSchemaAttribute(String userId, String externalSourceGUID, String externalSourceName, String parentElementGUID, String parentElementGUIDParameterName, String qualifiedName, String qualifiedNameParameterName, SchemaAttributeBuilder schemaAttributeBuilder, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(parentElementGUID, parentElementGUIDParameterName, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, qualifiedNameParameterName, methodName);
        EntityDetail parentEntity = this.getEntityFromRepository(userId, parentElementGUID, parentElementGUIDParameterName, OpenMetadataType.SCHEMA_ELEMENT.typeName, null, null, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
        String parentAttributeTypeName = OpenMetadataType.COMPLEX_SCHEMA_TYPE.typeName;
        String parentAttributeRelationshipTypeGUID = OpenMetadataType.ATTRIBUTE_FOR_SCHEMA_RELATIONSHIP.typeGUID;
        String parentAttributeRelationshipTypeName = OpenMetadataType.ATTRIBUTE_FOR_SCHEMA_RELATIONSHIP.typeName;
        if (parentEntity != null && parentEntity.getType() != null) {
            if (this.repositoryHelper.isTypeOf(this.serviceName, parentEntity.getType().getTypeDefName(), OpenMetadataType.SCHEMA_ATTRIBUTE.typeName)) {
                parentAttributeTypeName = OpenMetadataType.SCHEMA_ATTRIBUTE.typeName;
                parentAttributeRelationshipTypeGUID = OpenMetadataType.NESTED_SCHEMA_ATTRIBUTE_RELATIONSHIP.typeGUID;
                parentAttributeRelationshipTypeName = OpenMetadataType.NESTED_SCHEMA_ATTRIBUTE_RELATIONSHIP.typeName;
            }
            this.setUpAnchorsClassificationFromParent(userId, parentElementGUID, parentElementGUIDParameterName, schemaAttributeBuilder, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            SchemaTypeBuilder schemaTypeBuilder = schemaAttributeBuilder.getSchemaTypeBuilder();
            if (schemaTypeBuilder != null && schemaTypeBuilder.isDerived()) {
                String sourceName = "local";
                if (externalSourceName != null && !externalSourceName.isEmpty()) {
                    sourceName = externalSourceName;
                }
                InstanceProperties instanceProperties = schemaTypeBuilder.getCalculatedValueProperties(methodName);
                String formula = this.repositoryHelper.getStringProperty(sourceName, OpenMetadataProperty.FORMULA.name, instanceProperties, methodName);
                schemaAttributeBuilder.setCalculatedValue(userId, externalSourceGUID, externalSourceName, formula, methodName);
            }
            return this.createNestedSchemaAttribute(userId, externalSourceGUID, externalSourceName, parentElementGUID, parentElementGUIDParameterName, parentAttributeTypeName, parentAttributeRelationshipTypeGUID, parentAttributeRelationshipTypeName, qualifiedName, qualifiedNameParameterName, schemaAttributeBuilder, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        this.invalidParameterHandler.throwUnknownElement(userId, parentElementGUID, OpenMetadataType.SCHEMA_ELEMENT.typeName, this.serviceName, this.serverName, methodName);
        return null;
    }

    public String createNestedSchemaAttribute(String userId, String externalSourceGUID, String externalSourceName, String parentElementGUID, String parentElementGUIDParameterName, String qualifiedName, String qualifiedNameParameterName, String displayName, String description, String externalSchemaTypeGUID, String dataType, String defaultValue, String fixedValue, String validValuesSetGUID, String formula, boolean isDeprecated, int elementPosition, int minCardinality, int maxCardinality, boolean allowsDuplicateValues, boolean orderedValues, String defaultValueOverride, int sortOrder, int minimumLength, int length, int significantDigits, boolean isNullable, String nativeJavaClass, List<String> aliases, Map<String, String> additionalProperties, String typeName, Map<String, Object> extendedProperties, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(parentElementGUID, parentElementGUIDParameterName, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, qualifiedNameParameterName, methodName);
        String schemaAttributeTypeName = OpenMetadataType.SCHEMA_ATTRIBUTE.typeName;
        String schemaAttributeTypeId = OpenMetadataType.SCHEMA_ATTRIBUTE.typeGUID;
        if (typeName != null) {
            schemaAttributeTypeName = typeName;
            schemaAttributeTypeId = this.invalidParameterHandler.validateTypeName(typeName, OpenMetadataType.SCHEMA_ATTRIBUTE.typeName, this.serviceName, methodName, this.repositoryHelper);
        }
        SchemaAttributeBuilder schemaAttributeBuilder = new SchemaAttributeBuilder(qualifiedName, displayName, description, elementPosition, minCardinality, maxCardinality, isDeprecated, defaultValueOverride, allowsDuplicateValues, orderedValues, sortOrder, minimumLength, length, significantDigits, isNullable, nativeJavaClass, aliases, additionalProperties, schemaAttributeTypeId, schemaAttributeTypeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        if (formula != null) {
            schemaAttributeBuilder.setCalculatedValue(userId, externalSourceGUID, externalSourceName, formula, methodName);
        }
        schemaAttributeBuilder.setEffectivityDates(effectiveFrom, effectiveTo);
        SchemaTypeBuilder schemaTypeBuilder = this.getSchemaTypeBuilder(qualifiedName, externalSchemaTypeGUID, dataType, defaultValue, fixedValue, validValuesSetGUID);
        schemaAttributeBuilder.setSchemaType(userId, schemaTypeBuilder, methodName);
        return this.createNestedSchemaAttribute(userId, externalSourceGUID, externalSourceName, parentElementGUID, parentElementGUIDParameterName, qualifiedName, qualifiedNameParameterName, schemaAttributeBuilder, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    SchemaTypeBuilder getSchemaTypeBuilder(String qualifiedName, String externalSchemaTypeGUID, String dataType, String defaultValue, String fixedValue, String validValuesSetGUID) {
        String schemaTypeGUID = OpenMetadataType.STRUCT_SCHEMA_TYPE.typeGUID;
        String schemaTypeName = OpenMetadataType.STRUCT_SCHEMA_TYPE.typeName;
        if (externalSchemaTypeGUID != null) {
            schemaTypeGUID = OpenMetadataType.EXTERNAL_SCHEMA_TYPE.typeGUID;
            schemaTypeName = OpenMetadataType.EXTERNAL_SCHEMA_TYPE.typeName;
        } else if (validValuesSetGUID != null) {
            schemaTypeGUID = OpenMetadataType.ENUM_SCHEMA_TYPE.typeGUID;
            schemaTypeName = OpenMetadataType.ENUM_SCHEMA_TYPE.typeName;
        } else if (fixedValue != null) {
            schemaTypeGUID = OpenMetadataType.LITERAL_SCHEMA_TYPE.typeGUID;
            schemaTypeName = OpenMetadataType.LITERAL_SCHEMA_TYPE.typeName;
        } else if (dataType != null) {
            schemaTypeGUID = OpenMetadataType.PRIMITIVE_SCHEMA_TYPE.typeGUID;
            schemaTypeName = OpenMetadataType.PRIMITIVE_SCHEMA_TYPE.typeName;
        }
        SchemaTypeBuilder schemaTypeBuilder = new SchemaTypeBuilder(qualifiedName + ":Type", schemaTypeGUID, schemaTypeName, this.repositoryHelper, this.serviceName, this.serverName);
        schemaTypeBuilder.setDataType(dataType);
        schemaTypeBuilder.setDefaultValue(defaultValue);
        schemaTypeBuilder.setFixedValue(fixedValue);
        schemaTypeBuilder.setExternalSchemaTypeGUID(externalSchemaTypeGUID);
        schemaTypeBuilder.setValidValuesSetGUID(validValuesSetGUID);
        return schemaTypeBuilder;
    }

    public String createNestedSchemaAttribute(String userId, String externalSourceGUID, String externalSourceName, String parentElementGUID, String parentElementGUIDParameterName, String parentElementTypeName, String parentAttributeRelationshipTypeGUID, String parentAttributeRelationshipTypeName, String qualifiedName, String qualifiedNameParameterName, SchemaAttributeBuilder schemaAttributeBuilder, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(parentElementGUID, parentElementGUIDParameterName, methodName);
        this.invalidParameterHandler.validateName(qualifiedName, qualifiedNameParameterName, methodName);
        String schemaAttributeGUID = this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, schemaAttributeBuilder.getTypeGUID(), schemaAttributeBuilder.getTypeName(), schemaAttributeBuilder, effectiveTime, methodName);
        if (schemaAttributeGUID != null) {
            String schemaAttributeGUIDParameterName = "schemaAttributeGUID";
            this.addEmbeddedTypes(userId, externalSourceGUID, externalSourceName, schemaAttributeGUID, "schemaAttributeGUID", schemaAttributeBuilder.getTypeName(), schemaAttributeBuilder.getSchemaTypeBuilder(), effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            this.uncheckedLinkElementToElement(userId, externalSourceGUID, externalSourceName, parentElementGUID, parentElementGUIDParameterName, schemaAttributeGUID, "schemaAttributeGUID", parentAttributeRelationshipTypeGUID, schemaAttributeBuilder.getParentRelationshipProperties(methodName), methodName);
            return schemaAttributeGUID;
        }
        return null;
    }

    public List<SCHEMA_ATTRIBUTE> getSchemaAttributesForComplexSchemaType(String userId, String schemaTypeGUID, String guidParameterName, String requiredClassificationName, String omittedClassificationName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getSchemaAttributesForComplexSchemaType(userId, schemaTypeGUID, guidParameterName, OpenMetadataType.SCHEMA_ATTRIBUTE.typeName, requiredClassificationName, omittedClassificationName, this.supportedZones, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<SCHEMA_ATTRIBUTE> getSchemaAttributesForComplexSchemaType(String userId, String schemaTypeGUID, String schemaTypeGUIDParameterName, String schemaAttributeTypeName, String requiredClassificationName, String omittedClassificationName, List<String> serviceSupportedZones, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String schemaAttributeGUIDParameterName = "schemaAttributeEntity.getGUID()";
        String typeName = OpenMetadataType.SCHEMA_ATTRIBUTE.typeName;
        if (schemaAttributeTypeName != null) {
            typeName = schemaAttributeTypeName;
        }
        List<EntityDetail> entities = this.getAttachedEntities(userId, schemaTypeGUID, schemaTypeGUIDParameterName, OpenMetadataType.SCHEMA_TYPE.typeName, OpenMetadataType.ATTRIBUTE_FOR_SCHEMA_RELATIONSHIP.typeGUID, OpenMetadataType.ATTRIBUTE_FOR_SCHEMA_RELATIONSHIP.typeName, typeName, requiredClassificationName, omittedClassificationName, 2, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, serviceSupportedZones, startFrom, pageSize, effectiveTime, methodName);
        ArrayList<SCHEMA_ATTRIBUTE> results = new ArrayList<SCHEMA_ATTRIBUTE>();
        if (entities != null) {
            for (EntityDetail schemaAttributeEntity : entities) {
                if (schemaAttributeEntity == null) continue;
                results.add(this.getSchemaAttributeFromEntity(userId, schemaAttributeEntity.getGUID(), "schemaAttributeEntity.getGUID()", schemaAttributeEntity, forLineage, forDuplicateProcessing, effectiveTime, methodName));
            }
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public List<SCHEMA_ATTRIBUTE> getAttachedSchemaAttributes(String userId, String parentElementGUID, String parentElementGUIDParameterName, String schemaAttributeTypeName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getAttachedSchemaAttributes(userId, parentElementGUID, parentElementGUIDParameterName, schemaAttributeTypeName, this.supportedZones, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<SCHEMA_ATTRIBUTE> getAttachedSchemaAttributes(String userId, String parentElementGUID, String parentElementGUIDParameterName, String schemaAttributeTypeName, List<String> serviceSupportedZones, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        EntityDetail parentEntity = this.getEntityFromRepository(userId, parentElementGUID, parentElementGUIDParameterName, OpenMetadataType.SCHEMA_ELEMENT.typeName, null, null, forLineage, forDuplicateProcessing, serviceSupportedZones, effectiveTime, methodName);
        if (parentEntity != null && parentEntity.getType() != null) {
            if (this.repositoryHelper.isTypeOf(this.serviceName, parentEntity.getType().getTypeDefName(), OpenMetadataType.SCHEMA_ATTRIBUTE.typeName)) {
                return this.getNestedSchemaAttributes(userId, parentElementGUID, parentElementGUIDParameterName, schemaAttributeTypeName, serviceSupportedZones, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
            return this.getSchemaAttributesForComplexSchemaType(userId, parentElementGUID, parentElementGUIDParameterName, schemaAttributeTypeName, null, null, serviceSupportedZones, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        return null;
    }

    public List<SCHEMA_ATTRIBUTE> getNestedSchemaAttributes(String userId, String schemaAttributeGUID, String schemaAttributeGUIDParameterName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getNestedSchemaAttributes(userId, schemaAttributeGUID, schemaAttributeGUIDParameterName, OpenMetadataType.SCHEMA_ATTRIBUTE.typeName, this.supportedZones, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<SCHEMA_ATTRIBUTE> getNestedSchemaAttributes(String userId, String schemaAttributeGUID, String schemaAttributeGUIDParameterName, String schemaAttributeTypeName, List<String> serviceSupportedZones, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String nestedSchemaAttributeGUIDParameterName = "schemaAttributeEntity.getGUID()";
        String resultTypeName = OpenMetadataType.SCHEMA_ATTRIBUTE.typeName;
        if (schemaAttributeTypeName != null) {
            resultTypeName = schemaAttributeTypeName;
        }
        List<EntityDetail> entities = this.getAttachedEntities(userId, schemaAttributeGUID, schemaAttributeGUIDParameterName, OpenMetadataType.SCHEMA_ATTRIBUTE.typeName, OpenMetadataType.NESTED_SCHEMA_ATTRIBUTE_RELATIONSHIP.typeGUID, OpenMetadataType.NESTED_SCHEMA_ATTRIBUTE_RELATIONSHIP.typeName, resultTypeName, null, null, 2, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, serviceSupportedZones, startFrom, pageSize, effectiveTime, methodName);
        ArrayList<SCHEMA_ATTRIBUTE> results = new ArrayList<SCHEMA_ATTRIBUTE>();
        if (entities != null) {
            for (EntityDetail schemaAttributeEntity : entities) {
                if (schemaAttributeEntity == null) continue;
                results.add(this.getSchemaAttributeFromEntity(userId, schemaAttributeEntity.getGUID(), "schemaAttributeEntity.getGUID()", schemaAttributeEntity, forLineage, forDuplicateProcessing, effectiveTime, methodName));
            }
        } else {
            EntityDetail entity = this.getAttachedEntity(userId, schemaAttributeGUID, schemaAttributeGUIDParameterName, OpenMetadataType.SCHEMA_ATTRIBUTE.typeName, OpenMetadataType.SCHEMA_ATTRIBUTE_TYPE_RELATIONSHIP.typeGUID, OpenMetadataType.SCHEMA_ATTRIBUTE_TYPE_RELATIONSHIP.typeName, OpenMetadataType.SCHEMA_ATTRIBUTE.typeName, 2, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
            if (entity != null) {
                String schemaTypeGUIDParameterName = "schemaTypeGUID";
                return this.getSchemaAttributesForComplexSchemaType(userId, entity.getGUID(), schemaTypeGUIDParameterName, schemaAttributeTypeName, null, null, this.supportedZones, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    private List<Relationship> getSchemaAttributeRelationships(String userId, EntityDetail schemaAttributeEntity, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String schemaAttributeGUIDParameterName = "schemaAttributeEntity";
        ArrayList<Relationship> results = new ArrayList<Relationship>();
        List<Relationship> relationships = this.getAttachmentLinks(userId, schemaAttributeEntity.getGUID(), "schemaAttributeEntity", OpenMetadataType.SCHEMA_ATTRIBUTE.typeName, null, null, null, OpenMetadataType.SCHEMA_ATTRIBUTE.typeName, 0, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, 0, this.invalidParameterHandler.getMaxPagingSize(), effectiveTime, methodName);
        if (relationships != null) {
            for (Relationship relationship : relationships) {
                if (relationship == null || relationship.getType() == null) continue;
                String typeName = relationship.getType().getTypeDefName();
                if (OpenMetadataType.FOREIGN_KEY_RELATIONSHIP.typeName.equals(typeName)) {
                    results.add(relationship);
                    continue;
                }
                if (OpenMetadataType.GRAPH_EDGE_LINK_RELATIONSHIP.typeName.equals(typeName)) {
                    results.add(relationship);
                    continue;
                }
                if (OpenMetadataType.ATTRIBUTE_FOR_SCHEMA_RELATIONSHIP.typeName.equals(typeName)) {
                    results.add(relationship);
                    continue;
                }
                if (!OpenMetadataType.NESTED_SCHEMA_ATTRIBUTE_RELATIONSHIP.typeName.equals(typeName) || !schemaAttributeEntity.getGUID().equals(relationship.getEntityTwoProxy().getGUID())) continue;
                results.add(relationship);
            }
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    private SCHEMA_ATTRIBUTE getSchemaAttributeFromEntity(String userId, String schemaAttributeGUID, String schemaAttributeGUIDParameterName, EntityDetail schemaAttributeEntity, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (schemaAttributeEntity != null && schemaAttributeEntity.getType() != null) {
            Object schemaType = null;
            try {
                Classification typeClassification = this.repositoryHelper.getClassificationFromEntity(this.serviceName, (EntitySummary)schemaAttributeEntity, OpenMetadataType.TYPE_EMBEDDED_ATTRIBUTE_CLASSIFICATION.typeName, methodName);
                if (typeClassification != null && typeClassification.getProperties() != null) {
                    String schemaTypeName = this.repositoryHelper.getStringProperty(this.serviceName, OpenMetadataProperty.SCHEMA_TYPE_NAME.name, typeClassification.getProperties(), methodName);
                    schemaType = this.schemaTypeHandler.getSchemaTypeFromInstance(userId, (InstanceHeader)schemaAttributeEntity, schemaTypeName, typeClassification.getProperties(), schemaAttributeEntity.getClassifications(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
                }
            }
            catch (ClassificationErrorException typeClassification) {
                // empty catch block
            }
            if (schemaType == null) {
                schemaType = this.schemaTypeHandler.getSchemaTypeForParent(userId, schemaAttributeGUID, schemaAttributeGUIDParameterName, OpenMetadataType.SCHEMA_ATTRIBUTE.typeName, OpenMetadataType.SCHEMA_ATTRIBUTE_TYPE_RELATIONSHIP.typeGUID, OpenMetadataType.SCHEMA_ATTRIBUTE_TYPE_RELATIONSHIP.typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
            List<Relationship> attributeRelationships = this.getSchemaAttributeRelationships(userId, schemaAttributeEntity, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            return this.schemaAttributeConverter.getNewSchemaAttributeBean(this.beanClass, schemaAttributeEntity, this.schemaTypeBeanClass, schemaType, attributeRelationships, methodName);
        }
        return null;
    }

    private List<SCHEMA_ATTRIBUTE> getSchemaAttributesFromEntities(String userId, List<EntityDetail> schemaAttributeEntities, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String parameterName = "schemaAttributeEntities";
        if (schemaAttributeEntities != null) {
            ArrayList<SCHEMA_ATTRIBUTE> schemaAttributes = new ArrayList<SCHEMA_ATTRIBUTE>();
            for (EntityDetail entity : schemaAttributeEntities) {
                if (entity == null) continue;
                schemaAttributes.add(this.getSchemaAttributeFromEntity(userId, entity.getGUID(), "schemaAttributeEntities", entity, forLineage, forDuplicateProcessing, effectiveTime, methodName));
            }
            if (!schemaAttributes.isEmpty()) {
                return schemaAttributes;
            }
        }
        return null;
    }

    public SCHEMA_ATTRIBUTE getSchemaAttribute(String userId, String schemaAttributeGUID, String schemaAttributeGUIDParameterName, String expectedTypeName, String requiredClassificationName, String omittedClassificationName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String typeParameterName = "expectedTypeName";
        this.invalidParameterHandler.validateGUID(schemaAttributeGUID, schemaAttributeGUIDParameterName, methodName);
        this.invalidParameterHandler.validateName(expectedTypeName, "expectedTypeName", methodName);
        EntityDetail schemaAttributeEntity = this.getEntityFromRepository(userId, schemaAttributeGUID, schemaAttributeGUIDParameterName, expectedTypeName, requiredClassificationName, omittedClassificationName, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
        return this.getSchemaAttributeFromEntity(userId, schemaAttributeGUID, schemaAttributeGUIDParameterName, schemaAttributeEntity, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<SCHEMA_ATTRIBUTE> getSchemaAttributesByName(String userId, String typeGUID, String typeName, String name, String requiredClassificationName, String omittedClassificationName, int elementStart, int maxElements, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getSchemaAttributesByName(userId, typeGUID, typeName, name, requiredClassificationName, omittedClassificationName, this.supportedZones, elementStart, maxElements, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<SCHEMA_ATTRIBUTE> getSchemaAttributesByName(String userId, String typeGUID, String typeName, String name, String requiredClassificationName, String omittedClassificationName, List<String> serviceSupportedZones, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String nameParameterName = "name";
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add(OpenMetadataProperty.QUALIFIED_NAME.name);
        specificMatchPropertyNames.add(OpenMetadataProperty.DISPLAY_NAME.name);
        List<EntityDetail> schemaAttributeEntities = this.getEntitiesByValue(userId, name, "name", typeGUID, typeName, specificMatchPropertyNames, true, false, requiredClassificationName, omittedClassificationName, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, serviceSupportedZones, startFrom, pageSize, effectiveTime, methodName);
        return this.getSchemaAttributesFromEntities(userId, schemaAttributeEntities, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<SCHEMA_ATTRIBUTE> findSchemaAttributes(String userId, String searchString, String searchStringParameterName, String resultTypeGUID, String resultTypeName, String requiredClassificationName, String omittedClassificationName, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List<EntityDetail> schemaAttributeEntities = this.findEntities(userId, searchString, searchStringParameterName, resultTypeGUID, resultTypeName, requiredClassificationName, omittedClassificationName, startFrom, pageSize, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return this.getSchemaAttributesFromEntities(userId, schemaAttributeEntities, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void updateSchemaAttribute(String userId, String externalSourceGUID, String externalSourceName, String schemaAttributeGUID, String schemaAttributeGUIDParameterName, String qualifiedName, String qualifiedNameParameterName, String displayName, String description, String externalSchemaTypeGUID, String dataType, String defaultValue, String fixedValue, String validValuesSetGUID, String formula, boolean isDeprecated, int elementPosition, int minCardinality, int maxCardinality, boolean allowsDuplicateValues, boolean orderedValues, String defaultValueOverride, int sortOrder, int minimumLength, int length, int significantDigits, boolean isNullable, String nativeJavaClass, List<String> aliases, Map<String, String> additionalProperties, String typeName, Map<String, Object> extendedProperties, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        EntityDetail schemaAttributeEntity;
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(schemaAttributeGUID, schemaAttributeGUIDParameterName, methodName);
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(qualifiedName, qualifiedNameParameterName, methodName);
        }
        String attributeTypeName = OpenMetadataType.SCHEMA_ATTRIBUTE.typeName;
        String attributeTypeId = OpenMetadataType.SCHEMA_ATTRIBUTE.typeGUID;
        if (typeName != null) {
            attributeTypeName = typeName;
            attributeTypeId = this.invalidParameterHandler.validateTypeName(typeName, OpenMetadataType.SCHEMA_ATTRIBUTE.typeName, this.serviceName, methodName, this.repositoryHelper);
        }
        if ((schemaAttributeEntity = this.getEntityFromRepository(userId, schemaAttributeGUID, schemaAttributeGUIDParameterName, attributeTypeName, null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName)) != null) {
            SchemaAttributeBuilder schemaAttributeBuilder = new SchemaAttributeBuilder(qualifiedName, displayName, description, elementPosition, minCardinality, maxCardinality, isDeprecated, defaultValueOverride, allowsDuplicateValues, orderedValues, sortOrder, minimumLength, length, significantDigits, isNullable, nativeJavaClass, aliases, additionalProperties, attributeTypeId, attributeTypeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
            schemaAttributeBuilder.setEffectivityDates(effectiveFrom, effectiveTo);
            InstanceProperties instanceProperties = schemaAttributeBuilder.getInstanceProperties(methodName);
            this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, schemaAttributeGUID, schemaAttributeGUIDParameterName, OpenMetadataType.SCHEMA_ATTRIBUTE.typeGUID, OpenMetadataType.SCHEMA_ATTRIBUTE.typeName, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, instanceProperties, true, effectiveTime, methodName);
            SchemaTypeBuilder schemaTypeBuilder = this.getSchemaTypeBuilder(qualifiedName, externalSchemaTypeGUID, dataType, defaultValue, fixedValue, validValuesSetGUID);
            this.setClassificationInRepository(userId, externalSourceGUID, externalSourceName, schemaAttributeEntity, schemaAttributeGUIDParameterName, attributeTypeName, OpenMetadataType.TYPE_EMBEDDED_ATTRIBUTE_CLASSIFICATION.typeGUID, OpenMetadataType.TYPE_EMBEDDED_ATTRIBUTE_CLASSIFICATION.typeName, schemaTypeBuilder.getTypeEmbeddedInstanceProperties(methodName), isMergeUpdate, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, effectiveTime, methodName);
            if (formula != null) {
                schemaAttributeBuilder.setCalculatedValue(userId, externalSourceGUID, externalSourceName, formula, methodName);
                this.setClassificationInRepository(userId, externalSourceGUID, externalSourceName, schemaAttributeEntity, schemaAttributeGUIDParameterName, attributeTypeName, OpenMetadataType.TYPE_EMBEDDED_ATTRIBUTE_CLASSIFICATION.typeGUID, OpenMetadataType.TYPE_EMBEDDED_ATTRIBUTE_CLASSIFICATION.typeName, schemaTypeBuilder.getTypeEmbeddedInstanceProperties(methodName), isMergeUpdate, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, effectiveTime, methodName);
            }
        }
    }

    public void updateSchemaAttribute(String userId, String externalSourceGUID, String externalSourceName, String schemaAttributeGUID, String schemaAttributeGUIDParameterName, String qualifiedName, String qualifiedNameParameterName, SchemaAttributeBuilder schemaAttributeBuilder, String typeName, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        EntityDetail schemaAttributeEntity;
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(schemaAttributeGUID, schemaAttributeGUIDParameterName, methodName);
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(qualifiedName, qualifiedNameParameterName, methodName);
        }
        String attributeTypeName = OpenMetadataType.SCHEMA_ATTRIBUTE.typeName;
        if (typeName != null) {
            attributeTypeName = typeName;
        }
        if ((schemaAttributeEntity = this.getEntityFromRepository(userId, schemaAttributeGUID, schemaAttributeGUIDParameterName, attributeTypeName, null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName)) != null) {
            InstanceProperties instanceProperties = schemaAttributeBuilder.getInstanceProperties(methodName);
            this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, schemaAttributeGUID, schemaAttributeGUIDParameterName, OpenMetadataType.SCHEMA_ATTRIBUTE.typeGUID, OpenMetadataType.SCHEMA_ATTRIBUTE.typeName, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, instanceProperties, true, effectiveTime, methodName);
            SchemaTypeBuilder schemaTypeBuilder = schemaAttributeBuilder.getSchemaTypeBuilder();
            if (schemaTypeBuilder != null) {
                InstanceProperties calculatedValueProperties = schemaTypeBuilder.getCalculatedValueProperties(methodName);
                if (calculatedValueProperties == null) {
                    if (!isMergeUpdate) {
                        try {
                            String sourceName = "local";
                            if (externalSourceName != null && !externalSourceName.isEmpty()) {
                                sourceName = externalSourceName;
                            }
                            this.repositoryHelper.getClassificationFromEntity(sourceName, (EntitySummary)schemaAttributeEntity, OpenMetadataType.CALCULATED_VALUE_CLASSIFICATION.typeName, methodName);
                            this.removeClassificationFromRepository(userId, externalSourceGUID, externalSourceName, schemaAttributeGUID, schemaAttributeGUIDParameterName, OpenMetadataType.SCHEMA_ATTRIBUTE.typeName, OpenMetadataType.CALCULATED_VALUE_CLASSIFICATION.typeGUID, OpenMetadataType.CALCULATED_VALUE_CLASSIFICATION.typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                        }
                        catch (ClassificationErrorException classificationErrorException) {}
                    }
                } else {
                    this.setClassificationInRepository(userId, externalSourceGUID, externalSourceName, schemaAttributeEntity, schemaAttributeGUIDParameterName, attributeTypeName, OpenMetadataType.CALCULATED_VALUE_CLASSIFICATION.typeGUID, OpenMetadataType.CALCULATED_VALUE_CLASSIFICATION.typeName, calculatedValueProperties, isMergeUpdate, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, effectiveTime, methodName);
                }
                this.setClassificationInRepository(userId, externalSourceGUID, externalSourceName, schemaAttributeEntity, schemaAttributeGUIDParameterName, attributeTypeName, OpenMetadataType.TYPE_EMBEDDED_ATTRIBUTE_CLASSIFICATION.typeGUID, OpenMetadataType.TYPE_EMBEDDED_ATTRIBUTE_CLASSIFICATION.typeName, schemaTypeBuilder.getTypeEmbeddedInstanceProperties(methodName), isMergeUpdate, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, effectiveTime, methodName);
            }
        }
    }

    public void updateSchemaAttribute(String userId, String externalSourceGUID, String externalSourceName, String schemaAttributeGUID, InstanceProperties instanceProperties, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String parameterName = "schemaAttributeGUID";
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, schemaAttributeGUID, "schemaAttributeGUID", OpenMetadataType.SCHEMA_ATTRIBUTE.typeGUID, OpenMetadataType.SCHEMA_ATTRIBUTE.typeName, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, instanceProperties, true, effectiveTime, methodName);
    }

    public void updateSchemaAttribute(String userId, String externalSourceGUID, String externalSourceName, String schemaAttributeGUID, String schemaAttributeGUIDParameterName, InstanceProperties instanceProperties, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, schemaAttributeGUID, schemaAttributeGUIDParameterName, OpenMetadataType.SCHEMA_ATTRIBUTE.typeGUID, OpenMetadataType.SCHEMA_ATTRIBUTE.typeName, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, instanceProperties, isMergeUpdate, effectiveTime, methodName);
    }

    public void updateSchemaAttribute(String userId, String externalSourceGUID, String externalSourceName, String schemaAttributeGUID, String schemaAttributeGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, List<String> serviceSupportedZones, InstanceProperties instanceProperties, boolean isMergeUpdate, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, schemaAttributeGUID, schemaAttributeGUIDParameterName, OpenMetadataType.SCHEMA_ATTRIBUTE.typeGUID, OpenMetadataType.SCHEMA_ATTRIBUTE.typeName, forLineage, forDuplicateProcessing, serviceSupportedZones, instanceProperties, isMergeUpdate, effectiveTime, methodName);
    }

    public void removeSchemaTypes(String userId, String externalSourceGUID, String externalSourceName, String schemaAttributeGUID, String schemaAttributeGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
    }
}

