/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.ReferenceableHandler;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaTypeBuilder;
import org.odpi.openmetadata.commonservices.generichandlers.ffdc.GenericHandlersErrorCode;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

class SchemaElementHandler<B>
extends ReferenceableHandler<B> {
    SchemaElementHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    String getAssetSchemaTypeGUID(String userId, String externalSourceGUID, String externalSourceName, String assetGUID, String assetGUIDParameterName, String assetTypeName, String assetScopeGUID, String schemaTypeTypeGUID, String schemaTypeTypeName, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(assetGUID, assetGUIDParameterName, methodName);
        String assetQualifiedName = this.getBeanStringPropertyFromRepository(userId, assetGUID, assetGUIDParameterName, assetTypeName, OpenMetadataProperty.QUALIFIED_NAME.name, effectiveTime, methodName);
        if (assetQualifiedName == null) {
            this.invalidParameterHandler.throwUnknownElement(userId, assetGUID, assetTypeName, this.serviceName, this.serverName, methodName);
            return null;
        }
        EntityDetail schemaTypeEntity = this.getAttachedEntity(userId, assetGUID, assetGUIDParameterName, assetTypeName, OpenMetadataType.ASSET_SCHEMA_TYPE_RELATIONSHIP.typeGUID, OpenMetadataType.ASSET_SCHEMA_TYPE_RELATIONSHIP.typeName, schemaTypeTypeName, 2, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
        if (schemaTypeEntity == null) {
            String schemaTypeQualifiedName = "SchemaOf:" + assetQualifiedName;
            SchemaTypeBuilder builder = new SchemaTypeBuilder(schemaTypeQualifiedName, schemaTypeTypeGUID, schemaTypeTypeName, this.repositoryHelper, this.serviceName, this.serverName);
            this.setUpAnchorsClassificationFromAnchor(userId, assetGUID, assetGUIDParameterName, assetScopeGUID, builder, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            String schemaTypeGUID = this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, schemaTypeTypeGUID, schemaTypeTypeName, builder, effectiveTime, methodName);
            String schemaTypeGUIDParameterName = "schemaTypeGUID";
            if (schemaTypeGUID != null) {
                this.linkElementToElement(userId, externalSourceGUID, externalSourceName, assetGUID, assetGUIDParameterName, assetTypeName, schemaTypeGUID, "schemaTypeGUID", schemaTypeTypeName, forLineage, forDuplicateProcessing, this.supportedZones, OpenMetadataType.ASSET_SCHEMA_TYPE_RELATIONSHIP.typeGUID, OpenMetadataType.ASSET_SCHEMA_TYPE_RELATIONSHIP.typeName, null, effectiveFrom, effectiveTo, effectiveTime, methodName);
            }
            return schemaTypeGUID;
        }
        return schemaTypeEntity.getGUID();
    }

    void addEmbeddedTypes(String userId, String externalSourceGUID, String externalSourceName, String schemaTypeGUID, String schemaTypeGUIDParameterName, String schemaTypeTypeName, SchemaTypeBuilder schemaTypeBuilder, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String mapFromParameterName = "mapFromSchemaType";
        String mapToParameterName = "mapToSchemaType";
        String externalParameterName = "externalSchemaType";
        String optionParameterName = "optionSchemaType";
        if (schemaTypeBuilder != null) {
            List<SchemaTypeBuilder> schemaOptionBuilders;
            if (this.repositoryHelper.isTypeOf(this.serviceName, schemaTypeBuilder.getTypeName(), OpenMetadataType.EXTERNAL_SCHEMA_TYPE.typeName)) {
                String externalSchemaGUID = schemaTypeBuilder.getExternalSchemaTypeGUID();
                if (externalSchemaGUID != null) {
                    this.linkElementToElement(userId, externalSourceGUID, externalSourceName, schemaTypeGUID, schemaTypeGUIDParameterName, schemaTypeTypeName, externalSchemaGUID, "externalSchemaType", OpenMetadataType.SCHEMA_TYPE.typeName, forLineage, forDuplicateProcessing, this.supportedZones, OpenMetadataType.LINKED_EXTERNAL_SCHEMA_TYPE_RELATIONSHIP.typeGUID, OpenMetadataType.LINKED_EXTERNAL_SCHEMA_TYPE_RELATIONSHIP.typeName, null, effectiveFrom, effectiveTo, effectiveTime, methodName);
                }
            } else if (this.repositoryHelper.isTypeOf(this.serviceName, schemaTypeBuilder.getTypeName(), OpenMetadataType.MAP_SCHEMA_TYPE.typeName)) {
                SchemaTypeBuilder mapFromBuilder = schemaTypeBuilder.getMapFrom();
                SchemaTypeBuilder mapToBuilder = schemaTypeBuilder.getMapTo();
                String mapFromGUID = schemaTypeBuilder.getMapFromGUID();
                String mapToGUID = schemaTypeBuilder.getMapToGUID();
                if (mapFromBuilder != null) {
                    mapFromGUID = this.addSchemaType(userId, externalSourceGUID, externalSourceName, mapFromBuilder, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                }
                if (mapFromGUID != null) {
                    this.linkElementToElement(userId, externalSourceGUID, externalSourceName, schemaTypeGUID, schemaTypeGUIDParameterName, schemaTypeTypeName, mapFromGUID, "mapFromSchemaType", OpenMetadataType.SCHEMA_TYPE.typeName, forLineage, forDuplicateProcessing, this.supportedZones, OpenMetadataType.MAP_FROM_ELEMENT_TYPE_RELATIONSHIP.typeGUID, OpenMetadataType.MAP_FROM_ELEMENT_TYPE_RELATIONSHIP.typeName, null, effectiveFrom, effectiveTo, effectiveTime, methodName);
                }
                if (mapToBuilder != null) {
                    mapToGUID = this.addSchemaType(userId, externalSourceGUID, externalSourceName, mapToBuilder, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
                }
                if (mapToGUID != null) {
                    this.linkElementToElement(userId, externalSourceGUID, externalSourceName, schemaTypeGUID, schemaTypeGUIDParameterName, schemaTypeTypeName, mapToGUID, "mapToSchemaType", OpenMetadataType.SCHEMA_TYPE.typeName, forLineage, forDuplicateProcessing, this.supportedZones, OpenMetadataType.MAP_TO_ELEMENT_TYPE_RELATIONSHIP.typeGUID, OpenMetadataType.MAP_TO_ELEMENT_TYPE_RELATIONSHIP.typeName, null, effectiveFrom, effectiveTo, effectiveTime, methodName);
                }
            } else if (this.repositoryHelper.isTypeOf(this.serviceName, schemaTypeBuilder.getTypeName(), OpenMetadataType.SCHEMA_TYPE_CHOICE.typeName) && (schemaOptionBuilders = schemaTypeBuilder.getSchemaOptions()) != null) {
                for (SchemaTypeBuilder schemaOptionBuilder : schemaOptionBuilders) {
                    String optionGUID;
                    if (schemaOptionBuilder == null || (optionGUID = this.addSchemaType(userId, externalSourceGUID, externalSourceName, schemaOptionBuilder, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName)) == null) continue;
                    this.linkElementToElement(userId, externalSourceGUID, externalSourceName, schemaTypeGUID, schemaTypeGUIDParameterName, schemaTypeTypeName, optionGUID, "optionSchemaType", OpenMetadataType.SCHEMA_TYPE.typeName, forLineage, forDuplicateProcessing, this.supportedZones, OpenMetadataType.SCHEMA_TYPE_CHOICE.typeGUID, OpenMetadataType.SCHEMA_TYPE_CHOICE.typeName, null, effectiveFrom, effectiveTo, effectiveTime, methodName);
                }
            }
        }
    }

    private String addSchemaType(String userId, String externalSourceGUID, String externalSourceName, SchemaTypeBuilder schemaTypeBuilder, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String schemaTypeGUIDParameterName = "schemaTypeGUID";
        String schemaTypeGUID = this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, schemaTypeBuilder.getTypeGUID(), schemaTypeBuilder.getTypeName(), schemaTypeBuilder, effectiveTime, methodName);
        this.addEmbeddedTypes(userId, externalSourceGUID, externalSourceName, schemaTypeGUID, "schemaTypeGUID", OpenMetadataType.SCHEMA_TYPE.typeName, schemaTypeBuilder, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return schemaTypeGUID;
    }

    int countSchemaAttributes(String userId, String schemaElementGUID, String guidParameterName, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(schemaElementGUID, guidParameterName, methodName);
        return this.repositoryHandler.countAttachedRelationshipsByType(userId, schemaElementGUID, OpenMetadataType.SCHEMA_ELEMENT.typeName, OpenMetadataType.NESTED_SCHEMA_ATTRIBUTE_RELATIONSHIP.typeGUID, OpenMetadataType.NESTED_SCHEMA_ATTRIBUTE_RELATIONSHIP.typeName, 2, null, null, SequencingOrder.CREATION_DATE_RECENT, null, false, false, effectiveTime, methodName);
    }

    public void setupQueryTargetRelationship(String userId, String externalSourceGUID, String externalSourceName, String schemaElementGUID, String schemaElementGUIDParameterName, String schemaElementTypeName, String queryId, String query, String queryTargetGUID, String queryTargetGUIDParameterName, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String queryParameterName = "query";
        this.invalidParameterHandler.validateObject((Object)query, "query", methodName);
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.QUERY.name, query, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.QUERY_ID.name, queryId, methodName);
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, schemaElementGUID, schemaElementGUIDParameterName, schemaElementTypeName, queryTargetGUID, queryTargetGUIDParameterName, OpenMetadataType.SCHEMA_ELEMENT.typeName, forLineage, forDuplicateProcessing, this.supportedZones, OpenMetadataType.DERIVED_SCHEMA_TYPE_QUERY_TARGET_RELATIONSHIP.typeGUID, OpenMetadataType.DERIVED_SCHEMA_TYPE_QUERY_TARGET_RELATIONSHIP.typeName, properties, effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void updateQueryTargetRelationship(String userId, String externalSourceGUID, String externalSourceName, String schemaElementGUID, String schemaElementGUIDParameterName, String schemaElementTypeName, String queryId, String query, String queryTargetGUID, String queryTargetGUIDParameterName, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String queryParameterName = "query";
        this.invalidParameterHandler.validateObject((Object)query, "query", methodName);
        InstanceProperties properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, null, OpenMetadataProperty.QUERY.name, query, methodName);
        properties = this.repositoryHelper.addStringPropertyToInstance(this.serviceName, properties, OpenMetadataProperty.QUERY_ID.name, queryId, methodName);
        this.updateElementToElementLink(userId, externalSourceGUID, externalSourceName, schemaElementGUID, schemaElementGUIDParameterName, schemaElementTypeName, queryTargetGUID, queryTargetGUIDParameterName, OpenMetadataType.SCHEMA_ELEMENT.typeName, forLineage, forDuplicateProcessing, this.supportedZones, OpenMetadataType.DERIVED_SCHEMA_TYPE_QUERY_TARGET_RELATIONSHIP.typeGUID, OpenMetadataType.DERIVED_SCHEMA_TYPE_QUERY_TARGET_RELATIONSHIP.typeName, isMergeUpdate, this.setUpEffectiveDates(properties, effectiveFrom, effectiveTo), effectiveTime, methodName);
    }

    public void clearQueryTargetRelationship(String userId, String externalSourceGUID, String externalSourceName, String schemaElementGUID, String schemaElementGUIDParameterName, String schemaElementTypeName, String queryTargetGUID, String queryTargetGUIDParameterName, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, schemaElementGUID, schemaElementGUIDParameterName, schemaElementTypeName, queryTargetGUID, queryTargetGUIDParameterName, OpenMetadataType.SCHEMA_ELEMENT.typeGUID, OpenMetadataType.SCHEMA_ELEMENT.typeName, false, false, OpenMetadataType.DERIVED_SCHEMA_TYPE_QUERY_TARGET_RELATIONSHIP.typeGUID, OpenMetadataType.DERIVED_SCHEMA_TYPE_QUERY_TARGET_RELATIONSHIP.typeName, null, methodName);
    }

    public void setupSchemaElementRelationship(String userId, String externalSourceGUID, String externalSourceName, String endOneGUID, String endTwoGUID, String relationshipTypeName, Map<String, Object> properties, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String endOneParameterName = "endOneGUID";
        String endTwoParameterName = "endTwoGUID";
        String relationshipTypeParameterName = "relationshipTypeName";
        String propertiesParameterName = "properties";
        this.invalidParameterHandler.validateName(relationshipTypeName, "relationshipTypeName", methodName);
        String relationshipTypeGUID = this.invalidParameterHandler.validateTypeName(relationshipTypeName, null, this.serviceName, methodName, this.repositoryHelper);
        InstanceProperties instanceProperties = null;
        if (properties != null && !properties.isEmpty()) {
            try {
                instanceProperties = this.repositoryHelper.addPropertyMapToInstance(this.serviceName, null, properties, methodName);
            }
            catch (Exception badPropertyException) {
                throw new InvalidParameterException(GenericHandlersErrorCode.BAD_PARAMETER.getMessageDefinition(relationshipTypeName, badPropertyException.getClass().getName(), badPropertyException.getMessage()), this.getClass().getName(), methodName, badPropertyException, "properties");
            }
        }
        this.linkElementToElement(userId, externalSourceGUID, externalSourceName, endOneGUID, "endOneGUID", OpenMetadataType.SCHEMA_ELEMENT.typeName, endTwoGUID, "endTwoGUID", OpenMetadataType.SCHEMA_ELEMENT.typeName, forLineage, forDuplicateProcessing, relationshipTypeGUID, relationshipTypeName, instanceProperties, effectiveFrom, effectiveTo, effectiveTime, methodName);
    }

    public void clearSchemaElementRelationship(String userId, String externalSourceGUID, String externalSourceName, String endOneGUID, String endTwoGUID, String relationshipTypeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String endOneParameterName = "endOneGUID";
        String endTwoParameterName = "endTwoGUID";
        String relationshipTypeParameterName = "relationshipTypeName";
        this.invalidParameterHandler.validateName(relationshipTypeName, "relationshipTypeName", methodName);
        String relationshipTypeGUID = this.invalidParameterHandler.validateTypeName(relationshipTypeName, null, this.serviceName, methodName, this.repositoryHelper);
        this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, endOneGUID, "endOneGUID", OpenMetadataType.SCHEMA_ELEMENT.typeName, endTwoGUID, "endTwoGUID", OpenMetadataType.SCHEMA_ELEMENT.typeGUID, OpenMetadataType.SCHEMA_ELEMENT.typeName, forLineage, forDuplicateProcessing, relationshipTypeGUID, relationshipTypeName, effectiveTime, methodName);
    }
}

