/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.commonservices.generichandlers.OMFConverter;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.SchemaTypeElement;
import org.odpi.openmetadata.frameworks.openmetadata.properties.schema.DerivedSchemaTypeQueryTargetProperties;
import org.odpi.openmetadata.frameworks.openmetadata.properties.schema.SchemaTypeProperties;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.typedefs.TypeDefCategory;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class SchemaTypeConverter<B>
extends OMFConverter<B> {
    public SchemaTypeConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    @Override
    public B getNewSchemaTypeBean(Class<B> beanClass, InstanceHeader schemaRootHeader, String schemaTypeTypeName, InstanceProperties schemaRootProperties, List<Classification> schemaRootClassifications, int attributeCount, String validValueSetGUID, String externalSchemaTypeGUID, B externalSchemaType, String mapFromSchemaTypeGUID, B mapFromSchemaType, String mapToSchemaTypeGUID, B mapToSchemaType, List<String> schemaTypeOptionGUIDs, List<B> schemaTypeOptions, List<Relationship> queryTargetRelationships, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof SchemaTypeElement) {
                if (schemaRootHeader != null && schemaRootProperties != null) {
                    SchemaTypeElement bean = (SchemaTypeElement)returnBean;
                    bean.setElementHeader(this.getMetadataElementHeader(beanClass, schemaRootHeader, schemaRootClassifications, methodName));
                    InstanceProperties instanceProperties = new InstanceProperties(schemaRootProperties);
                    SchemaTypeProperties schemaTypeProperties = new SchemaTypeProperties();
                    schemaTypeProperties.setQualifiedName(this.removeQualifiedName(instanceProperties));
                    schemaTypeProperties.setDisplayName(this.removeDisplayName(instanceProperties));
                    schemaTypeProperties.setDescription(this.removeDescription(instanceProperties));
                    schemaTypeProperties.setIsDeprecated(this.removeIsDeprecated(instanceProperties));
                    schemaTypeProperties.setVersionNumber(this.removeVersionNumber(instanceProperties));
                    schemaTypeProperties.setAuthor(this.removeAuthor(instanceProperties));
                    schemaTypeProperties.setUsage(this.removeUsage(instanceProperties));
                    schemaTypeProperties.setEncodingStandard(this.removeEncodingStandard(instanceProperties));
                    schemaTypeProperties.setNamespace(this.removeNamespace(instanceProperties));
                    schemaTypeProperties.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                    schemaTypeProperties.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
                    bean.setSchemaTypeProperties(schemaTypeProperties);
                    bean.setAttributeCount(attributeCount);
                    bean.setMapFromElement((SchemaTypeElement)mapFromSchemaType);
                    bean.setMapToElement((SchemaTypeElement)mapToSchemaType);
                    bean.setExternalSchemaType((SchemaTypeElement)externalSchemaType);
                    if (schemaTypeOptions != null && !schemaTypeOptions.isEmpty()) {
                        ArrayList<SchemaTypeElement> schemaTypeOptionBeans = new ArrayList<SchemaTypeElement>();
                        for (B optionBean : schemaTypeOptions) {
                            if (optionBean == null) continue;
                            schemaTypeOptionBeans.add((SchemaTypeElement)optionBean);
                        }
                        if (!schemaTypeOptionBeans.isEmpty()) {
                            bean.setSchemaOptions(schemaTypeOptionBeans);
                        }
                    }
                    InstanceProperties classificationProperties = super.getClassificationProperties(OpenMetadataType.CALCULATED_VALUE_CLASSIFICATION.typeName, schemaRootClassifications);
                    bean.setFormula(this.getFormula(classificationProperties));
                    bean.setFormulaType(this.getFormulaType(classificationProperties));
                    if (queryTargetRelationships != null) {
                        ArrayList<DerivedSchemaTypeQueryTargetProperties> queryTargets = new ArrayList<DerivedSchemaTypeQueryTargetProperties>();
                        for (Relationship relationship : queryTargetRelationships) {
                            if (relationship != null && relationship.getEntityTwoProxy() != null) {
                                DerivedSchemaTypeQueryTargetProperties queryTargetProperties = new DerivedSchemaTypeQueryTargetProperties();
                                queryTargetProperties.setQueryId(this.getQueryId(relationship.getProperties()));
                                queryTargetProperties.setQuery(this.getQuery(relationship.getProperties()));
                                queryTargetProperties.setQueryTargetGUID(relationship.getEntityTwoProxy().getGUID());
                                queryTargets.add(queryTargetProperties);
                                continue;
                            }
                            this.handleBadRelationship(beanClass.getName(), relationship, methodName);
                        }
                        if (!queryTargets.isEmpty()) {
                            bean.setQueries(queryTargets);
                        }
                    }
                    return returnBean;
                }
                this.handleMissingMetadataInstance(beanClass.getName(), TypeDefCategory.ENTITY_DEF, methodName);
            }
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
        }
        return null;
    }
}

