/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaElementHandler;
import org.odpi.openmetadata.commonservices.generichandlers.SchemaTypeBuilder;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Classification;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceHeader;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class SchemaTypeHandler<B>
extends SchemaElementHandler<B> {
    private final OpenMetadataAPIGenericConverter<B> schemaTypeConverter;

    public SchemaTypeHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
        this.schemaTypeConverter = converter;
    }

    public String addSchemaType(String userId, String externalSourceGUID, String externalSourceName, SchemaTypeBuilder schemaTypeBuilder, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String schemaTypeGUIDParameterName = "schemaTypeGUID";
        String schemaTypeGUID = this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, schemaTypeBuilder.getTypeGUID(), schemaTypeBuilder.getTypeName(), schemaTypeBuilder, effectiveTime, methodName);
        this.addEmbeddedTypes(userId, externalSourceGUID, externalSourceName, schemaTypeGUID, "schemaTypeGUID", schemaTypeBuilder.getTypeName(), schemaTypeBuilder, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return schemaTypeGUID;
    }

    public String addPrimitiveSchemaType(String userId, String externalSourceGUID, String externalSourceName, String qualifiedName, String displayName, String description, String versionNumber, boolean isDeprecated, String author, String usage, String encodingStandard, String namespace, String dataType, String defaultValue, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String typeName = OpenMetadataType.PRIMITIVE_SCHEMA_TYPE.typeName;
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, OpenMetadataType.PRIMITIVE_SCHEMA_TYPE.typeName, this.serviceName, methodName, this.repositoryHelper);
        SchemaTypeBuilder builder = new SchemaTypeBuilder(qualifiedName, displayName, description, versionNumber, isDeprecated, author, usage, encodingStandard, namespace, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setDataType(dataType);
        builder.setDefaultValue(defaultValue);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        return this.addSchemaType(userId, externalSourceGUID, externalSourceName, builder, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public String addLiteralSchemaType(String userId, String externalSourceGUID, String externalSourceName, String qualifiedName, String displayName, String description, String versionNumber, boolean isDeprecated, String author, String usage, String encodingStandard, String namespace, String dataType, String fixedValue, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String typeName = OpenMetadataType.LITERAL_SCHEMA_TYPE.typeName;
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, OpenMetadataType.LITERAL_SCHEMA_TYPE.typeName, this.serviceName, methodName, this.repositoryHelper);
        SchemaTypeBuilder builder = new SchemaTypeBuilder(qualifiedName, displayName, description, versionNumber, isDeprecated, author, usage, encodingStandard, namespace, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setDataType(dataType);
        builder.setFixedValue(fixedValue);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        return this.addSchemaType(userId, externalSourceGUID, externalSourceName, builder, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public String addEnumSchemaType(String userId, String externalSourceGUID, String externalSourceName, String qualifiedName, String displayName, String description, String versionNumber, boolean isDeprecated, String author, String usage, String encodingStandard, String namespace, String dataType, String defaultValue, String validValuesSetGUID, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String typeName = OpenMetadataType.ENUM_SCHEMA_TYPE.typeName;
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, OpenMetadataType.ENUM_SCHEMA_TYPE.typeName, this.serviceName, methodName, this.repositoryHelper);
        SchemaTypeBuilder builder = new SchemaTypeBuilder(qualifiedName, displayName, description, versionNumber, isDeprecated, author, usage, encodingStandard, namespace, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setDataType(dataType);
        builder.setDefaultValue(defaultValue);
        builder.setValidValuesSetGUID(validValuesSetGUID);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        return this.addSchemaType(userId, externalSourceGUID, externalSourceName, builder, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public String addStructSchemaType(String userId, String externalSourceGUID, String externalSourceName, String qualifiedName, String displayName, String description, String versionNumber, boolean isDeprecated, String author, String usage, String encodingStandard, String namespace, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String typeName = OpenMetadataType.STRUCT_SCHEMA_TYPE.typeName;
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, OpenMetadataType.STRUCT_SCHEMA_TYPE.typeName, this.serviceName, methodName, this.repositoryHelper);
        SchemaTypeBuilder builder = new SchemaTypeBuilder(qualifiedName, displayName, description, versionNumber, isDeprecated, author, usage, encodingStandard, namespace, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        return this.addSchemaType(userId, externalSourceGUID, externalSourceName, builder, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public String addSchemaTypeChoice(String userId, String externalSourceGUID, String externalSourceName, String qualifiedName, String displayName, String description, String versionNumber, boolean isDeprecated, String author, String usage, String encodingStandard, String namespace, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        String typeName = OpenMetadataType.SCHEMA_TYPE_CHOICE.typeName;
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, OpenMetadataType.SCHEMA_TYPE_CHOICE.typeName, this.serviceName, methodName, this.repositoryHelper);
        SchemaTypeBuilder builder = new SchemaTypeBuilder(qualifiedName, displayName, description, versionNumber, isDeprecated, author, usage, encodingStandard, namespace, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        return this.addSchemaType(userId, externalSourceGUID, externalSourceName, builder, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public String addMapSchemaType(String userId, String externalSourceGUID, String externalSourceName, String qualifiedName, String displayName, String description, String versionNumber, boolean isDeprecated, String author, String usage, String encodingStandard, String namespace, String mapFromSchemaTypeGUID, String mapToSchemaTypeGUID, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String qualifiedNameParameterName = "qualifiedName";
        String fromGUIDParameterName = "mapFromSchemaTypeGUID";
        String toGUIDParameterName = "mapToSchemaTypeGUID";
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        this.invalidParameterHandler.validateGUID(mapFromSchemaTypeGUID, "mapFromSchemaTypeGUID", methodName);
        this.invalidParameterHandler.validateGUID(mapToSchemaTypeGUID, "mapToSchemaTypeGUID", methodName);
        String typeName = OpenMetadataType.SCHEMA_TYPE_CHOICE.typeName;
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, OpenMetadataType.SCHEMA_TYPE_CHOICE.typeName, this.serviceName, methodName, this.repositoryHelper);
        SchemaTypeBuilder builder = new SchemaTypeBuilder(qualifiedName, displayName, description, versionNumber, isDeprecated, author, usage, encodingStandard, namespace, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setMapGUIDs(mapFromSchemaTypeGUID, mapToSchemaTypeGUID);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        return this.addSchemaType(userId, externalSourceGUID, externalSourceName, builder, effectiveFrom, effectiveTo, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public String createSchemaTypeFromTemplate(String userId, String externalSourceGUID, String externalSourceName, String templateGUID, String qualifiedName, String displayName, String description, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String templateGUIDParameterName = "templateGUID";
        String qualifiedNameParameterName = "qualifiedName";
        this.invalidParameterHandler.validateUserId(userId, methodName);
        this.invalidParameterHandler.validateGUID(templateGUID, "templateGUID", methodName);
        this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        SchemaTypeBuilder builder = new SchemaTypeBuilder(qualifiedName, displayName, description, this.repositoryHelper, this.serviceName, this.serverName);
        return this.createBeanFromTemplate(userId, externalSourceGUID, externalSourceName, templateGUID, "templateGUID", OpenMetadataType.SCHEMA_TYPE.typeGUID, OpenMetadataType.SCHEMA_TYPE.typeName, qualifiedName, OpenMetadataProperty.QUALIFIED_NAME.name, builder, this.supportedZones, true, false, null, methodName);
    }

    public void updateSchemaType(String userId, String externalSourceGUID, String externalSourceName, String existingSchemaTypeGUID, String existingSchemaTypeGUIDParameterName, SchemaTypeBuilder builder, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        InstanceProperties properties = builder.getInstanceProperties(methodName);
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, existingSchemaTypeGUID, existingSchemaTypeGUIDParameterName, this.getSchemaTypeTypeGUID(builder), this.getSchemaTypeTypeName(builder), forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, properties, isMergeUpdate, effectiveTime, methodName);
    }

    public void updateSchemaType(String userId, String externalSourceGUID, String externalSourceName, String schemaTypeGUID, String qualifiedName, String displayName, String description, String versionNumber, boolean isDeprecated, String author, String usage, String encodingStandard, String namespace, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, Date effectiveFrom, Date effectiveTo, boolean isMergeUpdate, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String qualifiedNameParameterName = "qualifiedName";
        String elementGUIDParameterName = "schemaTypeGUID";
        if (!isMergeUpdate) {
            this.invalidParameterHandler.validateName(qualifiedName, "qualifiedName", methodName);
        }
        String typeName = OpenMetadataType.SCHEMA_TYPE.typeName;
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, OpenMetadataType.SCHEMA_TYPE.typeName, this.serviceName, methodName, this.repositoryHelper);
        SchemaTypeBuilder builder = new SchemaTypeBuilder(qualifiedName, displayName, description, versionNumber, isDeprecated, author, usage, encodingStandard, namespace, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        builder.setEffectivityDates(effectiveFrom, effectiveTo);
        this.updateSchemaType(userId, externalSourceGUID, externalSourceName, schemaTypeGUID, "schemaTypeGUID", builder, isMergeUpdate, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    private String getSchemaTypeTypeGUID(SchemaTypeBuilder builder) {
        if (builder.getTypeGUID() != null) {
            return builder.getTypeGUID();
        }
        return OpenMetadataType.SCHEMA_TYPE.typeGUID;
    }

    private String getSchemaTypeTypeName(SchemaTypeBuilder builder) {
        if (builder.getTypeName() != null) {
            return builder.getTypeName();
        }
        return OpenMetadataType.SCHEMA_TYPE.typeName;
    }

    public void removeSchemaType(String userId, String externalSourceGUID, String externalSourceName, String schemaTypeGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String guidParameterName = "schemaTypeGUID";
        this.deleteBeanInRepository(userId, externalSourceGUID, externalSourceName, schemaTypeGUID, "schemaTypeGUID", OpenMetadataType.SCHEMA_TYPE.typeGUID, OpenMetadataType.SCHEMA_TYPE.typeName, false, null, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public B getSchemaTypeForAsset(String userId, String assetGUID, String assetGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getSchemaTypeForParent(userId, assetGUID, assetGUIDParameterName, OpenMetadataType.ASSET.typeName, OpenMetadataType.ASSET_SCHEMA_TYPE_RELATIONSHIP.typeGUID, OpenMetadataType.ASSET_SCHEMA_TYPE_RELATIONSHIP.typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public B getSchemaTypeForPort(String userId, String portGUID, String portGUIDParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getSchemaTypeForParent(userId, portGUID, portGUIDParameterName, OpenMetadataType.PORT.typeName, OpenMetadataType.PORT_SCHEMA_RELATIONSHIP.typeGUID, OpenMetadataType.PORT_SCHEMA_RELATIONSHIP.typeName, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public B getSchemaTypeForParent(String userId, String parentGUID, String parentGUIDParameterName, String parentTypeName, String relationshipTypeGUID, String relationshipTypeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        EntityDetail schemaTypeEntity = this.getAttachedEntity(userId, parentGUID, parentGUIDParameterName, parentTypeName, relationshipTypeGUID, relationshipTypeName, OpenMetadataType.SCHEMA_TYPE.typeName, 2, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
        return this.getSchemaTypeFromEntity(userId, schemaTypeEntity, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public void setupSchemaTypeParent(String userId, String externalSourceGUID, String externalSourceName, String schemaTypeGUID, String parentElementGUID, String parentElementTypeName, Date effectiveFrom, Date effectiveTo, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String schemaTypeGUIDParameterName = "schemaTypeGUID";
        String parentElementGUIDParameterName = "parentElementGUID";
        String parentElementTypeParameterName = "parentElementTypeName";
        this.invalidParameterHandler.validateName(parentElementTypeName, "parentElementTypeName", methodName);
        if (this.repositoryHelper.isTypeOf(this.serviceName, parentElementTypeName, OpenMetadataType.PORT.typeName)) {
            this.linkElementToElement(userId, externalSourceGUID, externalSourceName, parentElementGUID, "parentElementGUID", parentElementTypeName, schemaTypeGUID, "schemaTypeGUID", OpenMetadataType.SCHEMA_TYPE.typeName, forLineage, forDuplicateProcessing, OpenMetadataType.PORT_SCHEMA_RELATIONSHIP.typeGUID, OpenMetadataType.PORT_SCHEMA_RELATIONSHIP.typeName, null, effectiveFrom, effectiveTo, effectiveTime, methodName);
        } else {
            this.linkElementToElement(userId, externalSourceGUID, externalSourceName, parentElementGUID, "parentElementGUID", parentElementTypeName, schemaTypeGUID, "schemaTypeGUID", OpenMetadataType.SCHEMA_TYPE.typeName, forLineage, forDuplicateProcessing, OpenMetadataType.ASSET_SCHEMA_TYPE_RELATIONSHIP.typeGUID, OpenMetadataType.ASSET_SCHEMA_TYPE_RELATIONSHIP.typeName, null, effectiveFrom, effectiveTo, effectiveTime, methodName);
        }
    }

    public void clearSchemaTypeParent(String userId, String externalSourceGUID, String externalSourceName, String schemaTypeGUID, String parentElementGUID, String parentElementTypeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String schemaTypeGUIDParameterName = "schemaTypeGUID";
        String parentElementGUIDParameterName = "parentElementGUID";
        String parentElementTypeParameterName = "parentElementTypeName";
        this.invalidParameterHandler.validateName(parentElementTypeName, "parentElementTypeName", methodName);
        if (parentElementTypeName != null && this.repositoryHelper.isTypeOf(this.serviceName, parentElementTypeName, OpenMetadataType.PORT.typeName)) {
            this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, parentElementGUID, "parentElementGUID", parentElementTypeName, schemaTypeGUID, "schemaTypeGUID", OpenMetadataType.SCHEMA_TYPE.typeGUID, OpenMetadataType.SCHEMA_TYPE.typeName, forLineage, forDuplicateProcessing, OpenMetadataType.PORT_SCHEMA_RELATIONSHIP.typeGUID, OpenMetadataType.PORT_SCHEMA_RELATIONSHIP.typeName, effectiveTime, methodName);
        } else {
            this.unlinkElementFromElement(userId, false, externalSourceGUID, externalSourceName, parentElementGUID, "parentElementGUID", parentElementTypeName, schemaTypeGUID, "schemaTypeGUID", OpenMetadataType.SCHEMA_TYPE.typeGUID, OpenMetadataType.SCHEMA_TYPE.typeName, forLineage, forDuplicateProcessing, OpenMetadataType.ASSET_SCHEMA_TYPE_RELATIONSHIP.typeGUID, OpenMetadataType.ASSET_SCHEMA_TYPE_RELATIONSHIP.typeName, effectiveTime, methodName);
        }
    }

    public B getSchemaType(String userId, String schemaTypeGUID, String guidParameterName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        EntityDetail schemaTypeEntity = this.getEntityFromRepository(userId, schemaTypeGUID, guidParameterName, OpenMetadataType.SCHEMA_TYPE.typeName, null, null, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
        return this.getSchemaTypeFromEntity(userId, schemaTypeEntity, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> findSchemaTypes(String userId, String suppliedTypeName, String searchString, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String searchStringParameterName = "searchString";
        String typeName = OpenMetadataType.SCHEMA_TYPE.typeName;
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, OpenMetadataType.SCHEMA_TYPE.typeName, this.serviceName, methodName, this.repositoryHelper);
        List<EntityDetail> entities = this.findEntities(userId, searchString, "searchString", typeGUID, typeName, null, null, startFrom, pageSize, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        return this.getSchemaTypesFromEntities(userId, entities, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public List<B> getSchemaTypeByName(String userId, String suppliedTypeName, String name, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String nameParameterName = "name";
        String typeName = OpenMetadataType.SCHEMA_TYPE.typeName;
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, OpenMetadataType.SCHEMA_TYPE.typeName, this.serviceName, methodName, this.repositoryHelper);
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add(OpenMetadataProperty.QUALIFIED_NAME.name);
        specificMatchPropertyNames.add(OpenMetadataProperty.DISPLAY_NAME.name);
        List<EntityDetail> entities = this.getEntitiesByValue(userId, name, "name", typeGUID, typeName, specificMatchPropertyNames, true, false, null, null, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
        return this.getSchemaTypesFromEntities(userId, entities, forLineage, forDuplicateProcessing, effectiveTime, methodName);
    }

    public B getSchemaTypeForElement(String userId, String parentElementGUID, String parentElementTypeName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String parentElementGUIDParameterName = "parentElementGUID";
        String schemaTypeGUIDParameterName = "schemaTypeEnd.getGUID";
        List<Relationship> relationships = this.getAttachmentLinks(userId, parentElementGUID, "parentElementGUID", parentElementTypeName, null, null, null, null, 0, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, 0, 0, effectiveTime, methodName);
        if (relationships != null) {
            for (Relationship relationship : relationships) {
                if (this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), OpenMetadataType.ASSET_SCHEMA_TYPE_RELATIONSHIP.typeName)) {
                    return this.getSchemaType(userId, relationship.getEntityTwoProxy().getGUID(), "schemaTypeEnd.getGUID", forLineage, forDuplicateProcessing, effectiveTime, methodName);
                }
                if (this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), OpenMetadataType.ASSET_SCHEMA_TYPE_RELATIONSHIP.typeName)) {
                    return this.getSchemaType(userId, relationship.getEntityTwoProxy().getGUID(), "schemaTypeEnd.getGUID", forLineage, forDuplicateProcessing, effectiveTime, methodName);
                }
                if (this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), OpenMetadataType.SCHEMA_ATTRIBUTE_TYPE_RELATIONSHIP.typeName)) {
                    return this.getSchemaType(userId, relationship.getEntityTwoProxy().getGUID(), "schemaTypeEnd.getGUID", forLineage, forDuplicateProcessing, effectiveTime, methodName);
                }
                if (this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), OpenMetadataType.LINKED_EXTERNAL_SCHEMA_TYPE_RELATIONSHIP.typeName)) {
                    return this.getSchemaType(userId, relationship.getEntityTwoProxy().getGUID(), "schemaTypeEnd.getGUID", forLineage, forDuplicateProcessing, effectiveTime, methodName);
                }
                if (this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), OpenMetadataType.MAP_FROM_ELEMENT_TYPE_RELATIONSHIP.typeName)) {
                    return this.getSchemaType(userId, relationship.getEntityTwoProxy().getGUID(), "schemaTypeEnd.getGUID", forLineage, forDuplicateProcessing, effectiveTime, methodName);
                }
                if (this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), OpenMetadataType.MAP_TO_ELEMENT_TYPE_RELATIONSHIP.typeName)) {
                    return this.getSchemaType(userId, relationship.getEntityTwoProxy().getGUID(), "schemaTypeEnd.getGUID", forLineage, forDuplicateProcessing, effectiveTime, methodName);
                }
                if (this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), OpenMetadataType.DERIVED_SCHEMA_TYPE_QUERY_TARGET_RELATIONSHIP.typeName)) {
                    return this.getSchemaType(userId, relationship.getEntityTwoProxy().getGUID(), "schemaTypeEnd.getGUID", forLineage, forDuplicateProcessing, effectiveTime, methodName);
                }
                if (this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), OpenMetadataType.PORT_SCHEMA_RELATIONSHIP.typeName)) {
                    return this.getSchemaType(userId, relationship.getEntityTwoProxy().getGUID(), "schemaTypeEnd.getGUID", forLineage, forDuplicateProcessing, effectiveTime, methodName);
                }
                if (!this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), OpenMetadataType.SOLUTION_PORT_SCHEMA_RELATIONSHIP.typeName)) continue;
                return this.getSchemaType(userId, relationship.getEntityTwoProxy().getGUID(), "schemaTypeEnd.getGUID", forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
        }
        return null;
    }

    private List<B> getSchemaTypesFromEntities(String userId, List<EntityDetail> schemaTypeEntities, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ArrayList<B> results = new ArrayList<B>();
        if (schemaTypeEntities != null) {
            for (EntityDetail entity : schemaTypeEntities) {
                if (entity == null) continue;
                results.add(this.getSchemaTypeFromEntity(userId, entity, forLineage, forDuplicateProcessing, effectiveTime, methodName));
            }
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    private B getSchemaTypeFromEntity(String userId, EntityDetail schemaTypeEntity, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (schemaTypeEntity != null && schemaTypeEntity.getType() != null) {
            return this.getSchemaTypeFromInstance(userId, (InstanceHeader)schemaTypeEntity, schemaTypeEntity.getType().getTypeDefName(), schemaTypeEntity.getProperties(), schemaTypeEntity.getClassifications(), forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        return null;
    }

    public B getSchemaTypeFromInstance(String userId, InstanceHeader schemaRootHeader, String schemaRootTypeName, InstanceProperties instanceProperties, List<Classification> entityClassifications, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List<EntityDetail> schemaTypeOptionsEntities;
        EntityDetail externalSchemaTypeEntity;
        String schemaGUIDParameterName = "schemaRootGUID";
        int attributeCount = 0;
        String validValuesSetGUID = null;
        String externalSchemaTypeGUID = null;
        Object externalSchemaType = null;
        String mapToSchemaTypeGUID = null;
        Object mapToSchemaType = null;
        String mapFromSchemaTypeGUID = null;
        Object mapFromSchemaType = null;
        ArrayList<String> schemaTypeOptionGUIDs = null;
        ArrayList<B> schemaTypeOptions = null;
        if (this.repositoryHelper.isTypeOf(this.serviceName, schemaRootTypeName, OpenMetadataType.EXTERNAL_SCHEMA_TYPE.typeName) && (externalSchemaTypeEntity = this.getAttachedEntity(userId, schemaRootHeader.getGUID(), "schemaRootGUID", OpenMetadataType.SCHEMA_ELEMENT.typeName, OpenMetadataType.LINKED_EXTERNAL_SCHEMA_TYPE_RELATIONSHIP.typeGUID, OpenMetadataType.LINKED_EXTERNAL_SCHEMA_TYPE_RELATIONSHIP.typeName, OpenMetadataType.SCHEMA_TYPE.typeName, 2, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName)) != null) {
            externalSchemaTypeGUID = externalSchemaTypeEntity.getGUID();
            externalSchemaType = this.getSchemaTypeFromEntity(userId, externalSchemaTypeEntity, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        if (this.repositoryHelper.isTypeOf(this.serviceName, schemaRootTypeName, OpenMetadataType.COMPLEX_SCHEMA_TYPE.typeName)) {
            attributeCount = this.countSchemaAttributes(userId, schemaRootHeader.getGUID(), "schemaRootGUID", effectiveTime, methodName);
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, schemaRootTypeName, OpenMetadataType.ENUM_SCHEMA_TYPE.typeName)) {
            EntityDetail validValuesSetEntity = this.getAttachedEntity(userId, schemaRootHeader.getGUID(), "schemaRootGUID", OpenMetadataType.SCHEMA_ELEMENT.typeName, OpenMetadataType.VALID_VALUES_ASSIGNMENT_RELATIONSHIP.typeGUID, OpenMetadataType.VALID_VALUES_ASSIGNMENT_RELATIONSHIP.typeName, OpenMetadataType.VALID_VALUE_SET.typeName, 2, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
            if (validValuesSetEntity != null) {
                validValuesSetGUID = validValuesSetEntity.getGUID();
            }
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, schemaRootTypeName, OpenMetadataType.MAP_SCHEMA_TYPE.typeName)) {
            EntityDetail mapToSchemaTypeEntity;
            EntityDetail mapFromSchemaTypeEntity = this.getAttachedEntity(userId, schemaRootHeader.getGUID(), "schemaRootGUID", OpenMetadataType.SCHEMA_ELEMENT.typeName, OpenMetadataType.MAP_FROM_ELEMENT_TYPE_RELATIONSHIP.typeGUID, OpenMetadataType.MAP_FROM_ELEMENT_TYPE_RELATIONSHIP.typeName, OpenMetadataType.SCHEMA_TYPE.typeName, 2, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
            if (mapFromSchemaTypeEntity != null) {
                mapFromSchemaTypeGUID = mapFromSchemaTypeEntity.getGUID();
                mapFromSchemaType = this.getSchemaTypeFromEntity(userId, mapFromSchemaTypeEntity, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
            if ((mapToSchemaTypeEntity = this.getAttachedEntity(userId, schemaRootHeader.getGUID(), "schemaRootGUID", OpenMetadataType.SCHEMA_ELEMENT.typeName, OpenMetadataType.MAP_TO_ELEMENT_TYPE_RELATIONSHIP.typeGUID, OpenMetadataType.MAP_TO_ELEMENT_TYPE_RELATIONSHIP.typeName, OpenMetadataType.SCHEMA_TYPE.typeName, 2, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName)) != null) {
                mapToSchemaTypeGUID = mapToSchemaTypeEntity.getGUID();
                mapToSchemaType = this.getSchemaTypeFromEntity(userId, mapToSchemaTypeEntity, forLineage, forDuplicateProcessing, effectiveTime, methodName);
            }
        } else if (this.repositoryHelper.isTypeOf(this.serviceName, schemaRootTypeName, OpenMetadataType.SCHEMA_TYPE_CHOICE.typeName) && (schemaTypeOptionsEntities = this.getAttachedEntities(userId, schemaRootHeader.getGUID(), "schemaRootGUID", OpenMetadataType.SCHEMA_ELEMENT.typeName, OpenMetadataType.SCHEMA_TYPE_OPTION_RELATIONSHIP.typeGUID, OpenMetadataType.SCHEMA_TYPE_OPTION_RELATIONSHIP.typeName, OpenMetadataType.SCHEMA_TYPE.typeName, null, null, 2, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, 0, this.invalidParameterHandler.getMaxPagingSize(), effectiveTime, methodName)) != null && !schemaTypeOptionsEntities.isEmpty()) {
            schemaTypeOptionGUIDs = new ArrayList<String>();
            schemaTypeOptions = new ArrayList<B>();
            for (EntityDetail schemaTypeOptionEntity : schemaTypeOptionsEntities) {
                if (schemaTypeOptionEntity == null) continue;
                schemaTypeOptionGUIDs.add(schemaTypeOptionEntity.getGUID());
                schemaTypeOptions.add(this.getSchemaTypeFromEntity(userId, schemaTypeOptionEntity, forLineage, forDuplicateProcessing, effectiveTime, methodName));
            }
        }
        List<Relationship> queryTargets = this.getAttachmentLinks(userId, schemaRootHeader.getGUID(), "schemaRootGUID", OpenMetadataType.SCHEMA_ELEMENT.typeName, OpenMetadataType.DERIVED_SCHEMA_TYPE_QUERY_TARGET_RELATIONSHIP.typeGUID, OpenMetadataType.DERIVED_SCHEMA_TYPE_QUERY_TARGET_RELATIONSHIP.typeName, null, OpenMetadataType.SCHEMA_ELEMENT.typeName, 2, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, 0, 0, effectiveTime, methodName);
        return this.schemaTypeConverter.getNewSchemaTypeBean(this.beanClass, schemaRootHeader, schemaRootTypeName, instanceProperties, entityClassifications, attributeCount, validValuesSetGUID, externalSchemaTypeGUID, externalSchemaType, mapFromSchemaTypeGUID, mapFromSchemaType, mapToSchemaTypeGUID, mapToSchemaType, schemaTypeOptionGUIDs, schemaTypeOptions, queryTargets, methodName);
    }
}

