/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.commonservices.ffdc.InvalidParameterHandler;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericConverter;
import org.odpi.openmetadata.commonservices.generichandlers.OpenMetadataAPIGenericHandler;
import org.odpi.openmetadata.commonservices.generichandlers.SubjectAreaBuilder;
import org.odpi.openmetadata.commonservices.repositoryhandler.RepositoryHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.metadatasecurity.server.OpenMetadataServerSecurityVerifier;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class SubjectAreaHandler<B>
extends OpenMetadataAPIGenericHandler<B> {
    public SubjectAreaHandler(OpenMetadataAPIGenericConverter<B> converter, Class<B> beanClass, String serviceName, String serverName, InvalidParameterHandler invalidParameterHandler, RepositoryHandler repositoryHandler, OMRSRepositoryHelper repositoryHelper, String localServerUserId, OpenMetadataServerSecurityVerifier securityVerifier, List<String> supportedZones, List<String> defaultZones, List<String> publishZones, AuditLog auditLog) {
        super(converter, beanClass, serviceName, serverName, invalidParameterHandler, repositoryHandler, repositoryHelper, localServerUserId, securityVerifier, supportedZones, defaultZones, publishZones, auditLog);
    }

    public String createSubjectArea(String userId, String externalSourceGUID, String externalSourceName, String qualifiedName, String subjectAreaName, String displayName, String description, String usage, String scope, int domainIdentifier, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String typeName = OpenMetadataType.SUBJECT_AREA_DEFINITION.typeName;
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, OpenMetadataType.SUBJECT_AREA_DEFINITION.typeName, this.serviceName, methodName, this.repositoryHelper);
        SubjectAreaBuilder builder = new SubjectAreaBuilder(qualifiedName, subjectAreaName, displayName, description, usage, scope, domainIdentifier, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        return this.createBeanInRepository(userId, externalSourceGUID, externalSourceName, typeGUID, typeName, builder, effectiveTime, methodName);
    }

    public void updateSubjectArea(String userId, String externalSourceGUID, String externalSourceName, String subjectAreaGUID, String subjectAreaGUIDParameterName, String qualifiedName, String subjectAreaName, String displayName, String description, String criteria, String scope, int domainIdentifier, Map<String, String> additionalProperties, String suppliedTypeName, Map<String, Object> extendedProperties, boolean isMergeUpdate, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String typeName = OpenMetadataType.SUBJECT_AREA_DEFINITION.typeName;
        if (suppliedTypeName != null) {
            typeName = suppliedTypeName;
        }
        String typeGUID = this.invalidParameterHandler.validateTypeName(typeName, OpenMetadataType.SUBJECT_AREA_DEFINITION.typeName, this.serviceName, methodName, this.repositoryHelper);
        SubjectAreaBuilder builder = new SubjectAreaBuilder(qualifiedName, subjectAreaName, displayName, description, criteria, scope, domainIdentifier, additionalProperties, typeGUID, typeName, extendedProperties, this.repositoryHelper, this.serviceName, this.serverName);
        this.updateBeanInRepository(userId, externalSourceGUID, externalSourceName, subjectAreaGUID, subjectAreaGUIDParameterName, OpenMetadataType.SUBJECT_AREA_DEFINITION.typeGUID, OpenMetadataType.SUBJECT_AREA_DEFINITION.typeName, false, false, (List<String>)this.supportedZones, builder.getInstanceProperties(methodName), isMergeUpdate, new Date(), methodName);
    }

    public B getSubjectArea(String userId, String name, String nameParameter, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        ArrayList<String> specificMatchPropertyNames = new ArrayList<String>();
        specificMatchPropertyNames.add(OpenMetadataProperty.QUALIFIED_NAME.name);
        specificMatchPropertyNames.add(OpenMetadataProperty.SUBJECT_AREA_NAME.name);
        return this.getBeanByValue(userId, name, nameParameter, OpenMetadataType.SUBJECT_AREA_DEFINITION.typeGUID, OpenMetadataType.SUBJECT_AREA_DEFINITION.typeName, specificMatchPropertyNames, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
    }

    public String getSubjectAreaParentGUID(String userId, String subjectAreaGUID, String subjectAreaGUIDParameter, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        EntityDetail entity = this.getAttachedEntity(userId, subjectAreaGUID, subjectAreaGUIDParameter, OpenMetadataType.SUBJECT_AREA_DEFINITION.typeName, OpenMetadataType.SUBJECT_AREA_HIERARCHY_RELATIONSHIP.typeGUID, OpenMetadataType.SUBJECT_AREA_HIERARCHY_RELATIONSHIP.typeName, OpenMetadataType.SUBJECT_AREA_DEFINITION.typeName, 1, forLineage, forDuplicateProcessing, this.supportedZones, effectiveTime, methodName);
        if (entity != null) {
            return entity.getGUID();
        }
        return null;
    }

    public List<String> getSubjectAreaChildrenGUIDs(String userId, String subjectAreaGUID, String subjectAreaGUIDParameter, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        List<EntityDetail> entities = this.getAttachedEntities(userId, subjectAreaGUID, subjectAreaGUIDParameter, OpenMetadataType.SUBJECT_AREA_DEFINITION.typeName, OpenMetadataType.SUBJECT_AREA_HIERARCHY_RELATIONSHIP.typeGUID, OpenMetadataType.SUBJECT_AREA_HIERARCHY_RELATIONSHIP.typeName, OpenMetadataType.SUBJECT_AREA_DEFINITION.typeName, null, null, 0, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, (List<String>)this.supportedZones, 0, 0, effectiveTime, methodName);
        ArrayList<String> results = new ArrayList<String>();
        if (entities != null) {
            for (EntityDetail entity : entities) {
                if (entity == null) continue;
                results.add(entity.getGUID());
            }
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }

    public List<B> getSubjectAreas(String userId, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.getBeansByType(userId, OpenMetadataType.SUBJECT_AREA_DEFINITION.typeGUID, OpenMetadataType.SUBJECT_AREA_DEFINITION.typeName, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
    }

    public List<B> getSubjectAreasByDomain(String userId, int domainIdentifier, int startFrom, int pageSize, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime, String methodName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        if (domainIdentifier == 0) {
            return this.getSubjectAreas(userId, startFrom, pageSize, forLineage, forDuplicateProcessing, effectiveTime, methodName);
        }
        List<EntityDetail> entities = this.getEntitiesByType(userId, OpenMetadataType.SUBJECT_AREA_DEFINITION.typeGUID, OpenMetadataType.SUBJECT_AREA_DEFINITION.typeName, null, null, SequencingOrder.CREATION_DATE_RECENT, null, forLineage, forDuplicateProcessing, this.supportedZones, startFrom, pageSize, effectiveTime, methodName);
        ArrayList results = new ArrayList();
        if (entities != null) {
            for (EntityDetail entity : entities) {
                if (entity == null || entity.getProperties() == null || this.repositoryHelper.getIntProperty(this.serviceName, OpenMetadataProperty.DOMAIN_IDENTIFIER.name, entity.getProperties(), methodName) != domainIdentifier) continue;
                Object bean = this.converter.getNewBean(this.beanClass, entity, methodName);
                results.add(bean);
            }
        }
        if (results.isEmpty()) {
            return null;
        }
        return results;
    }
}

