/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.commonservices.generichandlers;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.odpi.openmetadata.commonservices.generichandlers.SAFConverter;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.frameworks.surveyaction.properties.SurveyReport;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityDetail;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.EntityProxy;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.InstanceProperties;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.instances.Relationship;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.repositoryconnector.OMRSRepositoryHelper;

public class SurveyReportConverter<B>
extends SAFConverter<B> {
    public SurveyReportConverter(OMRSRepositoryHelper repositoryHelper, String serviceName, String serverName) {
        super(repositoryHelper, serviceName, serverName);
    }

    @Override
    public B getNewComplexBean(Class<B> beanClass, EntityDetail primaryEntity, List<EntityDetail> supplementaryEntities, List<Relationship> relationships, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof SurveyReport) {
                SurveyReport bean = (SurveyReport)returnBean;
                bean.setElementHeader(this.getMetadataElementHeader(beanClass, primaryEntity, methodName));
                InstanceProperties instanceProperties = new InstanceProperties(primaryEntity.getProperties());
                bean.setQualifiedName(this.removeQualifiedName(instanceProperties));
                bean.setAdditionalProperties(this.removeAdditionalProperties(instanceProperties));
                bean.setDisplayName(this.removeDisplayName(instanceProperties));
                bean.setDescription(this.removeDescription(instanceProperties));
                bean.setStartDate(this.removeStartDate(instanceProperties));
                bean.setAnalysisParameters(this.removeAnalysisParameters(instanceProperties));
                bean.setAnalysisStep(this.removeAnalysisStep(instanceProperties));
                bean.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
                if (relationships != null) {
                    for (Relationship relationship : relationships) {
                        EntityProxy endOne;
                        if (relationship == null || relationship.getType() == null || relationship.getType().getTypeDefName() == null) continue;
                        if (this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), OpenMetadataType.ASSET_SURVEY_REPORT_RELATIONSHIP.typeName)) {
                            endOne = relationship.getEntityOneProxy();
                            if (endOne == null) continue;
                            bean.setAssetGUID(endOne.getGUID());
                            continue;
                        }
                        if (!this.repositoryHelper.isTypeOf(this.serviceName, relationship.getType().getTypeDefName(), OpenMetadataType.ENGINE_ACTION_SURVEY_REPORT_RELATIONSHIP.typeName) || (endOne = relationship.getEntityOneProxy()) == null) continue;
                        bean.setEngineActionGUID(endOne.getGUID());
                    }
                }
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }
}

