/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.glossaryauthor.fvt;

import java.io.IOException;
import java.util.Date;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Glossary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Node;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.term.Term;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.viewservices.glossaryauthor.fvt.FVTUtils;
import org.odpi.openmetadata.viewservices.glossaryauthor.fvt.GlossaryAuthorFVTCheckedException;
import org.odpi.openmetadata.viewservices.glossaryauthor.fvt.GlossaryFVT;
import org.odpi.openmetadata.viewservices.glossaryauthor.fvt.RunAllFVTOn2Servers;
import org.odpi.openmetadata.viewservices.glossaryauthor.fvt.TermFVT;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EffectiveDatesFVT {
    private static final String DEFAULT_TEST_PAST_GLOSSARY_NAME = "Test past Glossary for term FVT";
    private static final String DEFAULT_TEST_FUTURE_GLOSSARY_NAME = "Test future Glossary for term FVT";
    private static final String DEFAULT_TEST_TERM_NAME = "Test term A";
    private GlossaryFVT glossaryFVT = null;
    private TermFVT termFVT = null;
    private static Logger log = LoggerFactory.getLogger(EffectiveDatesFVT.class);

    public static void main(String[] args) {
        try {
            String url = RunAllFVTOn2Servers.getUrl(args);
            EffectiveDatesFVT.runWith2Servers(url);
        }
        catch (IOException e1) {
            System.out.println("Error getting user input");
        }
        catch (GlossaryAuthorFVTCheckedException e) {
            log.error("ERROR: " + e.getMessage());
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            log.error("ERROR: " + e.getReportedErrorMessage() + " Suggested action: " + e.getReportedUserAction());
        }
    }

    public EffectiveDatesFVT(String url, String serverName, String userId) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (log.isDebugEnabled()) {
            log.debug("Create a glossary");
        }
        this.glossaryFVT = new GlossaryFVT(url, serverName, userId);
        this.termFVT = new TermFVT(url, serverName, userId);
    }

    public void deleteRemaining() throws UserNotAuthorizedException, PropertyServerException, InvalidParameterException, GlossaryAuthorFVTCheckedException {
        this.termFVT.deleteRemainingTerms();
        this.glossaryFVT.deleteRemainingGlossaries();
    }

    public static void runWith2Servers(String url) throws GlossaryAuthorFVTCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        EffectiveDatesFVT.runIt(url, "cocoView1", "garygeeke");
        EffectiveDatesFVT.runIt(url, "cocoView2", "garygeeke");
    }

    public static synchronized void runIt(String url, String serverName, String userId) throws InvalidParameterException, GlossaryAuthorFVTCheckedException, PropertyServerException, UserNotAuthorizedException {
        try {
            System.out.println("EffectiveDatesFVT runIt started");
            EffectiveDatesFVT fvt = new EffectiveDatesFVT(url, serverName, userId);
            fvt.run();
            fvt.deleteRemaining();
            System.out.println("EffectiveDatesFVT runIt stopped");
        }
        catch (Exception error) {
            error.printStackTrace();
            throw error;
        }
    }

    public void run() throws GlossaryAuthorFVTCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        long now = new Date().getTime();
        try {
            this.glossaryFVT.createPastToGlossary(DEFAULT_TEST_PAST_GLOSSARY_NAME);
        }
        catch (InvalidParameterException e) {
            log.error("Expected creation of a Glossary with to in the past failed");
        }
        try {
            this.glossaryFVT.createPastFromGlossary(DEFAULT_TEST_PAST_GLOSSARY_NAME);
        }
        catch (InvalidParameterException e) {
            log.error("Expected creation of a Glossary with from in the past failed");
        }
        try {
            this.glossaryFVT.createInvalidEffectiveDateGlossary(DEFAULT_TEST_PAST_GLOSSARY_NAME);
        }
        catch (InvalidParameterException e) {
            log.error("Expected creation of a Glossary with invalid Effectivity dates failed");
        }
        Glossary futureGloss = this.glossaryFVT.createFutureGlossary(DEFAULT_TEST_FUTURE_GLOSSARY_NAME);
        FVTUtils.validateNode((Node)futureGloss);
        Term term5 = this.termFVT.createTerm(DEFAULT_TEST_TERM_NAME, futureGloss.getSystemAttributes().getGUID());
        FVTUtils.validateNode((Node)term5);
        this.checkTermGlossaryEffectivity(futureGloss, term5);
        Term gotTerm5 = this.termFVT.getTermByGUID(term5.getSystemAttributes().getGUID());
        FVTUtils.validateNode((Node)gotTerm5);
        this.checkTermGlossaryEffectivity(futureGloss, gotTerm5);
        Term futureTerm = this.termFVT.updateTermToFuture(now, gotTerm5.getSystemAttributes().getGUID(), term5);
        FVTUtils.validateNode((Node)futureTerm);
        this.checkTermGlossaryEffectivity(futureGloss, futureTerm);
        futureTerm = this.termFVT.getTermByGUID(term5.getSystemAttributes().getGUID());
        FVTUtils.validateNode((Node)futureTerm);
        this.checkTermGlossaryEffectivity(futureGloss, futureTerm);
    }

    private void checkTermGlossaryEffectivity(Glossary glossary, Term term) throws GlossaryAuthorFVTCheckedException {
        if (term.getGlossary() == null) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Term expected associated future Glossary");
        }
        Long glossaryFrom = glossary.getEffectiveFromTime();
        Long termGlossaryFrom = term.getGlossary().getFromEffectivityTime();
        Long glossaryTo = glossary.getEffectiveToTime();
        Long termGlossaryTo = term.getGlossary().getToEffectivityTime();
        if (glossaryFrom == null && termGlossaryFrom != null) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Term's Glossary fromTime not null but glossaries is null");
        }
        if (glossaryFrom != null && termGlossaryFrom == null) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Term's Glossary fromTime  null but glossaries is not null");
        }
        if (glossaryTo == null && termGlossaryTo != null) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Term's Glossary toTime not null but glossaries is null");
        }
        if (glossaryTo != null && termGlossaryTo == null) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Term's Glossary toTime null but glossaries is not null");
        }
        if (glossaryFrom != null && termGlossaryFrom != null && glossaryFrom.longValue() != termGlossaryFrom.longValue()) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Term's Glossary fromTime " + termGlossaryFrom + " does not match the glossaries " + glossaryFrom);
        }
        if (glossaryTo != null && termGlossaryTo != null && glossaryTo.longValue() != termGlossaryTo.longValue()) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Term's Glossary toTime " + termGlossaryTo + " does not match the glossaries " + glossaryTo);
        }
    }
}

