/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.glossaryauthor.fvt;

import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.odpi.openmetadata.accessservices.subjectarea.properties.enums.StatusFilter;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.category.Category;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.category.SubjectAreaDefinition;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Glossary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Taxonomy;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Graph;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Node;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.NodeType;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.RelationshipType;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.term.Term;
import org.odpi.openmetadata.adminservices.configuration.properties.ViewServiceConfig;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.viewservices.glossaryauthor.fvt.CategoryFVT;
import org.odpi.openmetadata.viewservices.glossaryauthor.fvt.GlossaryAuthorFVTCheckedException;
import org.odpi.openmetadata.viewservices.glossaryauthor.fvt.GlossaryFVT;
import org.odpi.openmetadata.viewservices.glossaryauthor.fvt.RelationshipsFVT;
import org.odpi.openmetadata.viewservices.glossaryauthor.fvt.RunAllFVTOn2Servers;
import org.odpi.openmetadata.viewservices.glossaryauthor.fvt.SubjectAreaDefinitionCategoryFVT;
import org.odpi.openmetadata.viewservices.glossaryauthor.fvt.TermFVT;
import org.odpi.openmetadata.viewservices.glossaryauthor.fvt.client.GlossaryAuthorViewRestClient;
import org.odpi.openmetadata.viewservices.glossaryauthor.fvt.client.graph.GlossaryAuthorViewGraphClient;
import org.odpi.openmetadata.viewservices.glossaryauthor.properties.GraphStatistics;
import org.odpi.openmetadata.viewservices.glossaryauthor.properties.NodeRelationshipStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphFVT {
    private static final String DEFAULT_TEST_GLOSSARY_NAME = "Test Glossary for Graph FVT";
    private static final String DEFAULT_TEST_TERM_NAME1 = "Test term 1";
    private static final String DEFAULT_TEST_TERM_NAME2 = "Test term 2";
    private static final String DEFAULT_TEST_TERM_NAME3 = "Test term 3";
    private static final String DEFAULT_TEST_CATEGORY_NAME = "Test category 1";
    private GlossaryAuthorViewGraphClient glossaryAuthorViewGraphClient = null;
    private GlossaryFVT glossaryFVT = null;
    private TermFVT termFVT = null;
    private RelationshipsFVT relationshipFVT = null;
    private CategoryFVT categoryFVT = null;
    private SubjectAreaDefinitionCategoryFVT subjectAreaFVT = null;
    private static Logger log = LoggerFactory.getLogger(GraphFVT.class);
    private String serverName = null;
    private String userId = null;

    public static void main(String[] args) {
        try {
            String url = RunAllFVTOn2Servers.getUrl(args);
            GraphFVT.runWith2Servers(url);
        }
        catch (IOException e1) {
            System.out.println("Error getting user input");
        }
        catch (GlossaryAuthorFVTCheckedException e) {
            log.error("ERROR: " + e.getMessage());
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            log.error("ERROR: " + e.getReportedErrorMessage() + " Suggested action: " + e.getReportedUserAction());
        }
    }

    public GraphFVT(String url, String serverName, String userId) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        GlossaryAuthorViewRestClient client = new GlossaryAuthorViewRestClient(serverName, url);
        this.glossaryAuthorViewGraphClient = new GlossaryAuthorViewGraphClient(client);
        if (log.isDebugEnabled()) {
            log.debug("Create a glossary");
        }
        this.glossaryFVT = new GlossaryFVT(url, serverName, userId);
        this.termFVT = new TermFVT(url, serverName, userId);
        this.categoryFVT = new CategoryFVT(url, serverName, userId);
        this.relationshipFVT = new RelationshipsFVT(url, serverName, userId);
        this.subjectAreaFVT = new SubjectAreaDefinitionCategoryFVT(url, serverName, userId);
        this.serverName = serverName;
        this.userId = userId;
    }

    public void deleteRemaining() throws UserNotAuthorizedException, PropertyServerException, InvalidParameterException, GlossaryAuthorFVTCheckedException {
        this.termFVT.deleteRemainingTerms();
        this.subjectAreaFVT.deleteRemainingSubjectAreas();
        this.categoryFVT.deleteRemainingCategories();
        this.relationshipFVT.deleteRemaining();
        this.glossaryFVT.deleteRemainingGlossaries();
    }

    private String retrieveOmagServerName(String viewServiceName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, PropertyServerException, UserNotAuthorizedException {
        List<ViewServiceConfig> viewServiceConfigs = this.glossaryAuthorViewGraphClient.getViewServiceConfigs(this.userId);
        for (ViewServiceConfig vsc : viewServiceConfigs) {
            if (!vsc.getViewServiceName().equals(viewServiceName)) continue;
            if (log.isDebugEnabled()) {
                log.debug("OMAG Server URL " + String.valueOf(vsc.getOMAGServerPlatformRootURL()));
            }
            return String.valueOf(vsc.getOMAGServerName());
        }
        return null;
    }

    public static void runWith2Servers(String url) throws GlossaryAuthorFVTCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        GraphFVT.runIt(url, "cocoView1", "garygeeke");
        GraphFVT.runIt(url, "cocoView2", "garygeeke");
    }

    public static void runIt(String url, String serverName, String userId) throws InvalidParameterException, GlossaryAuthorFVTCheckedException, PropertyServerException, UserNotAuthorizedException {
        try {
            System.out.println("GraphFVT runIt started");
            GraphFVT fvt = new GraphFVT(url, serverName, userId);
            fvt.run();
            fvt.deleteRemaining();
            System.out.println("GraphFVT runIt stopped");
        }
        catch (Exception error) {
            error.printStackTrace();
            throw error;
        }
    }

    public void run() throws GlossaryAuthorFVTCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Glossary glossary = this.glossaryFVT.createGlossary(DEFAULT_TEST_GLOSSARY_NAME);
        String glossaryGuid = glossary.getSystemAttributes().getGUID();
        Graph graph = this.getGraph(glossaryGuid, null, null, null, null);
        this.checkGraphContent(graph, 1, 0);
        Term term1 = this.termFVT.createTerm(DEFAULT_TEST_TERM_NAME1, glossaryGuid);
        graph = this.getGraph(glossaryGuid, null, null, null, null);
        this.checkGraphContent(graph, 2, 1);
        Term term2 = this.termFVT.createTerm(DEFAULT_TEST_TERM_NAME2, glossaryGuid);
        graph = this.getGraph(glossaryGuid, null, null, null, null);
        this.checkGraphContent(graph, 3, 2);
        graph = this.getGraph(term1.getSystemAttributes().getGUID(), null, null, null, null);
        this.checkGraphContent(graph, 2, 1);
        graph = this.getGraph(term2.getSystemAttributes().getGUID(), null, null, null, null);
        this.checkGraphContent(graph, 2, 1);
        this.relationshipFVT.createSynonym(term1, term2);
        graph = this.getGraph(term1.getSystemAttributes().getGUID(), null, null, null, null);
        this.checkGraphContent(graph, 3, 2);
        graph = this.getGraph(term1.getSystemAttributes().getGUID(), null, null, new HashSet<RelationshipType>(Arrays.asList(RelationshipType.Synonym)), null);
        this.checkGraphContent(graph, 2, 1);
        Term term3 = this.termFVT.createTerm(DEFAULT_TEST_TERM_NAME3, glossaryGuid);
        this.relationshipFVT.createSynonym(term1, term3);
        graph = this.getGraph(term1.getSystemAttributes().getGUID(), null, null, new HashSet<RelationshipType>(Arrays.asList(RelationshipType.Synonym)), null);
        this.checkGraphContent(graph, 3, 2);
        graph = this.getGraph(glossaryGuid, null, null, null, null);
        this.checkGraphContent(graph, 4, 3);
        graph = this.getGraph(term3.getSystemAttributes().getGUID(), null, null, new HashSet<RelationshipType>(Arrays.asList(RelationshipType.Synonym)), null);
        this.checkGraphContent(graph, 2, 1);
        graph = this.getGraph(glossaryGuid, null, new HashSet<NodeType>(Arrays.asList(NodeType.Glossary, NodeType.Term)), null, null);
        this.checkGraphContent(graph, 4, 3);
        Category category = this.categoryFVT.createCategory(DEFAULT_TEST_CATEGORY_NAME, glossaryGuid);
        graph = this.getGraph(glossaryGuid, null, new HashSet<NodeType>(Arrays.asList(NodeType.Glossary, NodeType.Term)), null, null);
        this.checkGraphContent(graph, 4, 3);
        graph = this.getGraph(glossaryGuid, null, new HashSet<NodeType>(Arrays.asList(NodeType.Glossary, NodeType.Term, NodeType.Category)), null, null);
        this.checkGraphContent(graph, 5, 4);
        Taxonomy taxonomy = this.glossaryFVT.getTaxonomyForInput(DEFAULT_TEST_GLOSSARY_NAME);
        Glossary createdTaxonomy = this.glossaryFVT.issueCreateGlossary((Glossary)taxonomy);
        String taxonomyGuid = createdTaxonomy.getSystemAttributes().getGUID();
        SubjectAreaDefinition subjectAreaDefinition = this.subjectAreaFVT.createSubjectAreaDefinitionWithGlossaryGuid("Subject area 1", taxonomyGuid);
        graph = this.getGraph(taxonomyGuid, null, null, null, null);
        this.checkGraphContent(graph, 2, 1);
        this.checkNodesContainNodeType(graph, NodeType.Taxonomy);
        this.checkNodesContainNodeType(graph, NodeType.SubjectAreaDefinition);
        GraphStatistics graphST = this.getGraphStats(taxonomyGuid, null, null, null, null);
        this.checkGraphStats1(graphST, "Taxonomy");
        graphST = this.getGraphStats(glossaryGuid, null, null, null, null);
        this.checkGraphStats2(graphST, "Term", 3, "TermAnchor", 3);
        graphST = this.getGraphStats(term3.getSystemAttributes().getGUID(), null, null, null, null);
        this.checkGraphStats2(graphST, "Term", 2, "Synonym", 1);
        graphST = this.getGraphStats(term1.getSystemAttributes().getGUID(), null, null, null, null);
        this.checkGraphStats2(graphST, "Term", 3, "Synonym", 2);
        graphST = this.getGraphStats(subjectAreaDefinition.getSystemAttributes().getGUID(), null, null, null, null);
        this.checkGraphStats(graphST, 2, 1);
        this.subjectAreaFVT.deleteSubjectAreaDefinition(subjectAreaDefinition.getSystemAttributes().getGUID());
        this.categoryFVT.deleteCategory(category.getSystemAttributes().getGUID());
        this.termFVT.deleteTerm(term1.getSystemAttributes().getGUID());
        this.termFVT.deleteTerm(term2.getSystemAttributes().getGUID());
        this.termFVT.deleteTerm(term3.getSystemAttributes().getGUID());
        this.glossaryFVT.deleteGlossary(taxonomyGuid);
        this.glossaryFVT.deleteGlossary(glossaryGuid);
    }

    private void checkGraphStats1(GraphStatistics graphST, String nodeToCheck) throws GlossaryAuthorFVTCheckedException {
        Map nodeInfos = graphST.getNodeCounts();
        if (!nodeInfos.containsKey(nodeToCheck)) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected to find " + nodeToCheck + " but it did not exist");
        }
    }

    private void checkGraphStats2(GraphStatistics graphST, String nodeTypeName, int nodecount, String relTypeName, int relationshipCount) throws GlossaryAuthorFVTCheckedException {
        NodeRelationshipStats nrStats;
        Map nodeInfos = graphST.getNodeCounts();
        Map relaInfos = graphST.getRelationshipCounts();
        for (Map.Entry mapEntry : nodeInfos.entrySet()) {
            if (!((String)mapEntry.getKey()).equals(nodeTypeName) || (nrStats = (NodeRelationshipStats)mapEntry.getValue()).getCount() == nodecount) continue;
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected to find " + nodecount + " nodes but found " + nrStats.getCount());
        }
        for (Map.Entry mapEntry : relaInfos.entrySet()) {
            if (!((String)mapEntry.getKey()).equals(relTypeName)) continue;
            nrStats = (NodeRelationshipStats)mapEntry.getValue();
            if (nrStats.getCount() != relationshipCount) {
                throw new GlossaryAuthorFVTCheckedException("ERROR: Expected to find " + relationshipCount + " relationships but found " + nrStats.getCount());
            }
            if (!log.isDebugEnabled()) continue;
            log.debug(((NodeRelationshipStats)mapEntry.getValue()).toString());
            log.debug(nrStats.getCount().toString());
            log.debug(nrStats.getNodeOrRelationshipTypeName());
        }
    }

    private void checkGraphStats(GraphStatistics graphST, int nodeCount, int relCount) throws GlossaryAuthorFVTCheckedException {
        Map nodeInfos = graphST.getNodeCounts();
        Map relaInfos = graphST.getRelationshipCounts();
        if (nodeInfos.size() != nodeCount) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected to find " + nodeCount + " node but it found " + nodeInfos.size());
        }
        if (relaInfos.size() != relCount) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected to find " + relCount + " relationships but it found " + nodeInfos.size());
        }
    }

    private void checkNodesContainNodeType(Graph graph, NodeType nodeTypeToCheck) throws GlossaryAuthorFVTCheckedException {
        boolean found = false;
        if (graph == null || graph.getNodes() == null || graph.getNodes().size() == 0) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected to find " + nodeTypeToCheck.name() + "but there were no nodes in the graph");
        }
        Map nodes = graph.getNodes();
        Set guids = nodes.keySet();
        for (String guid : guids) {
            Node node = (Node)nodes.get(guid);
            if (node.getNodeType() != nodeTypeToCheck) continue;
            found = true;
        }
        if (!found) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected to find " + nodeTypeToCheck.name() + "but it did not exist");
        }
    }

    private void checkGraphContent(Graph graph, int expectedNodesSize, int expectedRelationshipsSize) throws GlossaryAuthorFVTCheckedException {
        if (log.isDebugEnabled()) {
            log.debug("CheckGraphContent expected " + expectedNodesSize + " Nodes and " + expectedRelationshipsSize + " Relationships");
        }
        if (graph.getNodes().size() != expectedNodesSize) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected " + expectedNodesSize + " nodes, got " + graph.getNodes().size());
        }
        if (expectedRelationshipsSize == 0 && graph.getRelationships() != null) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected 0 and graph.getRelationships() to be null ");
        }
        if (expectedRelationshipsSize != 0 && graph.getRelationships() == null) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected " + expectedRelationshipsSize + " and graph.getRelationships() is null ");
        }
        if (graph.getRelationships() != null && graph.getRelationships().size() != expectedRelationshipsSize) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected " + expectedRelationshipsSize + " relationships, got " + graph.getRelationships().size());
        }
    }

    private Graph getGraph(String guid, Date asOfTime, Set<NodeType> nodeFilter, Set<RelationshipType> relationshipFilter, StatusFilter statusFilter) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.glossaryAuthorViewGraphClient.getGraph(this.userId, guid, asOfTime, nodeFilter, relationshipFilter, statusFilter);
    }

    private GraphStatistics getGraphStats(String guid, Date asOfTime, Set<NodeType> nodeFilter, Set<RelationshipType> relationshipFilter, StatusFilter statusFilter) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.glossaryAuthorViewGraphClient.getGraphStatistics(this.userId, guid, asOfTime, nodeFilter, relationshipFilter, statusFilter);
    }
}

