/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.glossaryauthor.fvt;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.category.Category;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Glossary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Node;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Relationship;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.nodesummary.CategorySummary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.project.Project;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.term.Term;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Antonym;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Categorization;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.CategoryHierarchyLink;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.HasA;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.IsA;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.IsATypeOf;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.PreferredTerm;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.ProjectScope;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.RelatedTerm;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.ReplacementTerm;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Synonym;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Translation;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.TypedBy;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.UsedInContext;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.ValidValue;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.repositoryservices.connectors.stores.metadatacollectionstore.properties.SequencingOrder;
import org.odpi.openmetadata.viewservices.glossaryauthor.fvt.CategoryFVT;
import org.odpi.openmetadata.viewservices.glossaryauthor.fvt.FVTUtils;
import org.odpi.openmetadata.viewservices.glossaryauthor.fvt.GlossaryAuthorFVTCheckedException;
import org.odpi.openmetadata.viewservices.glossaryauthor.fvt.GlossaryFVT;
import org.odpi.openmetadata.viewservices.glossaryauthor.fvt.ProjectFVT;
import org.odpi.openmetadata.viewservices.glossaryauthor.fvt.RunAllFVTOn2Servers;
import org.odpi.openmetadata.viewservices.glossaryauthor.fvt.TermFVT;
import org.odpi.openmetadata.viewservices.glossaryauthor.fvt.client.GlossaryAuthorViewRestClient;
import org.odpi.openmetadata.viewservices.glossaryauthor.fvt.client.category.GlossaryAuthorViewCategoryClient;
import org.odpi.openmetadata.viewservices.glossaryauthor.fvt.client.relationships.GlossaryAuthorViewRelationshipsClient;
import org.odpi.openmetadata.viewservices.glossaryauthor.fvt.client.term.GlossaryAuthorViewTermClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.ResolvableType;

public class RelationshipsFVT {
    private static final String DEFAULT_TEST_GLOSSARY_NAME = "Test Glossary for relationships FVT";
    private static final String DEFAULT_TEST_TERM_NAME = "Test term A1";
    private static final String DEFAULT_TEST_TERM_NAME2 = "Test term B1";
    private static final String DEFAULT_TEST_TERM_NAME3 = "Test term C1";
    private static final String DEFAULT_TEST_CAT_NAME1 = "Test cat A1";
    private static final String DEFAULT_TEST_CAT_NAME2 = "Test cat B1";
    private static final String DEFAULT_TEST_CAT_NAME3 = "Test cat C1";
    private static final String DEFAULT_TEST_CAT_NAME4 = "Test cat D1";
    private static final String DEFAULT_TEST_PROJECT_NAME = "Test Project for relationships FVT";
    private GlossaryAuthorViewRelationshipsClient glossaryAuthorViewRelationshipsClient = null;
    private GlossaryAuthorViewCategoryClient glossaryAuthorViewCategory = null;
    private GlossaryAuthorViewTermClient glossaryAuthorViewTerm = null;
    private GlossaryFVT glossaryFVT = null;
    private TermFVT termFVT = null;
    private CategoryFVT catFVT = null;
    private ProjectFVT projectFVT = null;
    private String url = null;
    private String serverName = null;
    private String userId = null;
    private static Logger log = LoggerFactory.getLogger(RelationshipsFVT.class);
    private static final String HAS_A = "has-as";
    private static final String RELATED_TERM = "related-terms";
    private static final String SYNONYM = "synonyms";
    private static final String ANTONYM = "antonyms";
    private static final String TRANSLATION = "translations";
    private static final String USED_IN_CONTEXT = "used-in-contexts";
    private static final String PREFERRED_TERM = "preferred-terms";
    private static final String VALID_VALUE = "valid-values";
    private static final String REPLACEMENT_TERM = "replacement-terms";
    private static final String TYPED_BY = "typed-bys";
    private static final String IS_A = "is-as";
    private static final String IS_A_TYPE_OF_DEPRECATED = "is-a-type-of-deprecateds";
    private static final String IS_A_TYPE_OF = "is-a-type-ofs";
    private static final String TERM_CATEGORIZATION = "term-categorizations";
    private static final String SEMANTIC_ASSIGNMENT = "semantic-assignments";
    private static final String TERM_ANCHOR = "term-anchor";
    private static final String CATEGORY_ANCHOR = "category-anchor";
    private static final String PROJECT_SCOPE = "project-scopes";
    private static final String CATEGORY_HIERARCHY_LINK = "category-hierarchy-links";

    public RelationshipsFVT(String url, String serverName, String userId) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.url = url;
        GlossaryAuthorViewRestClient client = new GlossaryAuthorViewRestClient(serverName, url);
        this.glossaryAuthorViewRelationshipsClient = new GlossaryAuthorViewRelationshipsClient(client);
        this.glossaryAuthorViewCategory = new GlossaryAuthorViewCategoryClient(client);
        this.glossaryAuthorViewTerm = new GlossaryAuthorViewTermClient(client);
        this.termFVT = new TermFVT(url, serverName, userId);
        this.catFVT = new CategoryFVT(url, serverName, userId);
        this.glossaryFVT = new GlossaryFVT(url, serverName, userId);
        this.projectFVT = new ProjectFVT(url, serverName, userId);
        this.serverName = serverName;
        this.userId = userId;
    }

    void deleteRemaining() throws UserNotAuthorizedException, PropertyServerException, InvalidParameterException, GlossaryAuthorFVTCheckedException {
        this.catFVT.deleteRemainingCategories();
        this.termFVT.deleteRemainingTerms();
        this.glossaryFVT.deleteRemainingGlossaries();
        this.projectFVT.deleteRemainingProjects();
    }

    public static void main(String[] args) {
        try {
            String url = RunAllFVTOn2Servers.getUrl(args);
            RelationshipsFVT.runWith2Servers(url);
        }
        catch (IOException e1) {
            System.out.println("Error getting user input");
        }
        catch (GlossaryAuthorFVTCheckedException e) {
            log.error("ERROR: " + e.getMessage());
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            log.error("ERROR: " + e.getReportedErrorMessage() + " Suggested action: " + e.getReportedUserAction());
        }
    }

    public static void runWith2Servers(String url) throws GlossaryAuthorFVTCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        RelationshipsFVT.runIt(url, "cocoView1", "garygeeke");
        RelationshipsFVT.runIt(url, "cocoView2", "garygeeke");
    }

    public static void runIt(String url, String serverName, String userId) throws GlossaryAuthorFVTCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        try {
            System.out.println("relationshipFVT runIt started");
            RelationshipsFVT fvt = new RelationshipsFVT(url, serverName, userId);
            fvt.run();
            fvt.deleteRemaining();
            System.out.println("relationshipFVT runIt stopped");
        }
        catch (Exception error) {
            error.printStackTrace();
            throw error;
        }
    }

    public void run() throws GlossaryAuthorFVTCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (log.isDebugEnabled()) {
            log.debug("Create a glossary");
        }
        int term1relationshipcount = 0;
        int term2relationshipcount = 0;
        int term3relationshipcount = 0;
        int glossaryRelationshipCount = 0;
        int cat1RelationshipCount = 0;
        int cat2RelationshipCount = 0;
        Glossary glossary = this.glossaryFVT.createGlossary(DEFAULT_TEST_GLOSSARY_NAME);
        if (log.isDebugEnabled()) {
            log.debug("Create a term called Test term A1 using glossary GUID");
        }
        String glossaryGuid = glossary.getSystemAttributes().getGUID();
        Term term1 = this.termFVT.createTerm(DEFAULT_TEST_TERM_NAME, glossaryGuid);
        this.checkRelationshipNumberforGlossary(++glossaryRelationshipCount, glossary);
        this.checkRelationshipNumberforTerm(++term1relationshipcount, term1);
        FVTUtils.validateNode((Node)term1);
        if (log.isDebugEnabled()) {
            log.debug("Create a term called Test term B1 using glossary GUID");
        }
        Term term2 = this.termFVT.createTerm(DEFAULT_TEST_TERM_NAME2, glossaryGuid);
        this.checkRelationshipNumberforGlossary(++glossaryRelationshipCount, glossary);
        this.checkRelationshipNumberforTerm(++term2relationshipcount, term2);
        FVTUtils.validateNode((Node)term2);
        if (log.isDebugEnabled()) {
            log.debug("Create a term called Test term C1 using glossary GUID");
        }
        Term term3 = this.termFVT.createTerm(DEFAULT_TEST_TERM_NAME3, glossaryGuid);
        FVTUtils.validateNode((Node)term3);
        this.checkRelationshipNumberforGlossary(++glossaryRelationshipCount, glossary);
        this.checkRelationshipNumberforTerm(++term3relationshipcount, term3);
        Category cat1 = this.catFVT.createCategory(DEFAULT_TEST_CAT_NAME1, glossaryGuid);
        this.checkRelationshipNumberforGlossary(++glossaryRelationshipCount, glossary);
        this.checkRelationshipNumberforCategory(++cat1RelationshipCount, cat1);
        Category cat2 = this.catFVT.createCategory(DEFAULT_TEST_CAT_NAME2, glossaryGuid);
        this.checkRelationshipNumberforGlossary(++glossaryRelationshipCount, glossary);
        this.checkRelationshipNumberforCategory(++cat2RelationshipCount, cat1);
        this.synonymFVT(term1, term2);
        this.antonymFVT(term1, term3);
        this.relatedtermFVT(term1, term3);
        this.hasaFVT(term1, term3);
        this.translationFVT(term1, term2);
        this.usedincontextFVT(term1, term2);
        this.preferredtermFVT(term1, term2);
        this.validvalueFVT(term1, term2);
        this.replacementTermFVT(term1, term2);
        this.typedByFVT(term1, term2);
        this.isaFVT(term1, term2);
        this.isATypeOfFVT(term1, term2);
        this.termCategorizationFVT(term1, cat1);
        this.createSomeTermRelationships(term1, term2, term3);
        this.checkRelationshipNumberforTerm(term1relationshipcount += 12, term1);
        this.checkRelationshipNumberforTerm(term2relationshipcount += 11, term2);
        this.checkRelationshipNumberforTerm(++term3relationshipcount, term3);
        FVTUtils.validateRelationship((Relationship)this.createTermCategorization(term1, cat1));
        ++term1relationshipcount;
        this.checkRelationshipNumberforCategory(++cat1RelationshipCount, cat1);
        FVTUtils.validateRelationship((Relationship)this.createTermCategorization(term1, cat2));
        ++term1relationshipcount;
        this.checkRelationshipNumberforCategory(++cat2RelationshipCount, cat1);
        FVTUtils.validateRelationship((Relationship)this.createTermCategorization(term2, cat1));
        this.checkRelationshipNumberforCategory(++cat1RelationshipCount, cat1);
        FVTUtils.validateRelationship((Relationship)this.createTermCategorization(term3, cat1));
        this.checkRelationshipNumberforCategory(++cat1RelationshipCount, cat1);
        this.checkRelationshipNumberforTerm(term1relationshipcount, term1);
        this.checkRelationshipNumberforTerm(++term2relationshipcount, term2);
        this.checkRelationshipNumberforTerm(++term3relationshipcount, term3);
        if (log.isDebugEnabled()) {
            log.debug("get term relationships");
        }
        List<Relationship> term1Relationships = this.termFVT.getTermRelationships(term1);
        if (log.isDebugEnabled()) {
            log.debug("Get paged term relationships");
        }
        int numberofrelationships = 0;
        for (int offset = 0; offset < term1relationshipcount; offset += 3) {
            if (log.isDebugEnabled()) {
                log.debug("Get paged term relationships offset = " + offset + ",pageSize=3");
            }
            List<Relationship> term1PagedRelationships = this.termFVT.getTermRelationships(term1, null, offset, 3, SequencingOrder.GUID, null);
            numberofrelationships += term1PagedRelationships.size();
            if (!log.isDebugEnabled()) continue;
            log.debug("numberofrelationships = " + numberofrelationships + " term1PagedRelationships.size = " + term1PagedRelationships.size());
        }
        if (term1relationshipcount != numberofrelationships) {
            throw new GlossaryAuthorFVTCheckedException("Expected " + term1Relationships.size() + " got " + numberofrelationships);
        }
        Project project = this.projectFVT.createProject(DEFAULT_TEST_PROJECT_NAME);
        this.projectScopeFVT(project, term1);
        this.projectFVT.deleteProject(project.getSystemAttributes().getGUID());
        Category cat3 = this.catFVT.createCategory(DEFAULT_TEST_CAT_NAME3, glossaryGuid);
        Category cat4 = this.catFVT.createCategory(DEFAULT_TEST_CAT_NAME4, glossaryGuid);
        this.categoryHierarchyLinkFVT(cat3, cat4);
    }

    private void checkRelationshipNumberforTerm(int expectedrelationshipcount, Term term) throws GlossaryAuthorFVTCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        int actualCount = this.termFVT.getTermRelationships(term).size();
        if (expectedrelationshipcount != actualCount) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: expected " + expectedrelationshipcount + " for " + term.getName() + " got " + actualCount);
        }
    }

    private void checkRelationshipNumberforGlossary(int expectedrelationshipcount, Glossary glossary) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, GlossaryAuthorFVTCheckedException {
        int actualCount = this.glossaryFVT.getGlossaryRelationships(glossary).size();
        if (expectedrelationshipcount != actualCount) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: expected " + expectedrelationshipcount + " for " + glossary.getName() + " got " + actualCount);
        }
    }

    private void checkRelationshipNumberforCategory(int expectedrelationshipcount, Category category) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, GlossaryAuthorFVTCheckedException {
        int actualCount = this.catFVT.getCategoryRelationships(category).size();
        if (expectedrelationshipcount != actualCount) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: expected " + expectedrelationshipcount + " for " + category.getName() + " got " + actualCount);
        }
    }

    private void createSomeTermRelationships(Term term1, Term term2, Term term3) throws InvalidParameterException, PropertyServerException, GlossaryAuthorFVTCheckedException, UserNotAuthorizedException {
        FVTUtils.validateRelationship((Relationship)this.createValidValue(term1, term2));
        FVTUtils.validateRelationship((Relationship)this.createAntonym(term1, term2));
        FVTUtils.validateRelationship((Relationship)this.createIsaRelationship(term1, term2));
        FVTUtils.validateRelationship((Relationship)this.createPreferredTerm(term1, term2));
        FVTUtils.validateRelationship((Relationship)this.createRelatedTerm(term1, term2));
        FVTUtils.validateRelationship((Relationship)this.createHasA(term1, term2));
        FVTUtils.validateRelationship((Relationship)this.createSynonym(term1, term3));
        FVTUtils.validateRelationship((Relationship)this.createReplacementTerm(term1, term2));
        FVTUtils.validateRelationship((Relationship)this.createTermTYPEDBYRelationship(term1, term2));
        FVTUtils.validateRelationship((Relationship)this.createTranslation(term1, term2));
        FVTUtils.validateRelationship((Relationship)this.createUsedInContext(term1, term2));
        FVTUtils.validateRelationship((Relationship)this.createIsATypeOf(term1, term2));
    }

    public IsATypeOf createIsATypeOf(Term term1, Term term2) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, GlossaryAuthorFVTCheckedException {
        IsATypeOf isATypeOf = new IsATypeOf();
        isATypeOf.setDescription("ddd");
        isATypeOf.setSource("source");
        isATypeOf.setSteward("Stew");
        isATypeOf.getEnd1().setNodeGuid(term1.getSystemAttributes().getGUID());
        isATypeOf.getEnd2().setNodeGuid(term2.getSystemAttributes().getGUID());
        ResolvableType resolvableType = ResolvableType.forClassWithGenerics(SubjectAreaOMASAPIResponse.class, (Class[])new Class[]{IsATypeOf.class});
        ParameterizedTypeReference type = ParameterizedTypeReference.forType((Type)resolvableType.getType());
        IsATypeOf createdisATypeOf = this.glossaryAuthorViewRelationshipsClient.createRel(this.userId, isATypeOf, type, IS_A_TYPE_OF);
        FVTUtils.validateRelationship((Relationship)createdisATypeOf);
        FVTUtils.checkEnds((Relationship)isATypeOf, (Relationship)createdisATypeOf, "isATypeOf", "create");
        if (log.isDebugEnabled()) {
            log.debug("Created isATypeOf Relationship " + createdisATypeOf);
        }
        return createdisATypeOf;
    }

    private void isATypeOfFVT(Term term1, Term term2) throws UserNotAuthorizedException, PropertyServerException, InvalidParameterException, GlossaryAuthorFVTCheckedException {
        String relType = IS_A_TYPE_OF;
        ResolvableType resolvableType = ResolvableType.forClassWithGenerics(SubjectAreaOMASAPIResponse.class, (Class[])new Class[]{IsATypeOf.class});
        ParameterizedTypeReference type = ParameterizedTypeReference.forType((Type)resolvableType.getType());
        IsATypeOf createdIsATypeOf = this.createIsATypeOf(term1, term2);
        String guid = createdIsATypeOf.getGuid();
        if (log.isDebugEnabled()) {
            log.debug("Created IsaTypeOf " + createdIsATypeOf);
        }
        IsATypeOf gotIsATypeOf = (IsATypeOf)this.glossaryAuthorViewRelationshipsClient.getRel(this.userId, guid, type, relType);
        FVTUtils.validateRelationship((Relationship)gotIsATypeOf);
        if (log.isDebugEnabled()) {
            log.debug("Got IsaTypeOf " + gotIsATypeOf);
        }
        IsATypeOf updateIsATypeOf = new IsATypeOf();
        updateIsATypeOf.setDescription("ddd2");
        IsATypeOf updatedIsATypeOf = this.glossaryAuthorViewRelationshipsClient.updateRel(this.userId, guid, updateIsATypeOf, type, relType, false);
        FVTUtils.validateRelationship((Relationship)updatedIsATypeOf);
        if (!updatedIsATypeOf.getDescription().equals(updateIsATypeOf.getDescription())) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: IsaTypeOf update description not as expected");
        }
        if (!updatedIsATypeOf.getSource().equals(createdIsATypeOf.getSource())) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: IsaTypeOf update source not as expected");
        }
        if (!updatedIsATypeOf.getSteward().equals(createdIsATypeOf.getSteward())) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: IsaTypeOf update steward not as expected");
        }
        FVTUtils.checkEnds((Relationship)updatedIsATypeOf, (Relationship)createdIsATypeOf, "IsATypeOf", "update");
        if (log.isDebugEnabled()) {
            log.debug("Updated IsaTypeOf " + updatedIsATypeOf);
        }
        IsATypeOf replaceIsATypeOf = new IsATypeOf();
        replaceIsATypeOf.setDescription("ddd3");
        IsATypeOf replacedIsATypeOf = this.glossaryAuthorViewRelationshipsClient.replaceRel(this.userId, guid, replaceIsATypeOf, type, relType, true);
        FVTUtils.validateRelationship((Relationship)replacedIsATypeOf);
        if (!replacedIsATypeOf.getDescription().equals(replaceIsATypeOf.getDescription())) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: IsaTypeOf replace description not as expected");
        }
        if (replacedIsATypeOf.getSource() != null) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: IsaTypeOf replace source not as expected");
        }
        if (replacedIsATypeOf.getSteward() != null) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: IsaTypeOf replace steward not as expected");
        }
        if (!replacedIsATypeOf.getEnd1().getNodeGuid().equals(createdIsATypeOf.getEnd1().getNodeGuid())) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: IsaTypeOf replace end 1 not as expected");
        }
        if (!replacedIsATypeOf.getEnd2().getNodeGuid().equals(createdIsATypeOf.getEnd2().getNodeGuid())) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: IsaTypeOf replace end 2 not as expected");
        }
        if (log.isDebugEnabled()) {
            log.debug("Replaced IsaTypeOf " + replacedIsATypeOf);
        }
        this.glossaryAuthorViewRelationshipsClient.deleteRel(this.userId, guid, type, relType);
        if (log.isDebugEnabled()) {
            log.debug("Deleted IsaTypeOf with userId=" + guid);
        }
        gotIsATypeOf = (IsATypeOf)this.glossaryAuthorViewRelationshipsClient.restoreRel(this.userId, guid, type, relType);
        FVTUtils.validateRelationship((Relationship)gotIsATypeOf);
        if (log.isDebugEnabled()) {
            log.debug("Restored IsaTypeOf with userId=" + guid);
        }
        this.glossaryAuthorViewRelationshipsClient.deleteRel(this.userId, guid, type, relType);
        if (log.isDebugEnabled()) {
            log.debug("Deleted IsaTypeOf with userId=" + guid);
        }
    }

    private void isaFVT(Term term1, Term term2) throws InvalidParameterException, PropertyServerException, GlossaryAuthorFVTCheckedException, UserNotAuthorizedException {
        String relType = IS_A;
        ResolvableType resolvableType = ResolvableType.forClassWithGenerics(SubjectAreaOMASAPIResponse.class, (Class[])new Class[]{IsA.class});
        ParameterizedTypeReference type = ParameterizedTypeReference.forType((Type)resolvableType.getType());
        IsA createdIsA = this.createIsaRelationship(term1, term2);
        FVTUtils.validateRelationship((Relationship)createdIsA);
        if (log.isDebugEnabled()) {
            log.debug("Created Isa " + createdIsA);
        }
        String guid = createdIsA.getGuid();
        IsA gotIsA = (IsA)this.glossaryAuthorViewRelationshipsClient.getRel(this.userId, guid, type, relType);
        FVTUtils.validateRelationship((Relationship)gotIsA);
        if (log.isDebugEnabled()) {
            log.debug("Got Isa " + gotIsA);
        }
        IsA updateIsA = new IsA();
        updateIsA.setDescription("ddd2");
        IsA updatedIsA = this.glossaryAuthorViewRelationshipsClient.updateRel(this.userId, guid, updateIsA, type, relType, false);
        if (!updatedIsA.getDescription().equals(updateIsA.getDescription())) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: isa update description not as expected");
        }
        if (!updatedIsA.getSource().equals(createdIsA.getSource())) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: isa update source not as expected");
        }
        if (!updatedIsA.getExpression().equals(createdIsA.getExpression())) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: isa update expression not as expected");
        }
        if (!updatedIsA.getSteward().equals(createdIsA.getSteward())) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: isa update steward not as expected");
        }
        if (!updatedIsA.getEnd1().getNodeGuid().equals(createdIsA.getEnd1().getNodeGuid())) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: isa update end 1 not as expected");
        }
        if (!updatedIsA.getEnd2().getNodeGuid().equals(createdIsA.getEnd2().getNodeGuid())) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: isa update end 2 not as expected");
        }
        if (log.isDebugEnabled()) {
            log.debug("Updated Isa " + updatedIsA);
        }
        IsA replaceIsA = new IsA();
        replaceIsA.setDescription("ddd3");
        IsA replacedIsA = this.glossaryAuthorViewRelationshipsClient.replaceRel(this.userId, guid, replaceIsA, type, relType, true);
        FVTUtils.validateRelationship((Relationship)replacedIsA);
        if (!replacedIsA.getDescription().equals(replaceIsA.getDescription())) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: isa replace description not as expected");
        }
        if (replacedIsA.getSource() != null) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: isa replace source not as expected");
        }
        if (replacedIsA.getExpression() != null) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: isa replace expression not as expected");
        }
        if (replacedIsA.getSteward() != null) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: isa replace steward not as expected");
        }
        if (!replacedIsA.getEnd1().getNodeGuid().equals(createdIsA.getEnd1().getNodeGuid())) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: isa replace end 1 not as expected");
        }
        if (!replacedIsA.getEnd2().getNodeGuid().equals(createdIsA.getEnd2().getNodeGuid())) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: isa replace end 2 not as expected");
        }
        if (log.isDebugEnabled()) {
            log.debug("Replaced Isa " + replacedIsA);
        }
        this.glossaryAuthorViewRelationshipsClient.deleteRel(this.userId, guid, type, relType);
        if (log.isDebugEnabled()) {
            log.debug("Deleted Isa with userId=" + guid);
        }
        gotIsA = (IsA)this.glossaryAuthorViewRelationshipsClient.restoreRel(this.userId, guid, type, relType);
        FVTUtils.validateRelationship((Relationship)gotIsA);
        if (log.isDebugEnabled()) {
            log.debug("Restored Isa with userId=" + guid);
        }
        this.glossaryAuthorViewRelationshipsClient.deleteRel(this.userId, guid, type, relType);
        if (log.isDebugEnabled()) {
            log.debug("Deleted Isa with userId=" + guid);
        }
    }

    private IsA createIsaRelationship(Term term1, Term term2) throws GlossaryAuthorFVTCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        IsA isa = new IsA();
        isa.setDescription("ddd");
        isa.setExpression("Ex");
        isa.setSource("source");
        isa.setSteward("Stew");
        isa.getEnd1().setNodeGuid(term1.getSystemAttributes().getGUID());
        isa.getEnd2().setNodeGuid(term2.getSystemAttributes().getGUID());
        ResolvableType resolvableType = ResolvableType.forClassWithGenerics(SubjectAreaOMASAPIResponse.class, (Class[])new Class[]{IsA.class});
        ParameterizedTypeReference type = ParameterizedTypeReference.forType((Type)resolvableType.getType());
        IsA createdIsA = this.glossaryAuthorViewRelationshipsClient.createRel(this.userId, isa, type, IS_A);
        FVTUtils.validateRelationship((Relationship)createdIsA);
        FVTUtils.checkEnds((Relationship)isa, (Relationship)createdIsA, "isa", "create");
        return createdIsA;
    }

    private void typedByFVT(Term term1, Term term2) throws InvalidParameterException, PropertyServerException, GlossaryAuthorFVTCheckedException, UserNotAuthorizedException {
        String relType = TYPED_BY;
        ResolvableType resolvableType = ResolvableType.forClassWithGenerics(SubjectAreaOMASAPIResponse.class, (Class[])new Class[]{TypedBy.class});
        ParameterizedTypeReference type = ParameterizedTypeReference.forType((Type)resolvableType.getType());
        TypedBy createdTermTYPEDBYRelationship = this.createTermTYPEDBYRelationship(term1, term2);
        FVTUtils.validateRelationship((Relationship)createdTermTYPEDBYRelationship);
        if (log.isDebugEnabled()) {
            log.debug("Created TypedBy " + createdTermTYPEDBYRelationship);
        }
        String guid = createdTermTYPEDBYRelationship.getGuid();
        TypedBy gotTermTYPEDBYRelationship = (TypedBy)this.glossaryAuthorViewRelationshipsClient.getRel(this.userId, guid, type, relType);
        FVTUtils.validateRelationship((Relationship)gotTermTYPEDBYRelationship);
        if (log.isDebugEnabled()) {
            log.debug("Got TypedBy " + gotTermTYPEDBYRelationship);
        }
        TypedBy updateTermTYPEDBYRelationship = new TypedBy();
        updateTermTYPEDBYRelationship.setDescription("ddd2");
        TypedBy updatedTermTYPEDBYRelationship = this.glossaryAuthorViewRelationshipsClient.updateRel(this.userId, guid, updateTermTYPEDBYRelationship, type, relType, false);
        FVTUtils.validateRelationship((Relationship)updatedTermTYPEDBYRelationship);
        if (!updatedTermTYPEDBYRelationship.getDescription().equals(updateTermTYPEDBYRelationship.getDescription())) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: termTYPEDBYRelationship update description not as expected");
        }
        if (!updatedTermTYPEDBYRelationship.getSource().equals(createdTermTYPEDBYRelationship.getSource())) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: termTYPEDBYRelationship update source not as expected");
        }
        if (!updatedTermTYPEDBYRelationship.getSteward().equals(createdTermTYPEDBYRelationship.getSteward())) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: termTYPEDBYRelationship update steward not as expected");
        }
        FVTUtils.checkEnds((Relationship)updatedTermTYPEDBYRelationship, (Relationship)createdTermTYPEDBYRelationship, "TYPEDBY", "update");
        if (log.isDebugEnabled()) {
            log.debug("Updated TypedBy " + updatedTermTYPEDBYRelationship);
        }
        TypedBy replaceTermTYPEDBYRelationship = new TypedBy();
        replaceTermTYPEDBYRelationship.setDescription("ddd3");
        TypedBy replacedTermTYPEDBYRelationship = this.glossaryAuthorViewRelationshipsClient.replaceRel(this.userId, guid, replaceTermTYPEDBYRelationship, type, relType, true);
        FVTUtils.validateRelationship((Relationship)replacedTermTYPEDBYRelationship);
        if (!replacedTermTYPEDBYRelationship.getDescription().equals(replaceTermTYPEDBYRelationship.getDescription())) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: termTYPEDBYRelationship replace description not as expected");
        }
        if (replacedTermTYPEDBYRelationship.getSource() != null) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: termTYPEDBYRelationship replace source not as expected");
        }
        if (replacedTermTYPEDBYRelationship.getSteward() != null) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: termTYPEDBYRelationship replace steward not as expected");
        }
        FVTUtils.checkEnds((Relationship)replacedTermTYPEDBYRelationship, (Relationship)createdTermTYPEDBYRelationship, "TYPEDBY", "replace");
        if (log.isDebugEnabled()) {
            log.debug("Replaced TypedBy " + replacedTermTYPEDBYRelationship);
        }
        this.glossaryAuthorViewRelationshipsClient.deleteRel(this.userId, guid, type, relType);
        if (log.isDebugEnabled()) {
            log.debug("Deleted TypedBy with userId=" + guid);
        }
        gotTermTYPEDBYRelationship = (TypedBy)this.glossaryAuthorViewRelationshipsClient.restoreRel(this.userId, guid, type, relType);
        FVTUtils.validateRelationship((Relationship)gotTermTYPEDBYRelationship);
        if (log.isDebugEnabled()) {
            log.debug("Restored TypedBy with userId=" + guid);
        }
        this.glossaryAuthorViewRelationshipsClient.deleteRel(this.userId, guid, type, relType);
        if (log.isDebugEnabled()) {
            log.debug("Deleted TypedBy with userId=" + guid);
        }
    }

    private TypedBy createTermTYPEDBYRelationship(Term term1, Term term2) throws GlossaryAuthorFVTCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        TypedBy termTYPEDBYRelationship = new TypedBy();
        termTYPEDBYRelationship.setDescription("ddd");
        termTYPEDBYRelationship.setSource("source");
        termTYPEDBYRelationship.setSteward("Stew");
        termTYPEDBYRelationship.getEnd1().setNodeGuid(term1.getSystemAttributes().getGUID());
        termTYPEDBYRelationship.getEnd2().setNodeGuid(term2.getSystemAttributes().getGUID());
        ResolvableType resolvableType = ResolvableType.forClassWithGenerics(SubjectAreaOMASAPIResponse.class, (Class[])new Class[]{TypedBy.class});
        ParameterizedTypeReference type = ParameterizedTypeReference.forType((Type)resolvableType.getType());
        TypedBy createdTermTYPEDBYRelationship = this.glossaryAuthorViewRelationshipsClient.createRel(this.userId, termTYPEDBYRelationship, type, TYPED_BY);
        FVTUtils.validateRelationship((Relationship)createdTermTYPEDBYRelationship);
        FVTUtils.checkEnds((Relationship)termTYPEDBYRelationship, (Relationship)createdTermTYPEDBYRelationship, "TypedBy", "create");
        return createdTermTYPEDBYRelationship;
    }

    private void replacementTermFVT(Term term1, Term term2) throws InvalidParameterException, PropertyServerException, GlossaryAuthorFVTCheckedException, UserNotAuthorizedException {
        String relType = REPLACEMENT_TERM;
        ResolvableType resolvableType = ResolvableType.forClassWithGenerics(SubjectAreaOMASAPIResponse.class, (Class[])new Class[]{ReplacementTerm.class});
        ParameterizedTypeReference type = ParameterizedTypeReference.forType((Type)resolvableType.getType());
        ReplacementTerm createdReplacementTerm = this.createReplacementTerm(term1, term2);
        FVTUtils.validateRelationship((Relationship)createdReplacementTerm);
        if (log.isDebugEnabled()) {
            log.debug("Created ReplacementTerm " + createdReplacementTerm);
        }
        String guid = createdReplacementTerm.getGuid();
        ReplacementTerm gotReplacementTerm = (ReplacementTerm)this.glossaryAuthorViewRelationshipsClient.getRel(this.userId, guid, type, relType);
        FVTUtils.validateRelationship((Relationship)gotReplacementTerm);
        if (log.isDebugEnabled()) {
            log.debug("Got ReplacementTerm " + gotReplacementTerm);
        }
        ReplacementTerm updateReplacementTerm = new ReplacementTerm();
        updateReplacementTerm.setDescription("ddd2");
        ReplacementTerm updatedReplacementTerm = this.glossaryAuthorViewRelationshipsClient.updateRel(this.userId, guid, updateReplacementTerm, type, relType, false);
        FVTUtils.validateRelationship((Relationship)updatedReplacementTerm);
        if (!updatedReplacementTerm.getDescription().equals(updateReplacementTerm.getDescription())) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: replacementTerm update description not as expected");
        }
        if (!updatedReplacementTerm.getSource().equals(createdReplacementTerm.getSource())) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: replacementTerm update source not as expected");
        }
        if (!updatedReplacementTerm.getExpression().equals(createdReplacementTerm.getExpression())) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: replacementTerm update expression not as expected");
        }
        if (!updatedReplacementTerm.getSteward().equals(createdReplacementTerm.getSteward())) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: replacementTerm update steward not as expected");
        }
        FVTUtils.checkEnds((Relationship)updatedReplacementTerm, (Relationship)createdReplacementTerm, "replacementTerm", "update");
        if (log.isDebugEnabled()) {
            log.debug("Updated ReplacementTerm " + updatedReplacementTerm);
        }
        ReplacementTerm replaceReplacementTerm = new ReplacementTerm();
        replaceReplacementTerm.setDescription("ddd3");
        ReplacementTerm replacedReplacementTerm = this.glossaryAuthorViewRelationshipsClient.replaceRel(this.userId, guid, replaceReplacementTerm, type, relType, true);
        FVTUtils.validateRelationship((Relationship)replacedReplacementTerm);
        if (!replacedReplacementTerm.getDescription().equals(replaceReplacementTerm.getDescription())) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: replacementTerm replace description not as expected");
        }
        if (replacedReplacementTerm.getSource() != null) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: replacementTerm replace source not as expected");
        }
        if (replacedReplacementTerm.getExpression() != null) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: replacementTerm replace expression not as expected");
        }
        if (replacedReplacementTerm.getSteward() != null) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: replacementTerm replace steward not as expected");
        }
        FVTUtils.checkEnds((Relationship)replacedReplacementTerm, (Relationship)createdReplacementTerm, "replacementTerm", "replace");
        if (log.isDebugEnabled()) {
            log.debug("Replaced ReplacementTerm " + replacedReplacementTerm);
        }
        this.glossaryAuthorViewRelationshipsClient.deleteRel(this.userId, guid, type, relType);
        if (log.isDebugEnabled()) {
            log.debug("Deleted ReplacementTerm with userId=" + guid);
        }
        gotReplacementTerm = (ReplacementTerm)this.glossaryAuthorViewRelationshipsClient.restoreRel(this.userId, guid, type, relType);
        FVTUtils.validateRelationship((Relationship)gotReplacementTerm);
        if (log.isDebugEnabled()) {
            log.debug("Restored ReplacementTerm with userId=" + guid);
        }
        this.glossaryAuthorViewRelationshipsClient.deleteRel(this.userId, guid, type, relType);
        if (log.isDebugEnabled()) {
            log.debug("Deleted ReplacementTerm with userId=" + guid);
        }
    }

    private ReplacementTerm createReplacementTerm(Term term1, Term term2) throws GlossaryAuthorFVTCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ReplacementTerm replacementTerm = new ReplacementTerm();
        replacementTerm.setDescription("ddd");
        replacementTerm.setExpression("Ex");
        replacementTerm.setSource("source");
        replacementTerm.setSteward("Stew");
        replacementTerm.getEnd1().setNodeGuid(term1.getSystemAttributes().getGUID());
        replacementTerm.getEnd2().setNodeGuid(term2.getSystemAttributes().getGUID());
        ResolvableType resolvableType = ResolvableType.forClassWithGenerics(SubjectAreaOMASAPIResponse.class, (Class[])new Class[]{ReplacementTerm.class});
        ParameterizedTypeReference type = ParameterizedTypeReference.forType((Type)resolvableType.getType());
        ReplacementTerm createdReplacementTerm = this.glossaryAuthorViewRelationshipsClient.createRel(this.userId, replacementTerm, type, REPLACEMENT_TERM);
        FVTUtils.validateRelationship((Relationship)createdReplacementTerm);
        FVTUtils.checkEnds((Relationship)replacementTerm, (Relationship)createdReplacementTerm, "ReplacementTerm", "create");
        return createdReplacementTerm;
    }

    private void validvalueFVT(Term term1, Term term2) throws InvalidParameterException, PropertyServerException, GlossaryAuthorFVTCheckedException, UserNotAuthorizedException {
        String relType = VALID_VALUE;
        ResolvableType resolvableType = ResolvableType.forClassWithGenerics(SubjectAreaOMASAPIResponse.class, (Class[])new Class[]{ValidValue.class});
        ParameterizedTypeReference type = ParameterizedTypeReference.forType((Type)resolvableType.getType());
        ValidValue createdValidValue = this.createValidValue(term1, term2);
        FVTUtils.validateRelationship((Relationship)createdValidValue);
        if (log.isDebugEnabled()) {
            log.debug("Created ValidValue " + createdValidValue);
        }
        String guid = createdValidValue.getGuid();
        ValidValue gotValidValue = (ValidValue)this.glossaryAuthorViewRelationshipsClient.getRel(this.userId, guid, type, relType);
        FVTUtils.validateRelationship((Relationship)gotValidValue);
        if (log.isDebugEnabled()) {
            log.debug("Got ValidValue " + gotValidValue);
        }
        ValidValue updateValidValue = new ValidValue();
        updateValidValue.setDescription("ddd2");
        ValidValue updatedValidValue = this.glossaryAuthorViewRelationshipsClient.updateRel(this.userId, guid, updateValidValue, type, relType, false);
        if (!updatedValidValue.getDescription().equals(updateValidValue.getDescription())) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: validValue update description not as expected");
        }
        if (!updatedValidValue.getSource().equals(createdValidValue.getSource())) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: validValue update source not as expected");
        }
        if (!updatedValidValue.getExpression().equals(createdValidValue.getExpression())) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: validValue update expression not as expected");
        }
        if (!updatedValidValue.getSteward().equals(createdValidValue.getSteward())) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: validValue update steward not as expected");
        }
        FVTUtils.checkEnds((Relationship)updatedValidValue, (Relationship)createdValidValue, "ValidValue", "update");
        if (log.isDebugEnabled()) {
            log.debug("Updated ValidValue " + updateValidValue);
        }
        ValidValue replaceValidValue = new ValidValue();
        replaceValidValue.setDescription("ddd3");
        replaceValidValue.setGuid(createdValidValue.getGuid());
        ValidValue replacedValidValue = this.glossaryAuthorViewRelationshipsClient.replaceRel(this.userId, guid, replaceValidValue, type, relType, true);
        if (!replacedValidValue.getDescription().equals(replaceValidValue.getDescription())) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: validValue replace description not as expected");
        }
        if (replacedValidValue.getSource() != null) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: validValue replace source not as expected");
        }
        if (replacedValidValue.getExpression() != null) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: validValue replace expression not as expected");
        }
        if (replacedValidValue.getSteward() != null) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: validValue replace steward not as expected");
        }
        FVTUtils.checkEnds((Relationship)replacedValidValue, (Relationship)createdValidValue, "ValidValue", "replace");
        if (log.isDebugEnabled()) {
            log.debug("Replaced ValidValue " + replaceValidValue);
        }
        this.glossaryAuthorViewRelationshipsClient.deleteRel(this.userId, guid, type, relType);
        if (log.isDebugEnabled()) {
            log.debug("Deleted ValidValue with userId=" + guid);
        }
        gotValidValue = (ValidValue)this.glossaryAuthorViewRelationshipsClient.restoreRel(this.userId, guid, type, relType);
        FVTUtils.validateRelationship((Relationship)gotValidValue);
        if (log.isDebugEnabled()) {
            log.debug("Restored ValidValue with userId=" + guid);
        }
        this.glossaryAuthorViewRelationshipsClient.deleteRel(this.userId, guid, type, relType);
        if (log.isDebugEnabled()) {
            log.debug("Deleted ValidValue with userId=" + guid);
        }
    }

    private ValidValue createValidValue(Term term1, Term term2) throws GlossaryAuthorFVTCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ValidValue validValue = new ValidValue();
        validValue.setDescription("ddd");
        validValue.setExpression("Ex");
        validValue.setSource("source");
        validValue.setSteward("Stew");
        validValue.getEnd1().setNodeGuid(term1.getSystemAttributes().getGUID());
        validValue.getEnd2().setNodeGuid(term2.getSystemAttributes().getGUID());
        ResolvableType resolvableType = ResolvableType.forClassWithGenerics(SubjectAreaOMASAPIResponse.class, (Class[])new Class[]{ValidValue.class});
        ParameterizedTypeReference type = ParameterizedTypeReference.forType((Type)resolvableType.getType());
        ValidValue createdValidValue = this.glossaryAuthorViewRelationshipsClient.createRel(this.userId, validValue, type, VALID_VALUE);
        FVTUtils.validateRelationship((Relationship)createdValidValue);
        FVTUtils.checkEnds((Relationship)validValue, (Relationship)createdValidValue, "ValidValue", "create");
        return createdValidValue;
    }

    private void preferredtermFVT(Term term1, Term term2) throws UserNotAuthorizedException, PropertyServerException, InvalidParameterException, GlossaryAuthorFVTCheckedException {
        String relType = PREFERRED_TERM;
        ResolvableType resolvableType = ResolvableType.forClassWithGenerics(SubjectAreaOMASAPIResponse.class, (Class[])new Class[]{PreferredTerm.class});
        ParameterizedTypeReference type = ParameterizedTypeReference.forType((Type)resolvableType.getType());
        PreferredTerm createdPreferredTerm = this.createPreferredTerm(term1, term2);
        FVTUtils.validateRelationship((Relationship)createdPreferredTerm);
        if (log.isDebugEnabled()) {
            log.debug("Created PreferredTerm " + createdPreferredTerm);
        }
        String guid = createdPreferredTerm.getGuid();
        PreferredTerm gotPreferredTerm = (PreferredTerm)this.glossaryAuthorViewRelationshipsClient.getRel(this.userId, guid, type, relType);
        FVTUtils.validateRelationship((Relationship)gotPreferredTerm);
        if (log.isDebugEnabled()) {
            log.debug("Got PreferredTerm " + gotPreferredTerm);
        }
        PreferredTerm updatePreferredTerm = new PreferredTerm();
        updatePreferredTerm.setDescription("ddd2");
        PreferredTerm updatedPreferredTerm = this.glossaryAuthorViewRelationshipsClient.updateRel(this.userId, guid, updatePreferredTerm, type, relType, false);
        FVTUtils.validateRelationship((Relationship)updatedPreferredTerm);
        if (!updatedPreferredTerm.getDescription().equals(updatePreferredTerm.getDescription())) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: preferredTerm update description not as expected");
        }
        if (!updatedPreferredTerm.getSource().equals(createdPreferredTerm.getSource())) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: preferredTerm update source not as expected");
        }
        if (!updatedPreferredTerm.getExpression().equals(createdPreferredTerm.getExpression())) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: preferredTerm update expression not as expected");
        }
        if (!updatedPreferredTerm.getSteward().equals(createdPreferredTerm.getSteward())) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: preferredTerm update steward not as expected");
        }
        FVTUtils.checkEnds((Relationship)updatedPreferredTerm, (Relationship)createdPreferredTerm, "PreferredTerm", "update");
        if (log.isDebugEnabled()) {
            log.debug("Updated PreferredTerm " + updatedPreferredTerm);
        }
        PreferredTerm replacePreferredTerm = new PreferredTerm();
        replacePreferredTerm.setDescription("ddd3");
        PreferredTerm replacedPreferredTerm = this.glossaryAuthorViewRelationshipsClient.replaceRel(this.userId, guid, replacePreferredTerm, type, relType, true);
        FVTUtils.validateRelationship((Relationship)replacedPreferredTerm);
        if (!replacedPreferredTerm.getDescription().equals(replacePreferredTerm.getDescription())) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: preferredTerm replace description not as expected");
        }
        if (replacedPreferredTerm.getSource() != null) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: preferredTerm replace source not as expected");
        }
        if (replacedPreferredTerm.getExpression() != null) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: preferredTerm replace expression not as expected");
        }
        if (replacedPreferredTerm.getSteward() != null) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: preferredTerm replace steward not as expected");
        }
        FVTUtils.checkEnds((Relationship)replacedPreferredTerm, (Relationship)createdPreferredTerm, "PreferredTerm", "replace");
        if (log.isDebugEnabled()) {
            log.debug("Replaced PreferredTerm " + createdPreferredTerm);
        }
        this.glossaryAuthorViewRelationshipsClient.deleteRel(this.userId, guid, type, relType);
        if (log.isDebugEnabled()) {
            log.debug("Deleted PreferredTerm with userId=" + guid);
        }
        gotPreferredTerm = (PreferredTerm)this.glossaryAuthorViewRelationshipsClient.restoreRel(this.userId, guid, type, relType);
        FVTUtils.validateRelationship((Relationship)gotPreferredTerm);
        if (log.isDebugEnabled()) {
            log.debug("restored PreferredTerm with userId=" + guid);
        }
        this.glossaryAuthorViewRelationshipsClient.deleteRel(this.userId, guid, type, relType);
        log.debug("Deleted PreferredTerm with userId=" + guid);
    }

    private PreferredTerm createPreferredTerm(Term term1, Term term2) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, GlossaryAuthorFVTCheckedException {
        PreferredTerm preferredTerm = new PreferredTerm();
        preferredTerm.setDescription("ddd");
        preferredTerm.setExpression("Ex");
        preferredTerm.setSource("source");
        preferredTerm.setSteward("Stew");
        preferredTerm.getEnd1().setNodeGuid(term1.getSystemAttributes().getGUID());
        preferredTerm.getEnd2().setNodeGuid(term2.getSystemAttributes().getGUID());
        ResolvableType resolvableType = ResolvableType.forClassWithGenerics(SubjectAreaOMASAPIResponse.class, (Class[])new Class[]{PreferredTerm.class});
        ParameterizedTypeReference type = ParameterizedTypeReference.forType((Type)resolvableType.getType());
        PreferredTerm createdPreferredTerm = this.glossaryAuthorViewRelationshipsClient.createRel(this.userId, preferredTerm, type, PREFERRED_TERM);
        FVTUtils.validateRelationship((Relationship)createdPreferredTerm);
        FVTUtils.checkEnds((Relationship)preferredTerm, (Relationship)createdPreferredTerm, "PreferredTerm", "create");
        return createdPreferredTerm;
    }

    private void usedincontextFVT(Term term1, Term term2) throws InvalidParameterException, PropertyServerException, GlossaryAuthorFVTCheckedException, UserNotAuthorizedException {
        String relType = USED_IN_CONTEXT;
        ResolvableType resolvableType = ResolvableType.forClassWithGenerics(SubjectAreaOMASAPIResponse.class, (Class[])new Class[]{UsedInContext.class});
        ParameterizedTypeReference type = ParameterizedTypeReference.forType((Type)resolvableType.getType());
        UsedInContext createdUsedInContext = this.createUsedInContext(term1, term2);
        FVTUtils.validateRelationship((Relationship)createdUsedInContext);
        if (log.isDebugEnabled()) {
            log.debug("Created UsedInContext " + createdUsedInContext);
        }
        String guid = createdUsedInContext.getGuid();
        UsedInContext gotUsedInContext = (UsedInContext)this.glossaryAuthorViewRelationshipsClient.getRel(this.userId, guid, type, relType);
        FVTUtils.validateRelationship((Relationship)gotUsedInContext);
        if (log.isDebugEnabled()) {
            log.debug("Got UsedInContext " + gotUsedInContext);
        }
        UsedInContext updateUsedInContext = new UsedInContext();
        updateUsedInContext.setDescription("ddd2");
        UsedInContext updatedUsedInContext = this.glossaryAuthorViewRelationshipsClient.updateRel(this.userId, guid, updateUsedInContext, type, relType, false);
        FVTUtils.validateRelationship((Relationship)updatedUsedInContext);
        if (!updatedUsedInContext.getDescription().equals(updateUsedInContext.getDescription())) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: usedInContext update description not as expected");
        }
        if (!updatedUsedInContext.getSource().equals(createdUsedInContext.getSource())) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: usedInContext update source not as expected");
        }
        if (!updatedUsedInContext.getExpression().equals(createdUsedInContext.getExpression())) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: usedInContext update expression not as expected");
        }
        if (!updatedUsedInContext.getSteward().equals(createdUsedInContext.getSteward())) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: usedInContext update steward not as expected");
        }
        FVTUtils.checkEnds((Relationship)updatedUsedInContext, (Relationship)createdUsedInContext, "UsedInContext", "update");
        if (log.isDebugEnabled()) {
            log.debug("Updated UsedInContext " + updatedUsedInContext);
        }
        UsedInContext replaceUsedInContext = new UsedInContext();
        replaceUsedInContext.setDescription("ddd3");
        UsedInContext replacedUsedInContext = this.glossaryAuthorViewRelationshipsClient.replaceRel(this.userId, guid, replaceUsedInContext, type, relType, true);
        FVTUtils.validateRelationship((Relationship)replacedUsedInContext);
        if (!replacedUsedInContext.getDescription().equals(replaceUsedInContext.getDescription())) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: usedInContext replace description not as expected");
        }
        if (replacedUsedInContext.getSource() != null) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: usedInContext replace source not as expected");
        }
        if (replacedUsedInContext.getExpression() != null) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: usedInContext replace expression not as expected");
        }
        if (replacedUsedInContext.getSteward() != null) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: usedInContext replace steward not as expected");
        }
        FVTUtils.checkEnds((Relationship)replacedUsedInContext, (Relationship)createdUsedInContext, "UsedInContext", "replace");
        if (log.isDebugEnabled()) {
            log.debug("Replaced UsedInContext " + replacedUsedInContext);
        }
        this.glossaryAuthorViewRelationshipsClient.deleteRel(this.userId, guid, type, relType);
        if (log.isDebugEnabled()) {
            log.debug("Deleted UsedInContext with userId=" + guid);
        }
        gotUsedInContext = (UsedInContext)this.glossaryAuthorViewRelationshipsClient.restoreRel(this.userId, guid, type, relType);
        FVTUtils.validateRelationship((Relationship)gotUsedInContext);
        if (log.isDebugEnabled()) {
            log.debug("Restored UsedInContext with userId=" + guid);
        }
        this.glossaryAuthorViewRelationshipsClient.deleteRel(this.userId, guid, type, relType);
        if (log.isDebugEnabled()) {
            log.debug("Deleted UsedInContext with userId=" + guid);
        }
    }

    private UsedInContext createUsedInContext(Term term1, Term term2) throws GlossaryAuthorFVTCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        UsedInContext usedInContext = new UsedInContext();
        usedInContext.setDescription("ddd");
        usedInContext.setExpression("Ex");
        usedInContext.setSource("source");
        usedInContext.setSteward("Stew");
        usedInContext.getEnd1().setNodeGuid(term1.getSystemAttributes().getGUID());
        usedInContext.getEnd2().setNodeGuid(term2.getSystemAttributes().getGUID());
        ResolvableType resolvableType = ResolvableType.forClassWithGenerics(SubjectAreaOMASAPIResponse.class, (Class[])new Class[]{UsedInContext.class});
        ParameterizedTypeReference type = ParameterizedTypeReference.forType((Type)resolvableType.getType());
        UsedInContext createdUsedInContext = this.glossaryAuthorViewRelationshipsClient.createRel(this.userId, usedInContext, type, USED_IN_CONTEXT);
        FVTUtils.validateRelationship((Relationship)createdUsedInContext);
        FVTUtils.checkEnds((Relationship)usedInContext, (Relationship)createdUsedInContext, "UsedInContext", "create");
        return createdUsedInContext;
    }

    private void translationFVT(Term term1, Term term2) throws InvalidParameterException, PropertyServerException, GlossaryAuthorFVTCheckedException, UserNotAuthorizedException {
        String relType = TRANSLATION;
        ResolvableType resolvableType = ResolvableType.forClassWithGenerics(SubjectAreaOMASAPIResponse.class, (Class[])new Class[]{Translation.class});
        ParameterizedTypeReference type = ParameterizedTypeReference.forType((Type)resolvableType.getType());
        Translation createdTranslation = this.createTranslation(term1, term2);
        FVTUtils.validateRelationship((Relationship)createdTranslation);
        if (log.isDebugEnabled()) {
            log.debug("Created Translation " + createdTranslation);
        }
        String guid = createdTranslation.getGuid();
        Translation gotTranslation = (Translation)this.glossaryAuthorViewRelationshipsClient.getRel(this.userId, guid, type, relType);
        FVTUtils.validateRelationship((Relationship)gotTranslation);
        if (log.isDebugEnabled()) {
            log.debug("Got Translation " + gotTranslation);
        }
        Translation updateTranslation = new Translation();
        updateTranslation.setDescription("ddd2");
        Translation updatedTranslation = this.glossaryAuthorViewRelationshipsClient.updateRel(this.userId, guid, updateTranslation, type, relType, false);
        FVTUtils.validateRelationship((Relationship)updatedTranslation);
        if (!updatedTranslation.getDescription().equals(updateTranslation.getDescription())) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: translation update description not as expected");
        }
        if (!updatedTranslation.getSource().equals(createdTranslation.getSource())) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: translation update source not as expected");
        }
        if (!updatedTranslation.getExpression().equals(createdTranslation.getExpression())) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: translation update expression not as expected");
        }
        if (!updatedTranslation.getSteward().equals(createdTranslation.getSteward())) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: translation update steward not as expected");
        }
        FVTUtils.checkEnds((Relationship)updatedTranslation, (Relationship)createdTranslation, "translation", "update");
        if (log.isDebugEnabled()) {
            log.debug("Updated Translation " + updatedTranslation);
        }
        Translation replaceTranslation = new Translation();
        replaceTranslation.setDescription("ddd3");
        Translation replacedTranslation = this.glossaryAuthorViewRelationshipsClient.replaceRel(this.userId, guid, replaceTranslation, type, relType, true);
        FVTUtils.validateRelationship((Relationship)replacedTranslation);
        if (!replacedTranslation.getDescription().equals(replaceTranslation.getDescription())) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: translation replace description not as expected");
        }
        if (replacedTranslation.getSource() != null) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: translation replace source not as expected");
        }
        if (replacedTranslation.getExpression() != null) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: translation replace expression not as expected");
        }
        if (replacedTranslation.getSteward() != null) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: translation replace steward not as expected");
        }
        FVTUtils.checkEnds((Relationship)replacedTranslation, (Relationship)updatedTranslation, "translation", "replace");
        if (log.isDebugEnabled()) {
            log.debug("Replaced Translation " + replacedTranslation);
        }
        this.glossaryAuthorViewRelationshipsClient.deleteRel(this.userId, guid, type, relType);
        if (log.isDebugEnabled()) {
            log.debug("Deleted Translation with userId=" + guid);
        }
        gotTranslation = (Translation)this.glossaryAuthorViewRelationshipsClient.restoreRel(this.userId, guid, type, relType);
        FVTUtils.validateRelationship((Relationship)gotTranslation);
        if (log.isDebugEnabled()) {
            log.debug("Restored Translation with userId=" + guid);
        }
        this.glossaryAuthorViewRelationshipsClient.deleteRel(this.userId, guid, type, relType);
        if (log.isDebugEnabled()) {
            log.debug("Deleted Translation with userId=" + guid);
        }
    }

    private Translation createTranslation(Term term1, Term term2) throws GlossaryAuthorFVTCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ResolvableType resolvableType = ResolvableType.forClassWithGenerics(SubjectAreaOMASAPIResponse.class, (Class[])new Class[]{Translation.class});
        ParameterizedTypeReference type = ParameterizedTypeReference.forType((Type)resolvableType.getType());
        Translation translation = new Translation();
        translation.setDescription("ddd");
        translation.setExpression("Ex");
        translation.setSource("source");
        translation.setSteward("Stew");
        translation.getEnd1().setNodeGuid(term1.getSystemAttributes().getGUID());
        translation.getEnd2().setNodeGuid(term2.getSystemAttributes().getGUID());
        Translation createdTranslation = this.glossaryAuthorViewRelationshipsClient.createRel(this.userId, translation, type, TRANSLATION);
        FVTUtils.validateRelationship((Relationship)createdTranslation);
        FVTUtils.checkEnds((Relationship)translation, (Relationship)createdTranslation, TRANSLATION, "create");
        return createdTranslation;
    }

    private void hasaFVT(Term term1, Term term3) throws UserNotAuthorizedException, PropertyServerException, InvalidParameterException, GlossaryAuthorFVTCheckedException {
        String relType = HAS_A;
        ResolvableType resolvableType = ResolvableType.forClassWithGenerics(SubjectAreaOMASAPIResponse.class, (Class[])new Class[]{HasA.class});
        ParameterizedTypeReference type = ParameterizedTypeReference.forType((Type)resolvableType.getType());
        HasA createdHasA = this.createHasA(term1, term3);
        Term term1PostCreate = this.termFVT.getTermByGUID(term1.getSystemAttributes().getGUID());
        if (log.isDebugEnabled()) {
            log.debug(" term1PostCreate.isSpineObject() " + term1PostCreate.isSpineObject());
            log.debug(" term1PostCreate GUID " + term1PostCreate.getSystemAttributes().getGUID());
            log.debug(" term1  GUID " + term1.getSystemAttributes().getGUID());
        }
        Term term3PostCreate = this.termFVT.getTermByGUID(term3.getSystemAttributes().getGUID());
        if (log.isDebugEnabled()) {
            log.debug(" term3PostCreate.isSpineAttribute() " + term3PostCreate.isSpineAttribute());
            log.debug(" term3PostCreate GUID " + term3PostCreate.getSystemAttributes().getGUID());
            log.debug(" term3  GUID " + term3.getSystemAttributes().getGUID());
        }
        FVTUtils.validateRelationship((Relationship)createdHasA);
        if (log.isDebugEnabled()) {
            log.debug("Created Hasa " + createdHasA);
            log.debug("Hasa End1" + createdHasA.getEnd1().getNodeGuid());
            log.debug("Hasa End2" + createdHasA.getEnd2().getNodeGuid());
        }
        String guid = createdHasA.getGuid();
        HasA gotHasATerm = (HasA)this.glossaryAuthorViewRelationshipsClient.getRel(this.userId, guid, type, relType);
        FVTUtils.validateRelationship((Relationship)gotHasATerm);
        if (log.isDebugEnabled()) {
            log.debug("Got Hasa " + gotHasATerm);
        }
        HasA updateHasATerm = new HasA();
        updateHasATerm.setDescription("ddd2");
        HasA updatedHasATerm = this.glossaryAuthorViewRelationshipsClient.updateRel(this.userId, guid, updateHasATerm, type, relType, false);
        FVTUtils.validateRelationship((Relationship)updatedHasATerm);
        if (!updatedHasATerm.getDescription().equals(updateHasATerm.getDescription())) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: HASARelationship update description not as expected");
        }
        if (!updatedHasATerm.getSource().equals(createdHasA.getSource())) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: HASARelationship update source not as expected");
        }
        if (!updatedHasATerm.getSteward().equals(createdHasA.getSteward())) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: HASARelationship update steward not as expected");
        }
        FVTUtils.checkEnds((Relationship)updatedHasATerm, (Relationship)createdHasA, "has-a", "update");
        if (log.isDebugEnabled()) {
            log.debug("Updated HASARelationship " + updatedHasATerm);
        }
        HasA replaceHasA = new HasA();
        replaceHasA.setDescription("ddd3");
        HasA replacedHasA = this.glossaryAuthorViewRelationshipsClient.replaceRel(this.userId, guid, replaceHasA, type, relType, true);
        FVTUtils.validateRelationship((Relationship)replacedHasA);
        if (!replacedHasA.getDescription().equals(replaceHasA.getDescription())) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: HASARelationship replace description not as expected");
        }
        if (replacedHasA.getSource() != null) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: HASARelationship replace source not as expected");
        }
        if (replacedHasA.getSteward() != null) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: HASARelationship replace steward not as expected");
        }
        FVTUtils.checkEnds((Relationship)updatedHasATerm, (Relationship)replacedHasA, "has-a", "replace");
        if (log.isDebugEnabled()) {
            log.debug("Replaced HASARelationship " + replacedHasA);
        }
        term1PostCreate = this.termFVT.getTermByGUID(term1.getSystemAttributes().getGUID());
        if (log.isDebugEnabled()) {
            log.debug(" term1PostCreate.isSpineObject() " + term1PostCreate.isSpineObject());
        }
        term3PostCreate = this.termFVT.getTermByGUID(term3.getSystemAttributes().getGUID());
        if (log.isDebugEnabled()) {
            log.debug(" term3PostCreate.isSpineAttribute() " + term3PostCreate.isSpineAttribute());
        }
        if (!(term1PostCreate = this.termFVT.getTermByGUID(term1.getSystemAttributes().getGUID())).isSpineObject()) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: expect term 1 to be a Spine Object");
        }
        term3PostCreate = this.termFVT.getTermByGUID(term3.getSystemAttributes().getGUID());
        if (!term3PostCreate.isSpineAttribute()) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: expect term 3 to be a Spine Attribute");
        }
        this.glossaryAuthorViewRelationshipsClient.deleteRel(this.userId, guid, type, relType);
        if (log.isDebugEnabled()) {
            log.debug("Deleted Hasa with userId=" + guid);
        }
        gotHasATerm = (HasA)this.glossaryAuthorViewRelationshipsClient.restoreRel(this.userId, guid, type, relType);
        FVTUtils.validateRelationship((Relationship)gotHasATerm);
        if (log.isDebugEnabled()) {
            log.debug("Restored Hasa with userId=" + guid);
        }
        this.glossaryAuthorViewRelationshipsClient.deleteRel(this.userId, guid, type, relType);
        if (log.isDebugEnabled()) {
            log.debug("Deleted Hasa with userId=" + guid);
        }
    }

    private HasA createHasA(Term term1, Term term2) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, GlossaryAuthorFVTCheckedException {
        HasA hasA = new HasA();
        hasA.setDescription("ddd");
        hasA.setSource("source");
        hasA.setSteward("Stew");
        hasA.getEnd1().setNodeGuid(term1.getSystemAttributes().getGUID());
        hasA.getEnd2().setNodeGuid(term2.getSystemAttributes().getGUID());
        String relType = HAS_A;
        ResolvableType resolvableType = ResolvableType.forClassWithGenerics(SubjectAreaOMASAPIResponse.class, (Class[])new Class[]{HasA.class});
        ParameterizedTypeReference type = ParameterizedTypeReference.forType((Type)resolvableType.getType());
        HasA createdTermHasARelationship = this.glossaryAuthorViewRelationshipsClient.createRel(this.userId, hasA, type, relType);
        FVTUtils.validateRelationship((Relationship)createdTermHasARelationship);
        FVTUtils.checkEnds((Relationship)hasA, (Relationship)createdTermHasARelationship, "Has-a", "create");
        return createdTermHasARelationship;
    }

    private void relatedtermFVT(Term term1, Term term3) throws InvalidParameterException, PropertyServerException, GlossaryAuthorFVTCheckedException, UserNotAuthorizedException {
        String relType = RELATED_TERM;
        ResolvableType resolvableType = ResolvableType.forClassWithGenerics(SubjectAreaOMASAPIResponse.class, (Class[])new Class[]{RelatedTerm.class});
        ParameterizedTypeReference type = ParameterizedTypeReference.forType((Type)resolvableType.getType());
        RelatedTerm createdRelatedTerm = this.createRelatedTerm(term1, term3);
        FVTUtils.validateRelationship((Relationship)createdRelatedTerm);
        if (log.isDebugEnabled()) {
            log.debug("Created RelatedTerm " + createdRelatedTerm);
        }
        String guid = createdRelatedTerm.getGuid();
        RelatedTerm gotRelatedTerm = (RelatedTerm)this.glossaryAuthorViewRelationshipsClient.getRel(this.userId, guid, type, relType);
        FVTUtils.validateRelationship((Relationship)gotRelatedTerm);
        if (log.isDebugEnabled()) {
            log.debug("Got RelatedTerm " + gotRelatedTerm);
        }
        RelatedTerm updateRelatedTerm = new RelatedTerm();
        updateRelatedTerm.setDescription("ddd2");
        updateRelatedTerm.setGuid(createdRelatedTerm.getGuid());
        RelatedTerm updatedRelatedTerm = this.glossaryAuthorViewRelationshipsClient.updateRel(this.userId, guid, updateRelatedTerm, type, relType, false);
        FVTUtils.validateRelationship((Relationship)updatedRelatedTerm);
        if (!updatedRelatedTerm.getDescription().equals(updateRelatedTerm.getDescription())) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: RelatedTerm update description not as expected");
        }
        if (!updatedRelatedTerm.getSource().equals(createdRelatedTerm.getSource())) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: RelatedTerm update source not as expected");
        }
        if (!updatedRelatedTerm.getExpression().equals(createdRelatedTerm.getExpression())) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: RelatedTerm update expression not as expected");
        }
        if (!updatedRelatedTerm.getSteward().equals(createdRelatedTerm.getSteward())) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: RelatedTerm update steward not as expected");
        }
        FVTUtils.checkEnds((Relationship)updatedRelatedTerm, (Relationship)createdRelatedTerm, "RelatedTerm", "update");
        if (log.isDebugEnabled()) {
            log.debug("Updated RelatedTerm " + updatedRelatedTerm);
        }
        RelatedTerm replaceRelatedTerm = new RelatedTerm();
        replaceRelatedTerm.setDescription("ddd3");
        replaceRelatedTerm.setGuid(createdRelatedTerm.getGuid());
        RelatedTerm replacedRelatedTerm = this.glossaryAuthorViewRelationshipsClient.replaceRel(this.userId, guid, replaceRelatedTerm, type, relType, true);
        FVTUtils.validateRelationship((Relationship)replacedRelatedTerm);
        if (!replacedRelatedTerm.getDescription().equals(replaceRelatedTerm.getDescription())) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: RelatedTerm replace description not as expected");
        }
        if (replacedRelatedTerm.getSource() != null) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: RelatedTerm replace source not as expected");
        }
        if (replacedRelatedTerm.getExpression() != null) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: RelatedTerm replace expression not as expected");
        }
        if (replacedRelatedTerm.getSteward() != null) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: RelatedTerm replace steward not as expected");
        }
        FVTUtils.checkEnds((Relationship)replacedRelatedTerm, (Relationship)createdRelatedTerm, "RelatedTerm", "replace");
        if (log.isDebugEnabled()) {
            log.debug("Replaced RelatedTerm " + replacedRelatedTerm);
        }
        this.glossaryAuthorViewRelationshipsClient.deleteRel(this.userId, guid, type, relType);
        if (log.isDebugEnabled()) {
            log.debug("Deleted RelatedTerm with userId=" + guid);
        }
        gotRelatedTerm = (RelatedTerm)this.glossaryAuthorViewRelationshipsClient.restoreRel(this.userId, guid, type, relType);
        FVTUtils.validateRelationship((Relationship)gotRelatedTerm);
        if (log.isDebugEnabled()) {
            log.debug("Restored RelatedTerm with userId=" + guid);
        }
        this.glossaryAuthorViewRelationshipsClient.deleteRel(this.userId, guid, type, relType);
        if (log.isDebugEnabled()) {
            log.debug("Deleted RelatedTerm with userId=" + guid);
        }
    }

    private RelatedTerm createRelatedTerm(Term term1, Term term2) throws GlossaryAuthorFVTCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        RelatedTerm relatedterm = new RelatedTerm();
        relatedterm.setDescription("ddd");
        relatedterm.setExpression("Ex");
        relatedterm.setSource("source");
        relatedterm.setSteward("Stew");
        relatedterm.getEnd1().setNodeGuid(term1.getSystemAttributes().getGUID());
        relatedterm.getEnd2().setNodeGuid(term2.getSystemAttributes().getGUID());
        ResolvableType resolvableType = ResolvableType.forClassWithGenerics(SubjectAreaOMASAPIResponse.class, (Class[])new Class[]{RelatedTerm.class});
        ParameterizedTypeReference type = ParameterizedTypeReference.forType((Type)resolvableType.getType());
        RelatedTerm createdRelatedTerm = this.glossaryAuthorViewRelationshipsClient.createRel(this.userId, relatedterm, type, RELATED_TERM);
        FVTUtils.validateRelationship((Relationship)createdRelatedTerm);
        FVTUtils.checkEnds((Relationship)relatedterm, (Relationship)createdRelatedTerm, "RelatedTerm", "create");
        return createdRelatedTerm;
    }

    private void antonymFVT(Term term1, Term term3) throws InvalidParameterException, PropertyServerException, GlossaryAuthorFVTCheckedException, UserNotAuthorizedException {
        String relType = ANTONYM;
        ResolvableType resolvableType = ResolvableType.forClassWithGenerics(SubjectAreaOMASAPIResponse.class, (Class[])new Class[]{Antonym.class});
        ParameterizedTypeReference type = ParameterizedTypeReference.forType((Type)resolvableType.getType());
        Antonym createdAntonym = this.createAntonym(term1, term3);
        FVTUtils.validateRelationship((Relationship)createdAntonym);
        if (log.isDebugEnabled()) {
            log.debug("Created Antonym " + createdAntonym);
        }
        String guid = createdAntonym.getGuid();
        Antonym gotAntonym = (Antonym)this.glossaryAuthorViewRelationshipsClient.getRel(this.userId, guid, type, relType);
        FVTUtils.validateRelationship((Relationship)gotAntonym);
        if (log.isDebugEnabled()) {
            log.debug("Got Antonym " + gotAntonym);
        }
        Antonym updateAntonym = new Antonym();
        updateAntonym.setDescription("ddd2");
        Antonym updatedAntonym = this.glossaryAuthorViewRelationshipsClient.updateRel(this.userId, guid, updateAntonym, type, relType, false);
        FVTUtils.validateRelationship((Relationship)updatedAntonym);
        if (!updatedAntonym.getDescription().equals(updateAntonym.getDescription())) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Antonym update description not as expected");
        }
        if (!updatedAntonym.getSource().equals(createdAntonym.getSource())) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Antonym update source not as expected");
        }
        if (!updatedAntonym.getExpression().equals(createdAntonym.getExpression())) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Antonym update expression not as expected");
        }
        if (!updatedAntonym.getSteward().equals(createdAntonym.getSteward())) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Antonym update steward not as expected");
        }
        FVTUtils.checkEnds((Relationship)updatedAntonym, (Relationship)createdAntonym, "Antonym", "update");
        if (log.isDebugEnabled()) {
            log.debug("Updated Antonym " + updatedAntonym);
        }
        Antonym replaceAntonym = new Antonym();
        replaceAntonym.setDescription("ddd3");
        replaceAntonym.setGuid(createdAntonym.getGuid());
        Antonym replacedAntonym = this.glossaryAuthorViewRelationshipsClient.replaceRel(this.userId, guid, replaceAntonym, type, relType, true);
        FVTUtils.validateRelationship((Relationship)replacedAntonym);
        if (!replacedAntonym.getDescription().equals(replaceAntonym.getDescription())) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Antonym replace description not as expected");
        }
        if (replacedAntonym.getSource() != null) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Antonym replace source not as expected");
        }
        if (replacedAntonym.getExpression() != null) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Antonym replace expression not as expected");
        }
        if (replacedAntonym.getSteward() != null) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Antonym replace steward not as expected");
        }
        FVTUtils.checkEnds((Relationship)updatedAntonym, (Relationship)createdAntonym, "Antonym", "replace");
        if (log.isDebugEnabled()) {
            log.debug("Replaced Antonym " + replacedAntonym);
        }
        this.glossaryAuthorViewRelationshipsClient.deleteRel(this.userId, guid, type, relType);
        if (log.isDebugEnabled()) {
            log.debug("Deleted Antonym with userId=" + guid);
        }
        gotAntonym = (Antonym)this.glossaryAuthorViewRelationshipsClient.restoreRel(this.userId, guid, type, relType);
        FVTUtils.validateRelationship((Relationship)gotAntonym);
        if (log.isDebugEnabled()) {
            log.debug("Restored Antonym with userId=" + guid);
        }
        this.glossaryAuthorViewRelationshipsClient.deleteRel(this.userId, guid, type, relType);
        if (log.isDebugEnabled()) {
            log.debug("Deleted Antonym with userId=" + guid);
        }
    }

    private Antonym createAntonym(Term term1, Term term2) throws GlossaryAuthorFVTCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Antonym antonym = new Antonym();
        antonym.setDescription("ddd");
        antonym.setExpression("Ex");
        antonym.setSource("source");
        antonym.setSteward("Stew");
        antonym.getEnd1().setNodeGuid(term1.getSystemAttributes().getGUID());
        antonym.getEnd2().setNodeGuid(term2.getSystemAttributes().getGUID());
        ResolvableType resolvableType = ResolvableType.forClassWithGenerics(SubjectAreaOMASAPIResponse.class, (Class[])new Class[]{Antonym.class});
        ParameterizedTypeReference type = ParameterizedTypeReference.forType((Type)resolvableType.getType());
        Antonym createdAntonym = this.glossaryAuthorViewRelationshipsClient.createRel(this.userId, antonym, type, ANTONYM);
        FVTUtils.validateRelationship((Relationship)createdAntonym);
        FVTUtils.checkEnds((Relationship)antonym, (Relationship)createdAntonym, "Antonym", "create");
        return createdAntonym;
    }

    private void synonymFVT(Term term1, Term term2) throws InvalidParameterException, PropertyServerException, GlossaryAuthorFVTCheckedException, UserNotAuthorizedException {
        String relType = SYNONYM;
        ResolvableType resolvableType = ResolvableType.forClassWithGenerics(SubjectAreaOMASAPIResponse.class, (Class[])new Class[]{Synonym.class});
        ParameterizedTypeReference type = ParameterizedTypeReference.forType((Type)resolvableType.getType());
        Synonym createdSynonym = this.createSynonym(term1, term2);
        FVTUtils.validateRelationship((Relationship)createdSynonym);
        if (log.isDebugEnabled()) {
            log.debug("Created Synonym " + createdSynonym);
        }
        String guid = createdSynonym.getGuid();
        Synonym gotSynonym = (Synonym)this.glossaryAuthorViewRelationshipsClient.getRel(this.userId, guid, type, SYNONYM);
        FVTUtils.validateRelationship((Relationship)gotSynonym);
        if (log.isDebugEnabled()) {
            log.debug("Got Synonym " + gotSynonym);
        }
        Synonym updateSynonym = new Synonym();
        updateSynonym.setDescription("ddd2");
        Synonym updatedSynonym = this.glossaryAuthorViewRelationshipsClient.updateRel(this.userId, guid, updateSynonym, type, relType, false);
        FVTUtils.validateRelationship((Relationship)updatedSynonym);
        if (!updatedSynonym.getDescription().equals(updateSynonym.getDescription())) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: synonym update description not as expected");
        }
        if (log.isDebugEnabled()) {
            log.debug(" updatedSynonym " + updatedSynonym.toString());
        }
        if (!updatedSynonym.getSource().equals(createdSynonym.getSource())) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: synonym update source not as expected");
        }
        if (!updatedSynonym.getExpression().equals(createdSynonym.getExpression())) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: synonym update expression not as expected");
        }
        if (!updatedSynonym.getSteward().equals(createdSynonym.getSteward())) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: synonym update steward not as expected");
        }
        FVTUtils.checkEnds((Relationship)updatedSynonym, (Relationship)createdSynonym, "synonym", "update");
        if (log.isDebugEnabled()) {
            log.debug("Updated Synonym " + createdSynonym);
        }
        Synonym replaceSynonym = new Synonym();
        replaceSynonym.setDescription("ddd3");
        Synonym replacedSynonym = this.glossaryAuthorViewRelationshipsClient.replaceRel(this.userId, guid, replaceSynonym, type, relType, true);
        FVTUtils.validateRelationship((Relationship)replacedSynonym);
        if (!replacedSynonym.getDescription().equals(replaceSynonym.getDescription())) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: synonym replace description not as expected");
        }
        if (replacedSynonym.getSource() != null) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: synonym replace source not as expected");
        }
        if (replacedSynonym.getExpression() != null) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: synonym replace expression not as expected");
        }
        if (replacedSynonym.getSteward() != null) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: synonym replace steward not as expected");
        }
        FVTUtils.checkEnds((Relationship)updatedSynonym, (Relationship)replacedSynonym, "synonym", "replace");
        if (log.isDebugEnabled()) {
            log.debug("Replaced Synonym " + replacedSynonym);
        }
        this.glossaryAuthorViewRelationshipsClient.deleteRel(this.userId, guid, type, relType);
        if (log.isDebugEnabled()) {
            log.debug("Deleted Synonym with userId=" + guid);
        }
        gotSynonym = (Synonym)this.glossaryAuthorViewRelationshipsClient.restoreRel(this.userId, guid, type, relType);
        FVTUtils.validateRelationship((Relationship)gotSynonym);
        if (log.isDebugEnabled()) {
            log.debug("Restored Synonym with userId=" + guid);
        }
        this.glossaryAuthorViewRelationshipsClient.deleteRel(this.userId, guid, type, relType);
        if (log.isDebugEnabled()) {
            log.debug("Hard deleted Synonym with userId=" + guid);
        }
    }

    public Synonym createSynonym(Term term1, Term term2) throws GlossaryAuthorFVTCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Synonym synonym = new Synonym();
        synonym.setDescription("ddd");
        synonym.setExpression("Ex");
        synonym.setSource("source");
        synonym.setSteward("Stew");
        synonym.getEnd1().setNodeGuid(term1.getSystemAttributes().getGUID());
        synonym.getEnd2().setNodeGuid(term2.getSystemAttributes().getGUID());
        ResolvableType resolvableType = ResolvableType.forClassWithGenerics(SubjectAreaOMASAPIResponse.class, (Class[])new Class[]{Synonym.class});
        ParameterizedTypeReference type = ParameterizedTypeReference.forType((Type)resolvableType.getType());
        Synonym createdSynonym = this.glossaryAuthorViewRelationshipsClient.createRel(this.userId, synonym, type, SYNONYM);
        FVTUtils.validateRelationship((Relationship)createdSynonym);
        FVTUtils.checkEnds((Relationship)synonym, (Relationship)createdSynonym, "synonym", "create");
        return createdSynonym;
    }

    private void termCategorizationFVT(Term term, Category category) throws UserNotAuthorizedException, PropertyServerException, InvalidParameterException, GlossaryAuthorFVTCheckedException {
        String relType = TERM_CATEGORIZATION;
        ResolvableType resolvableType = ResolvableType.forClassWithGenerics(SubjectAreaOMASAPIResponse.class, (Class[])new Class[]{Categorization.class});
        ParameterizedTypeReference type = ParameterizedTypeReference.forType((Type)resolvableType.getType());
        Categorization createdTermCategorizationRelationship = this.createTermCategorization(term, category);
        FVTUtils.validateRelationship((Relationship)createdTermCategorizationRelationship);
        if (log.isDebugEnabled()) {
            log.debug("Created TermCategorizationRelationship " + createdTermCategorizationRelationship);
        }
        String guid = createdTermCategorizationRelationship.getGuid();
        Categorization gotTermCategorizationRelationship = (Categorization)this.glossaryAuthorViewRelationshipsClient.getRel(this.userId, guid, type, relType);
        FVTUtils.validateRelationship((Relationship)gotTermCategorizationRelationship);
        if (log.isDebugEnabled()) {
            log.debug("Got TermCategorizationRelationship " + gotTermCategorizationRelationship);
        }
        Categorization updateTermCategorizationRelationship = new Categorization();
        updateTermCategorizationRelationship.setDescription("ddd2");
        Categorization updatedTermCategorizationRelationship = this.glossaryAuthorViewRelationshipsClient.updateRel(this.userId, guid, updateTermCategorizationRelationship, type, relType, false);
        FVTUtils.validateRelationship((Relationship)updatedTermCategorizationRelationship);
        FVTUtils.checkEnds((Relationship)updatedTermCategorizationRelationship, (Relationship)createdTermCategorizationRelationship, "TermCategorization", "update");
        if (!updatedTermCategorizationRelationship.getDescription().equals(updateTermCategorizationRelationship.getDescription())) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: TermCategorization update description not as expected");
        }
        if (updatedTermCategorizationRelationship.getStatus() != null) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: TermCategorization update status not as expected");
        }
        if (log.isDebugEnabled()) {
            log.debug("Updated TermCategorizationRelationship " + createdTermCategorizationRelationship);
        }
        Categorization replaceTermCategorizationRelationship = new Categorization();
        replaceTermCategorizationRelationship.setDescription("ddd3");
        Categorization replacedTermCategorizationRelationship = this.glossaryAuthorViewRelationshipsClient.replaceRel(this.userId, guid, replaceTermCategorizationRelationship, type, relType, true);
        FVTUtils.validateRelationship((Relationship)replacedTermCategorizationRelationship);
        if (!replacedTermCategorizationRelationship.getDescription().equals(replaceTermCategorizationRelationship.getDescription())) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: TermCategorization replace description not as expected");
        }
        if (replacedTermCategorizationRelationship.getStatus() != null) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: TermCategorization replace source not as expected");
        }
        FVTUtils.checkEnds((Relationship)replacedTermCategorizationRelationship, (Relationship)createdTermCategorizationRelationship, "TermCategorization", "replace");
        if (log.isDebugEnabled()) {
            log.debug("Replaced TermCategorizationRelationship " + replacedTermCategorizationRelationship);
        }
        this.glossaryAuthorViewRelationshipsClient.deleteRel(this.userId, guid, type, relType);
        if (log.isDebugEnabled()) {
            log.debug("Deleted TermCategorizationRelationship with userId=" + guid);
        }
        gotTermCategorizationRelationship = (Categorization)this.glossaryAuthorViewRelationshipsClient.restoreRel(this.userId, guid, type, relType);
        FVTUtils.validateRelationship((Relationship)gotTermCategorizationRelationship);
        if (log.isDebugEnabled()) {
            log.debug("Restored TermCategorizationRelationship with userId=" + guid);
        }
        this.glossaryAuthorViewRelationshipsClient.deleteRel(this.userId, guid, type, relType);
        if (log.isDebugEnabled()) {
            log.debug("Deleted TermCategorization with userId=" + guid);
        }
    }

    public Categorization createTermCategorization(Term term, Category category) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, GlossaryAuthorFVTCheckedException {
        Categorization termCategorization = new Categorization();
        termCategorization.getEnd1().setNodeGuid(category.getSystemAttributes().getGUID());
        termCategorization.getEnd2().setNodeGuid(term.getSystemAttributes().getGUID());
        ResolvableType resolvableType = ResolvableType.forClassWithGenerics(SubjectAreaOMASAPIResponse.class, (Class[])new Class[]{Categorization.class});
        ParameterizedTypeReference type = ParameterizedTypeReference.forType((Type)resolvableType.getType());
        Categorization createdTermCategorization = this.glossaryAuthorViewRelationshipsClient.createRel(this.userId, termCategorization, type, TERM_CATEGORIZATION);
        FVTUtils.validateRelationship((Relationship)createdTermCategorization);
        FVTUtils.checkEnds((Relationship)termCategorization, (Relationship)createdTermCategorization, "TermCategorizationRelationship", "create");
        if (log.isDebugEnabled()) {
            log.debug("Created TermCategorizationRelationship " + createdTermCategorization);
        }
        return createdTermCategorization;
    }

    private void projectScopeFVT(Project project, Term term) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, GlossaryAuthorFVTCheckedException {
        String relType = PROJECT_SCOPE;
        ResolvableType resolvableType = ResolvableType.forClassWithGenerics(SubjectAreaOMASAPIResponse.class, (Class[])new Class[]{ProjectScope.class});
        ParameterizedTypeReference type = ParameterizedTypeReference.forType((Type)resolvableType.getType());
        ProjectScope createdProjectScope = this.createProjectScope(project, term);
        FVTUtils.validateRelationship((Relationship)createdProjectScope);
        if (log.isDebugEnabled()) {
            log.debug("Created ProjectScopeRelationship " + createdProjectScope);
        }
        String guid = createdProjectScope.getGuid();
        ProjectScope gotProjectScopeRelationship = (ProjectScope)this.glossaryAuthorViewRelationshipsClient.getRel(this.userId, guid, type, relType);
        FVTUtils.validateRelationship((Relationship)gotProjectScopeRelationship);
        if (log.isDebugEnabled()) {
            log.debug("Got ProjectScopeRelationship " + gotProjectScopeRelationship);
        }
        ProjectScope updateProjectScope = new ProjectScope();
        updateProjectScope.setDescription("ddd2");
        updateProjectScope.setGuid(createdProjectScope.getGuid());
        ProjectScope updatedProjectScope = this.glossaryAuthorViewRelationshipsClient.updateRel(this.userId, guid, updateProjectScope, type, relType, false);
        FVTUtils.validateRelationship((Relationship)updatedProjectScope);
        if (!updatedProjectScope.getDescription().equals(updateProjectScope.getDescription())) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Project scope  update scopeDescription not as expected");
        }
        FVTUtils.checkEnds((Relationship)updatedProjectScope, (Relationship)createdProjectScope, "ProjectScope", "update");
        if (log.isDebugEnabled()) {
            log.debug("Updated ProjectScopeRelationship " + updatedProjectScope);
        }
        ProjectScope replaceProjectScope = new ProjectScope();
        replaceProjectScope.setDescription("ddd3");
        ProjectScope replacedProjectScope = this.glossaryAuthorViewRelationshipsClient.replaceRel(this.userId, guid, replaceProjectScope, type, relType, true);
        FVTUtils.validateRelationship((Relationship)replacedProjectScope);
        if (!replacedProjectScope.getDescription().equals(replaceProjectScope.getDescription())) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: project scope replace scope description not as expected");
        }
        FVTUtils.checkEnds((Relationship)replacedProjectScope, (Relationship)createdProjectScope, "ProjectScope", "replace");
        if (log.isDebugEnabled()) {
            log.debug("Replaced ProjectScopeRelationship " + replacedProjectScope);
        }
        this.glossaryAuthorViewRelationshipsClient.deleteRel(this.userId, guid, type, relType);
        if (log.isDebugEnabled()) {
            log.debug("Deleted ProjectScopeRelationship with userId=" + guid);
        }
        gotProjectScopeRelationship = (ProjectScope)this.glossaryAuthorViewRelationshipsClient.restoreRel(this.userId, guid, type, relType);
        FVTUtils.validateRelationship((Relationship)gotProjectScopeRelationship);
        if (log.isDebugEnabled()) {
            log.debug("Restored ProjectScopeRelationship with userId=" + guid);
        }
        this.glossaryAuthorViewRelationshipsClient.deleteRel(this.userId, guid, type, relType);
        if (log.isDebugEnabled()) {
            log.debug("Hard deleted ProjectScopeRelationship with userId=" + guid);
        }
    }

    protected ProjectScope createProjectScope(Project project, Term term) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, GlossaryAuthorFVTCheckedException {
        ProjectScope projectScope = new ProjectScope();
        projectScope.getEnd1().setNodeGuid(project.getSystemAttributes().getGUID());
        projectScope.getEnd2().setNodeGuid(term.getSystemAttributes().getGUID());
        ResolvableType resolvableType = ResolvableType.forClassWithGenerics(SubjectAreaOMASAPIResponse.class, (Class[])new Class[]{ProjectScope.class});
        ParameterizedTypeReference type = ParameterizedTypeReference.forType((Type)resolvableType.getType());
        ProjectScope createdProjectScope = this.glossaryAuthorViewRelationshipsClient.createRel(this.userId, projectScope, type, PROJECT_SCOPE);
        FVTUtils.validateRelationship((Relationship)createdProjectScope);
        if (log.isDebugEnabled()) {
            log.debug("CreatedProjectScopeRelationship " + createdProjectScope);
        }
        return createdProjectScope;
    }

    private void categoryHierarchyLinkFVT(Category parent, Category child) throws UserNotAuthorizedException, PropertyServerException, InvalidParameterException, GlossaryAuthorFVTCheckedException {
        String relType = CATEGORY_HIERARCHY_LINK;
        ResolvableType resolvableType = ResolvableType.forClassWithGenerics(SubjectAreaOMASAPIResponse.class, (Class[])new Class[]{CategoryHierarchyLink.class});
        ParameterizedTypeReference type = ParameterizedTypeReference.forType((Type)resolvableType.getType());
        CategoryHierarchyLink categoryHierarchyLink = this.createCategoryHierarchyLink(parent, child);
        if (log.isDebugEnabled()) {
            log.debug("Create CategoryHierarchyLink " + categoryHierarchyLink);
        }
        String guid = categoryHierarchyLink.getGuid();
        CategoryHierarchyLink gotCategoryHierarchyLink = (CategoryHierarchyLink)this.glossaryAuthorViewRelationshipsClient.getRel(this.userId, guid, type, relType);
        FVTUtils.validateRelationship((Relationship)gotCategoryHierarchyLink);
        if (log.isDebugEnabled()) {
            log.debug("Got CategoryHierarchyLink " + gotCategoryHierarchyLink);
        }
        Category gotChild = this.glossaryAuthorViewCategory.getByGUID(this.userId, child.getSystemAttributes().getGUID());
        if (log.isDebugEnabled()) {
            log.debug("Got Category gotChild " + gotChild);
        }
        this.checkParent(parent, gotChild);
        this.glossaryAuthorViewRelationshipsClient.deleteRel(this.userId, guid, type, relType);
        if (log.isDebugEnabled()) {
            log.debug("Deleted CategoryHierarchyLink with userId=" + guid);
        }
        gotCategoryHierarchyLink = (CategoryHierarchyLink)this.glossaryAuthorViewRelationshipsClient.restoreRel(this.userId, guid, type, relType);
        FVTUtils.validateRelationship((Relationship)gotCategoryHierarchyLink);
        if (log.isDebugEnabled()) {
            log.debug("Restored CategoryHierarchyLink with userId=" + guid);
        }
        this.glossaryAuthorViewRelationshipsClient.deleteRel(this.userId, guid, type, relType);
        if (log.isDebugEnabled()) {
            log.debug("Deleted CategoryHierarchyLink with userId=" + guid);
        }
    }

    public CategoryHierarchyLink createCategoryHierarchyLink(Category parent, Category child) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, GlossaryAuthorFVTCheckedException {
        ResolvableType resolvableType = ResolvableType.forClassWithGenerics(SubjectAreaOMASAPIResponse.class, (Class[])new Class[]{CategoryHierarchyLink.class});
        ParameterizedTypeReference type = ParameterizedTypeReference.forType((Type)resolvableType.getType());
        CategoryHierarchyLink categoryHierarchyLink = new CategoryHierarchyLink();
        categoryHierarchyLink.getEnd1().setNodeGuid(parent.getSystemAttributes().getGUID());
        categoryHierarchyLink.getEnd2().setNodeGuid(child.getSystemAttributes().getGUID());
        CategoryHierarchyLink createdCategoryHierarchyLink = this.glossaryAuthorViewRelationshipsClient.createRel(this.userId, categoryHierarchyLink, type, CATEGORY_HIERARCHY_LINK);
        FVTUtils.validateRelationship((Relationship)createdCategoryHierarchyLink);
        FVTUtils.checkEnds((Relationship)categoryHierarchyLink, (Relationship)createdCategoryHierarchyLink, "CategoryHierarchyLink", "create");
        if (log.isDebugEnabled()) {
            log.debug("Created CategoryHierarchyLink " + createdCategoryHierarchyLink);
            log.debug("Created CategoryHierarchyLink End1 " + createdCategoryHierarchyLink.getEnd1().getNodeGuid());
            log.debug("Created CategoryHierarchyLink End2 " + createdCategoryHierarchyLink.getEnd2().getNodeGuid());
        }
        return createdCategoryHierarchyLink;
    }

    public void checkParent(Category parent, Category gotChildCategory) throws GlossaryAuthorFVTCheckedException {
        if (gotChildCategory.getParentCategory() != null) {
            String parentGuidFromChild;
            CategorySummary categorySummary = gotChildCategory.getParentCategory();
            String parentGuid = parent.getSystemAttributes().getGUID();
            if (!parentGuid.equals(parentGuidFromChild = categorySummary.getGuid())) {
                throw new GlossaryAuthorFVTCheckedException("ERROR parent category guid - " + parentGuid + " no equal parent guid " + parentGuidFromChild + " from child.");
            }
        } else {
            throw new GlossaryAuthorFVTCheckedException("ERROR parent category is null");
        }
    }
}

