/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.glossaryauthor.fvt;

import java.io.IOException;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.Config;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.viewservices.glossaryauthor.fvt.GlossaryAuthorFVTCheckedException;
import org.odpi.openmetadata.viewservices.glossaryauthor.fvt.RunAllFVTOn2Servers;
import org.odpi.openmetadata.viewservices.glossaryauthor.fvt.client.Configs.GlossaryAuthorViewConfigClient;
import org.odpi.openmetadata.viewservices.glossaryauthor.fvt.client.GlossaryAuthorViewRestClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigFVT {
    private String serverName = null;
    private String userId = null;
    private String url = null;
    private static final String BASE_URL = "/servers/%s/open-metadata/view-services/glossary-author/users/%s/configs";
    private static Logger log = LoggerFactory.getLogger(ConfigFVT.class);

    public static void main(String[] args) {
        try {
            String url = RunAllFVTOn2Servers.getUrl(args);
            ConfigFVT.runWith2Servers(url);
        }
        catch (IOException e1) {
            System.out.println("Error getting user input");
        }
        catch (GlossaryAuthorFVTCheckedException e) {
            log.error("ERROR: " + e.getMessage());
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            log.error("ERROR: " + e.getReportedErrorMessage() + " Suggested action: " + e.getReportedUserAction());
        }
    }

    public ConfigFVT(String url, String serverName, String userId) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (log.isDebugEnabled()) {
            log.debug("Config FVT");
        }
        this.url = url;
        this.userId = userId;
        this.serverName = serverName;
    }

    public static void runWith2Servers(String url) throws GlossaryAuthorFVTCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ConfigFVT.runIt(url, "cocoView1", "garygeeke");
        ConfigFVT.runIt(url, "cocoView2", "garygeeke");
    }

    public static synchronized void runIt(String url, String serverName, String userId) throws InvalidParameterException, GlossaryAuthorFVTCheckedException, PropertyServerException, UserNotAuthorizedException {
        try {
            System.out.println("ConfigFVT runIt started");
            ConfigFVT fvt = new ConfigFVT(url, serverName, userId);
            fvt.run();
            System.out.println("ConfigFVT runIt stopped");
        }
        catch (Exception error) {
            error.printStackTrace();
            throw error;
        }
    }

    public void run() throws GlossaryAuthorFVTCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        GlossaryAuthorViewRestClient glossaryAuthorViewRestClient = new GlossaryAuthorViewRestClient(this.serverName, this.url);
        GlossaryAuthorViewConfigClient glossaryAuthorViewConfigClient = new GlossaryAuthorViewConfigClient(glossaryAuthorViewRestClient);
        Config config = glossaryAuthorViewConfigClient.getConfig(this.userId);
        if (config.getMaxPageSize() != 1000) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected 1000 as the max page size got " + config.getMaxPageSize());
        }
        if (log.isDebugEnabled()) {
            log.debug("Config MaxPageSize is " + config.getMaxPageSize());
        }
        if (log.isDebugEnabled()) {
            log.debug(config.toString());
        }
    }
}

