/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.glossaryauthor.fvt.client.project;

import java.lang.reflect.Type;
import java.util.List;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.category.Category;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.FindRequest;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Relationship;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.project.Project;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.accessservices.subjectarea.utils.QueryBuilder;
import org.odpi.openmetadata.adminservices.configuration.properties.OMAGServerConfig;
import org.odpi.openmetadata.adminservices.configuration.properties.ViewServiceConfig;
import org.odpi.openmetadata.adminservices.rest.OMAGServerConfigResponse;
import org.odpi.openmetadata.adminservices.rest.ViewServiceConfigResponse;
import org.odpi.openmetadata.adminservices.rest.ViewServicesResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.GenericResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.ResponseParameterization;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.viewservices.glossaryauthor.fvt.client.GlossaryAuthorViewRestClient;
import org.odpi.openmetadata.viewservices.glossaryauthor.fvt.client.project.GlossaryAuthorViewProject;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.ResolvableType;

public class GlossaryAuthorViewProjectClient
implements GlossaryAuthorViewProject,
ResponseParameterization<Project> {
    protected final GlossaryAuthorViewRestClient client;
    private static final String BASE_URL = "/servers/%s/open-metadata/view-services/glossary-author/users/%s/projects";
    private static final String GLOSSARY_AUTHOR_CONFIG_BASE_URL = "/open-metadata/admin-services/users/%s/servers/%s/configuration";
    private static final String GLOSSARY_AUTHOR_C_BASE_URL = "/open-metadata/admin-services/users/%s/servers/%s/view-services/glossary-author";
    private static final String GLOSSARY_AUTHOR_VIEWCONFIG_BASE_URL = "/open-metadata/admin-services/users/%s/servers/%s/view-services/configuration";

    protected String getMethodInfo(String methodName) {
        return methodName + " for " + this.resultType().getSimpleName();
    }

    public GlossaryAuthorViewProjectClient(GlossaryAuthorViewRestClient client) {
        this.client = client;
    }

    @Override
    public Project create(String userId, Project project) throws PropertyServerException, InvalidParameterException, UserNotAuthorizedException {
        GenericResponse<Project> response = this.client.postRESTCall(userId, this.getMethodInfo("create"), BASE_URL, this.getParameterizedType(), project);
        return (Project)response.head().get();
    }

    @Override
    public Project update(String userId, String guid, Project project, boolean isReplace) throws PropertyServerException, InvalidParameterException, UserNotAuthorizedException {
        String urlTemplate = "/servers/%s/open-metadata/view-services/glossary-author/users/%s/projects/%s?isReplace=" + Boolean.toString(isReplace);
        String methodInfo = this.getMethodInfo("update(isReplace=" + isReplace + ")");
        GenericResponse<Project> response = this.client.putRESTCall(userId, guid, methodInfo, urlTemplate, this.getParameterizedType(), project);
        return (Project)response.head().get();
    }

    @Override
    public void delete(String userId, String guid) throws PropertyServerException {
        String methodName = this.getMethodInfo("Restore");
        ResolvableType resolvableType = ResolvableType.forClassWithGenerics(SubjectAreaOMASAPIResponse.class, (Class[])new Class[]{Category.class});
        ParameterizedTypeReference type = ParameterizedTypeReference.forType((Type)resolvableType.getType());
        String urlTemplate = BASE_URL;
        this.client.delRESTCall(userId, type, methodName, urlTemplate, guid);
    }

    @Override
    public Project restore(String userId, String guid) throws PropertyServerException, InvalidParameterException, UserNotAuthorizedException {
        String methodName = this.getMethodInfo("Restore");
        ResolvableType resolvableType = ResolvableType.forClassWithGenerics(SubjectAreaOMASAPIResponse.class, (Class[])new Class[]{Project.class});
        ParameterizedTypeReference type = ParameterizedTypeReference.forType((Type)resolvableType.getType());
        String urlTemplate = "/servers/%s/open-metadata/view-services/glossary-author/users/%s/projects/%s";
        GenericResponse<String> response = this.client.postRESTCall(userId, methodName, urlTemplate, type, guid);
        return (Project)response.head().get();
    }

    @Override
    public List<Category> getCategoryChildren(String userId, String parentGuid, FindRequest findRequest, boolean exactValue, boolean ignoreCase) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ResolvableType resolvableType = ResolvableType.forClassWithGenerics(SubjectAreaOMASAPIResponse.class, (Class[])new Class[]{Category.class});
        ParameterizedTypeReference type = ParameterizedTypeReference.forType((Type)resolvableType.getType());
        String urlTemplate = "/servers/%s/open-metadata/view-services/glossary-author/users/%s/projects/%s/categories";
        GenericResponse completeResponse = this.client.findRESTCallById(userId, this.getMethodInfo("getCategoryChildren"), urlTemplate, type, findRequest, exactValue, ignoreCase, null, parentGuid);
        return completeResponse.results();
    }

    @Override
    public List<Project> findAll(String userId) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.find(userId, new FindRequest(), false, true);
    }

    @Override
    public Project getByGUID(String userId, String guid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ResolvableType resolvableType = ResolvableType.forClassWithGenerics(SubjectAreaOMASAPIResponse.class, (Class[])new Class[]{Project.class});
        ParameterizedTypeReference type = ParameterizedTypeReference.forType((Type)resolvableType.getType());
        String urlTemplate = "/servers/%s/open-metadata/view-services/glossary-author/users/%s/projects/%s";
        GenericResponse response = this.client.getByGUIdRESTCall(userId, guid, this.getMethodInfo("getByGUID"), type, urlTemplate);
        return (Project)response.head().get();
    }

    @Override
    public List<Project> find(String userId, FindRequest findRequest, boolean exactValue, boolean ignoreCase) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ResolvableType resolvableType = ResolvableType.forClassWithGenerics(SubjectAreaOMASAPIResponse.class, (Class[])new Class[]{Project.class});
        ParameterizedTypeReference type = ParameterizedTypeReference.forType((Type)resolvableType.getType());
        GenericResponse completeResponse = this.client.findRESTCall(userId, this.getMethodInfo("find"), BASE_URL, type, findRequest, exactValue, ignoreCase, null);
        return completeResponse.results();
    }

    @Override
    public List<Category> getCategories(String userId, String projectGuid, FindRequest findRequest) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String urnTemplate = "/servers/%s/open-metadata/view-services/glossary-author/users/%s/projects/%s/categories";
        String methodInfo = this.getMethodInfo(" getCategories");
        QueryBuilder query = this.client.createFindQuery(methodInfo, findRequest);
        String urlTemplate = "/servers/%s/open-metadata/view-services/glossary-author/users/%s/projects/%s/categories" + query.toString();
        ResolvableType resolvableType = ResolvableType.forClassWithGenerics(SubjectAreaOMASAPIResponse.class, (Class[])new Class[]{Category.class});
        ParameterizedTypeReference type = ParameterizedTypeReference.forType((Type)resolvableType.getType());
        GenericResponse response = this.client.getByIdRESTCall(userId, projectGuid, methodInfo, type, urlTemplate);
        return response.results();
    }

    @Override
    public OMAGServerConfig getConfig(String userId) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        OMAGServerConfigResponse completeResponse = this.client.getConfigRESTCall(userId, "current", this.getMethodInfo("getConfig"), OMAGServerConfigResponse.class, GLOSSARY_AUTHOR_CONFIG_BASE_URL);
        return completeResponse.getOMAGServerConfig();
    }

    @Override
    public ViewServiceConfig getGlossaryAuthViewServiceConfig(String userId) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ViewServiceConfigResponse completeResponse = this.client.getViewServiceConfigRESTCall(userId, "current", this.getMethodInfo("getOmagServerName"), ViewServiceConfigResponse.class, GLOSSARY_AUTHOR_C_BASE_URL);
        return completeResponse.getConfig();
    }

    @Override
    public List<Relationship> getRelationships(String userId, String guid, FindRequest findRequest) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ResolvableType resolvableType = ResolvableType.forClassWithGenerics(SubjectAreaOMASAPIResponse.class, (Class[])new Class[]{Relationship.class});
        ParameterizedTypeReference type = ParameterizedTypeReference.forType((Type)resolvableType.getType());
        String urlTemplate = "/servers/%s/open-metadata/view-services/glossary-author/users/%s/projects/%s/relationships";
        GenericResponse completeResponse = this.client.findRESTCallById(userId, this.getMethodInfo("findRelationships"), urlTemplate, type, findRequest, false, true, 0, guid);
        return completeResponse.results();
    }

    @Override
    public List<ViewServiceConfig> getViewServiceConfigs(String userId) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ViewServicesResponse completeResponse = this.client.getViewConfigRESTCall(userId, this.getMethodInfo("getViewServiceConfig"), ViewServicesResponse.class, GLOSSARY_AUTHOR_VIEWCONFIG_BASE_URL);
        return completeResponse.getServices();
    }

    @Override
    public List<Relationship> getAllRelationships(String userId, String guid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.getRelationships(userId, guid, new FindRequest());
    }

    public Class<? extends GenericResponse> responseType() {
        return SubjectAreaOMASAPIResponse.class;
    }
}

