/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.glossaryauthor.fvt;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.odpi.openmetadata.accessservices.subjectarea.client.SubjectAreaNodeClient;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.category.Category;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.FindRequest;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Glossary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Node;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Relationship;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.nodesummary.CategorySummary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.nodesummary.GlossarySummary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.term.Term;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.viewservices.glossaryauthor.fvt.FVTUtils;
import org.odpi.openmetadata.viewservices.glossaryauthor.fvt.GlossaryAuthorFVTCheckedException;
import org.odpi.openmetadata.viewservices.glossaryauthor.fvt.GlossaryFVT;
import org.odpi.openmetadata.viewservices.glossaryauthor.fvt.RunAllFVTOn2Servers;
import org.odpi.openmetadata.viewservices.glossaryauthor.fvt.client.GlossaryAuthorViewRestClient;
import org.odpi.openmetadata.viewservices.glossaryauthor.fvt.client.category.GlossaryAuthorViewCategoryClient;

public class CategoryFVT {
    private static final String DEFAULT_TEST_GLOSSARY_NAME = "Test Glossary for category sample";
    private static final String DEFAULT_TEST_GLOSSARY_NAME2 = "Test Glossary for category sample 2";
    private static final String DEFAULT_TEST_CATEGORY_NAME = "Test category A";
    private static final String DEFAULT_TEST_CATEGORY_NAME_UPDATED = "Test category A updated";
    private static final String DEFAULT_TEST_CATEGORY_NAME2 = "Test category B";
    private static final String DEFAULT_TEST_CATEGORY_NAME3 = "Test category C";
    private static final String DEFAULT_TEST_CATEGORY_A_CHILD = "Test category A child";
    private SubjectAreaNodeClient<Category> subjectAreaCategory = null;
    private GlossaryAuthorViewCategoryClient glossaryAuthorViewCategoryClient = null;
    private GlossaryFVT glossaryFVT = null;
    private String serverName = null;
    private String userId = null;
    private int existingCategoryCount = 0;
    private Set<String> createdCategoriesSet = new HashSet<String>();

    public static void main(String[] args) {
        try {
            String url = RunAllFVTOn2Servers.getUrl(args);
            CategoryFVT.runWith2Servers(url);
        }
        catch (IOException e1) {
            System.out.println("Error getting user input");
        }
        catch (GlossaryAuthorFVTCheckedException e) {
            System.out.println("ERROR: " + e.getMessage());
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            e.printStackTrace();
        }
    }

    public static void runWith2Servers(String url) throws GlossaryAuthorFVTCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        CategoryFVT.runIt(url, "cocoView1", "garygeeke");
        CategoryFVT.runIt(url, "cocoView2", "garygeeke");
    }

    public CategoryFVT(String url, String serverName, String userId) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        GlossaryAuthorViewRestClient glossaryAuthorViewRestClient = new GlossaryAuthorViewRestClient(serverName, url);
        this.glossaryAuthorViewCategoryClient = new GlossaryAuthorViewCategoryClient(glossaryAuthorViewRestClient);
        this.glossaryFVT = new GlossaryFVT(url, serverName, userId);
        this.serverName = serverName;
        this.userId = userId;
        this.existingCategoryCount = this.findCategories("", false, false).size();
        System.out.println("existingCategoryCount " + this.existingCategoryCount);
    }

    public static void runIt(String url, String serverName, String userId) throws GlossaryAuthorFVTCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        try {
            System.out.println("CategoryFVT runIt started");
            CategoryFVT fvt = new CategoryFVT(url, serverName, userId);
            fvt.run();
            fvt.deleteRemaining();
            System.out.println("CategoryFVT runIt stopped");
        }
        catch (Exception error) {
            error.printStackTrace();
            throw error;
        }
    }

    public static int getCategoryCount(String url, String serverName, String userId) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException, GlossaryAuthorFVTCheckedException {
        CategoryFVT fvt = new CategoryFVT(url, serverName, userId);
        return fvt.findCategories("", false, false).size();
    }

    public void run() throws GlossaryAuthorFVTCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        System.out.println("Create a glossary");
        Glossary glossary = this.glossaryFVT.createGlossary(this.serverName + " Test Glossary for category sample");
        String glossaryGuid = glossary.getSystemAttributes().getGUID();
        System.out.println("Create a category1");
        Category category1 = this.createCategoryWithGlossaryGuid(this.serverName + " Test category A", glossary.getSystemAttributes().getGUID());
        System.out.println("Create a category2");
        Category category2 = this.createCategoryWithGlossaryGuid(this.serverName + " Test category B", glossary.getSystemAttributes().getGUID());
        FVTUtils.validateNode((Node)category1);
        FVTUtils.validateNode((Node)category2);
        FindRequest findRequest = new FindRequest();
        List<Category> results = this.glossaryFVT.getCategories(glossaryGuid, findRequest, true);
        if (results.size() != 2) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected 2 back on getGlossaryCategories onlyTop true" + results.size());
        }
        results = this.glossaryFVT.getCategories(glossaryGuid, findRequest, false);
        if (results.size() != 2) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected 2 back on getGlossaryCategories " + results.size());
        }
        findRequest.setPageSize(Integer.valueOf(1));
        results = this.glossaryFVT.getCategories(glossaryGuid, findRequest, false);
        if (results.size() != 1) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected 1 back on getGlossaryCategories with page size 1, got " + results.size());
        }
        Category categoryChild = this.createCategoryWithParentGlossary(DEFAULT_TEST_CATEGORY_A_CHILD, category1, glossaryGuid);
        FVTUtils.validateNode((Node)categoryChild);
        findRequest.setPageSize(null);
        results = this.glossaryFVT.getCategories(glossaryGuid, findRequest, true);
        if (results.size() != 2) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected 2 top categories back on getGlossaryCategories " + results.size());
        }
        results = this.glossaryFVT.getCategories(glossaryGuid, findRequest, false);
        if (results.size() != 3) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected all 3 categories  getGlossaryCategories " + results.size());
        }
        String category1Guid = category1.getSystemAttributes().getGUID();
        List<Category> children = this.getCategoryChildren(category1Guid);
        if (children.size() != 1) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected 1 Category as the child " + children.size());
        }
        this.deleteCategory(categoryChild.getSystemAttributes().getGUID());
        children = this.getCategoryChildren(category1Guid);
        if (children.size() != 0) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected 0 Categories as the child has been deleted " + children.size());
        }
        Category categoryForUpdate = new Category();
        categoryForUpdate.setName(this.serverName + " Test category A updated");
        System.out.println("Get the category1");
        String guid = category1Guid;
        Category gotCategory = this.getCategoryByGUID(guid);
        FVTUtils.validateNode((Node)gotCategory);
        System.out.println("Update the category1");
        Category updatedCategory = this.updateCategory(guid, categoryForUpdate);
        FVTUtils.validateNode((Node)updatedCategory);
        System.out.println("Get the category1 again");
        gotCategory = this.getCategoryByGUID(guid);
        FVTUtils.validateNode((Node)gotCategory);
        System.out.println("Delete the category1");
        this.deleteCategory(guid);
        System.out.println("Restore the category1");
        gotCategory = this.restoreCategory(guid);
        FVTUtils.validateNode((Node)gotCategory);
        System.out.println("Delete the category1");
        this.deleteCategory(guid);
        System.out.println("Create a category with a parent category");
        Category category3 = this.createCategoryWithParentGlossaryGuid(this.serverName + " Test category C", category2.getSystemAttributes().getGUID(), glossary.getSystemAttributes().getGUID());
        FVTUtils.validateNode((Node)category3);
        System.out.println("create categories to find");
        results = this.findCategories("zzz");
        if (results.size() != 0) {
            for (Category result : results) {
                System.err.println("pre result name " + result.getName());
                System.err.println("pre result guid " + result.getSystemAttributes().getGUID());
                if (result.getParentCategory() == null) continue;
                System.err.println("pre result parent cat name " + result.getParentCategory().getName());
            }
        }
        Category categoryForFind1 = this.getCategoryForInput("abc", glossaryGuid);
        categoryForFind1.setQualifiedName("iii");
        categoryForFind1 = this.issueCreateCategory(categoryForFind1);
        FVTUtils.validateNode((Node)categoryForFind1);
        Category categoryForFind2 = this.createCategory("iii", glossaryGuid);
        FVTUtils.validateNode((Node)categoryForFind2);
        Category categoryForFind3ForInput = this.getCategoryForInput("jjj", glossaryGuid);
        categoryForFind3ForInput.setDescription("This is a description for jjj");
        Category categoryForFind3 = this.issueCreateCategory(categoryForFind3ForInput);
        FVTUtils.validateNode((Node)categoryForFind3);
        Category categoryForFind4 = this.createCategory("This is a Category with spaces in name", glossaryGuid);
        FVTUtils.validateNode((Node)categoryForFind4);
        results = this.findCategories("jjj");
        if (results.size() != 1) {
            System.err.println("categoryForFind3 name " + categoryForFind3.getName());
            for (Category result : results) {
                System.err.println("result name " + result.getName());
                System.err.println("result desc " + result.getDescription());
                System.err.println("result guid " + result.getSystemAttributes().getGUID());
            }
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected 1 back on the find for jjj got " + results.size());
        }
        results = this.findCategories("iii");
        if (results.size() != 2) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected 2 back on the find got " + results.size());
        }
        results = this.findCategories(null);
        if (results.size() != 6 + this.existingCategoryCount) {
            for (Category result : results) {
                System.err.println("result name " + result.getName());
                System.err.println("result desc " + result.getDescription());
                System.err.println("result guid " + result.getSystemAttributes().getGUID());
            }
            throw new GlossaryAuthorFVTCheckedException("ERROR1: Expected 6 back on the find got " + results.size() + " 6 + existing=" + this.existingCategoryCount);
        }
        results = this.glossaryAuthorViewCategoryClient.findAll(this.userId);
        if (results.size() != 6 + this.existingCategoryCount) {
            for (Category result : results) {
                System.err.println("result name " + result.getName());
                System.err.println("result desc " + result.getDescription());
                System.err.println("result guid " + result.getSystemAttributes().getGUID());
            }
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected 6 back on the find got " + results.size());
        }
        this.deleteCategory(categoryForFind2.getSystemAttributes().getGUID());
        results = this.findCategories("iii");
        if (results.size() != 1) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected 1 back on the find for yyy got " + results.size());
        }
        results = this.findCategories("This is a Category with spaces in name");
        if (results.size() != 1) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected 1 back on the find for Category with spaces in name got " + results.size());
        }
        this.createCategory(DEFAULT_TEST_CATEGORY_NAME, glossaryGuid);
        Category categoryForUniqueQFN2 = this.createCategory(DEFAULT_TEST_CATEGORY_NAME, glossaryGuid);
        if (categoryForUniqueQFN2 == null || categoryForUniqueQFN2.getQualifiedName().length() == 0) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected qualified name to be set");
        }
        this.deleteCategory(categoryForFind1.getSystemAttributes().getGUID());
        this.deleteCategory(categoryForFind3.getSystemAttributes().getGUID());
        this.deleteCategory(categoryForFind4.getSystemAttributes().getGUID());
        this.deleteCategory(categoryForUniqueQFN2.getSystemAttributes().getGUID());
        this.testHierarchyWithSearchCriteria();
    }

    private void testHierarchyWithSearchCriteria() throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, GlossaryAuthorFVTCheckedException {
        System.out.println("Create a glossary");
        Glossary glossary = this.glossaryFVT.createGlossary(this.serverName + " Test Glossary for category sample 2");
        String glossaryGuid = glossary.getSystemAttributes().getGUID();
        System.out.println("Create a ttt");
        Category parentCategory = this.createCategoryWithGlossaryGuid("ttt", glossary.getSystemAttributes().getGUID());
        String parentGuid = parentCategory.getSystemAttributes().getGUID();
        HashSet<String> childGuids = new HashSet<String>();
        for (int i = 0; i < 3; ++i) {
            Category cat1 = this.createCategoryWithParentGlossaryGuid("mm" + i, parentGuid, glossaryGuid);
            childGuids.add(cat1.getSystemAttributes().getGUID());
            Category cat2 = this.createCategoryWithParentGlossaryGuid("nn" + i, parentGuid, glossaryGuid);
            childGuids.add(cat2.getSystemAttributes().getGUID());
            Category grandchild = this.createCategoryWithParentGlossaryGuid("mm" + i, cat1.getSystemAttributes().getGUID(), glossaryGuid);
            childGuids.add(grandchild.getSystemAttributes().getGUID());
        }
        if (this.getCategoryChildren(parentGuid).size() != 6) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected 6 child categories");
        }
        FindRequest findRequest = new FindRequest();
        findRequest.setSearchCriteria("mm1");
        int count = this.glossaryAuthorViewCategoryClient.getCategoryChildren(this.userId, parentGuid, findRequest, false, true).size();
        if (count != 1) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected 1 child category, got " + count);
        }
        count = this.glossaryFVT.getCategories(glossaryGuid, findRequest, false).size();
        if (count != 2) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected 2 glossary categories for mm3 including grandchild, got " + count);
        }
        findRequest = new FindRequest();
        count = this.glossaryFVT.getCategories(glossaryGuid, findRequest, true).size();
        if (count != 1) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected 1 glossary categories, got " + count);
        }
        findRequest.setSearchCriteria("tt");
        count = this.glossaryFVT.getCategories(glossaryGuid, findRequest, true).size();
        if (count != 1) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected 1 glossary categories for tt* not including grandchildren, got " + count);
        }
        findRequest = new FindRequest();
        findRequest.setSearchCriteria("mm1");
        count = this.glossaryFVT.getCategories(glossaryGuid, findRequest, true).size();
        if (count != 0) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected 0 glossary categories for mm3 not including grandchild, got " + count);
        }
        findRequest.setSearchCriteria("mm");
        count = this.glossaryAuthorViewCategoryClient.getCategoryChildren(this.userId, parentGuid, findRequest, false, true).size();
        if (count != 3) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected 3 child category, got " + count);
        }
        count = this.glossaryFVT.getCategories(glossaryGuid, findRequest, false).size();
        if (count != 6) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected 6 glossary categories for mm including grandchildren, got " + count);
        }
        for (int i = 3; i < 10; ++i) {
            Category cat1 = this.createCategoryWithParentGlossaryGuid("mm" + i, parentGuid, glossaryGuid);
            childGuids.add(cat1.getSystemAttributes().getGUID());
            Category cat2 = this.createCategoryWithParentGlossaryGuid("nn" + i, parentGuid, glossaryGuid);
            childGuids.add(cat2.getSystemAttributes().getGUID());
            Category grandchild = this.createCategoryWithParentGlossaryGuid("mm" + i, cat1.getSystemAttributes().getGUID(), glossaryGuid);
            childGuids.add(grandchild.getSystemAttributes().getGUID());
        }
        findRequest.setPageSize(Integer.valueOf(5));
        List<Category> categories = this.glossaryAuthorViewCategoryClient.getCategoryChildren(this.userId, parentGuid, findRequest, false, true);
        count = categories.size();
        if (count != 5) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected 5 child categories with mm, got " + count);
        }
        count = this.glossaryFVT.getCategories(glossaryGuid, findRequest, false).size();
        if (count != 5) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected 5 glossary categories for mm* including grandchildren, got " + count);
        }
        count = this.glossaryFVT.getCategories(glossaryGuid, findRequest, true).size();
        if (count != 0) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected 0 glossary categories for mm* not including grandchildren, got " + count);
        }
        findRequest.setStartingFrom(5);
        categories = this.glossaryAuthorViewCategoryClient.getCategoryChildren(this.userId, parentGuid, findRequest, false, true);
        count = categories.size();
        if (count != 5) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected 5 child categories with mm (findRequest.setStartingFrom(5)),got " + count);
        }
        count = this.glossaryFVT.getCategories(glossaryGuid, findRequest, false).size();
        if (count != 5) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected 5 glossary categories for mm* (findRequest.setStartingFrom(5) including grandchildren, got " + count);
        }
        count = this.glossaryFVT.getCategories(glossaryGuid, findRequest, true).size();
        if (count != 0) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected 0 glossary categories as startingFrom is higher than the number of elements " + count);
        }
        findRequest.setStartingFrom(0);
        findRequest.setSearchCriteria("nn");
        findRequest.setPageSize(Integer.valueOf(20));
        count = this.glossaryAuthorViewCategoryClient.getCategoryChildren(this.userId, parentGuid, findRequest, false, true).size();
        if (count != 10) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected 10 child categories for nn and got " + count);
        }
        count = this.glossaryFVT.getCategories(glossaryGuid, findRequest, false).size();
        if (count != 10) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected 10 glossary categories for nn* including grandchildren, got " + count);
        }
        count = this.glossaryFVT.getCategories(glossaryGuid, findRequest, true).size();
        if (count != 0) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected 0 glossary categories for nn* not including grandchildren, got " + count);
        }
        findRequest.setPageSize(Integer.valueOf(5));
        count = this.glossaryAuthorViewCategoryClient.getCategoryChildren(this.userId, parentGuid, findRequest, false, true).size();
        if (count != 5) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected 5 child categories for nn, got " + count);
        }
        count = this.glossaryFVT.getCategories(glossaryGuid, findRequest, false).size();
        if (count != 5) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected 5 glossary categories for nn including grandchildren, got " + count);
        }
        findRequest.setStartingFrom(5);
        count = this.glossaryAuthorViewCategoryClient.getCategoryChildren(this.userId, parentGuid, findRequest, false, true).size();
        if (count != 5) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected 5 child categories for nn, got " + count);
        }
        count = this.glossaryFVT.getCategories(glossaryGuid, findRequest, false).size();
        if (count != 5) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected 5 glossary categories for nn* including grandchildren, got " + count);
        }
        count = this.glossaryFVT.getCategories(glossaryGuid, findRequest, true).size();
        if (count != 0) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected 0 glossary categories for nn* not including grandchildren, got " + count);
        }
        findRequest.setStartingFrom(0);
        findRequest.setPageSize(Integer.valueOf(10));
        count = this.glossaryAuthorViewCategoryClient.getCategoryChildren(this.userId, parentGuid, findRequest, false, true).size();
        if (count != 10) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected 10 child categories for nn*, got " + count);
        }
        count = this.glossaryFVT.getCategories(glossaryGuid, findRequest, false).size();
        if (count != 10) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected 10 glossary categories for nn* including grandchildren, got " + count);
        }
        count = this.glossaryFVT.getCategories(glossaryGuid, findRequest, true).size();
        if (count != 0) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected 0 glossary categories for nn* not including grandchildren, got " + count);
        }
        for (String childGuid : childGuids) {
            this.deleteCategory(childGuid);
        }
        this.deleteCategory(parentGuid);
        this.glossaryFVT.deleteGlossary(glossaryGuid);
    }

    private Category createCategoryWithParentGlossaryGuid(String categoryName, String parentGuid, String glossaryGuid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, GlossaryAuthorFVTCheckedException {
        Category category = new Category();
        category.setName(categoryName);
        GlossarySummary GlossarySummary2 = new GlossarySummary();
        GlossarySummary2.setGuid(glossaryGuid);
        category.setGlossary(GlossarySummary2);
        CategorySummary parentCategory = new CategorySummary();
        parentCategory.setGuid(parentGuid);
        category.setParentCategory(parentCategory);
        Category newCategory = this.issueCreateCategory(category);
        FVTUtils.validateNode((Node)newCategory);
        System.out.println("Created Category " + newCategory.getName() + " with glossaryGuid " + newCategory.getSystemAttributes().getGUID());
        return newCategory;
    }

    public Category createCategoryWithGlossaryGuid(String categoryName, String glossaryGuid) throws GlossaryAuthorFVTCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Category category = new Category();
        category.setName(categoryName);
        GlossarySummary GlossarySummary2 = new GlossarySummary();
        GlossarySummary2.setGuid(glossaryGuid);
        category.setGlossary(GlossarySummary2);
        Category newCategory = this.issueCreateCategory(category);
        FVTUtils.validateNode((Node)newCategory);
        System.out.println("Created Category " + newCategory.getName() + " with userId " + newCategory.getSystemAttributes().getGUID());
        return newCategory;
    }

    Category createCategoryWithParentGlossary(String categoryName, Category parent, String glossaryGuid) throws GlossaryAuthorFVTCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Category category = new Category();
        category.setName(categoryName);
        GlossarySummary GlossarySummary2 = new GlossarySummary();
        GlossarySummary2.setGuid(glossaryGuid);
        category.setGlossary(GlossarySummary2);
        CategorySummary parentCategorySummary = new CategorySummary();
        parentCategorySummary.setGuid(parent.getSystemAttributes().getGUID());
        category.setParentCategory(parentCategorySummary);
        Category newCategory = this.issueCreateCategory(category);
        FVTUtils.validateNode((Node)newCategory);
        System.out.println("Created Category " + newCategory.getName() + " with guid " + newCategory.getSystemAttributes().getGUID());
        return newCategory;
    }

    public Category createCategory(String categoryName, String glossaryGuid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Category category = this.getCategoryForInput(categoryName, glossaryGuid);
        return this.issueCreateCategory(category);
    }

    private Category issueCreateCategory(Category category) throws PropertyServerException, UserNotAuthorizedException, InvalidParameterException {
        Category newCategory = this.glossaryAuthorViewCategoryClient.create(this.userId, category);
        if (newCategory != null) {
            this.createdCategoriesSet.add(newCategory.getSystemAttributes().getGUID());
            System.out.println("Created Category " + newCategory.getName() + " with userId " + newCategory.getSystemAttributes().getGUID());
        }
        return newCategory;
    }

    private Category getCategoryForInput(String categoryName, String glossaryGuid) {
        Category category = new Category();
        category.setName(categoryName);
        GlossarySummary GlossarySummary2 = new GlossarySummary();
        GlossarySummary2.setGuid(glossaryGuid);
        category.setGlossary(GlossarySummary2);
        return category;
    }

    public Category getCategoryByGUID(String guid) throws GlossaryAuthorFVTCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Category category = this.glossaryAuthorViewCategoryClient.getByGUID(this.userId, guid);
        FVTUtils.validateNode((Node)category);
        System.out.println("Got Category " + category.getName() + " with userId " + category.getSystemAttributes().getGUID() + " and status " + category.getSystemAttributes().getStatus());
        return category;
    }

    public List<Category> findCategories(String criteria) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        FindRequest findRequest = new FindRequest();
        findRequest.setSearchCriteria(criteria);
        return this.glossaryAuthorViewCategoryClient.find(this.userId, findRequest, false, true);
    }

    public List<Category> findCategories(String criteria, boolean exactValue, boolean ignoreCase) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        FindRequest findRequest = new FindRequest();
        findRequest.setSearchCriteria(criteria);
        List<Category> categoryList = this.glossaryAuthorViewCategoryClient.find(this.userId, findRequest, exactValue, ignoreCase);
        return categoryList;
    }

    public Category updateCategory(String guid, Category category) throws GlossaryAuthorFVTCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Category updatedCategory = this.glossaryAuthorViewCategoryClient.update(this.userId, guid, category, true);
        FVTUtils.validateNode((Node)updatedCategory);
        System.out.println("Updated Category name to " + updatedCategory.getName());
        return updatedCategory;
    }

    public void deleteCategory(String guid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.glossaryAuthorViewCategoryClient.delete(this.userId, guid);
        this.createdCategoriesSet.remove(guid);
        System.out.println("Deleted Category succeeded");
    }

    public Category restoreCategory(String guid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, GlossaryAuthorFVTCheckedException {
        Category restoredCategory = this.glossaryAuthorViewCategoryClient.restore(this.userId, guid);
        FVTUtils.validateNode((Node)restoredCategory);
        this.createdCategoriesSet.add(guid);
        System.out.println("restored Category name is " + restoredCategory.getName());
        return restoredCategory;
    }

    public List<Relationship> getCategoryRelationships(Category category) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.glossaryAuthorViewCategoryClient.getAllRelationships(this.userId, category.getSystemAttributes().getGUID());
    }

    private void deleteRemaining() throws UserNotAuthorizedException, PropertyServerException, InvalidParameterException, GlossaryAuthorFVTCheckedException {
        this.deleteRemainingCategories();
        this.glossaryFVT.deleteRemainingGlossaries();
    }

    void deleteRemainingCategories() throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, GlossaryAuthorFVTCheckedException {
        Iterator<String> iter = this.createdCategoriesSet.iterator();
        while (iter.hasNext()) {
            String guid = iter.next();
            iter.remove();
            this.deleteCategory(guid);
        }
        List<Category> categories = this.findCategories("");
        if (categories.size() != this.existingCategoryCount) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected " + this.existingCategoryCount + " Categories to be found, got " + categories.size());
        }
    }

    public List<Category> getCategoryChildren(String categoryGuid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.glossaryAuthorViewCategoryClient.getCategoryChildren(this.userId, categoryGuid, new FindRequest(), false, true);
    }

    public List<Term> getTerms(String categoryGuid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.glossaryAuthorViewCategoryClient.getTerms(this.userId, categoryGuid, new FindRequest());
    }

    public List<Term> getTerms(String categoryGuid, FindRequest findRequest) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.glossaryAuthorViewCategoryClient.getTerms(this.userId, categoryGuid, findRequest);
    }
}

