/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.glossaryauthor.fvt;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Glossary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Relationship;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.nodesummary.GlossarySummary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.term.Term;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.HasA;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.IsA;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.PreferredTerm;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.RelatedTerm;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Synonym;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.TermAnchor;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.Translation;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.viewservices.glossaryauthor.fvt.GlossaryAuthorFVTCheckedException;
import org.odpi.openmetadata.viewservices.glossaryauthor.fvt.RunAllFVTOn2Servers;
import org.odpi.openmetadata.viewservices.glossaryauthor.fvt.client.GlossaryAuthorViewRestClient;
import org.odpi.openmetadata.viewservices.glossaryauthor.fvt.client.glossarys.GlossaryAuthorViewGlossaryClient;
import org.odpi.openmetadata.viewservices.glossaryauthor.fvt.client.relationships.GlossaryAuthorViewRelationshipsClient;
import org.odpi.openmetadata.viewservices.glossaryauthor.fvt.client.term.GlossaryAuthorViewTermClient;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.ResolvableType;

public class CheckSerializationFVT {
    private final String userId;
    private final GlossaryAuthorViewRelationshipsClient glossaryAuthorViewRelationship;
    private final GlossaryAuthorViewTermClient glossaryAuthorViewTerm;
    private final GlossaryAuthorViewGlossaryClient glossaryAuthorViewGlossary;
    private static final String HAS_A = "has-as";
    private static final String RELATED_TERM = "related-terms";
    private static final String SYNONYM = "synonyms";
    private static final String ANTONYM = "antonyms";
    private static final String TRANSLATION = "translations";
    private static final String USED_IN_CONTEXT = "used-in-contexts";
    private static final String PREFERRED_TERM = "preferred-terms";
    private static final String VALID_VALUE = "valid-values";
    private static final String REPLACEMENT_TERM = "replacement-terms";
    private static final String TYPED_BY = "typed-bys";
    private static final String IS_A = "is-as";
    private static final String IS_A_TYPE_OF_DEPRECATED = "is-a-type-of-deprecateds";
    private static final String IS_A_TYPE_OF = "is-a-type-ofs";
    private static final String TERM_CATEGORIZATION = "term-categorizations";
    private static final String SEMANTIC_ASSIGNMENT = "semantic-assignments";
    private static final String TERM_ANCHOR = "term-anchor";
    private static final String CATEGORY_ANCHOR = "category-anchor";
    private static final String PROJECT_SCOPE = "project-scopes";
    private static final String CATEGORY_HIERARCHY_LINK = "category-hierarchy-links";

    public CheckSerializationFVT(String url, String serverName, String userId) throws InvalidParameterException {
        this.userId = userId;
        GlossaryAuthorViewRestClient client = new GlossaryAuthorViewRestClient(serverName, url);
        this.glossaryAuthorViewTerm = new GlossaryAuthorViewTermClient(client);
        this.glossaryAuthorViewGlossary = new GlossaryAuthorViewGlossaryClient(client);
        this.glossaryAuthorViewRelationship = new GlossaryAuthorViewRelationshipsClient(client);
    }

    public static void main(String[] args) {
        try {
            String url = RunAllFVTOn2Servers.getUrl(args);
            CheckSerializationFVT.runWith2Servers(url);
        }
        catch (IOException e1) {
            System.out.println("Error getting user input");
        }
        catch (GlossaryAuthorFVTCheckedException e) {
            System.out.println("ERROR: " + e.getMessage());
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            System.out.println("ERROR: " + e.getReportedErrorMessage() + " Suggested action: " + e.getReportedUserAction());
        }
    }

    public static void runWith2Servers(String url) throws GlossaryAuthorFVTCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        CheckSerializationFVT.runIt(url, "cocoView1", "garygeeke");
        CheckSerializationFVT.runIt(url, "cocoView2", "garygeeke");
    }

    public static void runIt(String url, String serverName, String userId) throws InvalidParameterException, GlossaryAuthorFVTCheckedException, PropertyServerException, UserNotAuthorizedException {
        try {
            System.out.println("CheckSerializationFVT runIt started");
            CheckSerializationFVT fvt = new CheckSerializationFVT(url, serverName, userId);
            fvt.run();
            System.out.println("CheckSerializationFVT runIt stopped");
        }
        catch (Exception error) {
            error.printStackTrace();
            throw error;
        }
    }

    private void run() throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, GlossaryAuthorFVTCheckedException {
        Glossary glossary = new Glossary();
        glossary.setName("Test");
        Glossary gotGlossary = this.glossaryAuthorViewGlossary.create(this.userId, glossary);
        GlossarySummary glossarySummary = new GlossarySummary();
        glossarySummary.setGuid(gotGlossary.getSystemAttributes().getGUID());
        Term termOne = new Term();
        termOne.setName("Test_term_a");
        termOne.setGlossary(glossarySummary);
        Term termTwo = new Term();
        termTwo.setName("Test_term_b");
        termTwo.setGlossary(glossarySummary);
        Term gotTermOne = this.glossaryAuthorViewTerm.create(this.userId, termOne);
        Term gotTermTwo = this.glossaryAuthorViewTerm.create(this.userId, termTwo);
        String oneTermGuid = gotTermOne.getSystemAttributes().getGUID();
        String twoTermGuid = gotTermTwo.getSystemAttributes().getGUID();
        this.checkChildrenSerialization(oneTermGuid, twoTermGuid);
        this.glossaryAuthorViewTerm.delete(this.userId, oneTermGuid);
        this.glossaryAuthorViewTerm.delete(this.userId, twoTermGuid);
        this.glossaryAuthorViewGlossary.delete(this.userId, gotGlossary.getSystemAttributes().getGUID());
    }

    public void checkChildrenSerialization(String oneTermGuid, String twoTermGuid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, GlossaryAuthorFVTCheckedException {
        List<Relationship> termAnchors = this.glossaryAuthorViewTerm.getAllRelationships(this.userId, oneTermGuid);
        this.checkCastChild(termAnchors.get(0), TermAnchor.class);
        System.out.println("TermAnchor is ok.");
        this.createHasA(oneTermGuid, twoTermGuid);
        List<Relationship> hasAList = this.glossaryAuthorViewTerm.getAllRelationships(this.userId, oneTermGuid);
        hasAList.removeIf(line -> line instanceof TermAnchor);
        HasA hasA = this.checkCastChild(hasAList.get(0), HasA.class);
        ResolvableType resolvableType = ResolvableType.forClassWithGenerics(SubjectAreaOMASAPIResponse.class, (Class[])new Class[]{HasA.class});
        ParameterizedTypeReference type = ParameterizedTypeReference.forType((Type)resolvableType.getType());
        this.glossaryAuthorViewRelationship.deleteRel(this.userId, hasA.getGuid(), type, HAS_A);
        System.out.println("HasA is ok.");
        this.createIsA(oneTermGuid, twoTermGuid);
        List<Relationship> isAList = this.glossaryAuthorViewTerm.getAllRelationships(this.userId, oneTermGuid);
        isAList.removeIf(line -> line instanceof TermAnchor);
        IsA isA = this.checkCastChild(isAList.get(0), IsA.class);
        resolvableType = ResolvableType.forClassWithGenerics(SubjectAreaOMASAPIResponse.class, (Class[])new Class[]{IsA.class});
        ParameterizedTypeReference typeIsA = ParameterizedTypeReference.forType((Type)resolvableType.getType());
        this.glossaryAuthorViewRelationship.deleteRel(this.userId, isA.getGuid(), typeIsA, IS_A);
        System.out.println("IsA is ok.");
        this.createRelatedTerm(oneTermGuid, twoTermGuid);
        List<Relationship> relatedTerms = this.glossaryAuthorViewTerm.getAllRelationships(this.userId, oneTermGuid);
        relatedTerms.removeIf(line -> line instanceof TermAnchor);
        RelatedTerm relatedTerm = this.checkCastChild(relatedTerms.get(0), RelatedTerm.class);
        resolvableType = ResolvableType.forClassWithGenerics(SubjectAreaOMASAPIResponse.class, (Class[])new Class[]{RelatedTerm.class});
        ParameterizedTypeReference typeRT = ParameterizedTypeReference.forType((Type)resolvableType.getType());
        this.glossaryAuthorViewRelationship.deleteRel(this.userId, relatedTerm.getGuid(), typeRT, RELATED_TERM);
        System.out.println("RelatedTerm is ok.");
        this.createTranslation(oneTermGuid, twoTermGuid);
        List<Relationship> translations = this.glossaryAuthorViewTerm.getAllRelationships(this.userId, oneTermGuid);
        translations.removeIf(line -> line instanceof TermAnchor);
        Translation translation = this.checkCastChild(translations.get(0), Translation.class);
        resolvableType = ResolvableType.forClassWithGenerics(SubjectAreaOMASAPIResponse.class, (Class[])new Class[]{Translation.class});
        ParameterizedTypeReference typeT = ParameterizedTypeReference.forType((Type)resolvableType.getType());
        this.glossaryAuthorViewRelationship.deleteRel(this.userId, translation.getGuid(), typeT, TRANSLATION);
        System.out.println("Translation is ok.");
        this.createPreferredTerm(oneTermGuid, twoTermGuid);
        List<Relationship> preferredTerms = this.glossaryAuthorViewTerm.getAllRelationships(this.userId, oneTermGuid);
        preferredTerms.removeIf(line -> line instanceof TermAnchor);
        PreferredTerm preferredTerm = this.checkCastChild(preferredTerms.get(0), PreferredTerm.class);
        resolvableType = ResolvableType.forClassWithGenerics(SubjectAreaOMASAPIResponse.class, (Class[])new Class[]{PreferredTerm.class});
        ParameterizedTypeReference typePT = ParameterizedTypeReference.forType((Type)resolvableType.getType());
        this.glossaryAuthorViewRelationship.deleteRel(this.userId, preferredTerm.getGuid(), typePT, PREFERRED_TERM);
        System.out.println("PreferredTerm is ok.");
        this.createSynonym(oneTermGuid, twoTermGuid);
        List<Relationship> synonyms = this.glossaryAuthorViewTerm.getAllRelationships(this.userId, oneTermGuid);
        synonyms.removeIf(line -> line instanceof TermAnchor);
        Synonym synonym = this.checkCastChild(synonyms.get(0), Synonym.class);
        resolvableType = ResolvableType.forClassWithGenerics(SubjectAreaOMASAPIResponse.class, (Class[])new Class[]{Synonym.class});
        ParameterizedTypeReference typeS = ParameterizedTypeReference.forType((Type)resolvableType.getType());
        this.glossaryAuthorViewRelationship.deleteRel(this.userId, synonym.getGuid(), typeS, SYNONYM);
        System.out.println("Synonym is ok.");
    }

    private <L extends Relationship, ForCast extends Relationship> ForCast checkCastChild(L line, Class<ForCast> lClass) throws GlossaryAuthorFVTCheckedException {
        try {
            return (ForCast)line;
        }
        catch (ClassCastException e) {
            throw new GlossaryAuthorFVTCheckedException("The class " + lClass.getSimpleName() + "was deserialized incorrectly, so it cannot be cast");
        }
    }

    private void createHasA(String oneTermGuid, String twoTermGuid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        HasA hasA = new HasA();
        hasA.getEnd1().setNodeGuid(oneTermGuid);
        hasA.getEnd2().setNodeGuid(twoTermGuid);
        ResolvableType resolvableType = ResolvableType.forClassWithGenerics(SubjectAreaOMASAPIResponse.class, (Class[])new Class[]{HasA.class});
        ParameterizedTypeReference type = ParameterizedTypeReference.forType((Type)resolvableType.getType());
        this.glossaryAuthorViewRelationship.createRel(this.userId, hasA, type, HAS_A);
    }

    private void createIsA(String oneTermGuid, String twoTermGuid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        IsA isA = new IsA();
        isA.getEnd1().setNodeGuid(oneTermGuid);
        isA.getEnd2().setNodeGuid(twoTermGuid);
        ResolvableType resolvableType = ResolvableType.forClassWithGenerics(SubjectAreaOMASAPIResponse.class, (Class[])new Class[]{IsA.class});
        ParameterizedTypeReference type = ParameterizedTypeReference.forType((Type)resolvableType.getType());
        this.glossaryAuthorViewRelationship.createRel(this.userId, isA, type, IS_A);
    }

    private void createRelatedTerm(String oneTermGuid, String twoTermGuid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        RelatedTerm relatedTerm = new RelatedTerm();
        relatedTerm.getEnd1().setNodeGuid(oneTermGuid);
        relatedTerm.getEnd2().setNodeGuid(twoTermGuid);
        ResolvableType resolvableType = ResolvableType.forClassWithGenerics(SubjectAreaOMASAPIResponse.class, (Class[])new Class[]{RelatedTerm.class});
        ParameterizedTypeReference type = ParameterizedTypeReference.forType((Type)resolvableType.getType());
        this.glossaryAuthorViewRelationship.createRel(this.userId, relatedTerm, type, RELATED_TERM);
    }

    private void createTranslation(String oneTermGuid, String twoTermGuid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Translation translation = new Translation();
        translation.getEnd1().setNodeGuid(oneTermGuid);
        translation.getEnd2().setNodeGuid(twoTermGuid);
        ResolvableType resolvableType = ResolvableType.forClassWithGenerics(SubjectAreaOMASAPIResponse.class, (Class[])new Class[]{Translation.class});
        ParameterizedTypeReference type = ParameterizedTypeReference.forType((Type)resolvableType.getType());
        this.glossaryAuthorViewRelationship.createRel(this.userId, translation, type, TRANSLATION);
    }

    private void createPreferredTerm(String oneTermGuid, String twoTermGuid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        PreferredTerm preferredTerm = new PreferredTerm();
        preferredTerm.getEnd1().setNodeGuid(oneTermGuid);
        preferredTerm.getEnd2().setNodeGuid(twoTermGuid);
        ResolvableType resolvableType = ResolvableType.forClassWithGenerics(SubjectAreaOMASAPIResponse.class, (Class[])new Class[]{PreferredTerm.class});
        ParameterizedTypeReference type = ParameterizedTypeReference.forType((Type)resolvableType.getType());
        this.glossaryAuthorViewRelationship.createRel(this.userId, preferredTerm, type, PREFERRED_TERM);
    }

    private void createSynonym(String oneTermGuid, String twoTermGuid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Synonym synonym = new Synonym();
        synonym.getEnd1().setNodeGuid(oneTermGuid);
        synonym.getEnd2().setNodeGuid(twoTermGuid);
        ResolvableType resolvableType = ResolvableType.forClassWithGenerics(SubjectAreaOMASAPIResponse.class, (Class[])new Class[]{Synonym.class});
        ParameterizedTypeReference type = ParameterizedTypeReference.forType((Type)resolvableType.getType());
        this.glossaryAuthorViewRelationship.createRel(this.userId, synonym, type, SYNONYM);
    }
}

