/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.glossaryauthor.fvt;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.odpi.openmetadata.accessservices.subjectarea.client.SubjectAreaNodeClient;
import org.odpi.openmetadata.accessservices.subjectarea.client.SubjectAreaRestClient;
import org.odpi.openmetadata.accessservices.subjectarea.client.nodes.categories.SubjectAreaCategoryClient;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.category.SubjectAreaDefinition;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.FindRequest;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Glossary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Node;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.nodesummary.CategorySummary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.nodesummary.GlossarySummary;
import org.odpi.openmetadata.adminservices.configuration.properties.ViewServiceConfig;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.viewservices.glossaryauthor.fvt.FVTUtils;
import org.odpi.openmetadata.viewservices.glossaryauthor.fvt.GlossaryAuthorFVTCheckedException;
import org.odpi.openmetadata.viewservices.glossaryauthor.fvt.GlossaryFVT;
import org.odpi.openmetadata.viewservices.glossaryauthor.fvt.RunAllFVTOn2Servers;
import org.odpi.openmetadata.viewservices.glossaryauthor.fvt.client.GlossaryAuthorViewRestClient;
import org.odpi.openmetadata.viewservices.glossaryauthor.fvt.client.graph.GlossaryAuthorViewGraphClient;

public class SubjectAreaDefinitionCategoryFVT {
    private static final String DEFAULT_TEST_GLOSSARY_NAME = "Test Glossary for subject area definition sample";
    private static final String DEFAULT_TEST_CATEGORY_NAME = "Test subject area definition A";
    private static final String DEFAULT_TEST_CATEGORY_NAME_UPDATED = "Test subject area definition A updated";
    private static final String DEFAULT_TEST_CATEGORY_NAME2 = "Test subject area definition B";
    private static final String DEFAULT_TEST_CATEGORY_NAME3 = "Test subject area definition C";
    private static SubjectAreaNodeClient<SubjectAreaDefinition> subjectAreaCategory = null;
    private GlossaryFVT glossaryFVT = null;
    private String userId = null;
    private int existingSubjectAreaCount = 0;
    private static GlossaryAuthorViewRestClient glossaryAuthorViewRestClient = null;
    private static GlossaryAuthorViewGraphClient glossaryAuthorViewGraphClient = null;
    private Set<String> createdSubjectAreasSet = new HashSet<String>();

    public static void main(String[] args) {
        try {
            String url = RunAllFVTOn2Servers.getUrl(args);
            SubjectAreaDefinitionCategoryFVT.runWith2Servers(url);
        }
        catch (IOException e1) {
            System.out.println("Error getting user input");
        }
        catch (GlossaryAuthorFVTCheckedException e) {
            System.out.println("ERROR: " + e.getMessage());
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            System.out.println("ERROR: " + e.getReportedErrorMessage() + " Suggested action: " + e.getReportedUserAction());
        }
    }

    public static void runWith2Servers(String url) throws GlossaryAuthorFVTCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        SubjectAreaDefinitionCategoryFVT.runIt(url, "cocoView1", "garygeeke");
        SubjectAreaDefinitionCategoryFVT.runIt(url, "cocoView2", "garygeeke");
    }

    public SubjectAreaDefinitionCategoryFVT(String url, String serverName, String userId) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.glossaryFVT = new GlossaryFVT(url, serverName, userId);
        glossaryAuthorViewRestClient = new GlossaryAuthorViewRestClient(serverName, url);
        glossaryAuthorViewGraphClient = new GlossaryAuthorViewGraphClient(glossaryAuthorViewRestClient);
        String omagServer = this.retrieveOmagServerName("Glossary Author");
        SubjectAreaRestClient client = new SubjectAreaRestClient(omagServer, url);
        subjectAreaCategory = new SubjectAreaCategoryClient(client);
        this.userId = userId;
        this.existingSubjectAreaCount = this.findSubjectAreaDefinitions("").size();
        System.out.println("existingSubjectAreaCount " + this.existingSubjectAreaCount);
    }

    public SubjectAreaDefinitionCategoryFVT(String url, String serverName, String omagServerName, String userId) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        SubjectAreaRestClient client = new SubjectAreaRestClient(omagServerName, url);
        subjectAreaCategory = new SubjectAreaCategoryClient(client);
        this.glossaryFVT = new GlossaryFVT(url, serverName, userId);
        this.userId = userId;
        this.existingSubjectAreaCount = this.findSubjectAreaDefinitions("").size();
        System.out.println("existingSubjectAreaCount " + this.existingSubjectAreaCount);
    }

    private String retrieveOmagServerName(String viewServiceName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, PropertyServerException, UserNotAuthorizedException {
        List<ViewServiceConfig> viewServiceConfigs = glossaryAuthorViewGraphClient.getViewServiceConfigs(this.userId);
        for (ViewServiceConfig vsc : viewServiceConfigs) {
            if (!vsc.getViewServiceName().equals(viewServiceName)) continue;
            System.out.println("OMAG Server URL " + String.valueOf(vsc.getOMAGServerPlatformRootURL()));
            return String.valueOf(vsc.getOMAGServerName());
        }
        return null;
    }

    public static void runIt(String url, String serverName, String userId) throws GlossaryAuthorFVTCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        try {
            System.out.println("SubjectAreaDefinitionCategoryFVT runIt started");
            SubjectAreaDefinitionCategoryFVT fvt = new SubjectAreaDefinitionCategoryFVT(url, serverName, userId);
            fvt.run();
            fvt.deleteRemaining();
            System.out.println("SubjectAreaDefinitionCategoryFVT runIt stopped");
        }
        catch (Exception error) {
            error.printStackTrace();
            throw error;
        }
    }

    public static int getSubjectAreaCount(String url, String serverName, String userId) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException, GlossaryAuthorFVTCheckedException {
        SubjectAreaDefinitionCategoryFVT fvt = new SubjectAreaDefinitionCategoryFVT(url, serverName, userId);
        return fvt.findSubjectAreaDefinitions("").size();
    }

    public void run() throws GlossaryAuthorFVTCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        System.out.println("Create a glossary");
        Glossary glossary = this.glossaryFVT.createGlossary(DEFAULT_TEST_GLOSSARY_NAME);
        FVTUtils.validateNode((Node)glossary);
        System.out.println("Create a subjectArea1");
        SubjectAreaDefinition subjectArea1 = this.createSubjectAreaDefinitionWithGlossaryGuid(DEFAULT_TEST_CATEGORY_NAME, glossary.getSystemAttributes().getGUID());
        FVTUtils.validateNode((Node)subjectArea1);
        System.out.println("Create a subjectArea2");
        SubjectAreaDefinition subjectArea2 = this.createSubjectAreaDefinitionWithGlossaryGuid(DEFAULT_TEST_CATEGORY_NAME2, glossary.getSystemAttributes().getGUID());
        FVTUtils.validateNode((Node)subjectArea2);
        SubjectAreaDefinition subjectAreaForUpdate = new SubjectAreaDefinition();
        subjectAreaForUpdate.setName(DEFAULT_TEST_CATEGORY_NAME_UPDATED);
        if (subjectArea1 != null) {
            System.out.println("Get the subjectArea1 ");
            String guid = subjectArea1.getSystemAttributes().getGUID();
            SubjectAreaDefinition gotSubjectAreaDefinition = this.getSubjectAreaDefinitionByGUID(guid);
            System.out.println("Update the subjectArea1 ");
            SubjectAreaDefinition updatedSubjectAreaDefinition = this.updateSubjectAreaDefinition(guid, subjectAreaForUpdate);
            FVTUtils.validateNode((Node)updatedSubjectAreaDefinition);
            System.out.println("Get the subjectArea1  again");
            gotSubjectAreaDefinition = this.getSubjectAreaDefinitionByGUID(guid);
            FVTUtils.validateNode((Node)gotSubjectAreaDefinition);
            System.out.println("Delete the subjectArea1 ");
            this.deleteSubjectAreaDefinition(guid);
            System.out.println("restore the subjectArea1 ");
            gotSubjectAreaDefinition = this.restoreSubjectAreaDefinition(guid);
            FVTUtils.validateNode((Node)gotSubjectAreaDefinition);
            System.out.println("Delete the subjectArea1 ");
            this.deleteSubjectAreaDefinition(guid);
            System.out.println("Purge a subjectArea1 ");
            System.out.println("Create a subjectArea with a parent subjectArea");
            System.out.println("Create a category with a parent category");
            SubjectAreaDefinition subjectAreaDefinition3 = this.createSubjectAreaDefinitionWithParentGlossaryGuid(DEFAULT_TEST_CATEGORY_NAME3, subjectArea2.getSystemAttributes().getGUID(), glossary.getSystemAttributes().getGUID());
            FVTUtils.validateNode((Node)subjectAreaDefinition3);
        }
    }

    private SubjectAreaDefinition createSubjectAreaDefinitionWithParentGlossaryGuid(String subjectAreaName, String parentGuid, String glossaryGuid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        SubjectAreaDefinition subjectArea = new SubjectAreaDefinition();
        subjectArea.setName(subjectAreaName);
        GlossarySummary glossarySummary = new GlossarySummary();
        glossarySummary.setGuid(glossaryGuid);
        subjectArea.setGlossary(glossarySummary);
        CategorySummary parentCategory = new CategorySummary();
        parentCategory.setGuid(parentGuid);
        subjectArea.setParentCategory(parentCategory);
        SubjectAreaDefinition newSubjectAreaDefinition = (SubjectAreaDefinition)subjectAreaCategory.create(this.userId, (Object)subjectArea);
        if (newSubjectAreaDefinition != null) {
            this.createdSubjectAreasSet.add(newSubjectAreaDefinition.getSystemAttributes().getGUID());
            System.out.println("Created SubjectAreaDefinition " + newSubjectAreaDefinition.getName() + " with glossaryGuid " + newSubjectAreaDefinition.getSystemAttributes().getGUID());
        }
        return newSubjectAreaDefinition;
    }

    public SubjectAreaDefinition createSubjectAreaDefinitionWithGlossaryGuid(String subjectAreaName, String glossaryGuid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        SubjectAreaDefinition subjectArea = new SubjectAreaDefinition();
        subjectArea.setName(subjectAreaName);
        GlossarySummary glossarySummary = new GlossarySummary();
        glossarySummary.setGuid(glossaryGuid);
        subjectArea.setGlossary(glossarySummary);
        SubjectAreaDefinition newSubjectAreaDefinition = (SubjectAreaDefinition)subjectAreaCategory.create(this.userId, (Object)subjectArea);
        if (newSubjectAreaDefinition != null) {
            this.createdSubjectAreasSet.add(newSubjectAreaDefinition.getSystemAttributes().getGUID());
            System.out.println("Created SubjectAreaDefinition " + newSubjectAreaDefinition.getName() + " with guid " + newSubjectAreaDefinition.getSystemAttributes().getGUID());
        }
        return newSubjectAreaDefinition;
    }

    public SubjectAreaDefinition getSubjectAreaDefinitionByGUID(String guid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        SubjectAreaDefinition subjectArea = (SubjectAreaDefinition)subjectAreaCategory.getByGUID(this.userId, guid);
        if (subjectArea != null) {
            System.out.println("Got SubjectAreaDefinition " + subjectArea.getName() + " with userId " + subjectArea.getSystemAttributes().getGUID() + " and status " + subjectArea.getSystemAttributes().getStatus());
        }
        return subjectArea;
    }

    public SubjectAreaDefinition updateSubjectAreaDefinition(String guid, SubjectAreaDefinition subjectArea) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        SubjectAreaDefinition updatedSubjectAreaDefinition = (SubjectAreaDefinition)subjectAreaCategory.update(this.userId, guid, (Object)subjectArea);
        if (updatedSubjectAreaDefinition != null) {
            System.out.println("Updated SubjectAreaDefinition name to " + updatedSubjectAreaDefinition.getName());
        }
        return updatedSubjectAreaDefinition;
    }

    public void deleteSubjectAreaDefinition(String guid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        subjectAreaCategory.delete(this.userId, guid);
        this.createdSubjectAreasSet.remove(guid);
        System.out.println("Deleted SubjectAreaDefinition guid is " + guid);
    }

    public SubjectAreaDefinition restoreSubjectAreaDefinition(String guid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        SubjectAreaDefinition restoredSubjectAreaDefinition = (SubjectAreaDefinition)subjectAreaCategory.restore(this.userId, guid);
        if (restoredSubjectAreaDefinition != null) {
            this.createdSubjectAreasSet.add(restoredSubjectAreaDefinition.getSystemAttributes().getGUID());
            System.out.println("restored SubjectAreaDefinition name is " + restoredSubjectAreaDefinition.getName());
        }
        return restoredSubjectAreaDefinition;
    }

    public List<SubjectAreaDefinition> findSubjectAreaDefinitions(String criteria) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        FindRequest findRequest = new FindRequest();
        findRequest.setSearchCriteria(criteria);
        return subjectAreaCategory.find(this.userId, findRequest);
    }

    private void deleteRemaining() throws UserNotAuthorizedException, PropertyServerException, InvalidParameterException, GlossaryAuthorFVTCheckedException {
        this.deleteRemainingSubjectAreas();
        this.glossaryFVT.deleteRemainingGlossaries();
    }

    void deleteRemainingSubjectAreas() throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, GlossaryAuthorFVTCheckedException {
        Iterator<String> iter = this.createdSubjectAreasSet.iterator();
        while (iter.hasNext()) {
            String guid = iter.next();
            iter.remove();
            this.deleteSubjectAreaDefinition(guid);
        }
        List<SubjectAreaDefinition> subjectAreas = this.findSubjectAreaDefinitions("");
        if (subjectAreas.size() != this.existingSubjectAreaCount) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected " + this.existingSubjectAreaCount + " Subject Area Definitions to be found, got " + subjectAreas.size());
        }
    }
}

