/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.glossaryauthor.fvt;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.category.Category;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.FindRequest;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Glossary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Taxonomy;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Node;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Relationship;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.nodesummary.GlossarySummary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.term.Term;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.viewservices.glossaryauthor.fvt.FVTUtils;
import org.odpi.openmetadata.viewservices.glossaryauthor.fvt.GlossaryAuthorFVTCheckedException;
import org.odpi.openmetadata.viewservices.glossaryauthor.fvt.RunAllFVTOn2Servers;
import org.odpi.openmetadata.viewservices.glossaryauthor.fvt.client.GlossaryAuthorViewRestClient;
import org.odpi.openmetadata.viewservices.glossaryauthor.fvt.client.glossarys.GlossaryAuthorViewGlossaryClient;
import org.odpi.openmetadata.viewservices.glossaryauthor.fvt.client.term.GlossaryAuthorViewTermClient;

public class GlossaryFVT {
    private static final String DEFAULT_TEST_GLOSSARY_NAME = "Testglossary1";
    private static final String DEFAULT_TEST_GLOSSARY_NAME2 = "Testglossary2";
    private static final String DEFAULT_TEST_GLOSSARY_NAME3 = "Testglossary3";
    private static final String DEFAULT_TEST_TERM_LIST = "Test term Number ";
    private GlossaryAuthorViewGlossaryClient glossaryAuthorViewGlossaryClient = null;
    private GlossaryAuthorViewTermClient glossaryAuthorViewTermClient = null;
    private String serverName = null;
    private String userId = null;
    private int existingGlossaryCount = 0;
    private Set<String> createdGlossariesSet;

    public GlossaryFVT(String url, String serverName, String userId) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        GlossaryAuthorViewRestClient client = new GlossaryAuthorViewRestClient(serverName, url);
        this.glossaryAuthorViewGlossaryClient = new GlossaryAuthorViewGlossaryClient(client);
        this.glossaryAuthorViewTermClient = new GlossaryAuthorViewTermClient(client);
        this.serverName = serverName;
        this.userId = userId;
        this.createdGlossariesSet = new HashSet<String>();
        this.existingGlossaryCount = this.findGlossaries("").size();
        System.out.println("existingGlossaryCount " + this.existingGlossaryCount);
    }

    public static void runWith2Servers(String url) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException, GlossaryAuthorFVTCheckedException {
        GlossaryFVT.runIt(url, "cocoView1", "garygeeke");
        GlossaryFVT.runIt(url, "cocoView2", "garygeeke");
    }

    public static void main(String[] args) {
        try {
            String url = RunAllFVTOn2Servers.getUrl(args);
            GlossaryFVT.runWith2Servers(url);
        }
        catch (IOException e1) {
            System.out.println("Error getting user input");
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            System.out.println("ERROR: " + e.getReportedErrorMessage() + " Suggested action: " + e.getReportedUserAction());
        }
        catch (GlossaryAuthorFVTCheckedException e) {
            System.out.println("ERROR: " + e.getMessage());
        }
    }

    public static void runIt(String url, String serverName, String userId) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException, GlossaryAuthorFVTCheckedException {
        try {
            System.out.println("GlossaryFVT runIt started " + serverName + " and " + userId);
            GlossaryFVT fvt = new GlossaryFVT(url, serverName, userId);
            fvt.run();
            fvt.deleteRemainingGlossaries();
            System.out.println("GlossaryFVT runIt finished");
        }
        catch (Exception error) {
            error.printStackTrace();
            throw error;
        }
    }

    public static int getGlossaryCount(String url, String serverName, String userId) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException, GlossaryAuthorFVTCheckedException {
        GlossaryFVT fvt = new GlossaryFVT(url, serverName, userId);
        return fvt.findGlossaries("").size();
    }

    public void run() throws GlossaryAuthorFVTCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        List<Glossary> initialGlossaryState = this.findGlossaries(null);
        int initialGlossaryCount = 0;
        if (initialGlossaryState != null && initialGlossaryState.size() > 0) {
            initialGlossaryCount = initialGlossaryState.size();
        }
        System.out.println("Create a glossary");
        Glossary glossary = this.createGlossary(this.serverName + " Testglossary1");
        FVTUtils.validateNode((Node)glossary);
        Glossary glossary2 = this.createGlossary(this.serverName + " Testglossary2");
        FVTUtils.validateNode((Node)glossary2);
        List<Glossary> results = this.findGlossaries(null);
        if (results.size() != initialGlossaryCount + 2) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected " + initialGlossaryCount + "2 back on the find got " + results.size());
        }
        Glossary glossaryForUpdate = new Glossary();
        glossaryForUpdate.setName(this.serverName + " Testglossary3");
        System.out.println("Get the glossary");
        String guid = glossary.getSystemAttributes().getGUID();
        Glossary gotGlossary = this.getGlossaryByGUID(guid);
        System.out.println("Update the glossary");
        Glossary updatedGlossary = this.updateGlossary(guid, glossaryForUpdate);
        FVTUtils.validateNode((Node)updatedGlossary);
        System.out.println("Get the glossary again");
        gotGlossary = this.getGlossaryByGUID(guid);
        FVTUtils.validateNode((Node)gotGlossary);
        System.out.println("Delete the glossary");
        this.deleteGlossary(guid);
        System.out.println("restore the glossary");
        gotGlossary = this.restoreGlossary(guid);
        FVTUtils.validateNode((Node)gotGlossary);
        System.out.println("Delete the glossary again");
        this.deleteGlossary(guid);
        System.out.println("Create glossary with the same name as a deleted one");
        glossary = this.createGlossary(this.serverName + " Testglossary1");
        FVTUtils.validateNode((Node)glossary);
        System.out.println("create glossaries to find");
        Glossary glossaryForFind1 = this.getGlossaryForInput("qrs");
        glossaryForFind1.setQualifiedName("yyy");
        glossaryForFind1 = this.issueCreateGlossary(glossaryForFind1);
        FVTUtils.validateNode((Node)glossaryForFind1);
        Glossary glossaryForFind2 = this.createGlossary("yyy");
        FVTUtils.validateNode((Node)glossaryForFind2);
        Glossary glossaryForFind3 = this.createGlossary("zzz");
        FVTUtils.validateNode((Node)glossaryForFind3);
        Glossary glossaryForFind4 = this.createGlossary("This is a Glossary with spaces in name");
        FVTUtils.validateNode((Node)glossaryForFind4);
        results = this.findGlossaries("zzz");
        if (results.size() != 1) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected 1 back on the find got " + results.size());
        }
        results = this.findGlossaries("yyy");
        if (results.size() != 2) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected 2 back on the find got " + results.size());
        }
        this.deleteGlossary(glossaryForFind2.getSystemAttributes().getGUID());
        results = this.findGlossaries("yyy");
        if (results.size() != 1) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected 1 back on the find got " + results.size());
        }
        results = this.findGlossaries("This is a Glossary with spaces in name");
        if (results.size() != 1) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected 1 back on the find got " + results.size());
        }
        this.createGlossary(DEFAULT_TEST_GLOSSARY_NAME);
        Glossary glossaryForUniqueQFN2 = this.createGlossary(DEFAULT_TEST_GLOSSARY_NAME);
        if (glossaryForUniqueQFN2 == null || glossaryForUniqueQFN2.getQualifiedName().length() == 0) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected qualified name to be set");
        }
        String glossaryForUniqueQFN2Guid = glossaryForUniqueQFN2.getSystemAttributes().getGUID();
        ArrayList<Term> multipleTermList = new ArrayList<Term>();
        for (int i = 1; i < 5; ++i) {
            multipleTermList.add(this.getTermForInput(DEFAULT_TEST_TERM_LIST + String.valueOf(i), glossaryForUniqueQFN2Guid));
        }
        Term[] termArray = new Term[multipleTermList.size()];
        termArray = multipleTermList.toArray(termArray);
        this.createMultipleTerms(this.userId, glossaryForUniqueQFN2Guid, termArray);
        FindRequest findRequest = new FindRequest();
        findRequest.setSearchCriteria("");
        List<Term> termList = this.getTerms(glossaryForUniqueQFN2Guid, findRequest);
        if (termList.size() != 4) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected 4 back on getGlossaryTerms for multipleCreate got " + results.size());
        }
        this.deleteTermsOnGlossary(this.userId, glossaryForUniqueQFN2Guid);
    }

    private void deleteTermsOnGlossary(String userId, String glossaryForUniqueQFN2Guid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        FindRequest findRequest = new FindRequest();
        findRequest.setSearchCriteria("");
        List<Term> termList = this.getTerms(glossaryForUniqueQFN2Guid, findRequest);
        for (Term term : termList) {
            this.glossaryAuthorViewTermClient.delete(userId, term.getSystemAttributes().getGUID());
        }
    }

    public Term getTermForInput(String termName, String glossaryGuid) {
        Term term = new Term();
        term.setName(termName);
        GlossarySummary glossarySummary = new GlossarySummary();
        glossarySummary.setGuid(glossaryGuid);
        term.setGlossary(glossarySummary);
        return term;
    }

    void deleteRemainingGlossaries() throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, GlossaryAuthorFVTCheckedException {
        Iterator<String> iter = this.createdGlossariesSet.iterator();
        while (iter.hasNext()) {
            String guid = iter.next();
            iter.remove();
            this.deleteGlossary(guid);
        }
        List<Glossary> glossaries = this.findGlossaries("");
        if (glossaries.size() != this.existingGlossaryCount) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected " + this.existingGlossaryCount + " glossaries, got " + glossaries.size());
        }
    }

    public Glossary createGlossary(String glossaryName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Glossary glossary = this.getGlossaryForInput(glossaryName);
        return this.issueCreateGlossary(glossary);
    }

    public Glossary issueCreateGlossary(Glossary glossary) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        Glossary newGlossary = this.glossaryAuthorViewGlossaryClient.create(this.userId, glossary);
        if (newGlossary != null) {
            String guid = newGlossary.getSystemAttributes().getGUID();
            System.out.println("Created Glossary " + newGlossary.getName() + " with userId " + guid);
            this.createdGlossariesSet.add(guid);
        }
        return newGlossary;
    }

    public Glossary getGlossaryForInput(String glossaryName) {
        Glossary glossary = new Glossary();
        glossary.setName(glossaryName);
        return glossary;
    }

    public Taxonomy getTaxonomyForInput(String glossaryName) {
        Taxonomy taxonomy = new Taxonomy();
        taxonomy.setName(glossaryName);
        return taxonomy;
    }

    public Glossary createPastToGlossary(String name) throws GlossaryAuthorFVTCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Glossary glossary = new Glossary();
        glossary.setName(name);
        long now = new Date().getTime();
        glossary.setEffectiveToTime(Long.valueOf(new Date(now - 10L).getTime()));
        Glossary newGlossary = this.issueCreateGlossary(glossary);
        FVTUtils.validateNode((Node)newGlossary);
        System.out.println("Created Glossary " + newGlossary.getName() + " with GUID " + newGlossary.getSystemAttributes().getGUID());
        return newGlossary;
    }

    public Glossary createPastFromGlossary(String name) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Glossary glossary = new Glossary();
        glossary.setName(name);
        long now = new Date().getTime();
        glossary.setEffectiveFromTime(Long.valueOf(new Date(now - 10L).getTime()));
        return this.issueCreateGlossary(glossary);
    }

    public Glossary createInvalidEffectiveDateGlossary(String name) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Glossary glossary = new Glossary();
        glossary.setName(name);
        long now = new Date().getTime();
        glossary.setEffectiveFromTime(Long.valueOf(new Date(now - 10L).getTime()));
        glossary.setEffectiveToTime(Long.valueOf(new Date(now - 11L).getTime()));
        return this.issueCreateGlossary(glossary);
    }

    public Glossary createFutureGlossary(String name) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, GlossaryAuthorFVTCheckedException {
        Glossary glossary = new Glossary();
        glossary.setName(name);
        long now = new Date().getTime();
        glossary.setEffectiveFromTime(Long.valueOf(new Date(now + 86400000L).getTime()));
        glossary.setEffectiveToTime(Long.valueOf(new Date(now + 172800000L).getTime()));
        Glossary newGlossary = this.issueCreateGlossary(glossary);
        FVTUtils.validateNode((Node)newGlossary);
        System.out.println("Created Glossary " + newGlossary.getName() + " with userId " + newGlossary.getSystemAttributes().getGUID());
        return newGlossary;
    }

    public List<Glossary> findGlossaries(String criteria) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        FindRequest findRequest = new FindRequest();
        findRequest.setSearchCriteria(criteria);
        List<Glossary> glossaries = this.glossaryAuthorViewGlossaryClient.find(this.userId, findRequest);
        return glossaries;
    }

    public Glossary getGlossaryByGUID(String guid) throws GlossaryAuthorFVTCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Glossary glossary = this.glossaryAuthorViewGlossaryClient.getByGUID(this.userId, guid);
        FVTUtils.validateNode((Node)glossary);
        System.out.println("Got Glossary " + glossary.getName() + " with userId " + glossary.getSystemAttributes().getGUID() + " and status " + glossary.getSystemAttributes().getStatus());
        return glossary;
    }

    public Glossary updateGlossary(String guid, Glossary glossary) throws GlossaryAuthorFVTCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        boolean isReplace = true;
        Glossary updatedGlossary = this.glossaryAuthorViewGlossaryClient.update(this.userId, guid, glossary, isReplace);
        FVTUtils.validateNode((Node)updatedGlossary);
        System.out.println("Updated Glossary name to " + updatedGlossary.getName());
        return updatedGlossary;
    }

    public void deleteGlossary(String guid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.glossaryAuthorViewGlossaryClient.delete(this.userId, guid);
        this.createdGlossariesSet.remove(guid);
        System.out.println("Delete succeeded");
    }

    public Glossary restoreGlossary(String guid) throws GlossaryAuthorFVTCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Glossary restoredGlossary = this.glossaryAuthorViewGlossaryClient.restore(this.userId, guid);
        FVTUtils.validateNode((Node)restoredGlossary);
        this.createdGlossariesSet.add(restoredGlossary.getSystemAttributes().getGUID());
        System.out.println("Restored Glossary name is " + restoredGlossary.getName());
        return restoredGlossary;
    }

    public List<Relationship> getGlossaryRelationships(Glossary glossary) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.glossaryAuthorViewGlossaryClient.getAllRelationships(this.userId, glossary.getSystemAttributes().getGUID());
    }

    public List<Category> getCategories(String glossaryGuid, FindRequest findRequest, boolean onlyTop) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.glossaryAuthorViewGlossaryClient.getCategories(this.userId, glossaryGuid, findRequest, onlyTop);
    }

    public List<Term> getTerms(String glossaryGuid, FindRequest findRequest) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.glossaryAuthorViewGlossaryClient.getTerms(this.userId, glossaryGuid, findRequest);
    }

    public List<Term> createMultipleTerms(String userId, String guid, Term[] termArray) throws PropertyServerException, InvalidParameterException, UserNotAuthorizedException {
        return this.glossaryAuthorViewGlossaryClient.createTerms(userId, guid, termArray);
    }
}

