/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.viewservices.glossaryauthor.fvt;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.common.FindRequest;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.glossary.Glossary;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Node;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.graph.Relationship;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.project.GlossaryProject;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.project.Project;
import org.odpi.openmetadata.accessservices.subjectarea.properties.objects.term.Term;
import org.odpi.openmetadata.accessservices.subjectarea.properties.relationships.ProjectScope;
import org.odpi.openmetadata.accessservices.subjectarea.responses.SubjectAreaOMASAPIResponse;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.viewservices.glossaryauthor.fvt.FVTUtils;
import org.odpi.openmetadata.viewservices.glossaryauthor.fvt.GlossaryAuthorFVTCheckedException;
import org.odpi.openmetadata.viewservices.glossaryauthor.fvt.GlossaryFVT;
import org.odpi.openmetadata.viewservices.glossaryauthor.fvt.RelationshipsFVT;
import org.odpi.openmetadata.viewservices.glossaryauthor.fvt.RunAllFVTOn2Servers;
import org.odpi.openmetadata.viewservices.glossaryauthor.fvt.TermFVT;
import org.odpi.openmetadata.viewservices.glossaryauthor.fvt.client.GlossaryAuthorViewRestClient;
import org.odpi.openmetadata.viewservices.glossaryauthor.fvt.client.project.GlossaryAuthorViewProjectClient;
import org.odpi.openmetadata.viewservices.glossaryauthor.fvt.client.relationships.GlossaryAuthorViewRelationshipsClient;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.ResolvableType;

public class ProjectFVT {
    private static final String DEFAULT_TEST_PROJECT_NAME = "Testproject1";
    private static final String DEFAULT_TEST_PROJECT_NAME2 = "Testproject2";
    private static final String DEFAULT_TEST_PROJECT_NAME3 = "Testproject3";
    private static final String DEFAULT_TEST_PROJECT_NAME4 = "Testproject4";
    private static final String DEFAULT_TEST_PROJECT_NAME5 = "Testproject5";
    private static final String DEFAULT_TEST_PROJECT_NAME6 = "Testproject6";
    private static final String DEFAULT_TEST_PROJECT_NAME7 = "Testproject7";
    private static final String DEFAULT_TEST_PROJECT_NAME8 = "Testproject8";
    private static final String DEFAULT_TEST_GLOSSARY_NAME = "Test Glossary for project FVT";
    private static final String DEFAULT_TEST_TERM_NAME = "Test term A1";
    private static final String PROJECT_SCOPE = "project-scopes";
    private GlossaryAuthorViewProjectClient glossaryAuthorViewProjectClient = null;
    private GlossaryAuthorViewRelationshipsClient glossaryAuthorViewRelationshipsClient = null;
    private GlossaryFVT glossaryFVT = null;
    private TermFVT termFVT = null;
    private RelationshipsFVT relationshipsFVT = null;
    private String serverName = null;
    private String userId = null;
    private int existingProjectCount = 0;
    private Set<String> createdProjectsSet = new HashSet<String>();

    public ProjectFVT(String url, String serverName, String userId) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        GlossaryAuthorViewRestClient client = new GlossaryAuthorViewRestClient(serverName, url);
        this.glossaryAuthorViewProjectClient = new GlossaryAuthorViewProjectClient(client);
        this.glossaryAuthorViewRelationshipsClient = new GlossaryAuthorViewRelationshipsClient(client);
        this.glossaryFVT = new GlossaryFVT(url, serverName, userId);
        this.termFVT = new TermFVT(url, serverName, userId);
        this.serverName = serverName;
        this.userId = userId;
        this.existingProjectCount = this.findProjects("").size();
        System.out.println("existingProjectCount " + this.existingProjectCount);
    }

    public static void runWith2Servers(String url) throws GlossaryAuthorFVTCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ProjectFVT.runIt(url, "cocoView1", "garygeeke");
        ProjectFVT.runIt(url, "cocoView2", "garygeeke");
    }

    public static void main(String[] args) {
        try {
            String url = RunAllFVTOn2Servers.getUrl(args);
            ProjectFVT.runWith2Servers(url);
        }
        catch (IOException e1) {
            System.out.println("Error getting user input");
        }
        catch (GlossaryAuthorFVTCheckedException e) {
            System.out.println("ERROR: " + e.getMessage());
        }
        catch (InvalidParameterException | PropertyServerException | UserNotAuthorizedException e) {
            System.out.println("ERROR: " + e.getReportedErrorMessage() + " Suggested action: " + e.getReportedUserAction());
        }
    }

    public static void runIt(String url, String serverName, String userId) throws GlossaryAuthorFVTCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        try {
            System.out.println("ProjectFVT runIt started");
            ProjectFVT fvt = new ProjectFVT(url, serverName, userId);
            fvt.run();
            fvt.termFVT.deleteRemainingTerms();
            fvt.glossaryFVT.deleteRemainingGlossaries();
            fvt.deleteRemainingProjects();
            System.out.println("ProjectFVT runIt stopped");
        }
        catch (Exception error) {
            error.printStackTrace();
            throw error;
        }
    }

    public static int getProjectCount(String url, String serverName, String userId) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException, GlossaryAuthorFVTCheckedException {
        ProjectFVT fvt = new ProjectFVT(url, serverName, userId);
        return fvt.findProjects(".*").size();
    }

    public void run() throws GlossaryAuthorFVTCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        System.out.println("Create a project");
        Project project = this.createProject(this.serverName + " Testproject1");
        FVTUtils.validateNode((Node)project);
        Project project2 = this.createProject(this.serverName + " Testproject2");
        FVTUtils.validateNode((Node)project2);
        List<Project> results = this.findProjects(null);
        if (results.size() != 2) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected 2 back on the find got " + results.size());
        }
        Project projectForUpdate = new Project();
        projectForUpdate.setName(this.serverName + " Testproject3");
        System.out.println("Get the project");
        String guid = project.getSystemAttributes().getGUID();
        Project gotProject = this.getProjectByGUID(guid);
        FVTUtils.validateNode((Node)gotProject);
        System.out.println("Update the project");
        Project updatedProject = this.updateProject(guid, projectForUpdate);
        FVTUtils.validateNode((Node)updatedProject);
        System.out.println("Get the project again");
        gotProject = this.getProjectByGUID(guid);
        FVTUtils.validateNode((Node)gotProject);
        System.out.println("Delete the project");
        this.deleteProject(guid);
        System.out.println("restore the project");
        gotProject = this.restoreProject(guid);
        FVTUtils.validateNode((Node)gotProject);
        System.out.println("Delete the project again");
        this.deleteProject(guid);
        System.out.println("Create project with the same name as a deleted one");
        project = this.createProject(this.serverName + " Testproject1");
        FVTUtils.validateNode((Node)project);
        System.out.println("create projects to find");
        Project projectForFind1 = this.getProjectForInput(DEFAULT_TEST_PROJECT_NAME7);
        projectForFind1.setQualifiedName(DEFAULT_TEST_PROJECT_NAME6);
        projectForFind1 = this.issueCreateProject(projectForFind1);
        FVTUtils.validateNode((Node)projectForFind1);
        Project projectForFind2 = this.createProject(DEFAULT_TEST_PROJECT_NAME6);
        FVTUtils.validateNode((Node)projectForFind2);
        Project projectForFind3 = this.createProject(DEFAULT_TEST_PROJECT_NAME5);
        FVTUtils.validateNode((Node)projectForFind3);
        Project projectForFind4 = this.createProject("This is a Project with spaces in name");
        FVTUtils.validateNode((Node)projectForFind4);
        results = this.findProjects(DEFAULT_TEST_PROJECT_NAME5);
        if (results.size() != 1) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected 1 back on the find got " + results.size());
        }
        results = this.findProjects(DEFAULT_TEST_PROJECT_NAME6);
        if (results.size() != 2) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected 2 back on the find got " + results.size());
        }
        this.deleteProject(projectForFind2.getSystemAttributes().getGUID());
        results = this.findProjects(DEFAULT_TEST_PROJECT_NAME6);
        if (results.size() != 1) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected 1 back on the find got " + results.size());
        }
        results = this.findProjects("This is a Project with spaces in name");
        if (results.size() != 1) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected 1 back on the find got " + results.size());
        }
        this.createProject(DEFAULT_TEST_PROJECT_NAME);
        Project projectForUniqueQFN2 = this.createProject(DEFAULT_TEST_PROJECT_NAME);
        if (projectForUniqueQFN2 == null || projectForUniqueQFN2.getQualifiedName().length() == 0) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected qualified name to be set");
        }
        Project project8 = this.createProject(this.serverName + " Testproject8");
        Glossary glossary = this.glossaryFVT.createGlossary(DEFAULT_TEST_GLOSSARY_NAME);
        System.out.println("Create a term called Test term A1 using glossary GUID");
        String glossaryGuid = glossary.getSystemAttributes().getGUID();
        Term term1 = this.termFVT.createTerm(DEFAULT_TEST_TERM_NAME, glossaryGuid);
        System.out.println("Create a project scope relationship between called Test term A1 and Testproject8");
        this.createProjectScope(project8, term1);
        List<Relationship> prjRelationships = this.getProjectRelationships(project8);
        if (prjRelationships.size() != 1) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected 1 relationship on project got " + prjRelationships.size());
        }
    }

    public Project createProject(String projectName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Project project = this.getProjectForInput(projectName);
        return this.issueCreateProject(project);
    }

    public Project issueCreateProject(Project project) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        Project newProject = this.glossaryAuthorViewProjectClient.create(this.userId, project);
        if (newProject != null) {
            this.createdProjectsSet.add(newProject.getSystemAttributes().getGUID());
            System.out.println("Created Project " + newProject.getName() + " with userId " + newProject.getSystemAttributes().getGUID());
        }
        return newProject;
    }

    public Project getProjectForInput(String projectName) {
        Project project = new Project();
        project.setName(projectName);
        return project;
    }

    public GlossaryProject getGlossaryProjectForInput(String projectName) {
        GlossaryProject glossaryProject = new GlossaryProject();
        glossaryProject.setName(projectName);
        return glossaryProject;
    }

    public List<Project> findProjects(String criteria) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        FindRequest findRequest = new FindRequest();
        findRequest.setSearchCriteria(criteria);
        List<Project> projects = this.glossaryAuthorViewProjectClient.find(this.userId, findRequest, false, true);
        return projects;
    }

    public Project getProjectByGUID(String guid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, GlossaryAuthorFVTCheckedException {
        Project project = this.glossaryAuthorViewProjectClient.getByGUID(this.userId, guid);
        FVTUtils.validateNode((Node)project);
        System.out.println("Got Project " + project.getName() + " with userId " + project.getSystemAttributes().getGUID() + " and status " + project.getSystemAttributes().getStatus());
        return project;
    }

    public Project updateProject(String guid, Project project) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, GlossaryAuthorFVTCheckedException {
        Project updatedProject = this.glossaryAuthorViewProjectClient.update(this.userId, guid, project, false);
        FVTUtils.validateNode((Node)updatedProject);
        System.out.println("Updated Project name to " + updatedProject.getName());
        return updatedProject;
    }

    public void deleteProject(String guid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.glossaryAuthorViewProjectClient.delete(this.userId, guid);
        this.createdProjectsSet.remove(guid);
        System.out.println("Deleted Project succeeded");
    }

    public Project restoreProject(String guid) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, GlossaryAuthorFVTCheckedException {
        Project restoredProject = this.glossaryAuthorViewProjectClient.restore(this.userId, guid);
        FVTUtils.validateNode((Node)restoredProject);
        this.createdProjectsSet.add(restoredProject.getSystemAttributes().getGUID());
        System.out.println("Restored Project name is " + restoredProject.getName());
        return restoredProject;
    }

    public List<Relationship> getProjectRelationships(Project project) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        return this.glossaryAuthorViewProjectClient.getAllRelationships(this.userId, project.getSystemAttributes().getGUID());
    }

    protected ProjectScope createProjectScope(Project project, Term term) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, GlossaryAuthorFVTCheckedException {
        ProjectScope projectScope = new ProjectScope();
        projectScope.getEnd1().setNodeGuid(project.getSystemAttributes().getGUID());
        projectScope.getEnd2().setNodeGuid(term.getSystemAttributes().getGUID());
        ResolvableType resolvableType = ResolvableType.forClassWithGenerics(SubjectAreaOMASAPIResponse.class, (Class[])new Class[]{ProjectScope.class});
        ParameterizedTypeReference type = ParameterizedTypeReference.forType((Type)resolvableType.getType());
        ProjectScope createdProjectScope = this.glossaryAuthorViewRelationshipsClient.createRel(this.userId, projectScope, type, PROJECT_SCOPE);
        FVTUtils.validateRelationship((Relationship)createdProjectScope);
        return createdProjectScope;
    }

    void deleteRemainingProjects() throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, GlossaryAuthorFVTCheckedException {
        Iterator<String> iter = this.createdProjectsSet.iterator();
        while (iter.hasNext()) {
            String guid = iter.next();
            iter.remove();
            this.deleteProject(guid);
        }
        List<Project> projects = this.findProjects("");
        if (projects.size() != this.existingProjectCount) {
            throw new GlossaryAuthorFVTCheckedException("ERROR: Expected " + this.existingProjectCount + " Projects to be found, got " + projects.size());
        }
    }
}

